#ifndef lint
static	char sccsid[] = "@(#)formatData.c 1.2 90/01/02 ";
#endif

#include <stdio.h>
#include <errno.h>
#include <ctype.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <sys/signal.h>

#include <stropts.h>
#include <sys/ioctl.h>


#define	Error		(void) fprintf


/* Local variables */
char *prog;
char prog_desc[] = "Format Shower Data for xvgr";
char prog_opts[] = "?";		/* getopt() flags */

char		*Stdin = "stdin";


/* Global variables */
extern int getopt();
extern int optind;
extern char *optarg;


usage()
{
	Error(stderr, "%s -- usage:\n\n\t%s ", prog_desc, prog);
	Error(stderr, "\t filein \nwhere:\n");
	Error(stderr, "\tfilein  -- \tShower data file to convert\n");
	Error(stderr, "\t(assumes .log extension for input file)\n");
	Error(stderr, "\t(creates output file with .dat extension)\n");
	exit(1);
}


/*
 * Convert Shower Problem output (logging) file to format for input to
   xvgr (eg. xvgr -p ShowerGraph.par data.dat).
 */
main(argc, argv)
	int		argc;
	char		**argv;
{
	int		i;
	int		cnt;
	int		err;
	struct stat		st;
	struct sigvec		vec;
	char		Ifilename[256], Ofilename[256], *argFilename;
	FILE 		*Ifile, *Ofile;

	/* temperatures, pressures, valve positions and 'time' in Shower data file */
	float		Time,Tx, Fx, vh, vc, ph, pc, th, tc;
	long		Itime;

	prog = argv[0];		/* save program initiation name */

	err = 0;
	while ((i = getopt(argc, argv, prog_opts)) != EOF) 
	    switch (i)
	        {
	            case '?':
		usage();
	         }
	if (err > 0)
		exit(1);

	argc -= optind;		/* update arg pointers */
	argv += optind;

	/* If no filenames, ERROR */
	if (argc < 1) {
		Error(stderr,"\n%s: Not enough arguments\n\n",prog);
		usage();
	} else {
		argFilename = *argv++;
		argc--;

		strcpy(Ifilename, argFilename);
		strcat(Ifilename,".log");

		strcpy(Ofilename, argFilename);
		strcat(Ofilename,".dat");

		if ((Ifile = fopen(Ifilename, "r")) == NULL)
		     {
			Error(stderr,"%s: Unable to open input file '%s'\n",prog,Ifilename);
			exit(0);
		     }
		if ((Ofile = fopen(Ofilename, "w")) == NULL)
		     {
			Error(stderr,"%s: Unable to open output file '%s'\n",prog,Ifilename);
			exit(0);
		     }

		/* the Tx graph info */
		fprintf(Ofile,"@with g0\n@  s0 color 3\n");
		while (fscanf(Ifile,"%ld %f %f %f %f %f %f %f %f\n",&Itime,&Tx, &Fx, &vh, &vc, &ph, &pc, &th, &tc) != EOF)
		      { /* convert time from milliseconds to Julian date format */
			/* 0.0 is 12 noon and 0.5 is midnight */
			Time = ((float)Itime/1000.0) * .000011574 + 0.5; /* get msecs into Julian time */ 
			fprintf(Ofile,"%.8f,%.8f\n",Time, Tx);
		      }
		fprintf(Ofile,"&\n");

		/* the Fx graph info */
		fprintf(Ofile,"@with g1\n@  s0 color 8\n");
		rewind(Ifile);
		while (fscanf(Ifile,"%ld %f %f %f %f %f %f %f %f\n",&Itime,&Tx, &Fx, &vh, &vc, &ph, &pc, &th, &tc) != EOF)
		      {
			Time = ((float)Itime/1000.0) * .000011574 + 0.5; /* get usecs into Julian time */ 
			fprintf(Ofile,"%.8f,%.8f\n",Time, Fx);
		      }
		fprintf(Ofile,"&\n");

		
		/* the Valve position graph info */
		fprintf(Ofile,"@with g2\n@  s0 color 2\n@  s1 color 4\n");
		rewind(Ifile);
		while (fscanf(Ifile,"%ld %f %f %f %f %f %f %f %f\n",&Itime,&Tx, &Fx, &vh, &vc, &ph, &pc, &th, &tc) != EOF)
		      {
			Time = ((float)Itime/1000.0) * .000011574 + 0.5; /* get into Julian time */ 
			fprintf(Ofile,"%.8f,%.8f\n",Time, vh);
		      }
		fprintf(Ofile,"&\n");
		rewind(Ifile);
		while (fscanf(Ifile,"%ld %f %f %f %f %f %f %f %f\n",&Itime,&Tx, &Fx, &vh, &vc, &ph, &pc, &th, &tc) != EOF)
		      {
			Time = ((float)Itime/1000.0) * .000011574 + 0.5; /* get into Julian time */ 
			fprintf(Ofile,"%.8f,%.8f\n",Time, vc);
		      }
		fprintf(Ofile,"&\n");
		
		/* the input temperatures graph info */
		fprintf(Ofile,"@with g3\n@  s0 color 2\n@  s1 color 4\n");
		rewind(Ifile);
		while (fscanf(Ifile,"%ld %f %f %f %f %f %f %f %f\n",&Itime,&Tx, &Fx, &vh, &vc, &ph, &pc, &th, &tc) != EOF)
		      {
			Time = ((float)Itime/1000.0) * .000011574 + 0.5; /* get into Julian time */ 
			fprintf(Ofile,"%.8f,%.8f\n",Time, th);
		      }
		fprintf(Ofile,"&\n");
		rewind(Ifile);
		while (fscanf(Ifile,"%ld %f %f %f %f %f %f %f %f\n",&Itime,&Tx, &Fx, &vh, &vc, &ph, &pc, &th, &tc) != EOF)
		      {
			Time = ((float)Itime/1000.0) * .000011574 + 0.5; /* get into Julian time */ 
			fprintf(Ofile,"%.8f,%.8f\n",Time, tc);
		      }
		fprintf(Ofile,"&\n");

		/* the input pressures graph info */
		fprintf(Ofile,"@with g4\n@  s0 color 2\n@  s1 color 4\n");
		rewind(Ifile);
		while (fscanf(Ifile,"%ld %f %f %f %f %f %f %f %f\n",&Itime,&Tx, &Fx, &vh, &vc, &ph, &pc, &th, &tc) != EOF)
		      {
			Time = ((float)Itime/1000.0) * .000011574 + 0.5; /* get into Julian time */ 
			fprintf(Ofile,"%.8f,%.8f\n",Time, ph);
		      }
		fprintf(Ofile,"&\n");
		rewind(Ifile);
		while (fscanf(Ifile,"%ld %f %f %f %f %f %f %f %f\n",&Itime,&Tx, &Fx, &vh, &vc, &ph, &pc, &th, &tc) != EOF)
		      {
			Time = ((float)Itime/1000.0) * .000011574 + 0.5; /* get into Julian time */ 
			fprintf(Ofile,"%.8f,%.8f\n",Time, pc);
		      }
		fprintf(Ofile,"&\n");
		
		fclose(Ifile);
		fclose(Ofile);
	}

	exit(0);
}
