   /*******************************************************/
   /*      "C" Language Integrated Production System      */
   /*                                                     */
   /*                  A Product Of The                   */
   /*             Software Technology Branch              */
   /*             NASA - Johnson Space Center             */
   /*                                                     */
   /*             CLIPS Version 6.00  05/12/93            */
   /*                                                     */
   /*             FUZZY LHS PARSE MODULE                  */
   /*******************************************************/

/*************************************************************/
/* Purpose:                                                  */
/*                                                           */
/* Principal Programmer(s):                                  */
/*      Bob Orchard (NRCC - Nat'l Research Council of Canada)*/
/*                  (Fuzzy reasoning extensions)             */
/*                  (certainty factors for facts and rules)  */
/*                  (extensions to run command)              */
/*                                                           */
/* Contributing Programmer(s):                               */
/*                                                           */
/* Revision History:                                         */
/*                                                           */
/*************************************************************/


/******************************************************************
    Fuzzy Logic Module

    This file contains the following categories of functions:
    
    routines to parse fuzzy patterns in lhs of rule

 ******************************************************************/
 
#define _FUZZYLHS_SOURCE_


#include "setup.h"


#if FUZZY_DEFTEMPLATES && DEFRULE_CONSTRUCT && (! RUN_TIME) && (! BLOAD_ONLY)


#include <stdio.h>
#define _CLIPS_STDIO_

#include <math.h>


#include "tmpltdef.h"

#include "fuzzylhs.h"
#include "fuzzyrhs.h"

/******************************************************************
    Global Internal Function Declarations
    
    Defined in fuzzylhs.h
 ******************************************************************/



/******************************************************************
    Local Internal Function Declarations
 ******************************************************************/
 


/******************************************************************
    Local Internal Variable Declarations
 ******************************************************************/


   
/******************************************************************
    Global External Variable Declarations
 ******************************************************************/



/******************************************************************
    Global Internal Variable Declarations
 ******************************************************************/




                                                                  
/**********************************************************************
    FUNCTIONS FOR PARSING THE FUZZY PATTERNS ON THE LHS OF A RULE
 **********************************************************************/
 
 
/********************************************************************/
/* GetFuzzyLHSPattern:                                              */
/*                                                                  */
/* Note: can return a NULL ptr when no error since (fuzzyvar ?)     */
/*       is allowed                                                 */
/********************************************************************/

globle struct fuzzy_value *GetFuzzyLHSPattern(readSource,theToken,fzTemplate,error)
  char *readSource;
  struct token *theToken;
  struct  fuzzyLv *fzTemplate;
  int *error;
{   
   /*=======================================*/
   /* Put a space between the template name */
   /* and the fuzzy set definition.         */
   /* Next token should be modifier or term */
   /* OR a wildcard (?)                     */
   /*=======================================*/

   PPBackup();
   SavePPBuffer(" ");
   SavePPBuffer(theToken->printForm);
       
   /* if the token is SF_WILDCARD (ie. ?) this matches any fuzzy value for 
      the fuzzy variable - just return a null FUZZY_VALUE ptr 
   */
   if (theToken->type == SF_WILDCARD)
     {
       GetToken(readSource,theToken);
       return( NULL );
     }
   else
     {
       /* ParseFuzzyValue is in FUZZYRHS.C -- same syntax in pattern as in assert */
       return( ParseFuzzyValue(readSource,theToken,fzTemplate,error) );
     }
       
}





#endif  /* FUZZY_DEFTEMPLATES */
