/*******************************************************************
DYNACLIPS ( DYNAmic CLIPS Utilities)  Version 3.0
COPYRIGHT 1994  by Yilmaz Cengeloglu.

This utilities and libraries for CLIPS are  the sole property of
        Yilmaz Cengeloglu
        P.O. Box 10412
        Daytona Beach, FL 32120-0412, USA

DYNACLIPS Version 3.0  can be  freely used and redistributed for
educational purpose.  Commercial use  of these utilities is subject to the 
terms and conditions of a license agreement with the  Yilmaz Cengeloglu.



 **********************************************************************/

#include <stdio.h>

#include <math.h>
#include <string.h>
#include <malloc.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <sys/uio.h>


#define  MAX_ERR_MESS_LEN 1000
#define  MAX_FORMAT_WORDS 10
#define  MAX_LENGTH_KSNAME 30 
#define  MAX_LENGTH_KSTYPE 30 
#define  MAX_NUM_OF_KS  30 
char *Wordarr[MAX_FORMAT_WORDS];
#define READ_FLG        0466
#define WRITE_FLG       0266
#define ALL_FREE        0666
#define MAXIMUM_MEMORY_SIZE 100000
#define MAX_FACT_SIZE 255 
#define SHMEM_SIZE 100000
#define NUMBER_OF_FACTS 100 
typedef struct{
        char ksID[10];
        int  msgcode;
        char message[100];
        }DEF_CONTROL_MESSAGE;
typedef struct{ 
        int status;
        int type;
        char source[20];
        char destination[20];
	char fact[MAX_FACT_SIZE];
	}BBA_FACT;
typedef struct{
             int broadcast_status;
              DEF_CONTROL_MESSAGE CONT_MESS;
              BBA_FACT FACT[NUMBER_OF_FACTS];
             } BLACKBOARD;

#define MAX_PLANES_FOR_SH 10
#define NUMBER_OF_RADAR_VAR 11 
typedef struct{
          char aircraftID[10];
          int  x,y;
          int  Airspeed;
          int  Altitude;
          int  AssAltitude;
          int  DataBlockStatus;
          int FlightStripStatus;
          int SectorPosition; 
          int CommStatus;
          int PilotEmergency;
          int FlightPlanStatus;
         }DEF_PLANE_VAR;
typedef struct{
              int broadcast_status;
              int numofplanes;
              DEF_CONTROL_MESSAGE CONT_MESS;
              DEF_PLANE_VAR SH_PLANES[MAX_PLANES_FOR_SH];
             } DEF_SHARED;

#define MAXMSGSIZE 1000 
#define REG_MSG_SIZE 1000 
typedef struct {
   struct msgbuf *msgp;
   int qid,
       msgflg,
       msgsz,
       rtrn,
       msgtype;
       } DEF_MSGBUF;

typedef struct {
         int qid;
         int msgcode;
         char message[MAXMSGSIZE];
            } DEF_MESSAGE;

typedef struct {
         int status;
         int type;
         char KStype[MAX_LENGTH_KSTYPE];
         char KSname[MAX_LENGTH_KSNAME];
            } DEF_KSLIST;

#define  BB_FACT      1
#define  BB_RULE      2
#define  BB_COMMAND   3
#define  BBA_HAS_BEEN_READ      4
#define  EXIT_CONT	 	-1 	
#define  ENTER_NEW_KS 		1
#define  EXIT_KS 		2	
#define  DISPLAY_KS_NUM 	3 	
#define  CLR_ALL_BB 		5 	
#define  CLR_BB_FOR_OBJECT	6 	
#define  SEND_MES_TO_RADAR	7 	
#define DEL_BBA 	0
#define ADD_BBA 	1
#define DEL_ADD_BBA 	2 
#define  KS_EXIT_FROM_SYSTEM 	2 	
#define  ATC_MODE_ON 		4 	
#define  ATC_MODE_OFF 		6 	

DOEXTERN int segment;
DOEXTERN char  * ADDR;
DOEXTERN char  * RADAR_ADDR;
DOEXTERN int EXITFLAG;
DOEXTERN int QUEUE_ID;
DOEXTERN int COMMAND_QUEUE_ID;
DOEXTERN int SIGNAL_QUEUE_ID;
DOEXTERN int CONT_SEM_ID;
DOEXTERN int KS_SEM_ID;
DOEXTERN int RADAR_SEGMENT;
DOEXTERN int ATC_MODE;
DOEXTERN BLACKBOARD BBA;
DOEXTERN DEF_SHARED PLANES;
DOEXTERN int RADAR_FACT_ADDR[NUMBER_OF_RADAR_VAR];
DOEXTERN int BBA_ADDR[NUMBER_OF_FACTS];
DOEXTERN int OLDSTATUS[NUMBER_OF_FACTS];
DOEXTERN int old_bba_status;
DOEXTERN int old_radar_bba_status;
DOEXTERN int planeindex;
DOEXTERN char ksname[30];
DOEXTERN char ksID[MAX_LENGTH_KSNAME];
DOEXTERN char groupID[MAX_LENGTH_KSNAME];
DOEXTERN int  AddressOfGroup;
DOEXTERN char tempchar[255];

extern int  ASSERT_KSNAME();
extern int  CHANGE_GROUP_NAME();
extern void ADD_BB_STR();
extern void DEL_BB_STR();
extern void CLEAR_BB_FACTS();
extern void EXIT_CLIPS();
extern void UPDATE_BB_FACTS();


