/*//////////////////////////////////////////////////
//
//	USRFUNC.C is a file that is included in the
//		modified CLIPS build.  It defines
//		the function UserFunctions() as
//		described in the CLIPS Advanced Programming Manual.
//		It also includes support code for the
//		user-defined functions provided in the modified
//		CLIPS environment
//////////////////////////////////////////////////*/




/* Declarations of support functions...one for every user-defined CLIPS
	function */
/*
long AddListboxString(void);
void ClearListbox(void);
void SetStaticText(void);
void ClearStaticText(void);
long ModalMessageBox(void);
void SetCurrentSelection(void);
void SetResponseAssertion(void);
void StatusReady(void);
void StatusNotReady(void);
void Update(void);
void SaveConsultation(void);
void SetCurrentNode(void);
*/
/* Prototype for UserFunctions, the key CLIPS function */
/*int UserFunctions(void);

#include <windows.h>
#include "clips.h"
#include "..\\..\\dx\\source\\dx_ids.h"
#include "..\\..\\dx\\source\\dxclpfns.h"

*/
/*      I have a window in my main C code that lets the user directly
	type in a CLIPS command for immediate execution.
	The code essentially duplicates the standard command interpreter
	code found in the standard CLIPS source code.  In the interpreter
	code, a variable is used called BindList.  This function returns
	it for use in the main C code for the window
	Dont ask me more, I only copied it from the CLIPS source code. */
/*extern struct dataObject *BindList;
struct dataObject *GetBindList()
{
	return BindList;
}

*/
/* Storage for the DX function pointers... */
/*
FPW1DO lpfnCAddListBoxString;
FPV0DO lpfnCClearListbox;
FPV2DO lpfnCSetStaticText;
FPV0DO lpfnCClearStaticText;
FPW3DO lpfnCModalMessageBox;
FPV1DO lpfnCSetCurrentSelection;
FPV1DO lpfnCSetResponseAssertion;
FPV0DO lpfnCStatusNotReady;
FPV0DO lpfnCStatusReady;
FPV0DO lpfnCUpdate;
FPV0DO lpfnCSaveConsultation;
FPV1DO lpfnCSetCurrentNode;
*/
/* SetCallbackFunctions is called by the main C code, and is used
	to give CLIPS the addresses of the various user-defined functions
	in the main code.*/
/*void SetCallbackFunctions(FARPROC fp0,
			  FARPROC fp1,
			  FARPROC fp2,
			  FARPROC fp3,
			  FARPROC fp4,
			  FARPROC fp5,
			  FARPROC fp6,
			  FARPROC fp7,
			  FARPROC fp8,
			  FARPROC fp9,
			  FARPROC fp10,
			  FARPROC fp11)
{

	lpfnCAddListBoxString = (FPW1DO) fp0;
	lpfnCClearListbox = (FPV0DO)fp1;
	lpfnCSetStaticText = (FPV2DO) fp2;
	lpfnCClearStaticText = (FPV0DO) fp3;
	lpfnCModalMessageBox = (FPW3DO) fp4;
	lpfnCSetCurrentSelection = (FPV1DO) fp5;
	lpfnCSetResponseAssertion = (FPV1DO) fp6;
	lpfnCStatusNotReady = (FPV0DO) fp7;
	lpfnCStatusReady = (FPV0DO) fp8;
	lpfnCUpdate = (FPV0DO) fp9;
	lpfnCSaveConsultation = (FPV0DO) fp10;
	lpfnCSetCurrentNode = (FPV1DO) fp11;

}
*/



int UserFunctions()
/*
CLIPS Function UserFunctions()

Here we notify the CLIPS startup code of the presence of the additional
functions.
*/
{
/*

	long (*pLongFn)(void);
	void (*pVoidFn)(void);

	pLongFn = AddListboxString;
        DefineFunction("add-listbox-string",'l', PTIF pLongFn,
		"AddListboxString");

	pVoidFn = ClearListbox;
	DefineFunction("clear-listbox",'v', PTIF pVoidFn,
		"ClearListbox");

	pVoidFn = SetStaticText;
	DefineFunction("set-static-text",'v', PTIF pVoidFn,
        	"SetStaticText");

	pVoidFn = ClearStaticText;
        DefineFunction("clear-static-text",'v', PTIF pVoidFn,
        	"ClearStaticText");

	pLongFn = ModalMessageBox;
        DefineFunction("modal-message-box",'l', PTIF pLongFn,
		"ModalMessageBox");

	pVoidFn = SetCurrentSelection;
	DefineFunction("set-current-selection",'v', PTIF pVoidFn,
		"SetCurrentSelection");

	pVoidFn = SetResponseAssertion;
	DefineFunction("set-response-assertion",'v', PTIF pVoidFn,
        	"SetResponseAssertion");

	pVoidFn = StatusReady;
	DefineFunction("status-ready",'v', PTIF pVoidFn,
        	"StatusReady");

	pVoidFn = StatusNotReady;
        DefineFunction("status-not-ready",'v', PTIF pVoidFn,
		"StatusNotReady");

	pVoidFn = Update;
        DefineFunction("update",'v', PTIF pVoidFn,
		"Update");

        pVoidFn = SaveConsultation;
	DefineFunction("save-consultation",'v', PTIF pVoidFn,
		"SaveConsultation");

	pVoidFn = SetCurrentNode;
	DefineFunction("set-current-node",'v', PTIF pVoidFn,
		"SetCurrentNode");
*/
}



/* The remaining functions are the first that are called when a
	CLIPS user defined function is called.  Each validates
	the number and type of arguments associated with each
	function before calling an associated workhorse function
	in the main C code
*/
/*

long AddListboxString(void)
{
	DATA_OBJECT data_String;

	if (ArgCountCheck("add-listbox-string",EXACTLY,1) == -1)
		return 0L;

	if (ArgTypeCheck("add-listbox-string",1,STRING,&data_String)==0)
		return 0L;

	return (long) lpfnCAddListBoxString(data_String);
}

void ClearListbox(void)
{
        if (ArgCountCheck("clear-listbox",EXACTLY,0) == -1)
		return;
	lpfnCClearListbox();
}

void SetStaticText(void)
{
	DATA_OBJECT data_String, data_Title;

	if (ArgCountCheck("set-static-text",EXACTLY,2) == -1)
		return;

        if (
		(ArgTypeCheck("set-static-text",1,STRING,&data_String) == 0)
        	|| (ArgTypeCheck("set-static-text",2,STRING,&data_Title) == 0))

                return;

        lpfnCSetStaticText(data_String,data_Title);
}


void ClearStaticText(void)
{
	if (ArgCountCheck("clear-static-text",EXACTLY,0) == -1)
        	return;

        lpfnCClearStaticText();
}

long ModalMessageBox(void)
{
	DATA_OBJECT data_String, data_Title, data_Buttons;

	if (ArgCountCheck("modal-message-box",EXACTLY,3) == -1)
		return -1L;

        if (
		(ArgTypeCheck("modal-message-box",1,STRING,&data_String) == 0)
        	|| (ArgTypeCheck("modal-message-box",2,STRING,&data_Title) == 0)
		|| (ArgTypeCheck("modal-message-box",3,INTEGER,&data_Buttons) == 0))
		return -1L;

        return (long)
		lpfnCModalMessageBox(data_String, data_Title, data_Buttons);
}


void SetCurrentSelection(void)
{
	DATA_OBJECT data_Pos;

        if (ArgCountCheck("set-current-selection",EXACTLY,1) == -1)
        	return;

        if (ArgTypeCheck("set-current-selection",1,INTEGER,&data_Pos) == 0)
        	return;

	lpfnCSetCurrentSelection(data_Pos);
}

void SetResponseAssertion(void)
{
	DATA_OBJECT data_Pos;

        if (ArgCountCheck("set-response-assertion",EXACTLY,1) == -1)
        	return;

        if (ArgTypeCheck("set-response-assertion",1,SYMBOL_OR_STRING,
					&data_Pos) == 0)
        	return;

        lpfnCSetResponseAssertion(data_Pos);
}


void StatusReady(void)
{
        if (ArgCountCheck("status-ready",EXACTLY,0) == -1)
        	return;

	lpfnCStatusReady();
}


void StatusNotReady(void)
{
	if (ArgCountCheck("status-not-ready",EXACTLY,0) == -1)
		return;

        lpfnCStatusNotReady();
}

void Update(void)
{
	if (ArgCountCheck("update",EXACTLY,0) == -1)
        	return;

        lpfnCUpdate();
}

void SaveConsultation(void)
{
	if (ArgCountCheck("save-consultation",EXACTLY,0) == -1)
        	return;

        lpfnCSaveConsultation();
}

void SetCurrentNode(void)
{
        DATA_OBJECT data_Node;

	if (ArgCountCheck("set-current-node",EXACTLY,1) == -1)
		return;

        if (ArgTypeCheck("set-current-node",1,SYMBOL_OR_STRING,
					&data_Node) == 0)
        	return;

        lpfnCSetCurrentNode(data_Node);
}

*/