   /*******************************************************/
   /*      "C" Language Integrated Production System      */
   /*                                                     */
   /*                  A Product Of The                   */
   /*             Software Technology Branch              */
   /*             NASA - Johnson Space Center             */
   /*                                                     */
   /*             CLIPS Version 5.10  07/17/91            */
   /*                                                     */
   /*            SYSTEM DEPENDENT HEADER FILE             */
   /*******************************************************/

/*************************************************************/
/* Purpose:                                                  */
/*                                                           */
/* Principal Programmer(s):                                  */
/*      Gary D. Riley                                        */
/*                                                           */
/* Contributing Programmer(s):                               */
/*                                                           */
/* Revision History:                                         */
/*                                                           */
/*************************************************************/

#ifndef _H_sysdep
#define _H_sysdep

#if IBM_TBC || IBM_MSC
#include <dos.h>
#endif

#ifdef LOCALE
#undef LOCALE
#endif

#ifdef _SYSDEP_SOURCE_
#define LOCALE
#else
#define LOCALE extern
#endif

/* Mods: Function pointer declaration syntax below was changed to conform to
		Borland C++ coding syntax */
#if ANSI_COMPILER
LOCALE VOID                           InitializeCLIPS(void);
LOCALE VOID                           SetRedrawFunction(void (*)(void));
LOCALE VOID                           SetPauseEnvFunction(void (*)(void));
LOCALE VOID                           SetContinueEnvFunction(void (*)(int));
LOCALE VOID                           RerouteStdin(int,char *[]);
LOCALE VOID                           InitializeDefaultRouters(void);
LOCALE double                         gentime(void);
LOCALE VOID                           gensystem(void);
LOCALE VOID                           VMSSystem(char *);
#if MAC_TC4 || MAC_TC5 || MAC_MPW
LOCALE VOID                           CallSystemTask(void);
#endif

LOCALE VOID                           genexit(int);
LOCALE int                            genrand(void);
LOCALE VOID                           genseed(int);
#else
LOCALE VOID                           InitializeCLIPS();
LOCALE VOID                           SetRedrawFunction();
LOCALE VOID                           SetPauseEnvFunction();
LOCALE VOID                           SetContinueEnvFunction();
LOCALE VOID                           RerouteStdin();
LOCALE VOID                           InitializeDefaultRouters();
LOCALE double                         gentime();
LOCALE VOID                           gensystem();
LOCALE VOID                           VMSSystem();
#if MAC_TC4 || MAC_TC5 || MAC_MPW
LOCALE VOID                           CallSystemTask();
#endif
LOCALE VOID                           genexit();
LOCALE int                            genrand();
LOCALE VOID                           genseed();
#endif

#ifndef _SYSDEP_SOURCE_
#if ANSI_COMPILER
   extern VOID                    (*RedrawScreenFunction)(void);
   extern VOID                    (*PauseEnvFunction)(void);
   extern VOID                    (*ContinueEnvFunction)(int);
#else
   extern VOID                    (*RedrawScreenFunction)();
   extern VOID                    (*PauseEnvFunction)();
   extern VOID                    (*ContinueEnvFunction)();
#endif
#endif

#endif
 




