   /*******************************************************/
   /*      "C" Language Integrated Production System      */
   /*                                                     */
   /*                  A Product Of The                   */
   /*             Software Technology Branch              */
   /*             NASA - Johnson Space Center             */
   /*                                                     */
   /*             CLIPS Version 5.10  07/17/91            */
   /*                                                     */
   /*               SYSTEM DEPENDENT MODULE               */
   /*******************************************************/

/*************************************************************/
/* Purpose:                                                  */
/*                                                           */
/* Principal Programmer(s):                                  */
/*      Gary D. Riley                                        */
/*                                                           */
/* Contributing Programmer(s):                               */
/*      Brian L. Donnell                                     */
/*                                                           */
/* Revision History:                                         */
/*                                                           */
/*************************************************************/

#define _SYSDEP_SOURCE_

#include "setup.h"

#include <stdio.h>
#define _CLIPS_STDIO_
#include <string.h>

#if ANSI_COMPILER || IBM_TBC || IBM_MSC
#include <stdlib.h>
#endif

#include "sysdep.h"
#include "constrct.h"
#include "intrfile.h"
#include "utility.h"
#include "clipsmem.h"
#include "evaluatn.h"
#include "router.h"

#if DEFFACTS_CONSTRUCT
#include "deffacts.h"
#endif

#if DEFRULE_CONSTRUCT
#include "defrule.h"
#endif

#if DEFGENERIC_CONSTRUCT
#include "genrccom.h"
#endif

#if DEFFUNCTION_CONSTRUCT
#include "deffnctn.h"
#endif

#if DEFGLOBAL_CONSTRUCT
#include "defglobl.h"
#endif

#if DEFTEMPLATE_CONSTRUCT
#include "deftempl.h"
#endif

#if OBJECT_SYSTEM
#include "extobj.h"
#endif

#if ANSI_COMPILER
   extern VOID   SystemFunctionDefinitions(void);
   extern int    UserFunctions(void);
   extern VOID   PrimaryFunctionDefinitions(void);
   extern VOID   SecondaryFunctionDefinitions(void);
   extern VOID   IOFunctionDefinitions(void);
   extern VOID   PredicateFunctionDefinitions(void);
   extern VOID   FileFunctionDefinitions(void);
   extern VOID   MultifieldFunctionDefinitions(void);
   extern VOID   StringFunctionDefinitions(void);
   extern VOID   MathFunctionDefinitions(void); 
   extern VOID   HelpFunctionDefinitions(void);
   extern VOID   EditorFunctionDefinition(void);
   extern VOID   ConstructsToCCommandDefinition(void);
   extern VOID   InitializeAtomTables(void);
   extern VOID   InitializeFacts(void);
   extern VOID   InitGenModule(void);
   extern VOID   InitializeSpecialForms(void);        
   extern VOID   InitializeConstructs(void);
#else
   extern VOID   SystemFunctionDefinitions();
   extern int    UserFunctions();
   extern VOID   PrimaryFunctionDefinitions();
   extern VOID   SecondaryFunctionDefinitions();
   extern VOID   IOFunctionDefinitions();
   extern VOID   PredicateFunctionDefinitions();
   extern VOID   FileFunctionDefinitions();
   extern VOID   MultifieldFunctionDefinitions();
   extern VOID   StringFunctionDefinitions();
   extern VOID   MathFunctionDefinitions(); 
   extern VOID   HelpFunctionDefinitions();
   extern VOID   EditorFunctionDefinition();
   extern VOID   ConstructsToCCommandDefinition();
   extern VOID   InitializeAtomTables();
   extern VOID   InitializeFacts();
   extern VOID   InitGenModule();
   extern VOID   InitializeSpecialForms();        
   extern VOID   InitializeConstructs();
#endif

#if ANSI_COMPILER
   static VOID                    InitializeNonportableFeatures(void);
#if   VMS || UNIX_V || UNIX_7
   static int                     CatchCtrlC(void);
#endif
#if   (IBM_TBC || IBM_MSC) && (! WINDOW_INTERFACE)
   static VOID interrupt          CatchCtrlC(void);
   static VOID                    RestoreInterruptVectors(void);
#endif
#else
   static VOID                    InitializeNonportableFeatures();
#if   VMS || UNIX_V || UNIX_7
   static int                     CatchCtrlC();
#endif
#if   (IBM_TBC || IBM_MSC) && (! WINDOW_INTERFACE)
   static VOID interrupt          CatchCtrlC();
   static VOID                    RestoreInterruptVectors();
#endif
#endif

/***************************************/
/* LOCAL INTERNAL VARIABLE DEFINITIONS */
/***************************************/

#if ANSI_COMPILER
#if ! WINDOW_INTERFACE
#if IBM_TBC
   static VOID interrupt  (*OldCtrlC)(void);
   static VOID interrupt  (*OldBreak)(void);
#endif
#if IBM_MSC
   static VOID  (interrupt *OldCtrlC)(void);
   static VOID  (interrupt *OldBreak)(void);
#endif
#endif
#else
#if ! WINDOW_INTERFACE
#if IBM_TBC
   static VOID interrupt  (*OldCtrlC)();
   static VOID interrupt  (*OldBreak)();
#endif
#if IBM_MSC
   static VOID  (interrupt *OldCtrlC)();
   static VOID  (interrupt *OldBreak)();
#endif
#endif
#endif

/****************************************/
/* GLOBAL INTERNAL VARIABLE DEFINITIONS */
/****************************************/

#if ANSI_COMPILER
   globle VOID             (*RedrawScreenFunction)(void) = NULL;
   globle VOID             (*PauseEnvFunction)(void) = NULL;
   globle VOID             (*ContinueEnvFunction)(int) = NULL;
#else
   globle VOID             (*RedrawScreenFunction)() = NULL;
   globle VOID             (*PauseEnvFunction)() = NULL;
   globle VOID             (*ContinueEnvFunction)() = NULL;
#endif

/******************************************************/
/* InitializeCLIPS: Performs initialization of CLIPS. */
/******************************************************/
globle VOID InitializeCLIPS()
  {
   static BOOLEAN alreadyInitialized = CLIPS_FALSE;
   
   if (alreadyInitialized) return;
   
   InitializeDefaultRouters();        /* Initalizes streams for I/O.        */
   InitializeNonportableFeatures();   /* System dependent initializations.  */
   
#if ! RUN_TIME
   InitializeAtomTables();            /* Initializes the atom hash tables.  */
   SystemFunctionDefinitions();       /* Define system functions.           */
   UserFunctions();     
#endif

   InitializeFacts();                 /* Initializes use of facts.          */
   
#if ! RUN_TIME
   InitGenModule();                   /* Initializes function pointers.     */
   InitializeSpecialForms();          /* Initializes expression parsers.    */
   InitializeConstructs();
#endif
   
#if DEFRULE_CONSTRUCT
   InitializeDefrules();
#endif

#if (! BLOAD_ONLY) && (! RUN_TIME)
   InitializeIgnoredConstructs();            
#endif

#if DEFFACTS_CONSTRUCT
   InitializeDeffacts();
#endif

#if DEFGENERIC_CONSTRUCT
   SetupGenericFunctions();
#endif  
 
#if DEFFUNCTION_CONSTRUCT
   InitializeDeffunctions();
#endif

#if DEFGLOBAL_CONSTRUCT
   InitializeDefglobal();
#endif

#if DEFTEMPLATE_CONSTRUCT
   InitializeDeftemplates();
#endif

#if OBJECT_SYSTEM
   SetupObjectSystem();
#endif

   alreadyInitialized = CLIPS_TRUE;
   return;
  }

/***************************************************************/
/* SetRedrawFunction: Redraws the screen if clipswin is main */
/*                       or does nothing.                      */
/***************************************************************/
globle VOID SetRedrawFunction(fun_ptr)
  VOID (*fun_ptr)(VOID_ARG);
  {
   RedrawScreenFunction = fun_ptr;
  }
  
/***************************************************************/
/* SetPauseEnvFunction: Puts terminal in a normal state if */
/*                      clipswin is main or does nothing.      */
/***************************************************************/
globle VOID SetPauseEnvFunction(fun_ptr)
  VOID (*fun_ptr)(VOID_ARG);
  {
   PauseEnvFunction = fun_ptr;
  }

/**********************************************************/
/* SetContinueEnvFunction: Returns terminal to special screen */
/*   interface state if clipswin is main or does nothing. */
/**********************************************************/
globle VOID SetContinueEnvFunction(fun_ptr)
#if ANSI_COMPILER
   void (*fun_ptr)(int);
#else
   VOID (*fun_ptr)();
#endif
  {
   ContinueEnvFunction = fun_ptr;
  }

/****************************************************************/
/* RerouteStdin: Reroutes stdin to read initially from the file */
/*                specified on the command line with -f option. */
/****************************************************************/
globle VOID RerouteStdin(argc,argv)
int argc;
char *argv[];
  {
   int i;

   /* If no arguments return */
   if (argc < 3)
     { return; }

   /* If argv was not passed then forget it */
   if (argv == NULL)
      return;

   for (i = 1 ; i < argc ; i++)
     {
      if (strcmp(argv[i],"-f") == 0)
	{
	 if (i > (argc-1))
	   {
	    PrintCLIPS(WERROR,"No file found for -f option\n");
	    return;
	   }
	 else
	   OpenBatch(argv[++i],CLIPS_TRUE);
	}
     }
  }

#if ! RUN_TIME
/**************************************************/
/* SystemFunctionDefinitions: Sets up definitions */
/*   of system defined functions.                 */
/**************************************************/
globle VOID SystemFunctionDefinitions()
  {
   PrimaryFunctionDefinitions();
   SecondaryFunctionDefinitions();
   IOFunctionDefinitions();
   PredicateFunctionDefinitions();
   FileFunctionDefinitions();
   
#if MULTIFIELD_FUNCTIONS
   MultifieldFunctionDefinitions();
#endif

#if STRING_FUNCTIONS
   StringFunctionDefinitions();
#endif

#if EX_MATH
   MathFunctionDefinitions(); 
#endif     

#if CLP_TEXTPRO || CLP_HELP
   HelpFunctionDefinitions();
#endif

#if CLP_EDIT
   EditorFunctionDefinition();
#endif

#if CONSTRUCT_COMPILER
   ConstructsToCCommandDefinition();
#endif
  }
#endif

/*************************************************************/
/* gentime: A function to return a floating point number  */
/*   which indicates the present time. Used internally by    */
/*   CLIPS for timing rule firings and debugging.            */
/*************************************************************/

#if   VMS
#include timeb
#endif

#if   IBM_MSC
#include <sys\types.h>
#include <sys\timeb.h>
#endif

#if   IBM_TBC
#include <bios.h>
#endif

#if   UNIX_7
#include <sys/types.h>
#include <sys/timeb.h>
#endif

#if   UNIX_V
#include <sys/types.h>
#include <sys/times.h>
#endif

#if   MAC_MPW || MAC_TC5
#include <Events.h>
#include <Desk.h>
#endif

globle double gentime()
  {
#if   VMS || IBM_MSC ||  UNIX_7
   double sec, msec;
   int temp;
   struct timeb time_pointer;

   ftime(&time_pointer);
   temp = (int) time_pointer.time;
   temp = temp - ((temp/10000) * 10000);
   sec  = (double) temp;
   msec = (double) time_pointer.millitm;
   return(sec + (msec / 1000.0));
#endif

#if   UNIX_V
   long t_int;
   double t;
   struct tms buf;

   t_int = times(&buf);
   t = (double) t_int / 60.0; 
   return(t);
#endif

#if   MAC_TC4 || MAC_TC5 || MAC_MPW
   unsigned long int result;
   
   result = TickCount();

   return((double) result / 60.0);
#endif

#if   IBM_TBC
   unsigned long int result;
   
   result = biostime(0,(long int) 0);

   return((double) result / 18.2);
#endif

#if GENERIC
   return(0.0);
#endif                 
  }


/*****************************************************************/
/* gensystem:  This function can be called from CLIPS.  It will  */
/*   form a command string from its arguments, and pass this     */
/*   string to the operating system.  As currently defined, this */
/*   function does nothing, however, code has been included      */
/*   which should allow this function to work under VAX VMS and  */
/*   UNIX compatible systems.                                    */
/*****************************************************************/

#if   IBM_MSC
#include <process.h>
#endif

globle VOID gensystem()
  {
/* Mod:  Under Microsoft Windows, CLIPS cannot pass a command
		to DOS */
#ifndef MS_WINDOWS
   char *commandBuffer = NULL;
   int buff_index = 0;
   int buff_max = 0; 
   int numa, i;
   DATA_OBJECT arg_ptr;
	char *str_ptr;
   
   if ((numa = ArgCountCheck("system",AT_LEAST,1)) == -1) return;

   for (i = 1 ; i <= numa; i++)
	  {
      RtnUnknown(i,&arg_ptr);
      if ((GetType(arg_ptr) != STRING) &&
	  (GetType(arg_ptr) != SYMBOL))
		  {
	 SetHaltExecution(CLIPS_TRUE);
	 SetEvaluationError(CLIPS_TRUE);
	 ExpectedTypeError("system",i,"symbol or string");
			return;
	}
      
     str_ptr = DOToString(arg_ptr);
     
	  commandBuffer = AppendToString(str_ptr,commandBuffer,&buff_index,&buff_max);
    }
    
   if (commandBuffer == NULL) return;

#if VMS
   if (PauseEnvFunction != NULL) (*PauseEnvFunction)();
   VMSSystem(commandBuffer);
	putchar('\n');
   if (ContinueEnvFunction != NULL) (*ContinueEnvFunction)(1);
   if (RedrawScreenFunction != NULL) (*RedrawScreenFunction)();
#endif

#if   UNIX_7 || UNIX_V || IBM_MSC || IBM_TBC
   if (PauseEnvFunction != NULL) (*PauseEnvFunction)();
   system(commandBuffer);
   if (ContinueEnvFunction != NULL) (*ContinueEnvFunction)(1);
	if (RedrawScreenFunction != NULL) (*RedrawScreenFunction)();
#else

#if ! VMS
	PrintCLIPS(WDIALOG,
	    "System function not fully defined for this system.\n");
#endif

#endif

	rm(commandBuffer,buff_max);

	return;
#endif        
/*     Mod: ifndef MS_WINDOWS */
	}

#if   VMS
#include <descrip.h>
#include <ssdef.h>
#include <stsdef.h>

extern int LIB$SPAWN();

globle VOID VMSSystem(cmd)
  char *cmd;
  {
   long status, complcode;
	struct dsc$descriptor_s cmd_desc;

   cmd_desc.dsc$w_length = strlen(cmd);
   cmd_desc.dsc$a_pointer = cmd;
   cmd_desc.dsc$b_class = DSC$K_CLASS_S;
   cmd_desc.dsc$b_dtype = DSC$K_DTYPE_T;

   status = LIB$SPAWN(&cmd_desc,0,0,0,0,0,&complcode,0,0,0);
  }
#endif
 
/**************************************************************/
/* The following two functions are provided to trap control-c */
/* in order to interrupt the execution of a program.          */
/**************************************************************/

#if ! WINDOW_INTERFACE

#if   VMS
#include signal
#endif

#if UNIX_V || UNIX_7
#include <signal.h>
#endif

#if IBM_TBC || IBM_MSC
/* #include <dos.h> - already included from sysdep.h */
#endif

#if   MAC_MPW
#include <Desk.h>
#endif

#endif

static VOID InitializeNonportableFeatures()
  {
#if ! WINDOW_INTERFACE

#if MAC_TC4 || MAC_TC5 || MAC_MPW
   AddPeriodicFunction("systemtask",CallSystemTask,0);
#endif

#if VMS || UNIX_V || UNIX_7
   signal(SIGINT,CatchCtrlC);
#endif

#if IBM_TBC
   OldCtrlC = getvect(0x23);
   OldBreak = getvect(0x1b);
   setvect(0x23,CatchCtrlC);
   setvect(0x1b,CatchCtrlC);
   atexit(RestoreInterruptVectors);
#endif

#if IBM_MSC 
   OldCtrlC = _dos_getvect(0x23);
   OldBreak = _dos_getvect(0x1b);
   _dos_setvect(0x23,CatchCtrlC);
   _dos_setvect(0x1b,CatchCtrlC);
   atexit(RestoreInterruptVectors);
#endif

#endif
  }
  
#if ! WINDOW_INTERFACE

#if MAC_TC4 || MAC_TC5 || MAC_MPW
globle VOID CallSystemTask()
  {
   static unsigned long int lastCall;
   
   if (TickCount() < (lastCall + 10)) return;
   SystemTask(); 
   lastCall = TickCount();
   return;
  }
#endif

#if   VMS || UNIX_V || UNIX_7
static int CatchCtrlC()
  {
   SetHaltExecution(CLIPS_TRUE);
   CloseAllBatchSources();
   signal(SIGINT,CatchCtrlC);
   return(1);
  }
#endif

#if   IBM_TBC || IBM_MSC
static VOID interrupt CatchCtrlC()
  {
   SetHaltExecution(CLIPS_TRUE);
   CloseAllBatchSources();
  }

static VOID RestoreInterruptVectors()
  {
#if IBM_TBC
   setvect(0x23,OldCtrlC);
   setvect(0x1b,OldBreak);
#else
   _dos_setvect(0x23,OldCtrlC);
   _dos_setvect(0x1b,OldBreak);
#endif
  }
  
#endif

#endif

/******************************************/
/* GENEXIT:  A generic exit function.     */
/*   Error codes:                         */
/*    -1 - Normal exit                    */
/*     1 - Out of memory exit             */
/*     2 - Arbitrary limit violation exit */
/*     3 - Memory release error exit      */
/*     4 - Rule parsing exit              */
/*     5 - Run time exit                  */
/*     6 - Rule maintenance exit          */
/******************************************/
globle VOID genexit(num)
  int num;
  {
   exit(num);
  }

/***************************************/
/* genrand:                            */
/***************************************/
int genrand()
  {
#if ANSI_COMPILER
   return(rand());
#else
   return(0);
#endif
  }

/***************************************/
/* genseed:                            */
/***************************************/
globle VOID genseed(seed)
  int seed;
  {
#if ANSI_COMPILER
   srand(seed);
#endif
  }
 
 




