   /* SETUP.H contains revisions needed to compile the CLIPS
	DLL successfully for use with DX. */

   /*******************************************************/
   /*      "C" Language Integrated Production System      */
   /*                                                     */
   /*                  A Product Of The                   */
   /*             Software Technology Branch              */
   /*             NASA - Johnson Space Center             */
   /*                                                     */
   /*             CLIPS Version 5.10  07/17/91            */
   /*                                                     */
   /*                  SETUP HEADER FILE                  */
   /*******************************************************/

/*************************************************************/
/* Purpose:                                                  */
/*                                                           */
/* Principal Programmer(s):                                  */
/*      Gary D. Riley                                        */
/*                                                           */
/* Contributing Programmer(s):                               */
/*                                                           */
/* Revision History:                                         */
/*                                                           */
/*************************************************************/

/****************************************************************/
/* This file is the general header file for CLIPS. It contains  */
/* the global definitions used by CLIPS, and the compiler flags */
/* you have to edit to create a version of CLIPS for a specific */
/* system.                                                      */
/*                                                              */
/* If CLIPS is being used as an embedded tool, then this file   */
/* should be included in at least the main program. Any other   */
/* files which contain functions referring to things defined in */
/* this file must also include this file.                       */
/****************************************************************/

#ifndef _H_setup
#define _H_setup

/****************************************************************/
/* -------------------- COMPILER FLAGS ------------------------ */
/****************************************************************/

/****************************************************************/
/* Flag denoting what kind of machine CLIPS is to run on. Only  */
/* one of these flags should be turned on (set to 1) at a time. */
/****************************************************************/

#define GENERIC       0   /* Generic CLIPS (any machine)           */
#define VMS           0   /* VAX VMS                               */
#define UNIX_V        0   /* UNIX System V or 4.2bsd or HP Unix    */
#define UNIX_7        0   /* UNIX System III Version 7 or Sun Unix */
#define MAC_TC4       0   /* Apple Macintosh, with Think C 4.0.5   */
#define MAC_TC5       0   /* Apple Macintosh, with Think C 5.0     */
#define MAC_MPW       0   /* Apple Macintosh, with MPW 3.2 C       */
#define IBM_MSC       0   /* IBM PC, with Microsoft C (5.1)        */
#define IBM_TBC       1   /* IBM PC, with Turbo C (2.0 or higher)  */

/************************************************************/
/* ANSI_COMPILER: Set this flag to 1 if the compiler being  */
/*   used follows the draft proposed ANSI C standards       */
/*   (including the ANSI C libraries). Set this flag to 0,  */
/*   if the compiler being used follows the K & R standard. */
/************************************************************/

#define ANSI_COMPILER  1

#if ANSI_COMPILER
#define VOID     void
#define VOID_ARG void
#else
#define VOID     char
#define VOID_ARG
#endif
#define BOOLEAN int
#define globle

#if IBM_MSC || IBM_TBC
#define HUGE_ADDR huge
#else
#define HUGE_ADDR 
#endif


#if IBM_TBC

/* Mod:  The following compiler directives were added for
		compiling a MS-Windows DLL */
#ifdef _Windows 
#define MS_WINDOWS
#endif

#ifndef EXPORT
#ifdef __DLL__
#define EXPORT _export
#else
#define EXPORT
#endif
#endif

#endif
/****************************************************/
/* RUN_TIME:  Produces a run-time module for CLIPS. */
/****************************************************/

#define RUN_TIME 0

/**************************************************/
/* DEFRULE_CONSTRUCT:  Determines whether defrule */
/*   construct is included.                       */
/**************************************************/

#define DEFRULE_CONSTRUCT 1

/****************************************************/
/* DEFFACTS_CONSTRUCT:  Determines whether deffacts */
/*   construct is included.                         */
/****************************************************/

#define DEFFACTS_CONSTRUCT 1

/**************************************************/
/* DEFTEMPLATE_CONSTRUCT:  Determines whether the */
/*   deftemplate construct is included.           */
/**************************************************/

#define DEFTEMPLATE_CONSTRUCT 1

/************************************************/
/* DEFGLOBAL_CONSTRUCT:  Determines whether the */
/*   defglobal construct is included.           */
/************************************************/

#define DEFGLOBAL_CONSTRUCT 1

/**********************************************/
/* DEFFUNCTION_CONSTRUCT:  Determines whether */
/*   deffunction construct is included.       */
/**********************************************/

#define DEFFUNCTION_CONSTRUCT 1

/*********************************************/
/* DEFGENERIC_CONSTRUCT:  Determines whether */
/*   generic functions  are included.        */
/*********************************************/

#define DEFGENERIC_CONSTRUCT 1

/*****************************************************************/
/* OBJECT_SYSTEM:  Determines whether object system is included. */
/*   The MULTIFIELD_FUNCTIONS flag should also be on if you want */
/*   to be able to manipulate multi-field slots.                 */
/*****************************************************************/

#define OBJECT_SYSTEM 1

/****************************************************************/
/* EXTENDED MATH PACKAGE FLAG: If this is on, then the extended */
/* math package functions will be available for use, (normal    */
/* default). If this flag is off, then the extended math        */
/* functions will not be available, and the 30K or so of space  */
/* they require will be free. Usually a concern only on PC type */
/* machines.                                                    */
/****************************************************************/

#define EX_MATH  1

/****************************************************************/
/* TEXT PROCESSING : Turn on this flag for support of the       */
/* hierarchical lookup system.                                  */
/****************************************************************/

#define CLP_TEXTPRO 1

/****************************************************************/
/* HELP: To implement the help facility, set the flag below and */
/* specify the path and name of the help data file your system. */
/****************************************************************/

#define CLP_HELP 0

#if CLP_HELP

#define HELP_DEFAULT "clips.hlp"

#endif

/*************************************************************************/
/* BLOAD_ONLY:      Enables bload command and disables the load command. */
/* BLOAD:           Enables bload command.                               */
/* BLOAD_AND_BSAVE: Enables bload, and bsave commands.                   */
/*************************************************************************/

#define BLOAD_ONLY      0               /* sed */
#define BLOAD           0               /* sed */
#define BLOAD_AND_BSAVE 1               /* sed */

#if RUN_TIME
#undef BLOAD_ONLY
#define BLOAD_ONLY      0
#undef BLOAD
#define BLOAD           0
#undef BLOAD_AND_BSAVE
#define BLOAD_AND_BSAVE 0
#endif

/****************************************************************/
/* EDITOR: If this flag is turned on, an integrated EMACS style */
/*   editor can be called directly from CLIPS                   */
/****************************************************************/

#define  CLP_EDIT  0                    /* sed */

#if GENERIC || MAC_TC4 || MAC_TC5 || MAC_MPW
#undef CLP_EDIT                         /* Editor can't be used */
#define  CLP_EDIT  0                    /* with Generic or Mac  */
#endif

/*******************************************************************/
/* CONSTRUCT COMPILER: If this flag is turned on, you can generate */
/*   representing the CLIPS constructs which can be compiled and   */
/*   linked with CLIPS to create a run-time executable.            */
/*******************************************************************/

#define  CONSTRUCT_COMPILER  1

/*******************************************/
/* BASIC_IO: Includes printout, fprintout, */
/*   read, open, and close functions.      */
/*******************************************/

#define BASIC_IO 1

/***************************************************/
/* EXT_IO: Includes format and readline functions. */
/***************************************************/

#define EXT_IO 1

/************************************************/
/* STRING_FUNCTIONS: Includes string functions: */
/*   str-length, str-compare, upcase, lowcase,  */
/*   sub-string, str-index, and eval.           */
/************************************************/

#define STRING_FUNCTIONS 1

/*********************************************/
/* MULTIFIELD_FUNCTIONS: Includes multifield */
/*   functions:  mv-subseq, mv-delete,       */
/*   mv-append, str-explode, str-implode.    */
/*********************************************/

#define MULTIFIELD_FUNCTIONS 1

/****************************************************/
/* DEBUGGING_FUNCTIONS: Includes functions such as  */
/*   rules, facts, matches, ppdefrule, etc.         */
/****************************************************/

#define DEBUGGING_FUNCTIONS 1

/************************************************************************/
/* BLOCK_MEMORY: Causes memory to be allocated in large blocks.         */
/*   INITBUFFERSIZE and BLOCKSIZE should both be set to less than the  */
/*   maximum size of a signed integer. On a 16-bit machine, they should */
/*   be less than 32768. If a LightSpeed (Think) C version 2.x or 3.x   */
/*   compiler is being used, then this option should be turned on.      */
/************************************************************************/

#define BLOCK_MEMORY 1

#if BLOCK_MEMORY

#define INITBLOCKSIZE 32000   
#define BLOCKSIZE 32000      

#endif

/*****************************************************************/
/* WINDOW_INTERFACE : Set this flag if you are recompiling the   */
/*   IBM-PC MS-DOS Window Interface or the Macintosh LSC Window  */
/*   Interface. Currently, when enabled, this flag disables the  */
/*   more processing used by the help system.                    */
/*   This flag also prevents any input or output being directly  */
/*   sent to stdin or stdout.                                    */
/*****************************************************************/

#define WINDOW_INTERFACE 1

/******************************************************************/
/* STUDENT: Produces a version for use in teaching environments.  */
/*   Limits salience values to -2 to +2 and does not allow if and */
/*   while expressions.                                           */
/******************************************************************/

#define STUDENT 0

/*****************************************************************/
/* SHORT_LINK_NAMES: Converts some function and global variable  */
/*   names to 6 characters. Use with linkers that recognize      */
/*   fewer significant characters than the C compiler generating */
/*   the object code.                                            */
/*****************************************************************/

#define SHORT_LINK_NAMES 0

#if SHORT_LINK_NAMES
#include "shrtlnkn.h"
#endif

#endif








