   /*******************************************************/
   /*      "C" Language Integrated Production System      */
   /*                                                     */
   /*                  A Product Of The                   */
   /*             Software Technology Branch              */
   /*             NASA - Johnson Space Center             */
   /*                                                     */
   /*             CLIPS Version 5.10  07/17/91            */
   /*                                                     */
   /*                 ROUTER HEADER FILE                  */
   /*******************************************************/

/*************************************************************/
/* Purpose:                                                  */
/*                                                           */
/* Principal Programmer(s):                                  */
/*      Gary D. Riley                                        */
/*                                                           */
/* Contributing Programmer(s):                               */
/*                                                           */
/* Revision History:                                         */
/*                                                           */
/*************************************************************/

#ifndef _H_router
#define _H_router

#ifndef _CLIPS_STDIO_
#define _CLIPS_STDIO_
#include <stdio.h>
#endif

#ifdef LOCALE
#undef LOCALE
#endif

#ifdef _ROUTER_SOURCE_
#define LOCALE
#else
#define LOCALE extern
#endif

/**************************/
/* I/O ROUTER DEFINITIONS */
/**************************/

#if ANSI_COMPILER
LOCALE VOID                           InitializeDefaultRouters(void);
LOCALE int                            PrintCLIPS(char *,char *);
LOCALE int                            GetcCLIPS(char *);
LOCALE int                            UngetcCLIPS(int,char *);
LOCALE VOID                           ExitCLIPS(int); 
LOCALE VOID                           AbortExit(void);
/* Mod:  This allows the code to compile correctly as C++ code */
/* Mods: Function pointer declaration syntax below was changed to conform to
		Borland C++ coding syntax */
#ifdef __cplusplus
LOCALE BOOLEAN                        AddRouter(char *,int,int (*)(char *),int (*)(char *,char *),int (*)(char *),int (*)(char, char *),int (*)(int));
#else
LOCALE BOOLEAN                        AddRouter(char *,int,int (*)(),int (*)(),int (*)(),int (*)(),int (*)());
#endif
LOCALE int                            DeleteRouter(char *);
LOCALE int                            QueryRouters(char *);
LOCALE int                            DeactivateRouter(char *);
LOCALE int                            ActivateRouter(char *);
LOCALE VOID                           SetFastLoad(FILE *);
LOCALE VOID                           SetFastSave(FILE *);
LOCALE FILE                          *GetFastLoad(void);
LOCALE FILE                          *GetFastSave(void);
LOCALE int                            OpenStringSource(char *,char *,int);
LOCALE int                            OpenTextSource(char *,char *,int,int);
LOCALE int                            CloseStringSource(char *);
LOCALE int                            OpenStringDestination(char *,char *,int);
LOCALE int                            CloseStringDestination(char *);
LOCALE VOID                           InitializeStringRouter(void);
LOCALE FILE                          *FindFptr(char *);
/* Mod:
 >In the CLIPS code you will have to rename the procedure
 >OpenFile() as it is already used by Windows.  I use
 >ClipsOpenFile().  ROUTER.C, ROUTER.H, SYSIO.C,
*/
LOCALE int                            CLIPSOpenFile(char *,char *,char *);
LOCALE int                            CloseAllFiles(void);
LOCALE int                            CloseFile(char *);
LOCALE int                            FindFile(char *);
LOCALE VOID                           UnrecognizedRouterMessage(char *);
#else
LOCALE VOID                           InitializeDefaultRouters();
LOCALE int                            PrintCLIPS();
LOCALE int                            GetcCLIPS();
LOCALE int                            UngetcCLIPS();
LOCALE VOID                           ExitCLIPS(); 
LOCALE VOID                           AbortExit();
LOCALE BOOLEAN                        AddRouter();
LOCALE int                            DeleteRouter();
LOCALE int                            QueryRouters();
LOCALE int                            DeactivateRouter();
LOCALE int                            ActivateRouter();
LOCALE VOID                           SetFastLoad();
LOCALE VOID                           SetFastSave();
LOCALE FILE                          *GetFastLoad();
LOCALE FILE                          *GetFastSave();
LOCALE int                            OpenStringSource();
LOCALE int                            OpenTextSource();
LOCALE int                            CloseStringSource();
LOCALE int                            OpenStringDestination();
LOCALE int                            CloseStringDestination();
LOCALE VOID                           InitializeStringRouter();
LOCALE FILE                          *FindFptr();
/* Mod:
 >In the CLIPS code you will have to rename the procedure
 >OpenFile() as it is already used by Windows.  I use
 >ClipsOpenFile().  ROUTER.C, ROUTER.H, SYSIO.C,
*/
LOCALE int                            CLIPSOpenFile();
LOCALE int                            CloseAllFiles();
LOCALE int                            CloseFile();
LOCALE int                            FindFile();
LOCALE VOID                           UnrecognizedRouterMessage();
#endif 

#ifndef _ROUTER_SOURCE_
   extern char                *WERROR; 
   extern char                *WTRACE;
   extern char                *WDIALOG;
   extern char                *WCLIPS;
   extern char                *WDISPLAY;
   extern int                  CLIPSInputCount;
#endif

#endif






