   /*******************************************************/
   /*      "C" Language Integrated Production System      */
   /*                                                     */
   /*                  A Product Of The                   */
   /*             Software Technology Branch              */
   /*             NASA - Johnson Space Center             */
   /*                                                     */
   /*             CLIPS Version 5.10 07/17/91             */
   /*                                                     */
   /*                  CONSTRUCT MODULE                   */
   /*******************************************************/

/*************************************************************/
/* Purpose:                                                  */
/*                                                           */
/* Principal Programmer(s):                                  */
/*      Gary D. Riley                                        */
/*                                                           */
/* Contributing Programmer(s):                               */
/*                                                           */
/* Revision History:                                         */
/*                                                           */
/*************************************************************/
 
#ifndef _H_constrct

#define _H_constrct

#ifdef LOCALE
#undef LOCALE
#endif

#ifdef _CONSTRCT_SOURCE_
#define LOCALE
#else
#define LOCALE extern
#endif
   
/* Mods: Function pointer declaration syntax below was changed to conform to
		Borland C++ coding syntax */

#if ANSI_COMPILER
   LOCALE int                            LoadConstructs(char *);
   LOCALE VOID                           LoadConstructsFromLogicalName(char *); 
   LOCALE VOID                           InitializeIgnoredConstructs(void);
   LOCALE int                            ParseIgnoredConstruct(char *);
   LOCALE int                            SaveConstructs(char *);
   LOCALE BOOLEAN                        AddSaveFunction(char *,int (*)(),int);
   LOCALE BOOLEAN                        RemoveSaveFunction(char *);
   LOCALE VOID                           ResetCLIPS(void);
   LOCALE BOOLEAN                        AddResetFunction(char *,VOID (*)(),int);
   LOCALE BOOLEAN                        RemoveResetFunction(char *);
   LOCALE VOID                           ClearCLIPS(void);
   LOCALE VOID                           CallClearFunctions(void);
   LOCALE BOOLEAN                        AddClearFunction(char *,VOID (*)(),int);
   LOCALE BOOLEAN                        RemoveClearFunction(char *);
   LOCALE VOID                           AddConstruct(char *,int (*)());
   LOCALE int                            RemoveConstruct(char *);
   LOCALE int                            ValidConstruct(char *);
   LOCALE int                            ParseConstruct(char *,char *);
   LOCALE VOID                           SetCompilationsWatch(int);
   LOCALE BOOLEAN                        GetCompilationsWatch(void);
   LOCALE VOID                           SetPrintWhileLoading(BOOLEAN);
   LOCALE BOOLEAN                        GetPrintWhileLoading(void);
   LOCALE int                            ExecutingConstruct(void);
   LOCALE VOID                           SetExecutingConstruct(int);
   LOCALE VOID                           InitializeConstructs(void);
   LOCALE int                          (*SetBeforeResetFunction(int (*)()))();
   LOCALE int                          (*SetBeforeClearFunction(int (*)()))();
#else
   LOCALE int                            LoadConstructs();
   LOCALE VOID                           LoadConstructsFromLogicalName(); 
   LOCALE VOID                           InitializeIgnoredConstructs();
   LOCALE int                            ParseIgnoredConstruct();
   LOCALE int                            SaveConstructs();
   LOCALE BOOLEAN                        AddSaveFunction();
   LOCALE BOOLEAN                        RemoveSaveFunction();
   LOCALE VOID                           ResetCLIPS();
   LOCALE BOOLEAN                        AddResetFunction();
   LOCALE BOOLEAN                        RemoveResetFunction();
   LOCALE VOID                           ClearCLIPS();
   LOCALE VOID                           CallClearFunctions();
   LOCALE BOOLEAN                        AddClearFunction();
   LOCALE BOOLEAN                        RemoveClearFunction();
   LOCALE VOID                           AddConstruct();
   LOCALE int                            RemoveConstruct();
   LOCALE int                            ValidConstruct();
   LOCALE int                            ParseConstruct();
   LOCALE VOID                           SetCompilationsWatch();
   LOCALE BOOLEAN                        GetCompilationsWatch();
   LOCALE VOID                           SetPrintWhileLoading();
   LOCALE BOOLEAN                        GetPrintWhileLoading();
   LOCALE int                            ExecutingConstruct();
   LOCALE VOID                           SetExecutingConstruct();
   LOCALE VOID                           InitializeConstructs();
   LOCALE int                          (*SetBeforeResetFunction())();
   LOCALE int                          (*SetBeforeClearFunction())();
#endif 

#endif







