   /*******************************************************/
   /*      "C" Language Integrated Production System      */
   /*                                                     */
   /*                  A Product Of The                   */
   /*             Software Technology Branch              */
   /*             NASA - Johnson Space Center             */
   /*                                                     */
   /*             CLIPS Version 5.10  07/17/91            */
   /*                                                     */
   /*                CONSTANTS HEADER FILE                */
   /*******************************************************/

/*************************************************************/
/* Purpose:                                                  */
/*                                                           */
/* Principal Programmer(s):                                  */
/*      Gary D. Riley                                        */
/*                                                           */
/* Contributing Programmer(s):                               */
/*                                                           */
/* Revision History:                                         */
/*                                                           */
/*************************************************************/

/****************************************************************/
/* --------------- CLIPS Constants and Macros ----------------- */
/****************************************************************/

#ifndef _H_constant

#define _H_constant

/*  Mod:
 >In the file CONSTANT.H the #define for WORD will 
 >conflict with Windows.  The definition for WORD is no
 >longer used  by CLIPS 5.1 so you can remove it from the
 >file.
*/

#define FALSE 0
#define TRUE 1

#define CLIPS_FALSE 0
#define CLIPS_TRUE 1
#define EXACTLY       0
#define AT_LEAST      1
#define NO_MORE_THAN  2
#define RANGE 3

#define OFF 0
#define ON 1
#define LHS 0
#define RHS 1
#define NEGATIVE 0
#define POSITIVE 1
#define EOS '\0'

#define INSIDE  0
#define OUTSIDE 1

/* TOKEN AND TYPE VALUES */

#define PRIMITIVE_TYPE_NAME   "PRIMITIVE"
#define NUMBER_TYPE_NAME      "NUMBER"
#define INTEGER_TYPE_NAME     "INTEGER"
#define FLOAT_TYPE_NAME       "FLOAT"
#define SYMBOL_TYPE_NAME      "SYMBOL"
#define STRING_TYPE_NAME      "STRING"
#define MULTIFIELD_TYPE_NAME  "MULTIFIELD"
#define LEXEME_TYPE_NAME      "LEXEME"
#define ADDRESS_TYPE_NAME     "EXTERNAL-ADDRESS"

/* The first 9 primitive types need to retain their values!!
   Sorted arrays depend on their values!! */


#define FLOAT               0
#define NUMBER              FLOAT
#define INTEGER             1
#define SYMBOL              2
#define STRING              3
#define MULTIFIELD          4
#define EXTERNAL_ADDRESS    5
#define FACT_ADDRESS        6
#define INSTANCE            7
#define INSTANCE_NAME       8

#define FCALL              10  
#define GCALL              11
#define PCALL              12
#define GBWORD             13

#define SCALL_AND             20
#define SCALL_OR              21
#define SCALL_COMP_VARS       22
#define SCALL_CONSTANT        24
#define SCALL_NOTCONSTANT     25
#define SCALL_EQ_FIELD        26
#define SCALL_NEQ_FIELD       27
#define SCALL_GET_VAR         28

#define BWORD              40
#define BWORDS             41

#define LNOT               42
#define LAND               43
#define LOR                44
#define COAMP              45

#define LPAREN             46
#define RPAREN             47
#define SINGLE             48
#define STOP               49
#define KUNKNOWN           50

#define PATTERN            51
#define PAT_AND            52

#define NOTBWORD           53
#define NOTBWORDS          54
#define PAT_OR             55
#define PAT_NOT            56
#define PAT_TEST           57

#define BLOCKED            58
#define RVOID              59



#define INTEGER_OR_FLOAT          70
#define SYMBOL_OR_STRING          71
#define INSTANCE_OR_INSTANCE_NAME 72


typedef long int FACT_ID;
typedef int TYPE;

#endif






