   /*******************************************************/
   /*      "C" Language Integrated Production System      */
   /*                                                     */
   /*                  A Product Of The                   */
   /*             Software Technology Branch              */
   /*             NASA - Johnson Space Center             */
   /*                                                     */
   /*             CLIPS Version 5.10  07/17/91            */
   /*                                                     */
   /*                  CLIPS HEADER FILE                  */
   /*******************************************************/

/*************************************************************/
/* Purpose:                                                  */
/*                                                           */
/* Principal Programmer(s):                                  */
/*      Gary D. Riley                                        */
/*                                                           */
/* Contributing Programmer(s):                               */
/*                                                           */
/* Revision History:                                         */
/*                                                           */
/*************************************************************/

/* Mod (?):
	There MAY OR MAY NOT be a difference between this
	file and the original CLIPS distribution.
	Do a FC (file comparison) on the two to determine
	any differences.
*/


#ifndef _H_clips
#define _H_clips

#include "setup.h"
#include "constant.h"
#include "clipsmem.h"
#include "symbol.h"
#include "router.h"
#include "sysdep.h"
#include "expressn.h"
#include "evaluatn.h"
#include "facts.h"
#include "constrct.h"
#include "utility.h"

#include "intrfile.h"

#if DEFRULE_CONSTRUCT
#include "defrule.h"
#include "engine.h"
#include "drive.h"
#endif

#if DEFFACTS_CONSTRUCT
#include "deffacts.h"
#endif

#if DEFTEMPLATE_CONSTRUCT
#include "deftempl.h"
#endif

#if DEFGLOBAL_CONSTRUCT
#include "defglobl.h"
#endif

#if DEFFUNCTION_CONSTRUCT
#include "deffnctn.h"
#endif

#if DEFGENERIC_CONSTRUCT
#include "genrccom.h"
#include "genrcfun.h"
#endif

#if OBJECT_SYSTEM
#include "extobj.h"
#endif

/*****************************/
/* OTHER FUNCTION PROTOTYPES */
/*****************************/

#if ANSI_COMPILER
#if (BLOAD || BLOAD_ONLY || BLOAD_AND_BSAVE)
   int                            Bload(char *);
#endif
#if BLOAD_AND_BSAVE
   int                            Bsave(char *);
#endif
   int                            LoadFacts(char *);
   int                            SaveFacts(char *);
   int                            SetAutoFloatDividend(int);
   int                            GetAutoFloatDividend(void);
   VOID                           InitializeCLIPS(void);
#if DEFRULE_CONSTRUCT   
   BOOLEAN                        PPDefrule(char *,char *);
   VOID                           ListDefrules(void);
#endif
#else
#if (BLOAD || BLOAD_ONLY || BLOAD_AND_BSAVE)
   int                            Bload();
#endif
#if BLOAD_AND_BSAVE
   int                            Bsave();
#endif
   int                            LoadFacts();
   int                            SaveFacts();
   int                            SetAutoFloatDividend();
   int                            GetAutoFloatDividend();
   VOID                           InitializeCLIPS();

#if DEFRULE_CONSTRUCT   
   BOOLEAN                        PPDefrule();
   VOID                           ListDefrules();
#endif
#endif

#endif



