;;; -*- Mode: LISP; Package: RPG; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   rpg-ascii-dialog
;;; Short Desc: ASCII dialog
;;; Version:    1.0
;;; Status:     Experimental
;;; Last Mod:   25.06.91
;;; Author:     Thomas Rothenfluh
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;




;;;
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; DESCRIPTION
;;; ==========================================================================
;;; Use the functions below to make a demo run in the Lisp Listener


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :rpg)

(eval-when (load eval compile)
  (export  '(*ex3-elements* *ex3-ratings* *ex3-subtable*
	     dialog-3 do-all-triads-3 construct)))

;;; Local globals (what a concept!)
(defvar *ex3-elements* nil)
(defvar *ex3-ratings*  nil)
(defvar *ex3-subtable* nil)
(defvar *verbose*      nil)

;;; ==========================================================================
;;; DEMO FUNCTIONS
;;; ==========================================================================


;;; Separate function in order to allow re-entry
;;; (i.e., continuation of construct elicitation)
(defun do-all-triads-3 (&optional (out-stream t)(in-stream t))
  "Loop through all triples until USER aborts."
  (let (poles labels) 
    (clear-input   *query-io*)
    (cond ((< (triples :length t) 1)
	   (format out-stream
		   "~%~%No more triads to do.~%"))
	  ((y-or-n-p "~&Do you want to continue with eliciting triads? ")
	   (setf poles
	       (extract-element (triples :pop-random t) out-stream) )
	   (setf labels (name-construct-poles poles nil out-stream in-stream))
	   (setf *ex3-ratings* 
	     (define-construct labels *ex3-elements* out-stream in-stream))
	   (check-ratings *ex3-elements* *ex3-ratings* out-stream)
	   (when *verbose* *ex3-elements*)
	   (setf *ex3-subtable*
	     (get-table (cdr (attributes *ex3-elements*)) *ex3-elements*))
	   (do-all-triads-3 out-stream in-stream))
	  (t
	   (format out-stream
		   "~%~%Ok, you can resume with (do-all-triads-3). ~
                    ~%or with (cluster-it (table-to-array *ex3-subtable*) t) ~
                      to cluster your data.") ))))


(defun dialog-3 (&optional (user-out-stream t)(user-in-stream  t))
  "Demo run of Repertory Grid on the Listener."
  (let ()
    (when (and (not *verbose*)
	       (y-or-n-p "Do you want a verbose run? "))
      (setf *verbose* t))
    ;; Initialize all important data structures
    (setf *ex3-elements* nil)
    (setf *ex3-ratings*  nil)
    (setf *ex3-subtable* nil)
    (format user-out-stream "~%~%Welcome to the Rep Grid Module.~%~%")
    ;; Let the user enter all ELEMENTS
    (setf *ex3-elements* 
      (input-elements #'(lambda () (read-delimited-list #\*))
		      user-out-stream user-in-stream))
    ;; Generate all TRIADs
    (triples :init (attributes *ex3-elements*))
    ;; Expand Table with CONSTRUCT attribute
    (push 'construct (attributes *ex3-elements*))
    ;; Step through all triads
    (do-all-triads-3 user-out-stream user-in-stream)
    (cluster-it (table-to-array *ex3-subtable*) *verbose*) ))


;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
