;;; -*- Mode: LISP; Package: RPG; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   rpg-dialog
;;; Short Desc: dialog handling for RPG
;;; Version:    1.0
;;; Status:     Test
;;; Last Mod:   30.09.91 - ThE
;;; Author:     ThE (with ideas "stolen" from Thomas Wehrle's ID3)
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;; --------------------------------------------------------------------------
;;; Modification History
;;; 24.7.91 dta for pool buttons
;;; 27.9.91 ThE major changes 
;;;
;;; ==========================================================================
;;; TODO TODO TODO TODO TODO TODO TODO TODO TODO TODO TODO TODO TODO TODO TODO
;;; ========================================================================== 
;;;
;;; Allow iterations on triad-making and naming
;;;
;;; Allow for non-classified elements (but insert check in statistics!)
;;;
;;; Browsable output from Grids
;;; Include height=distance information in browser-display
;;;
;;; Include interval rating option
;;; Include ordinal  rating option
;;;
;;; define-elements (and input-elements) needs debugging
;;;
;;; make-xxx-elements should load their data here (no preloading)
;;;


;;; ==========================================================================
;;; PACKAGE and EXPORT DECLARATIONS
;;; ==========================================================================

(in-package :rpg)

(eval-when (load compile)
  (export '(start-rpg-dialog rpg-tool)))


;;; ==========================================================================
;;; GLOBAL VARIABLE DECLARATIONS
;;; ==========================================================================


(defvar *verbose-disp*    nil "Stream to route verbose messages")
(defvar tab               nil )
(defvar *output-button*   nil "Pool button holds current element table")
;;; Access its value with:
;;; (start-object (button-value *output-button*))

(defvar *construct*       nil "The current construct")        ; could be local
(defvar *rpg-result*      nil "The TABLE output of RepGrid.") ; unused

;;;(defvar *pause*           nil)
;;; (defvar *quit*            nil)
;;; (defvar table             nil "The current element table")

;;; Not used (yet?)
;;;(defvar *number-of-demos* 0)

(defvar *edit-table-disp* nil "Edit table")

(defvar *rpg-left* 
    (+ 10
       (left  pail-lib::*main-window*)
       (width pail-lib::*main-window*))
  "Left position to place RPG main window, depends on pAILab:Main")

(defvar *rpg-bottom-offset* 
    (bottom  pail-lib::*main-window*)
  "Bottom position to place RPG main window, depends on pAILab:Main")


;;; DEBUG: Global variables below are for debugging purposes only
(defvar *rpg-main* nil)			; DEBUG Main menu
(defvar *tool-disp nil)			; DEBUG Tool display
(defvar *text-disp* nil)		; DEBUG Tool Instructions
(defvar *d nil)				; DEBUG Triad
(defvar *i nil)				; DEBUG Triad
(defvar *m nil)				; DEBUG Triad
(defvar *o nil)				; DEBUG Triad
(defvar *e nil)				; DEBUG Error Windows

;;; ==========================================================================
;;; DEFINE THE FEATURES (WINDOWS, MENUS, ETC.) FOR ALL DIALOGS
;;; ==========================================================================


;;; Define the table editor for RepGrids 
;;; (see pail-lib/ed-table for definition)

(make-editor-fcn table-edit
		 :obj-var tab :default-menu-entries t 
		 :cell-font *small-font* :menu nil)


(defun start-rpg-dialog (&optional (from-button nil))
  (declare (special *RPGPATH*))
  (setf *verbose-disp*
    (make-display :display-type 'scroll-display
		  :title "RPG:Verbose Comments"
		  :active nil
		  :width 500
		  :height 250
		  :borders 1
		  :left 615
		  :bottom 100))
  (if *verbose*
      (progn (activate-display *verbose-disp*)
	     (setf *verbose* *verbose-disp*))
    (deactivate-display *verbose-disp*))
  (let* 
      ((rpg-main 
	(make-display :title   "RPG:Main Window"
		      :width   300
		      :height  150
		      :borders 1
		      :left    *rpg-left*
		      :bottom  *rpg-bottom-offset*))
       (help-button 
	(make-instance 'help-button 
	  :technical (add-path "rpg-desc.tec" *rpgpath*)
	  :general   (add-path "rpg-desc.gen" *rpgpath*)
	  :subject "RPG:Main Menu Help"))
       (tool-button 
	(make-instance 'push-button 
	  :label "Tool"
	  :width 70))
       (exit-button 
	(make-instance 'push-button 
	  :label "Exit"
	  :width 70)))
    ;; Now fiddling around with those displays
    (setf *rpg-main* rpg-main)
    ;; Get the fancy pAIL-logo 
    (copy-mask *pail-logo* 0 0 rpg-main
	       (- (width rpg-main) (cw:bitmap-width *pail-logo*) 15)
	       (- (height rpg-main) (cw:bitmap-height *pail-logo*) 15))
    ;; (setf (font rpg-main) (open-font :courier :roman 22 :weight :bold))
    (write-display rpg-main "Welcome to ThE" 
		   15 (- (height rpg-main) (* 2 (font-ascent (font rpg-main)))))
    (write-display rpg-main "Repertory Grid Module" 
		   15 (- (height rpg-main) (* 4 (font-ascent (font rpg-main)))))
    (setf (font rpg-main) *default-font*)
    ;; Shape the buttons
    (set-button help-button rpg-main :left 15 :bottom 15)
    (set-button tool-button rpg-main
		:left (/ (- (width rpg-main) (width tool-button)) 2)
		:bottom 15
		:action 
		`(lambda nil
		   ;; (disable-button ,exit-button)
		   (rpg-tool)
		   (reset-button ,tool-button)
		   ;;(enable-button ,exit-button)
		   ))
    (set-button exit-button rpg-main 
		:left (- (width rpg-main) (width exit-button) 15)
		:bottom 15
		:action 
		`(lambda nil
		   (close-display *verbose-disp*)
		   (close-display ,rpg-main)
		   (if ,from-button 
		       (reset-button ,from-button))))))


;;; COMMENT outputs a string to a DISPLAY
(defun comment (disp string &rest args)
  (when (displayp disp)
    (activate-display disp)
    (clear-display disp)
    (format-display disp string args)))


;;; TYPEIN Window are user for text entry
(defun typein ()
  "Pop up a typein window and return a list."
  (let* ((typein-window 
	  (make-display :title "RPG:Typein Window"
			:active t
			:width 700
			:height 100
			:borders 1
			:left 10
			:bottom 575))
	 (return nil))
    (setf return 
      (with-input-from-string (in (read-display typein-window 80 10))
	(do ((x (read in nil nil)(read in nil nil)) result)
	    ((null x) result)
	  (setf result (cons x result)))))
    (close-display typein-window)
    (reverse return)))

;;; (setf a (typein))
;;; (DEMO functionality removed Mon Sep 16 18:45:53 1991 - ThE)

;;; ==========================================================================
;;; TOOLBOX
;;; ==========================================================================


;;; RPG TOOL is the main interaction facility to use RepGrid.
;;; It is a display which provides several options 
;;; (through buttons, displays and menus)
;;;
;;; (0) RPG:Tool:Main		Main window
;;; (1) RPG:Tool:Comments	Displays comments on how to use the Tool
;;; (2) RPG:Tool:Help		Get access to general RepGrid-Tool help
;;; (3) RPG:Tool:Elements	Define the elements to be used
;;; (4) RPG:Tool:Triads		Apply the triads method to the elements
;;; (5) RPG:Tool:Cluster	Make statistical analysis of the grid
;;; (6) RPG:Tool:Exit		Quit the RepGrid tool 
;;;

(defun rpg-tool (&optional (menu-button nil) (exit-button nil))
  "Main user interaction function is provided by calling RPG-TOOL"
  (declare (special *text-disp* *tool-disp* *ttb pail-lib::*main-window*)
	   (ignore exit-button))
  (when (displayp menu-button) (disable-button menu-button))
  ;; (when (displayp exit-button) (disable-button exit-button))
#|
  (documentation-print 
   "Welcome to the Repertory Grid Toolbox!

  Please be aware that this is an EXPERIMENTAL version.
  All comments and suggestions are welcome!
                                                  (ThE)")
|#
  (setf *edit-table-disp* nil)
  (clear-scroll *verbose-disp*)
  ;;  (setf *elements* nil)
  (let* ((*value-button-border-p* t)
	 ;; ========== DISPLAYS 
	 (tool-disp         (make-display 
			     :title "RPG:Tool:Main - A RepGrid tool"
			     :width 800
			     :height 260
			     :borders 1
			     :left (left pail-lib::*main-window*)
			     :bottom (- (bottom pail-lib::*main-window*) 300 )))
			     ;; :bottom (abs (- (height cw::*root-window*) 260 5))
	 (tool-comment-disp (make-display  
			     :display-type 'scroll-display
			     :title "RPG:Tool:Comments"
			     :font (open-font-named "fixed")
			     :parent tool-disp
			     :width 300
			     :height 160
			     :borders 1
			     :left 400
			     :bottom 60))
	 ;; (tool-help-button  (make-instance 'push-button ; OBSOLETE
	 ;;		      :label "Help" :width 100))
	 (tool-help-button  (make-instance 'help-button 
			      :technical (add-path "rpg-tool.tec" *rpgpath*)
			      :general   (add-path "rpg-tool.gen" *rpgpath*)
			      :subject "RPG:Tool Display Help"))
	 (tool-elements-button (make-instance 'value-button ;'push-button 
				 :value "Elements" :width 100))
	 (tool-triad-button (make-instance 'push-button 
			      :label "Triads" :width 100))
	 (tool-cluster-button (make-instance 'push-button 
				:label "Cluster" :width 100))
	 (tool-exit-button (make-instance 'push-button 
			     :label "Exit" :width 100))
	 ;; ========== MENUS
	 ;; ---------- table-menu gives options to define the initial set of elements
	 (table-menu        
	  (make-instance 'menu
	    :items 
	    `(("Define elements" 
	       (progn 
		 ()
		 (define-elements)	; DEBUG THIS FUNCTION
		 (format-display 
		  *text-disp* 
		  "~%Your elements are now available.~
                   ~&Proceed with classifying them~
                   ~&by clicking the < Triad > Button.")
		 (reset-button  ,tool-elements-button))
	       "Define the elements yourself.")
	      ("Edit elements & ratings" 
	       (progn 
		 ()
		 (setf *edit-table-disp* t)
		 (setf 
		  (start-object (button-value *output-button*))
		  (table-edit 
		   (start-object (button-value *output-button*)) 
		   :title "RPG:RepGrid Table"
		   :offset-x 0))
		 ()
		 )
	       "Use the table editor to inspect and modify the data.")
	      ("Car example" 
	       (progn 
		 ()
		 (make-car-elements)
		 (format-display 
		  *text-disp* 
		  "~%Car elements now available.~
                   ~&Proceed with classifying them~
                   ~&by clicking the < Triad > Button.")
		 (reset-button ,tool-elements-button))
	       "Use data from the car example.")
	      ("Number example" 
	       (progn 
		 ()
		 (make-number-elements)
		 (format-display 
		  *text-disp* 
		  "~%Number elements now available.~
                   ~&Proceed with classifying them~
                   ~&by clicking the < Triad > Button.")
		 (reset-button ,tool-elements-button))
	       "Use number example")
	      ("People example" 
	       (progn 
		 ()
		 (make-people-elements)
		 (format-display 
		  *text-disp* 
		  "~%People elements now available.~
                   ~&Proceed with classifying them~
                   ~&by clicking the < Triad > Button.")
		 (reset-button ,tool-elements-button))
	       "Use people example"))))
	 ;; ---------- Verbose option toggle
	 (verb (make-instance 'radio-button 
		 :label "Verbose Mode"
		 :status *verbose*
		 :action 
		 #'(lambda ()
		     (if *verbose*
			 (progn
			   (setf *verbose* nil)
			   (deactivate-display *verbose-disp*))
		       (progn
			 (setf *verbose* *verbose-disp*)
			 (activate-display *verbose-disp*)))))))
    ;; ---------- the table-editor really is a large button 
    (setf *output-button* 
      (make-instance 'pool-button
	:name "Repertory Grid "
	:value ""
	:width 170
	:target-class 'rpg::elements
	:pool *pail-pool*
	:border  t))
    ;; ---------- Global accessible displays
    (setf *text-disp* tool-comment-disp); For other functions
    (setf *tool-disp* tool-disp)		; DEBUG only
    (setf *ttb tool-triad-button)		; DEBUG ONLY
    ;; ---------- The fancy pAIL-logo is a must!
    (copy-mask *pail-logo* 0 0 tool-disp 
	       (- (width tool-disp) (cw:bitmap-width *pail-logo*) 15)
	       (- (height tool-disp) (cw:bitmap-height *pail-logo*) 15))
    ;; ---------- EXIT gracefully
    (set-button tool-exit-button tool-disp 
		:left (- (width tool-disp) (width tool-exit-button) 15) 
		:bottom 15
		:action 
		#'(lambda ()
		    (declare (special browse))
		    ;; (when (displayp menu-button)(enable-button menu-button))
		    ;; (when (displayp exit-button)(enable-button exit-button))
		    (close-display *text-disp*)
		    (close-table-edit 'bla :close-all t)
		    (when (and (boundp 'browse) browse)
		      (dolist (b browse)
			(close-display (display b)))
		      (setf browse nil))
		    (close-display tool-disp)))
    ;; ---------- RPG:TOOL:Help
    (set-button tool-help-button tool-disp :left 15 :bottom 15)
    ;; ---------- RPG:TOOL:Elements
    (set-button tool-elements-button tool-disp 
		:left (round (+ 15
				(* 1 (width tool-elements-button))
				(* 1 (/ (- (width tool-disp)
					   30
					   (* 6 (width tool-elements-button)))
					5))))
		:bottom 15)
    ;; ---------- RPG:TOOL:Triad
    (set-button tool-triad-button tool-disp 
		:left (round 
		       (+ 15
			  (* 2 (width tool-triad-button))
			  (* 2 (/ (- (width tool-disp)
				     30
				     (* 6 (width tool-triad-button)))
				  5))))
		:bottom 15
		:action
		#'(lambda ()
		    (cond 
		     ((start-object (button-value *output-button*))
		      (format-display 
		       *text-disp* 
		       "~%Using TRIAD method to elicit new constructs.")
		      (triad-select 
		       (cdr (attributes (start-object 
					 (button-value *output-button*)))) 
		       :from-button tool-triad-button
		       :from-window tool-disp))
			  (t
			   (display-error "No elements specified!"
					  :button-label "Click here to continue"
					  :from-button tool-triad-button)
			   (enable-button tool-triad-button)))))
    ;; ---------- RPG:TOOL:Cluster
    (set-button tool-cluster-button tool-disp 
		:left (round (+ 15
				(* 3 (width tool-triad-button))
				(* 3 (/ (- (width tool-disp)
					   30
					   (* 6 (width tool-triad-button)))
					5))))
		:bottom 15
		:action
		#'(lambda ()
		    (disable-button tool-exit-button)
		    (cond 
		     ((start-object (button-value *output-button*))
		      ;; convert the full table to id3-like table
		      ;; i.e. remove the construct names (first attr)
		      (setf *rpg-result* 
			(get-table 
			 (cdr (attributes 
			       (start-object (button-value *output-button*)))) 
			 (start-object (button-value *output-button*))))
		      (cluster-it  
		       (fulltable-to-cleanarray 
			(start-object (button-value *output-button*)))))
		     ((display-error 
		       "No elements and constructs defined yet!")))
		    (reset-button tool-cluster-button)
		    (enable-button tool-exit-button)))
    (set-button *output-button* tool-disp 
		:left (/ (width tool-disp) 4) :bottom 90)
    (set-button verb tool-disp 
		:left (/ (width tool-disp) 4) :bottom 180)
    (setf (menu tool-elements-button) table-menu)
    (format-display *text-disp* 
		    "~&Welcome to the RepGrid tool! ~
                     ~&First you should define elements. ~
                     ~&~%Click on the < Elements > Button to do so.")))


(defun define-elements ()
  "Define elements."
  (setf (start-object (button-value *output-button*))
    (input-elements (start-object (button-value *output-button*)) 
		    *text-disp* *verbose-disp*))
  (push 'construct (attributes (start-object (button-value *output-button*))))
  (setf (start-object (button-value *output-button*)) 
    (start-object (button-value *output-button*))))


;;; ==========================================================================
;;; The GIN-Display Interface for TRIAD selection and naming
;;; ==========================================================================


(defun triad-select (element-list &key (from-button nil)
				       (from-window nil)
				       (title "RPG:TRIAD Window")
				       (info  "Elements to select:"))
  "Window-based triad elicitation method"
  (format-display *verbose* "; Triad method initializes")
  (triples :init element-list)		; Initialize triads
  (let* ((menu-width 300) 
	 (triad (triples :pop-random t))
	 (triad-disp	     (make-display 
			      :title title
			      :active t
			      :left 10 
			      :bottom (max 50 (- 400 (bottom from-window)))
			      :width (+ 10 menu-width)
			      :height 400))
	 (triad-instr        nil)
	 (triad-exit-button  (make-instance 'push-button 
			       :label "Exit"
			       :bottom 5 :width (- (floor menu-width 2) 4)
			       :parent triad-disp))
	 (triad-classify-button (make-instance 'push-button 
				  :label " Classify "
				  :left 5 :bottom 5 :width (- (floor menu-width 2) 4)
				  :parent triad-disp))
	 (triad-new-button   (make-instance 'push-button 
			       :label "Make new TRIAD"
			       :left 5 :width menu-width
			       :parent triad-disp))
	 (triad-choice-menu  (make-instance 'select-button
			       :label info 
			       :left 5 :width menu-width
			       :parent triad-disp
			       :items (list-to-stringlist triad)
			       :action 
			       #'(lambda nil 
				   (enable-button triad-classify-button)
				   (format-display 
				    *verbose*
				    (format nil 
					    "~&; Item ~a was selected.~
                         ~&; Click on the < Classify > Button ~
                         ~&; to continue with this choice." 
					    (item-label))))
			       :exclusive t )))
    ;; ---------- DEBUG ONLY
    (setf *m triad-choice-menu)(setf *d triad-disp)
    (setf *o triad-classify-button) (setf *i triad-instr) 
    ;; ---------- The size of the select-button triad-choice-menu is variably 
    ;; ---------- designed (but for TRIAD there are usually only three items)
    (set-button triad-choice-menu triad-disp 
		:height (max
			 (floor (height triad-disp) 2) ; maximal height
			 (* (length triad) 
			    (font-character-height (font triad-choice-menu))) )
		:bottom (+ 12 (* 2 (height triad-classify-button))))
    ;; ---------- Now determine size of other displays
    (set-button triad-classify-button triad-disp 
		:active nil
		:action 
		#'(lambda nil
		    ;; Button control now down in TRIAD-CLASSIFY
		    (let ((result nil))
		      (do ((status (items triad-choice-menu) (cdr status))
			   (item   triad         (cdr item)))
			  ((null status) (reverse result))
			(when (status (car status))
			  (push (car item) result)))
		      (triad-classify (car result) (remove (car result) triad)
				      element-list triad-disp triad-instr triad-choice-menu 
				      triad-exit-button triad-classify-button triad-new-button)
		      )))
    (set-button triad-exit-button triad-disp  
		:left   (+ (left triad-classify-button) 
			   (width triad-classify-button) 8)
		:action `(lambda nil 
			   (setf (display (start-object (button-value *output-button*))) nil)
			   (close-display ,triad-disp)
			   ;; NEXT ACTION HERE
			   (when ,from-button
			     (reset-button ,from-button))))
    (set-button triad-new-button triad-disp 
		:bottom (+ (height triad-classify-button) 8)
		:action 
		#'(lambda nil 
		    (cond ((< (triples :length t) 1)
			   (display-error "No more triads available"
					  :wait t
					  :from-button triad-new-button))
			  (t (setf triad (triples :pop-random t))
			     (setf (items triad-choice-menu) 
			       (list-to-stringlist triad))
			     (setf (action triad-choice-menu) 
			       #'(lambda nil 
				   (enable-button triad-classify-button)
				   (format-display *verbose*
						   (format nil 
							   "~&; Item ~a was selected.~
                         ~&; Click on the < Classify > Button~
                         ~&; to continue with this choice." 
							   (item-label)))))
			     (reset-button triad-new-button)
			     )))
		:active t)
    ;; ---------- The triad-instr displays provides user instructions
    (setf triad-instr 
      (make-display 
       :display-type 'scroll-display
       :title "Instructions:"
       :borders 1
       :parent triad-disp
       :left 5 :width menu-width
       :bottom (+ (height triad-choice-menu)(bottom triad-choice-menu) 4 20)
       :height (abs (- (inner-height triad-disp) 
		    (+ (height triad-choice-menu)(bottom triad-choice-menu) 4 20 20)))  ))
    (format-display triad-instr "~%Please select an item from the TRIAD below. ~%~
                          ~%Decide on a way that ~
                          ~%~R of these elements are similar~
                          ~%and in the same way different ~
                          ~%from the remaining element.~%~
                          ~%Click on the item which is~
                          ~%different from the rest"
		    (1- (length triad)))
    (format-display *verbose* "; Triad method is ready")
    t))

;;; (format t "~S" (start-object (button-value *output-button*)))
;;; (triad-select `(a b c d e f g h i k l m n o p q))
;;; (triad-select (cdr (attributes (start-object (button-value *output-button*)))))


(defun triad-classify 
    (selection others items 
     triad-disp triad-instr triad-choice-menu 
     triad-exit-button triad-classify-button triad-new-button)
  "Elicit the names of the construct-poles and classify all elements"
  (declare (special ele-min ele-max))
  ;; Button control now down here
  (disable-button triad-new-button)
  (reset-button triad-classify-button)	; Reset from calling function
  (disable-button triad-classify-button) ; But stay disabled
  (format-display triad-instr 
		  "~%~%Now enter descriptive labels~
                   ~%for each of the two classes")
  (let* ((old-triad-disp-width (width triad-disp))
	 (new-triad-disp-width 
	  (setf (width triad-disp) 1000)) ; Enlarge window to fit classification part
	 (new-triad-bottom (setf (bottom triad-disp) (bottom triad-disp)))
	 (gap 4)
	 (pole-min (string-cleanup
		    (ask (format nil "What is it about '~a' that makes it DIFFERENT ~
                      ~%from the other elements? ~%~%" selection)
			 :title "Please type in a descriptive label (one word):"
			 :left (left triad-disp) :bottom (bottom triad-disp))))
	 (pole-max (string-cleanup
		    (ask (format nil "Please supply a description which expresses ~
                    ~%the SIMILARITY between the elements '~{~a ~}':~%~%"
				 others)
			 :title "Please type in a descriptive label (one word):"
			 :left (left triad-disp) :bottom (bottom triad-disp))))
	 ;; (max-len  (string-counter items #'max))
	 (s-bottom    (+ 12 (* 2 (height triad-classify-button))))
	 (s-height    (- (height triad-disp) s-bottom 20))
	 (sn-region   (cw:make-region
		       :left    (- (width triad-disp) (* 4 gap) 100) :bottom  s-bottom
		       :height  s-height :width   (+ (* 2 gap) 100)))
	 (sn-left     (- (width triad-disp) (* 4 gap) 100))
	 (s-left      (+ (left triad-choice-menu) (width triad-choice-menu) gap))
	 (s-width     (floor (- (width triad-disp) s-left (+ (* 2 gap) 100) (* 5 gap)) 2))
	 (s0-region     (cw:make-region
			 :left    s-left :bottom  s-bottom
			 :height  s-height :width   s-width))
	 (s1-region     (cw:make-region
			 :left    (+ s-left s-width gap) :bottom  s-bottom
			 :height  s-height :width   s-width))
	 (s1-left     (+ (left triad-choice-menu) (width triad-choice-menu) gap))
	 (s2-left     (+ s1-left s-width gap))
	 (ordinal-button  (make-instance 'push-button 
			:label  "Ordinal  Scale"
			:left   s-left
			:width  s-width
			:bottom (+ (height triad-classify-button) 8)
			:parent triad-disp))
	 (interval-button  (make-instance 'push-button 
			:label  "Interval Scale"
			:left   (+ s-left s-width (* 2 gap))
			:width  s-width
			:bottom (+ (height triad-classify-button) 8)
			:parent triad-disp))
	 (done-button (make-instance 'push-button 
			:label  " D o n e "
			:left   s-left
			:width  (+ (* 2 gap) (* 2 s-width))
			:bottom 5
			:parent triad-disp))
	 (randomize-button (make-instance 'push-button 
			:label  " Random "
			:left   (+ gap (left done-button)(width done-button))
			:width  100
			:bottom 5
			:parent triad-disp))
	 (local-displays '(ordinal-button interval-button done-button randomize-button))
	 (result nil) 
	 (left-pos 0)
	 (warning-displayed-once nil)	; Display warning only once
	 )
    ;; ---------- Draw the "element container" windows
    ;; ---------- NOTE: Don't use DISPLAYs, or the element-displays might disappear
    (draw-rectangle triad-disp		; the "unclassified" bag
		    (cw:region-left   sn-region)
		    (cw:region-bottom sn-region)
		    (cw:region-width  sn-region)
		    (cw:region-height sn-region) )
    (draw-rectangle triad-disp		; The (0) bag
		    (cw:region-left   s0-region)
		    (cw:region-bottom s0-region)
		    (cw:region-width  s0-region)
		    (cw:region-height s0-region) )
    (draw-rectangle triad-disp		; The (1) bag
		    (cw:region-left   s1-region)
		    (cw:region-bottom s1-region)
		    (cw:region-width  s1-region)
		    (cw:region-height s1-region) )
    (draw-filled-rectangle triad-disp
			   (cw:region-left   s0-region)
			   (+ s-bottom s-height)
			   (+ 1 (cw:region-width  s0-region))
			   (+ s-bottom s-height (font-ascent (font triad-disp)))
			   :color black)
    (draw-filled-rectangle triad-disp
			   (cw:region-left   s1-region)
			   (+ s-bottom s-height)
			   (+ 1 (cw:region-width  s1-region))
			   (+ s-bottom s-height (font-ascent (font triad-disp)))
			   :color black)
    (draw-filled-rectangle triad-disp
			   (cw:region-left   sn-region)
			   (+ s-bottom s-height)
			   (+ 1 (cw:region-width  sn-region))
			   (+ s-bottom s-height (font-ascent (font triad-disp)))
			   :color black)
    (setf (font triad-disp) *small-font-11*)
    (write-display triad-disp (format nil " ~a" pole-min)
		   (cw:region-left   s0-region)
		   (+ s-bottom s-height gap) :operation boole-eqv)
    (write-display triad-disp (format nil " ~a" pole-max)
		   (cw:region-left   s1-region)
		   (+ s-bottom s-height gap) :operation boole-eqv)
    (write-display triad-disp " Unclassified"
		   (cw:region-left   sn-region)
		   (+ s-bottom s-height gap) :operation boole-eqv)
    (setf (font triad-disp) *default-font*)
    ;; ---------- Initialize the current construct 
    (setf *construct* nil)
    ;; ---------- DEBUG only
    (setf *s1 s0-region)
    (setf *s2 s1-region)
    (setf *sn sn-region) 
    (setf *rand randomize-button)
    (setf *done done-button)
    (setf *c nil)
    ;; ---------- Create or update element displays
    (cond ((null (cdr (display (start-object (button-value *output-button*)))))
	   ;; ---------- Create for every element a window
	   (setf (display (start-object (button-value *output-button*)))
	     (dotimes (i (1+ (length items)) (nreverse result))
	       (push nil result)))
	   (dotimes (count (length items))
	     (setf left-pos 
	       (cond ((member (nth count items) (list selection))
		      (+ (cw:region-left s0-region) 10))
		     (t 
		      (+ (cw:region-left s1-region) 10))))
	     (setf (nth (1+ count) (display (start-object (button-value *output-button*))))
	       (make-display :title (nth count items)
			     :active t
			     :parent triad-disp
			     :frame-menu nil
			     :borders 1
			     ;; position inside the right bag
			     :left (cond ((member (nth count items) (list selection))
					  (+ (cw:region-left s0-region) gap))
					 ((member (nth count items) others)
					  (+ (cw:region-left s1-region) gap))
					 (t 
					  (+ (cw:region-left sn-region) gap)))
			     ;; decrease the position for every element
			     :bottom (- (height triad-disp) 40 (* count 20))
			     :width 100
			     :height 1))) )
	  (t 
	   ;; Move existing displays to appropriate place
	   (dolist (x (cdr (display (start-object (button-value *output-button*)))))
	     (setf (left x) 
	       (cond ((member (title x) (list selection))
		      (+ (cw:region-left s0-region) gap))
		     ((member (title x) others)
		      (+ (cw:region-left s1-region) gap))
		     (t 
		      (+ (cw:region-left sn-region) gap))) )) ))
    (set-button done-button triad-disp
		:action 
		#'(lambda nil
		    (unless *construct*
		      (setf *construct*
			(read-from-string
			 (string-cleanup
			  (ask 
			   (format 
			    nil 
			    "Please enter a name for this CONSTRUCT~
                           ~%with its poles ~a and ~a:~%~%"
			    pole-min pole-max)
			   :title "Please type in a descriptive label (one word):"
			   :error-message "Input has to be a word"
			   :left (left triad-disp) :bottom (bottom triad-disp))))))
		    (unless (check-ratings items s0-region s1-region)
		      (display-error 
		       (format nil
			       "Statistical analysis of your data~
                                          ~&might be affected when you decide~
                                          ~&not to classify ALL elements")
		       :wait nil
		       :button-label "Click here to continue"
		       :title "WARNING:"))
		    ;; ========================================
		    ;; LOCAL EXIT FROM THE CLASSIFICATION PART
		    ;; ========================================
		    (make-ratings *construct* items s0-region s1-region)
		    (setf *construct*
		      (make-instance 'constructs
			:attributes '(0 1)
			:rows       (list ele-min ele-max) ; DEBUG GLOBALs
			:names      (list pole-min pole-max)))
		    ;; (setf (display (start-object (button-value *output-button*))) nil)
		    ;; (setf (width triad-disp) old-triad-disp-width)    
		    (enable-button triad-new-button)))
    (set-button randomize-button triad-disp
		:action 
		#'(lambda nil
		    (make-random-placements items s0-region s1-region)
		    (reset-button randomize-button)))
    ;; ---------- Not used yet! TODO TODO TODO
    ;; (set-button ordinal-button triad-disp)
    ;; (set-button interval-button triad-disp)
    ;; (disable-button ordinal-button)
    ;; (disable-button interval-button)
    ;; ---------- Maybe get rid of that later
    (set-button randomize-button triad-disp)
    (format-display triad-instr 
		    "~%~%Now drag each element in the RIGHTMOST~
                     ~%field (entitled 'Unclassified') to the~
                     ~%most appropriate group-field by pointing with~
                     ~%the mouse on the element field and dragging it~
                     ~%while pressing the middle mouse key~%~
                     ~%When all elements are classified,~
                     ~%click on the Button < D O N E >")))


(defun make-random-placements (items s1 s2)
  "Places an element randomly in a classification field"
  (declare (special *output-button*))
  (dolist (elem (reverse items))
    (let ((el (get-display elem 
			   (start-object (button-value *output-button*)))))
      (cond ((or (display-within-region-p el s1) ; Already classified?
		 (display-within-region-p el s2)))
	    (t (setf (left el)		; No -> Place randomly
		 (+ 4 (if (zerop (randomize 0 1))
			  (cw:region-left s1)
			(cw:region-left s2)))))))))


(defun check-ratings (items s1 s2)
  "Returns nil when not all elements are classifed."
  (declare (special *output-button*))
  (let ((result t))
    (dolist (elem (reverse items))
      (let ((el (get-display elem 
			     (start-object (button-value *output-button*)))))
	(cond ((or (display-within-region-p el s1)
		   (display-within-region-p el s2)))
	      (t (setf result nil)))))
    result))


(defun make-ratings (label items s1 s2)
  "Make the ratings according to the placement of the element displays."
  (declare (special *output-button* result ele-min ele-max ele-none))
  (setf result nil)
  (let ()
    ;; ---------- THESE ARE GLOBALS: DEBUG sometimes
    (setf ele-min nil)(setf ele-max nil)(setf ele-none nil)
    ;; ---------- Loop through all elements and assign appropriate ratings
    (dolist (elem (reverse items))
      (let ((el (get-display elem (start-object 
				   (button-value *output-button*)))))
	(cond ((display-within-region-p el s1)
	       (push elem ele-min) (push 0 result))
	      ((display-within-region-p el s2)
	       (push elem ele-max) (push 1 result))
	      ;; The rest gets nil --- maybe use the ID3-thing
	      (t (push elem ele-none) (push '* result)))))
    ;; ---------- Add the name of the construct in front
    (push label result)			
    ;; ---------- Add the name of the new construct as a new row
    (setf (rows (start-object (button-value *output-button*)))
      (append (rows (start-object (button-value *output-button*))) 
	      (list result))) ))


(defun display-within-region-p (display region)
  "Check whether the DISPLAY's midpoint lies within REGION"
  (when (and (displayp display)(cw:region-p region))
	(let ((display-midpoint-x (+ (left display)  
				     (/ (width display) 2)))
	      (display-midpoint-y (+ (bottom display)
				     (/ (height display) 2))))
	  (cw:region-contains-point-p 
	   region display-midpoint-x display-midpoint-y))))


;;; OBSOLETE ? (see above)
;;; Change left bottom to mid-point sometimes
(defun within-region (inner outer)
  "Check whether the display INNER's left bottom point is inside of OUTER.
   INNER and OUTER are either displays or coordinate lists 
   (left bottom right top)"
  (let* ((i (if (displayp inner) (disp-region inner) inner))
	 (o (if (displayp outer) (disp-region outer) outer))	 )
    (and (>= (first i)  (first o))
	 (>= (second i) (second o))
	 (<= (first i)  (third o))
	 (<= (second i) (fourth o)))))

(defun disp-region (disp)
  "Return a list with the following window parameters:
   (left bottom right top)"
  (list (left disp)(bottom disp)
	(+ (left disp)(width disp))
	(+ (bottom disp)(height disp))))


(defun region-list (disp)
  "Return a list with the following region parameters:
   (left bottom right top)"
  (list (cw:region-left disp)
	(cw:region-bottom disp)
	(+ (cw:region-left disp)  (cw:region-width disp))
	(+ (cw:region-bottom disp)(cw:region-height disp))))

;;; ==========================================================================
;;; GIN-compatible I/O functions
;;; ==========================================================================


(defun y-or-n-query (query &key (title nil))
  "Prompts for a y/n answer (uses GIN when possible)."
  (cond ((and (boundp *gin-p*) *gin-p*)
	 (eq :yes (y-or-n-dialog query 
				 :title title
				 :left 50 :bottom 150 )))
	(t
	 (when title 
	   (format t "~&~a~%" title))
	 (y-or-n-p (format t "~a ~%>>>> (Type y or n) " query)))))


(defun input-list (query &key (title nil))
  "Allows the entering of a list of items (uses GIN when possible)."
  (cond ((and (boundp *gin-p*) *gin-p*)
	 (string-to-list
	  (ask query
	       :title title
	       :error-message "Enter a list of items"
	       :left 50   :bottom 150
	       :width 600 :height 150)))
	(t
	 (when title 
	   (format t title))
	 (format t "~&>>>> Enter an asteriks * as last item to end your input: ")
	 (read-delimited-list #\*))))


(defun renew-scroll (disp)
  "Activate and clear a scroll window."
  (when (displayp disp)
    (activate-display disp)
    (clear-scroll disp)))


;;; ==========================================================================
;;; Create a cluster tree for later browsing
;;; ==========================================================================


;;; *cluster-tree* is the thing we need!

;;;; VERY EXPERIMENTAL SECTION BELOW!
  #|

;; Make all leaves
(dolist (x (first (car *cluster-tree*)))
  (format t "~%~a ~a" x (nth (1+ x) (attributes (start-object (button-value *output-button*)))))
  (setf (nth x (tree-disp (start-object (button-value *output-button*)))) x))
    (make-instance 'cluster-tree
      :content 
      (nth (1+ x) (tree-disp (start-object (button-value *output-button*))))
      :descendants
      nil)))


(dolist (x *cluster-tree*)
  
  (setf node (translate-index-to-list (first  x)))
  (setf des1 (translate-index-to-list (third  x)))
  (setf des2 (translate-index-to-list (fourth x)))
  (format t "~%~%~a~%~a~%~a" node des1 des2)
  (
  )

(setf a (make-hash-table 
 :test #'equal ))

(print (translate-index-to-list (first (car *cluster-tree*))))

(if (probe-file "rpg-help.gen")


|#

;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
;;; In case of troubles:
;;;
;;; (reset-button pail::rpg-button)
;;; (close pail::*prompt-window*)

;;; (setf lisp:*load-verbose* nil)
;;; (setf lisp:*compile-verbose* nil)
;;; (setf lisp:*load-verbose* t)



