;;; -*- Mode: LISP; Package: COMMON-LISP-USER; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   boole
;;; Short Desc: Demo of boolean drawing operations 
;;; Version:    1.0
;;; Status:     Demo
;;; Last Mod:   30.09.91 - ThE
;;; Author:     ThE 
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;; --------------------------------------------------------------------------

(in-package :xcw)

(setq *my-win* (make-window-stream
		:title "Lewis Carroll"
		:lines-high 17
		:chars-wide 68
		:activate-p t))

(format *my-win* "CLR~%SET~%1~%2~%C1~%C2~%AND~%IOR~%XOR~%EQV~%")
(format *my-win* "NAND~%NOR~%ANDC1~%ANDC2~%ORC1~%ORC2     ")

(setf (window-stream-left-margin *my-win*)
  (window-stream-x-position *my-win*))
(reset *my-win*)
(let ((xval (/ (+ (window-stream-right-margin *my-win*)
		  (window-stream-left-margin *my-win*)) 2))
      (height (window-stream-inner-height *my-win*))
      (width  (window-stream-inner-width *my-win*)))
  (draw-filled-rectangle-xy *my-win* xval 0 width height))

(let ((*draw-text-background* nil)
      (lis (list boole-clr boole-set boole-1 boole-2
		 boole-c1 boole-c2 boole-and boole-ior
		 boole-xor boole-eqv boole-nand boole-nor
		 boole-andc1 boole-andc2 boole-orc1 boole-orc2)))
  (dolist (i lis)
    (setf (window-stream-operation *my-win*) i)
    (format *my-win*
	    "Twinkle, twinkle little bat,  how I wonder where you're at~%"
	    )))

;; (cw:flush cw::*my-win*)