;;; -*- Mode: LISP; Package: PLANNING; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   gin-back.cl
;;; Short Desc: gin-like routines for background buffers
;;; Version:    1.0
;;; Status:     Experimental
;;; Last Mod:   8.91 Wan
;;; Author:     Hank Wan
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------
;; gin-back.cl
;;   Hank Wan, Aug 1991
;;
;; GIN package routines draw to an X window and to a background
;; buffer (to be used for refresh purposes, I believe).
;; Taking adantage of this, below are exact duplicates of selected graphics
;; routines in GIN except drawing is done only to the background buffer.
;; An explicit function, show-back-buffer, then displays the background
;; in the foreground.
;; The purpose is to make delay time of drawing hidden to the user, resulting
;; in a `movie' like effect.

;; See Also: gin.cl

(in-package :gin)

(export '(back-draw-line
	  back-draw-circle
	  back-draw-filled-circle
	  back-write-display
	  back-clear-display
	  show-back-buffer))

(defmethod back-draw-line ((d display) x1 y1 x2 y2 &key
			   (color cw::black)
			   (operation cw::boole-1)
			   (arrow nil))
  (cw:draw-line (pattern d) (cw:make-position :x x1 :y y1)
		(cw:make-position :x x2 :y y2) :color color :operation operation)
  (if arrow
      (let ((delta1 (+ (if (equal x1 x2) (if (> y2 y1) (/ pi 2) (- (/ pi 2))) (atan (/ (- y2 y1) (- x2 x1)))) arrow-head-angle))
	    (delta2 (- (if (equal x1 x2) (if (> y2 y1) (/ pi 2) (- (/ pi 2))) (atan (/ (- y2 y1) (- x2 x1)))) arrow-head-angle)))
	(draw-line d x2 y2
		   (floor (if (> x1 x2) (+ x2 (* arrow-head-length (cos delta1))) (- x2 (* arrow-head-length (cos delta1)))))
		   (floor (if (> x1 x2) (+ y2 (* arrow-head-length (sin delta1))) (- y2 (* arrow-head-length (sin delta1)))))
		   :color color :operation operation)
	(draw-line d
		   x2 y2
		   (floor (if (> x1 x2) (+ x2 (* arrow-head-length (cos delta2))) (- x2 (* arrow-head-length (cos delta2)))))
		   (floor (if (> x1 x2) (+ y2 (* arrow-head-length (sin delta2))) (- y2 (* arrow-head-length (sin delta2)))))
		   :color color :operation operation)
	(draw-line d
		   (floor (if (> x1 x2) (+ x2 (* arrow-head-length (cos delta1))) (- x2 (* arrow-head-length (cos delta1)))))
		   (floor (if (> x1 x2) (+ y2 (* arrow-head-length (sin delta1))) (- y2 (* arrow-head-length (sin delta1)))))
		   (floor (if (> x1 x2) (+ x2 (* arrow-head-length (cos delta2))) (- x2 (* arrow-head-length (cos delta2)))))
		   (floor (if (> x1 x2) (+ y2 (* arrow-head-length (sin delta2))) (- y2 (* arrow-head-length (sin delta2)))))
		   :color color :operation operation))))

(defmethod back-draw-circle ((d display) x y r &key
			     (color black)
			     (operation cw::boole-1))
  (cw:draw-circle (pattern d) (cw:make-position :x x :y y) r :color color :operation operation))

(defmethod back-draw-filled-circle ((d display) x y r &key
				    (color black)
				    (operation cw::boole-1))
  (cw:draw-filled-circle (pattern d) (cw:make-position :x x :y y) r :color color :operation operation))

(defmethod back-write-display ((d display) string &optional
			       (x (cw:window-stream-x-position (pattern d)))
			       (y (cw:window-stream-y-position (pattern d))) &key
			       (operation cw::boole-set))
  (setf (cw:window-stream-x-position (pattern d)) x)
  (setf (cw:window-stream-y-position (pattern d)) y)
  (setf (cw:window-stream-operation (pattern d)) operation)
  (format (pattern d) "~A" string)
  (setf (x-position d) (cw:window-stream-x-position (pattern d)))
  (setf (y-position d) (cw:window-stream-y-position (pattern d)))
  #|
    (cw:bitblt (window d) x (- y (cw:font-baseline (font d))) (pattern d)
	       x (- y (cw:font-baseline (font d)))
	       (font-string-width (font d) string)
	       (font-character-height (font d)))
|#
  string)

(defmethod back-clear-display ((d display) &key
			       (left 0)
			       (bottom 0)
			       (width (inner-width d))
			       (height (inner-height d)))
  (setf (cw:window-stream-x-position (pattern d)) 0)
  (setf (cw:window-stream-y-position (pattern d)) (- (height d) (font-character-height (font d))))
  (cw:clear-area (pattern d) (cw:make-region :left left :bottom bottom
					     :width width :height height)))

(defun show-back-buffer (d)
  (cw:bitblt (pattern d) 0 0 (window d) 0 0))
