;;; -*- Mode: LISP; Package: PLANNING; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   maze.cl
;;; Short Desc: Description of maze world
;;; Version:    0.1
;;; Status:     Provisional
;;; Last Mod:   11.2.92 DTA
;;; Author:     Allemang
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;




;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;; Changed 11.2 to avoid name clash with table rows.
;;; --------------------------------------------------------------------------
;;; maze domain



(in-package :planning)


(defclass maze-display (animate-display) ())


(defparameter *pup*	    (read-bitmap (add-path "madona" (add-subdir *pail-path* "bitmaps"))))


(setf *maze-ops*
  (list (make-instance 'op
	 :opname '(from ?x to ?y)
	 :filter '((?x connected to ?y))
	 :subgoals '((at ?x))
	 :add-list '((at ?y))
	 :del-list '((at ?x)))))

(defun make-maze-states (link)
  (let ((x (first link))
	(y (second link)))
    `((,x connected to ,y)
      (,y connected to ,x))))

(defparameter *maze-state* nil)

(setf *maze-state*
  (apply
   #'append
   (mapcar #'make-maze-states
	   '((1 2) (2 3) (3 4) (4 9) (9 14) (9 8) (8 7) (7 12) (12 13)
	     (12 11) (11 6) (11 16) (16 17) (17 22) (21 22) (22 23)
	     (23 18) (23 24) (24 19) (19 20) (20 15) (15 10) (10 5) (20 25)))))

(defparameter *maze-2-state* nil)

(setf *maze-2-state*
  (apply
   #'append
   (mapcar #'make-maze-states
	   '((1 2) (2 3) (3 4) (4 5)
	     (1 6) (6 7) (7 8) (8 5) (5 10) (10 11) (11 12)
	     (12 13) (13 14) (14 15)
	     (12 16) (16 17) (17 18)
	     (1 20) (20 21) (21 22)))))

(defun m-test1 ()
  (use-ops *maze-ops*)
  (solve (cons '(at 1) *maze-state*) '((at 25))))
(defun m-test2 ()
  (use-ops *maze-ops*)
  (solve (cons '(at 25) *maze-state*) '((at 1))))
(defun m-test3 ()
  (use-ops *maze-ops*)
  (solve (cons '(at 1) *maze-2-state*) '((at 22))))
(defun m-test4 ()
  (use-ops *maze-ops*)
  (solve (cons '(at 22) *maze-2-state*) '((at 1))))
(defun m-test5 ()
  (use-ops *maze-ops*)
  (solve (cons '(at 22) *maze-2-state*) '((at 12))))


(defun show-maze (maze-disp maze n)
   
  (setf (height maze-disp) (* 40 n))
  (setf (width maze-disp) (* 40 n))
  (clear-display maze-disp)
	
  (loop for i from 1 to (- n 1) do (draw-line maze-disp 0 (* 40 i) (* 40 n) (* 40 i))

    (draw-line maze-disp (* 40 i)  0 (* 40 i) (* 40 n)))
  (loop for item in maze do
	(multiple-value-bind (rowstart cols) (floor (- (second item) 1) n)
	  (multiple-value-bind (rowf colf) (floor (- (fourth item) 1) n)
	    (draw-filled-rectangle maze-disp
				   (+ 2 (* 40 rowstart)) (+ 2 (* 40 cols))
				   (- (+ 38 (* 40 rowf)) (+ 2 (* 40 rowstart))) (- (+ 38 (* 40 colf)) (+ 2 (* 40 cols)))
				   :color white  ))))
  (loop for i from 1 to (* n  n) do
	(multiple-value-bind (row col) (floor (- i 1) n)
	  (write-display maze-disp (format nil "~d" i) (+ 15 (* 40 row)) (+ 15 (* 40 col))
			 :font gin:*small-font-8*))
    )
			 
			 
  )

(defun place-pup (maze-disp  n s)
  (multiple-value-bind (row col) (floor (- s 1) n)
;      (write-display maze-disp "P" (+ 15 (* 40 row)) (+ 15 (* 40 col)))
      (copy-mask *pup*  0  0 maze-disp (+ 0 (* 40 row)) (+ 0 (* 40 col)) (width *pup*) (height *pup*)  boole-xor)
      ))

(defun move-pup (maze-disp  n s d)
  (multiple-value-bind (rowstart cols) (floor (- s 1) n)
    (multiple-value-bind (rowd cold) (floor (- d 1) n) 
;      (write-display maze-disp "P" (+ 15 (* 40 rowstart)) (+ 15 (* 40 cols)) :operation boole-xor)
      (copy-mask *pup*  0  0 maze-disp (+ 0 (* 40 rowstart)) (+ 0 (* 40 cols)) (width *pup*) (height *pup*) boole-xor)
;      (write-display maze-disp "P" (+ 15 (* 40 rowd)) (+ 15 (* 40 cold)) :operation boole-xor)
      (copy-mask *pup*  0  0 maze-disp (+ 0 (* 40 rowd)) (+ 0 (* 40 cold)) (width *pup*) (height *pup*)  boole-xor)
      ))
  )


(defmethod animate-plan ((world world-desc) start plan (maze-display maze-display))
  (let ()
    (when *animate*
      (show-maze maze-display (cdr start) 5)
      (place-pup maze-display 5
		 (cadr (loop for item in start
			   thereis (if (equal (format nil "~a" (car item)) "at") item))))
      (loop for step in (cdr plan) do
	    (progn (sleep 0.5)
		   (move-pup maze-display 5 (cadr step) (fourth step)))
	
	))))

