;;; -*- Mode: LISP; Package: csp; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   csp-dialog.cl
;;; Short Desc: Functions to scale sizes and fonts for the phisical screen
;;;             (and my-software-push methods)
;;;             Used by modules :  ATN ATP CSP CKY, 
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   8.2.93 - FB
;;; Author:     Fabio Baj
;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------
 
;;; --------------------------------------------------------------------------
 

;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :pail-lib)

(eval-when (compile load eval)
  (export '(my-findfont scalew scaleh small-screen 
	    *original-screen-width* *original-screen-height*)))
	    
;-----------------------------------------------
;; TO SCALE SCREENS
;;-----------------------------------------------
(defvar *original-screen-width*)
(defvar *original-screen-height*)
(setq *original-screen-width* 1300)
 (setq *original-screen-height* 1000)
 
(defun my-findfont (expected-font-size)
  ;; For a window of width width, which was designed to be with
  ;; expected-width, which originally had a font size expected-font
  ;; (integer), this returns a more or less appropriately sized font.  
  (let ((size (/ (* expected-font-size (width *root-window*))
		 *original-screen-width*)))
    (cond
   ;;  ((< size 8.5) gin::*small-font-8*)
     ((< size 9.5) gin::*small-font-9*)
     ((< size 10.5) gin::*small-font*)
     ((< size 11.5) gin::*small-font-11*)
     ((< size 13.5) gin::*bold-font*)
     ((< size  14.5) (open-font :courier :roman 15 :weight :bold))
    ((< size  16.5)  (open-font :courier :roman 18 :weight :bold))
     (t gin::*big-bold-font*))))




(defun  scalew (x ) 
  (round (* x (/ (width *root-window*) *original-screen-width*))))
(defun  scaleh (x )
  (round (* x (/ (height *root-window*) *original-screen-height*))))

(defun small-screen()
   (if (< (scalew 1152) 800) t))





