;;; -*- Mode:Lisp; Package:pail; Syntax:Common-Lisp; Base:10; -*-
;;;
;;; ************************************************************************
;;; PORTABLE AI LAB - UNI ZH
;;; ************************************************************************
;;;
;;; Filename:   pail-dialog
;;; Short Desc: main interface of the portable ai lab 
;;; Version:    1.0
;;; Status:     experimental
;;; Last Mod:   November 92 - MR
;;; Author:     SK/NA/DTA
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;; ------------------------------------------------------------------------
;;; Change History: 
;;; na
;;; ========================================================================

(eval-when (compile load)
  (ensure-loaded (add-path "global" *pail-lib-dir*)))

(in-package :pail-lib)


;;; this is t if this is just a runtime version, not a development version.

(defparameter *runtime* nil)
(defparameter *student* nil)

(defvar *main-window*)
(defvar *last-exit* nil)
(defvar *stop-demo* nil)
(defvar *pause-demo* nil)
(defvar *main-buttons* nil)

(defvar exit-button nil)

(defvar pool-central nil)
(defvar demo-button nil)
(defvar *pail-quit* nil)


(defvar *pail-modules* '(
  ("planning" "Planning")
  ("ebg"      "Explanation Based Generalization")
  ("atn"      "Augmented Transition Networks")
  ("cky"      "Chart Parsing")
  ("atp"      "Logic") 
  ("csp"      "Constraint Propagation")
  ("rules"    "Rule Chaining Engines")
  ("tms"      "Truth Maintenance")
  ("ga"       "Genetic Algorithms")
  ("id3"      "Inductive Learning with ID3")
  ("nn"	      "Neural Networks")
  ("rpg"      "Repertory Grid")
))

(defvar *number-of-modules* (length *pail-modules*))

(defun modname (x) (nth 0 x))
(defun modlabel(x) (nth 1 x))

(defun startfn (mod)
 (cond 
  ((string= mod "tms")
   (function gtre::start-tms-dialog)) ;this will eventually go
  (t 
   (find-symbol
    (symbol-name
     (read-from-string
      (concatenate 'string "start-" (string mod) "-dialog")))
    (find-package (symbol-name (read-from-string (string mod))))))))

(defun makefile (mod)
  (concatenate 'string (string mod) "-make" ".cl"))

;;; starting modules

(defun mod-start (mod &key (from-button nil))
  (load 
   (add-path (makefile mod) (add-subdir *pail-path* (string mod))))
  (setq *last-exit* (apply (startfn mod) (list from-button))))


(defun longest-label ()
 (let ((l 0)
       (lmax 0)
       (longest nil))
  (mapc
    (function
      (lambda (m)
	(cond ((> (setq l (length (modlabel m))) lmax)
	       (setq lmax l)
	       (setq longest (modlabel m))))))	
    *pail-modules*)
  longest))


(defun demo-button ()
 (set-button demo-button *main-window*
  :left (- (width *main-window*) 
           (width *pail-logo*) 5)
  :bottom (- (height *main-window*) 
             (* (- *number-of-modules* 3) (height exit-button)) 5)
  :action #'(lambda ()
	     (let 
	       ((pause-disp
	             (make-instance 'display 
		      :left (+ (left *main-window*)(* 2 (width *main-window*)))
		      :bottom (- (+ (bottom *main-window*) (height *main-window*))
		                 (* 2 (height *pail-logo*)))
		      :height (* 2 (height *pail-logo*))
		      :width (+ 40 (width *pail-logo*))
		      :title "Demo"))
		 (pause-button (make-instance 'push-button 
		                  :label "Pause" 
				  :width (width *pail-logo*))))
	      (set-button pause-button pause-disp
		:left 25 
		:bottom 10
		:action #'(lambda ()
			   (setf *pause-demo* (not *pause-demo*))
			     (if (equal (label pause-button) "Pause")
				 (setf (label pause-button) "Run")
				 (setf (label pause-button) "Pause"))
						    
			     (reset-button pause-button)))
	      (loop while (not *stop-demo*) do
		(loop for module in (list "id3" "rules" "atp" "atn" "planning") until *stop-demo*
		  do (progn
		       (software-push (eval (find-symbol (format nil "~a-button" module) :pail)))
		       (loop until *stop-demo* 
		         for i from 1 to (cadr (assoc module `( ("id3" 5)
								("rules" 1)
								("atp" 6)
								("atn" 3)
								("planning" 4))
								:test 'string=))
					       when (not (and (eq "id3" module) (eq i 1)))
					       do (funcall (find-symbol "auto-demo" module)  i)
					     )
					   (software-push *last-exit*))))
												    
	      (reset-button demo-button)
	      (setq *stop-demo* nil)
	      (close-display pause-disp)))))

(defun make-hack-button ()
 (let ((b (make-instance 'push-button :label "     " :width 55 :border nil)))
  (set-button b *main-window*
   :left (- (width *main-window*) (width b) 5)
   :bottom (- (height *main-window*) (* (round (/ *number-of-modules* 2))
					       (height exit-button)) 5)
   :action #'(lambda ()
	       (mapc (function reset-button) *main-buttons*)
	       (reset-button b)
	       (setq *stop-demo* t)))))
    
(defun init-main (buttonheight)
 (let ((h (+ 10 (* *number-of-modules*
       buttonheight))))
  (setf *main-window* 
    (make-instance 'display
      :left 10 
      :bottom (- (height *root-window*) h 30)
      :width  (+ 50
		 (font-string-width *default-font* (longest-label))
		 (width *pail-logo*))
      :height h
      :title "Main"))))
					 

			  
(defun make-pool-central ()
 (let ((b (make-instance 'file-button
            :width (width *pail-logo*)
            :w-directory (if pail-lib::*user-dir* 
			     pail-lib::*user-dir*
			   (add-path "pool" *pail-path*)))))
  (set-button b *main-window*
    :left (- (width *main-window*) (width b) 5)
    :bottom (- (height *main-window*) 
               (* (floor *number-of-modules* 2)
	          (height exit-button)) 5))))

(defun start-pail-dialog ()
  (when (boundp '*main-window*)(makunbound '*main-window*) )
  (let ((count 0))
    (or (cw::common-windows-initialized-p)
	(gin::init-window-system))
    (setq pail-lib::*max-browser-width* (round (width *root-window*) 1.3))
    (setq pail-lib::*max-browser-height* (round (height *root-window*) 1.3))
    (setq *default-push-button-width*
      (+ 8 (font-string-width *default-font* (longest-label))))
    
    (let ((*default-push-button-size-p* t)
	  (loadfile (merge-pathnames  ".pail-init.cl" (directory-namestring (user-homedir-pathname)))))
      (when (probe-file loadfile) (load loadfile))
      (setf exit-button  (make-instance 'push-button :label "Exit" :width 70)) 
      (mapc 
       (function
	(lambda (mod)
	  (let ((b (make-instance 'push-button :label (modlabel mod))))
	   (or (boundp '*main-window*)
	    (init-main (height b)))
	     (push b *main-buttons*)
	    (set-button b *main-window*
			:left 5
			:bottom (- (height *main-window*) 
				   (* (setq count (1+ count))
				      (height exit-button)) 5)
			:action `(lambda ()
				   (mod-start ,(modname mod) :from-button ,b))))))
       *pail-modules*)
         
      
      
      
      (when pail-lib::*user-dir*
	(if (probe-file pail-lib::*user-dir*)
	    (excl::chdir pail-lib::*user-dir*)
	  (setq pail-lib::*user-dir* nil)))
      
      (make-hack-button)
      
      (setf demo-button (make-instance 'push-button :label "Demo" :width 55))
      
      (copy-mask *pail-logo* 0 0 *main-window* 
		 (- (width *main-window*) 
		    5 
		    (width *pail-logo*)) 
		 (- (height *main-window*) (height *pail-logo*) 5))
      
      (copy-mask *idsia-logo* 0 0 *main-window* 
		 (- (width *main-window*) 
		    5 
		    (width *idsia-logo*))
		 5)

      (set-button exit-button *main-window*
		  :left (- (width *main-window*) (width exit-button) 5)
		  :bottom (+ (height *idsia-logo*) 20)
		  :action `(lambda nil (quit-pail))
		  :active nil)
      
      
      (place-help-button "main" *main-window* (- (width *main-window*) (width exit-button) 5) 
			  (- (height *main-window*) (* 2  (height *pail-logo*)) 5))

      
      (enable-button exit-button)))
)

(defun quit-pail ()
  (close-display *main-window*)
  (setq *pail-quit* t)
  (when (or *runtime* *student*) (excl:exit t :quiet t)))
 


;;; ==========================================================================
;;; END OF FILE
;;; ==========================================================================

