;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:GIN; Base:10; -*-
;;;
;;; ******************************
;;; *  PORTABLE AI LAB - UNI ZH  *
;;; ******************************
;;;
;;; Filename:   menu.cl
;;; Short Desc: simple menus with Common Displays.
;;; Version:    1.0
;;; Status:     Experimental
;;; Last Mod:   Jun 15 1991
;;; Author:     na

;;; ==========================================================================
;;; DESCRIPTION
;;; ==========================================================================

(in-package :gin)

(export '(*default-push-button-width*
	  *default-push-button-height*
	  *default-pop-up-button-width*
	  *default-pop-up-button-height*
	  *default-radio-button-width*
	  *default-radio-button-height*
	  *default-push-button-size-p*
	  *default-pop-up-button-size-p*
	  *value-button-border-p*
	  *push-button-label-left-align-p*
	  *push-button-movable-p*
	  accept-items
	  action
	  answer
	  bitmap
	  bottom
	  change-value
	  clear-button
	  disable-button
	  display
	  display-function
	  enable-button
	  height
	  highlight-button
	  inhibit-buttons
	  items
	  label
	  left
	  menu
	  menu
	  name
	  options
	  pop-up-button
	  push-button
	  radio-button
	  region
	  reset-button
	  set-button
	  set-exclusive
	  software-push
	  status
	  toggle-button
	  unset-button
	  button-value
	  value-button
	  width
	  y-or-n-dialog
	  ))


(defparameter *gray-bitmap*		*grey-bitmap*	"The bitmap that is used to disguise disabled/pushed Buttons")

(defparameter *default-push-button-width*	100)
(defparameter *default-push-button-height*	21)
(defparameter *default-pop-up-button-width*	100)
(defparameter *default-pop-up-button-height*	30)
(defparameter *default-radio-button-width*	10)
(defparameter *default-radio-button-height*	10)
(defparameter *value-button-border-p*		nil "specifies whether value-buttons will have a fixed border of width 1")
(defparameter *default-push-button-size-p*	nil "specifies whether push-buttons will use the width/height specified by their default")
(defparameter *default-pop-up-button-size-p*	nil "specifies whether pop-up-buttons will use the width/height specified by their default")
(defparameter *push-button-label-left-align-p*	nil "specifies whether push-buttons will set have the label centered or left aligned inside the button")
(defparameter *push-button-movable-p*		nil "specifies whether push-buttons or value-buttons will be movable with the middle mouse-button")


(defclass menu ()
	  ((items   :initarg :items
		    :accessor items)
	   (query   :initarg :query :accessor query
		    :initform nil)
	   (answer  :initform nil :accessor answer)
	   (options :initform nil :accessor options))
  (:documentation "a simple pop-up menu"))

(defclass button ()
	  ((left	:type integer :initarg :left	:accessor left)
	   (bottom	:type integer :initarg :bottom	:accessor bottom)
	   (width	:type integer :initarg :width	:accessor width)
	   (height	:type integer :initarg :height	:accessor height)
	   (border	:initform t   :initarg :border	:accessor border)
	   (bitmap	:initarg :bitmap :accessor bitmap)
	   (label :type string
		  :initarg :label
		  :initform nil
		  :accessor label)
	   (status :initarg :status
		   :initform nil
		   :accessor status)
	   (region :initarg :region
		   :initform nil
		   :accessor region)
	   (display :initarg :display
		    :initform nil
		    :accessor display)
	   (font    :initarg :font
		    :initform *default-font*
		    :accessor font)
	   (action :initarg :action
		   :initform nil
		   :accessor action)
	   (inhibit-buttons :initform nil
			    :initarg :inhibit-buttons
			    :accessor inhibit-buttons)
	   )
  (:documentation "This is a standard Button"))

(defclass push-button (button) () (:documentation "This is a push Button")) ;;; just to seperate methods.

(defclass value-button (push-button)
	  ((value	:initarg :value
			:accessor button-value)
	   (numeric	:initform nil :initarg :numeric
			:accessor numeric)
	   (name	:initarg :name :initform ""
			:accessor name)
	   (border :initarg :border :initform *value-button-border-p*
		   :accessor border)
	   (menu :initarg :menu :initform nil :accessor menu)
	   (before-action :initarg :before-action 	;;; This will ONLY be called if you have
			  :initform nil			;;; a menu attached to the value-button.
			  :accessor before-action)
	   (use-window :initarg :use-window		;;; If T, an auxiliary window will
		       :initform t			;;; be opened for reading a new button-value.
		       :accessor use-window)
	   (verbose-change :initarg :verbose-change	;;; only used if use-window = T
			   :initform t
			   :accessor verbose-change)
	   (display-function :initarg :display-function
			     :initform '(lambda (x) (if (stringp x)
							x
						      (write-to-string x)))
			     :accessor display-function))
  (:documentation "A button that has a label (left of the button-box) and a value"))

(defclass radio-button (button) ()
  (:documentation "This is a simple radio Button"))

(defclass pop-up-button (button)
	  ((menu :type menu :initform nil
		 :initarg :menu
		 :accessor menu))
  (:documentation "This is a pop-up Button"))



(defmethod initialize-instance :after ((b push-button) &rest junk)
  #| (declare (ignore junk)) |#
  (if *debug* (format t "~%initialize-instance :after (~A push-button) ~A" b junk))
  (unless (or (label b) (slot-boundp b 'bitmap))
    (setf (slot-value b 'label) "click here"))
  (unless (slot-boundp b 'width)
    (setf (width b) (max (if *default-push-button-size-p*
			     *default-push-button-width*
			   0)
			 (+ 8 (if (label b) (font-string-width (font b) (label b)) 0))
			 (if (slot-boundp b 'bitmap)
			     (+ 5 (width (bitmap b)))
			   0))))
  (unless (slot-boundp b 'height)
    (setf (height b) (max (if *default-push-button-size-p*
			      *default-push-button-height*
			    0)
			  (+ 6 (font-character-height (font b)))
			  (if (slot-boundp b 'bitmap)
			      (+ 5 (height (bitmap b)))
			    0)))))

(defmethod initialize-instance :after ((b value-button) &key name label width)
  ;; (declare (ignore junk))
  (if *debug* (format t "~%initialize-instance :after (~A value-button)  :name ~a :label ~a" b name label))
  (unless (slot-boundp b 'value)
    (setf (button-value b) (if (numeric b) 0 "")))
  (setf (name b) (if name name (if label label "")))
  (setf (slot-value b 'label) (apply (display-function b) (list (button-value b))))
  (unless width
    (setf (width b) (max (+ (font-string-width (font b) (label b)) 8)
			 (if (slot-boundp b 'bitmap)
			     (+ 3 (width (bitmap b)))
			   0)
			 (width b)))))

(defmethod (setf button-value) :after (arg (b value-button))
  (declare (ignore arg))
  (if *debug* (format t "~%(setf button-value) ~a to ~a [~a] " b
	  (button-value b)
	  (if (numeric b) "numeric" "string")))
  (setf (label b) (apply (display-function b) (list (button-value b)))))

(defmethod (setf label) :after (arg (b push-button))
  (if *debug* (format t "~%(setf (label ~a) ~a)" b arg))
  (when (and (label b) (display b) (status (display b)))
    (clear-display (display b) :left (left b) :bottom (bottom b)
		   :width (width b) :height (height b))
    (if (border b)
	(draw-rectangle (display b) (left b) (bottom b) (width b) (height b)))
    (let ((cf (font (display b)))
	  (c-label (clip-label b)))
      (setf (font (display b)) (font b))
      (write-display (display b) c-label
		     (+ (left b) (if *push-button-label-left-align-p* 3 (/ (- (width b) (font-string-width (font b) c-label)) 2)))
		     (+ (bottom b) (font-baseline (font b)) (/ (- (height b) (font-character-height (font b))) 2)))
      (setf (font (display b)) cf))))

(defmethod (setf label) :after (arg (b pop-up-button))
  (if *debug* (format t "~%(setf (label ~a) ~a)" b arg))
  (when (and (label b) (display b) (status (display b)))
    (clear-display (display b) :left (+ (left b) 3) :bottom (+ (bottom b) 3)
		   :width (- (width b) 6) :height (- (height b) 6))
    (let* ((display (display b))
	   (cf (font display))
	   (c-label (clip-label b)))
      (setf (font display) (font b))
      (write-display display c-label
		     (+ (left b) (/ (- (width b) (font-string-width (font b) c-label)) 2))
		     (+ (bottom b) (font-baseline (font b)) (/ (- (height b) (font-character-height (font b))) 2)))
      (setf (font display) cf))))


(defmethod initialize-instance :after ((b pop-up-button) &rest junk)
  #| (declare (ignore junk)) |#
  (if *debug* (format t "~%initialize-instance :after (~A pop-up-button) ~A" b junk))
  (if (not (or (label b) (slot-boundp b 'bitmap)))
      (setf (label b) "Menu"))
  (if (not (slot-boundp b 'width))
      (setf (width b) (max (if *default-pop-up-button-size-p*
			       *default-pop-up-button-width*
			     0)
			   (+ (if (label b) (font-string-width (font b) (label b)) 0) 40)
			   (if (slot-boundp b 'bitmap)
			       (+ 5 (width (bitmap b)))
			     0))))
  (if (not (slot-boundp b 'height))
      (setf (height b) (max (if *default-pop-up-button-size-p*
			       *default-pop-up-button-height*
			     0)
			    (+ 2 (font-character-height (font b)))
			    (if (label b) 30 0)
			    (if (slot-boundp b 'bitmap)
				(+ 5 (height (bitmap b)))
			      0)))))

(defmethod initialize-instance :after ((b radio-button) &rest junk)
  #| (declare (ignore junk)) |#
  (if *debug* (format t "~%initialize-instance :after (~A radio-button) ~A" b junk))
  (if (not (label b))
      (setf (label b) "select"))
  (if (not (slot-boundp b 'width))
      (setf (width b) *default-radio-button-width*))
  (if (not (slot-boundp b 'height))
      (setf (height b) *default-radio-button-height*)))


(defmethod initialize-instance :after ((m menu) &rest junk)
  (if *debug* (format t "~%initialize-instance :after (~A menu) ~A" m junk))
  (setf (options m) (cw:make-pop-up-menu (items m) :title (if (query m) (query m) nil))))

#|
(defmethod initialize-instance :after ((m menu) &rest junk)
  ;;(declare (ignore junk))
  (if *debug* (format t "~%initialize-instance :after (~A menu) ~A" m junk))
  (setf (options m) (cw:make-menu :items (upgrade (items m))
				  :justification :center
				  :border-color blue
				  :foreground-color 50%-gray
				  :background-color white
				  :borders 1
				  :title (if (query m) (list (query m)) nil))))


(defmethod accept-items ((m menu))
  (setf (answer m) (cw:pop-up-menu (options m))))

(defun upgrade (l)
  (let ((result nil))
    (dolist (i l (nreverse result))
      (push (list (car i) (cadr i) :documentation (caddr i)) result))))
|#

(defmethod accept-items ((m menu))
  (setf (answer m) (cw:pop-up-menu-choose (options m))))


(defmethod clip-label ((b button))
  (subseq (label b)
	  0 (let ((len 0) (font (font b)) (label (label b))
		  (maxc (length (label b))) (maxw (- (width b) 8)))
	      (dotimes (i maxc maxc) (if (> len maxw)
					 (return (1- i))
				       (incf len (font-character-width font (schar label i))))))))

(defmethod clip-label ((b value-button))
  (subseq (apply (display-function b) (list (button-value b)))
	  0 (let ((len 0) (font (font b)) (label (label b))
		  (maxc (length (label b))) (maxw (- (width b) 8)))
	      (dotimes (i maxc maxc) (if (> len maxw)
					 (return (1- i))
				       (incf len (font-character-width font (schar label i))))))))


(defmethod set-button ((b push-button) display &key
		       (left 0)
		       (bottom 0)
		       (active t)
		       (action nil)
		       (border 0))
  (when (and display (status display))
    (if (not (slot-boundp b 'left)) (setf (left b) left))
    (if (not (slot-boundp b 'bottom)) (setf (bottom b) bottom))
    (if action
	(setf (action b) action)
      (setf action (action b)))
    (setf (display b) display)
    (setf bottom (bottom b)) (setf left (left b))
    (if *debug* (format t "~%set-button (~A push-button) ~A :left ~A :bottom ~A :action ~A"
			b display left bottom (action b)))
    (enable-button (inhibit-buttons b)) (setf (status b) 0)
    (unless (eq border 0) (setf (border b) border))
    (clear-display display :left left :bottom bottom :width (width b) :height (height b))
    (if (border b) (draw-rectangle display left bottom (width b) (height b)))
    (setf (cw:window-stream-mouse-cursor (window display)) *mouse-cursor-northwest-arrow*)
    (if (slot-boundp b 'bitmap)
	(copy-mask (bitmap b) 0 0 display
		   (+ 3 left (floor (- (width b) (width (bitmap b)) 5) 2))
		   (+ 3 bottom (floor (- (height b) (height (bitmap b)) 5) 2))
		   (width (bitmap b)) (height (bitmap b)) boole-1 (cw:make-region :left (+ (left b) 3) :bottom (+ (bottom b) 3)
										  :width (- (width b) 5) :height (- (height b) 5))))
    (if (label b)
	(let ((cf (font display))
	      (c-label (clip-label b)))
	  (setf (font display) (font b))
	  (write-display display c-label
		       (+ left (if *push-button-label-left-align-p* 3 (/ (- (width b) (font-string-width (font b) c-label)) 2)))
		       (+ bottom (font-baseline (font b)) (/ (- (height b) (font-character-height (font b))) 2)))
	  (setf (font display) cf)))
    (when (not active)
      (if (colorp)
	  (progn (setf (cw:window-stream-foreground-color (pattern (display b))) 50%-gray)
		 (if (slot-boundp b 'bitmap)
		     (copy-mask (bitmap b) 0 0 (display b)
				(+ 3 (left b) (floor (- (width b) (width (bitmap b)) 5) 2))
				(+ 3 (bottom b) (floor (- (height b) (height (bitmap b)) 5) 2))
				(width (bitmap b)) (height (bitmap b)) boole-1 (cw:make-region :left (+ (left b) 3) :bottom (+ (bottom b) 3)
											       :width (- (width b) 5) :height (- (height b) 5))))
		 (if (label b)
		     (let ((cf (font (display b)))
			   (c-label (clip-label b)))
		       (setf (font (display b)) (font b))
		       (write-display (display b) c-label
				      (+ (left b) (if *push-button-label-left-align-p* 3 (/ (- (width b) (font-string-width (font b) c-label)) 2)))
				      (+ (bottom b) (font-baseline (font b)) (/ (- (height b) (font-character-height (font b))) 2)))
		       (setf (font (display b)) cf)))
		 (setf (cw:window-stream-foreground-color (pattern (display b))) black))
	(progn (cw:bitblt *gray-bitmap* 0 0 (window (display b)) (+ 1 (left b)) (+ 1 (bottom b)) 16 16 boole-and
			  (cw:make-region :left (+ 1 (left b)) :bottom (+ 1 (bottom b))
					  :width (- (width b) 1) :height (- (height b) 1)) t)
	       (cw:bitblt *gray-bitmap* 0 0 (pattern (display b)) (+ 1 (left b)) (+ 1 (bottom b)) 16 16 boole-and
			  (cw:make-region :left (+ 1 (left b)) :bottom (+ 1 (bottom b))
					  :width (- (width b) 1) :height (- (height b) 1)) t)))
      (setf (status b) -1))
    (setf (region b) (make-active-region display
					 :left left :bottom bottom
					 :width (width b) :height (height b)
					 :active active))
    (add-active-region-method (region b) ':left-button-down :after 
			      (function 
			       (lambda (&rest cw-internals)
				 (declare (ignore cw-internals))
				 (cw:deactivate (region b))
				 (if (colorp)
				     (progn (draw-filled-rectangle display (+ 1 left) (+ 1 bottom)
								   (- (width b) 1) (- (height b) 1)
								   :color black)
					    (setf (cw:window-stream-foreground-color (pattern (display b))) 50%-gray)
					    (if (slot-boundp b 'bitmap)
						(copy-mask (bitmap b) 0 0 display
							   (+ 3 left (floor (- (width b) (width (bitmap b)) 5) 2))
							   (+ 3 bottom (floor (- (height b) (height (bitmap b)) 5) 2))
							   (width (bitmap b)) (height (bitmap b)) boole-1 (cw:make-region :left (+ (left b) 3) :bottom (+ (bottom b) 3)
															  :width (- (width b) 5) :height (- (height b) 5))))
					    (if (label b)
						(let ((cf (font display))
						      (c-label (clip-label b)))
						  (setf (font display) (font b))
						  (write-display display c-label
								 (+ left (if *push-button-label-left-align-p* 3 (/ (- (width b) (font-string-width (font b) c-label)) 2)))
								 (+ bottom (font-baseline (font b)) (/ (- (height b) (font-character-height (font b))) 2)))
						  (setf (font display) cf)))
					    (setf (cw:window-stream-foreground-color (pattern (display b))) black))
				   (progn (cw:bitblt *gray-bitmap* 0 0 (pattern display) (+ 1 left) (+ 1 bottom) 16 16 boole-ior
						     (cw:make-region :left (+ 1 left)       :bottom (+ 1 bottom)
								     :width (- (width b) 1) :height (- (height b) 1)) t)
					  #| (cw:complement-area (pattern display) (cw:make-region :left (+ 1 left)
												:bottom (+ 1 bottom)
												:width (- (width b) 1)
												:height (- (height b) 1))) |#))
					  
				 (cw:bitblt (pattern display) (+ 1 left) (+ 1 bottom)
					    (window display) (+ 1 left) (+ 1 bottom))
				 (disable-button (inhibit-buttons b)) (setf (status b) 1))))
    (set-button-action b)
    (if *push-button-movable-p* (set-button-move b))
    (cw:modify-active-region-method (region b) :mouse-cursor-in
				    :after (function (lambda (&rest cw-internals)
						       (declare (ignore cw-internals))
						       (draw-rectangle display (+ 1 left) (+ 1 bottom)
								       (- (width b) 2) (- (height b) 2)
								       :color black)
						       (draw-rectangle display (+ 2 left) (+ 2 bottom)
								       (- (width b) 4) (- (height b) 4)
								       :color black))))
    (cw:modify-active-region-method (region b) :mouse-cursor-out
				    :after (function (lambda (&rest cw-internals)
						       (declare (ignore cw-internals))
						       (draw-rectangle display (+ 1 left) (+ 1 bottom)
								       (- (width b) 2) (- (height b) 2)
								       :color white)
						       (draw-rectangle display (+ 2 left) (+ 2 bottom)
								       (- (width b) 4) (- (height b) 4)
								       :color white))))
    b))

(defmethod set-button-move ((b push-button))
  (add-active-region-method (region b) ':middle-button-down
			    :after (function (lambda (&rest cw-internals)
					       (declare (ignore cw-internals))
					       (unset-button b)
					       (let ((frame (cw:make-bitmap :width (1+ (width b)) :height (1+ (height b)))))
						 (dotimes (i (width b))
						   (setf (cw:bitmap-bit frame i 0) 1)
						   (setf (cw:bitmap-bit frame i (height b)) 1))
						 (dotimes (i (height b))
						   (setf (cw:bitmap-bit frame 0 i) 1)
						   (setf (cw:bitmap-bit frame (width b) i) 1))
						 (setf (cw:window-stream-mouse-cursor (window (display b)))
						   (cw:make-mouse-cursor :source-bitmap frame
									 :mask-bitmap frame
									 :x-hotspot 0
									 :y-hotspot (height b))))
					       (setf (region (display b)) (make-active-region (display b)))
					       (add-active-region-method (region (display b)) ':middle-button-up
									 :after
									 (function (lambda (&rest cw-internals)
										     (declare (ignore cw-internals))
										     (if *debug* (format t "~%Setting Buttton with action ~A" (action b)))
										     (setf (region (display b)) (cw:flush (region (display b))))
										     (let ((pos (cw:mouse-position (window (display b)))))
										       (setf (left b) (cw:position-x pos))
										       (setf (bottom b) (cw:position-y pos))
										       (set-button b (display b) :border (border b))
										       (setf (cw:window-stream-mouse-cursor (window (display b))) *mouse-cursor-northwest-arrow*))))
									 )))))

(defmethod set-button-action ((b value-button))
  (add-active-region-method (region b) ':left-button-down :after
			    (function (lambda (&rest cw-internals)
					(declare (ignore cw-internals))
					(let ((input-proc (mp:process-run-function "Change val" #'change-value b)))
					  (mp:process-run-function "Set new val" #'change-value-action input-proc (action b)))))))

(defmethod set-button-action ((b push-button))
  (add-active-region-method (region b) ':left-button-down :after
			    (function (lambda (&rest cw-internals)
					(declare (ignore cw-internals))
					(mp:process-run-function (label b) #'button-call (action b))))))



(defmethod change-value ((b value-button))
  (declare (ignore junk))
  (setf (region b) (cw:deactivate (region b)))
  (if (menu b)
      (let* ((result (progn (if (before-action b) (apply (before-action b) nil))
			    (eval (accept-items (menu b))))))
	(if result
	    (setf (button-value b) result)) 
	(clear-display (display b) :left (left b) :bottom (bottom b)
		       :width (1+ (width b)) :height (1+ (height b))))
    (if (use-window b)
	(let* ((position (cw:mouse-position))
	       (oldv (format nil "[old value: ~a]" (label b)))
	       (width (max 350 (+ 21 (font-string-width *small-font* oldv))))
	       (height (if (verbose-change b) 70 50))
	       (input-display (make-display :title (format nil "Enter new value~a" (if (equal (name b) "") ":" (concatenate 'string " for " (name b))))
					    :left (max 0 (min (- (width *root-window*) width)
							      (- (cw:position-x position) 150)))
					    :bottom (max 0 (min (- (height *root-window*) height)
								(- (cw:position-y position) 10)))
					    :width width :height height))
	       (inputline (progn (when (verbose-change b)
				   (setf (font input-display) *small-font*)
				   (write-display input-display oldv 20 50)
				   (setf (font input-display) *default-font*))
				 (read-display input-display 20 20))))
	  (close-display input-display)
	  (if (> (length inputline) 0)
	      (if (numeric b)
		  (if (not (numberp (read-from-string inputline)))
		      (display-error (format nil "Numeric value expected~%~A is not a number" inputline))
		    (setf (button-value b) (read-from-string inputline)))
		(setf (button-value b) inputline))))
      (let ((tt (title (display b))))
	(setf (title (display b)) (format nil "Enter new value~a" (if (equal (name b) "") ":" (concatenate 'string " for " (name b)))))
	(clear-display (display b) :left (left b) :bottom (bottom b)
		       :width (1+ (width b)) :height (1+ (height b)))
	(let ((inputline (read-display (display b)
				       (+ (left b) 4)
				       (+ (bottom b) (font-baseline (font b))
					  (/ (- (height b) (font-character-height (font b))) 2))
				       :remove t)))
	  (if (> (length inputline) 0)
	      (if (numeric b)
		  (if (not (numberp (read-from-string inputline)))
		      (display-error "Numeric value expected"
				     :text2 (format nil "~A is not a number" inputline)
				     :wait t)
		    (setf (button-value b) (read-from-string inputline)))
		(setf (button-value b) inputline)))
	  (setf (title (display b)) tt)))))
  (set-button b (display b) :bottom (bottom b) :width (width b) :action (action b)))

(defun change-value-action (input-proc action)
  (mp:process-wait (concatenate 'string "Waiting for " (mp:process-name input-proc))
		   #'(lambda nil (not (mp:process-active-p input-proc))))
  (when action
    (if *debug* (format t "~%I am doing ~A~%" action))
    (apply action nil)))
  
(defmethod set-button :after ((b value-button) display &rest junk)
  (if *debug* (format t "~%set-button :after (~A value-button) ~A ~A" b display junk))
  (let* ((display (display b))
	 (cf (font display)))
    (setf (font display) (font b))
    (write-display display (name b) (- (left b) (font-string-width (font b) (name b)))
		   (+ (bottom b) (font-baseline (font b))
		      (/ (- (height b) (font-character-height (font b))) 2)))
    (setf (font display) cf)))

(defmethod unset-button :after ((b value-button))
  (if *debug* (format t "~%unset-button :after (~A value-button)" b))
  (write-display (display b) (name b) (- (left b) (font-string-width (font b) (name b)))
		 (+ (bottom b) (font-baseline (font (display b)))
		    (/ (- (height b) (font-character-height (font b))) 2))
		 :operation boole-clr))


(defmethod set-button ((b pop-up-button) display &key
		       (left 0) (bottom 0) (action nil))
  (when display
    (if *debug* (format t "~%set-button (~A pop-up-button) ~A ..." b display))
    (if (not (slot-boundp b 'left)) (setf (left b) left))
    (if (not (slot-boundp b 'bottom)) (setf (bottom b) bottom))
    (setf bottom (bottom b)) (setf left (left b))
    (if action
	(setf (action b) action)
      (setf action (action b)))
    (setf (display b) display)
    (draw-filled-rectangle display left bottom (width b) (height b) :color white)
    (draw-rectangle display left bottom (width b) (height b))
    (draw-rectangle display (+ left 2) (+ bottom 2) (- (width b) 4) (- (height b) 4))
    (if (label b)
	(let ((cf (font display))
	      (c-label (clip-label b)))
	  (setf (font display) (font b))
	  (write-display display c-label
		       (+ left (/ (- (width b) (font-string-width (font b) c-label)) 2))
		       (+ bottom (font-baseline (font b)) (/ (- (height b) (font-character-height (font b))) 2)))
	  (setf (font display) cf)))
    (if (slot-boundp b 'bitmap)
	(copy-mask (bitmap b) 0 0 (display b) (+ 3 (left b)) (+ 3 (bottom b))
		   (- (width b) 4) (- (height b) 4)))
    (when (menu b)
      (setf (region b) (make-active-region display
					   :left left :bottom bottom
					   :width (width b) :height (height b)))
      (cw:modify-active-region-method (region b) :button
				      :after (function (lambda (&rest cw-internals)
							 (declare (ignore cw-internals))
							 (if (action b)
							     (apply (action b) nil))
							 (accept-items (menu b))
							 (if (answer (menu b))
							    (mp:process-run-function (write-to-string (answer (menu b)))
										      #'(lambda nil (apply (answer (menu b)) nil)))))))
      )))

(defmethod disable-button ((b pop-up-button))
  (if (and (display b) (status (display b)))
      (when (equal (cw:active-region-status (region b)) :active)
	(setf (region b) (cw:deactivate (region b)))
	(if (colorp)
	    (progn (setf (cw:window-stream-foreground-color (pattern (display b))) 50%-gray)
		 (if (label b)
		     (let ((c-label (clip-label b)))
		       (write-display (display b) c-label
				      (+ (left b) (/ (- (width b) (font-string-width (font b) c-label)) 2))
				      (+ (bottom b) (font-baseline (font b)) (/ (- (height b) (font-character-height (font b))) 2)))))
		 (if (slot-boundp b 'bitmap)
		     (copy-mask (bitmap b) 0 0 (display b) (+ 3 (left b)) (+ 3 (bottom b))
				(- (width b) 4) (- (height b) 4)))
		 (setf (cw:window-stream-foreground-color (pattern (display b))) black))
	  (progn (cw:bitblt *gray-bitmap* 0 0 (window (display b)) (+ 3 (left b)) (+ 3 (bottom b)) 16 16 boole-and
			      (cw:make-region :left (+ 2 (left b)) :bottom (+ 2 (bottom b))
					      :width (- (width b) 4) :height (- (height b) 4)) t)
		   (cw:bitblt *gray-bitmap* 0 0 (pattern (display b)) (+ 3 (left b)) (+ 3 (bottom b)) 16 16 boole-and
			      (cw:make-region :left (+ 2 (left b)) :bottom (+ 2 (bottom b))
					      :width (- (width b) 4) :height (- (height b) 4)) t))))
    ))

(defmethod enable-button ((b pop-up-button))
  (when (and (display b)
	     (status (display b)))
    (setf (region b) (cw:activate (region b)))
    (clear-display (display b) :left (+ (left b) 4) :bottom (+ (bottom b) 4)
		   :width (- (width b) 6) :height (- (height b) 6))
    (if (label b)
	(let ((df (font (display b)))
	      (c-label (clip-label b)))
	  (setf (font (display b)) (font b))
	  (write-display (display b) c-label
		       (+ (left b) (/ (- (width b) (font-string-width (font b) c-label)) 2))
		       (+ (bottom b) (font-baseline (font b)) (/ (- (height b) (font-character-height (font b))) 2)))
	  (setf (font (display b)) df)))
    (if (slot-boundp b 'bitmap)
	(copy-mask (bitmap b) 0 0 (display b) (+ 3 (left b)) (+ 3 (bottom b))
		   (- (width b) 4) (- (height b) 4)))))

(defmethod unset-button ((b pop-up-button))
  (when (and (display b)
	     (status (display b)))
    (if (region b) (setf (region b) (cw:deactivate (region b))))
    (clear-display (display b) :left (left b) :bottom (bottom b) :width (1+ (width b)) :height (1+ (height b)))))

(defmethod disable-button ((b push-button))
  (if *debug* (format t "~%disable-button (~A push-button)" b))
  (when (and (display b)
	     (status (display b)))
    (if (equal (status b) 0)
	(setf (status b) -1)
      (setf (status b) (+ (status b) (signum (status b)))))
    (if (equal (cw:active-region-status (region b)) :active)
	(progn (setf (region b) (cw:deactivate (region b)))
	       (if (colorp)
		   (progn (setf (cw:window-stream-foreground-color (pattern (display b))) 50%-gray)
			  (if (slot-boundp b 'bitmap)
			      (copy-mask (bitmap b) 0 0 (display b)
					 (+ 3 (left b) (floor (- (width b) (width (bitmap b)) 5) 2))
					 (+ 3 (bottom b) (floor (- (height b) (height (bitmap b)) 5) 2))
					 (width (bitmap b)) (height (bitmap b)) boole-1 (cw:make-region :left (+ (left b) 3) :bottom (+ (bottom b) 3)
													:width (- (width b) 5) :height (- (height b) 5))))
			  (if (label b)
			      (let ((cf (font (display b)))
				    (c-label (clip-label b)))
				(setf (font (display b)) (font b))
				(write-display (display b) c-label
					       (+ (left b) (if *push-button-label-left-align-p* 3 (/ (- (width b) (font-string-width (font b) c-label)) 2)))
					       (+ (bottom b) (font-baseline (font b)) (/ (- (height b) (font-character-height (font b))) 2)))
				(setf (font (display b)) cf)))
			  (setf (cw:window-stream-foreground-color (pattern (display b))) black))
		 (progn (cw:bitblt *gray-bitmap* 0 0 (window (display b)) (+ 1 (left b)) (+ 1 (bottom b)) 16 16 boole-and
				   (cw:make-region :left (+ 1 (left b)) :bottom (+ 1 (bottom b))
						   :width (- (width b) 1) :height (- (height b) 1)) t)
			(cw:bitblt *gray-bitmap* 0 0 (pattern (display b)) (+ 1 (left b)) (+ 1 (bottom b)) 16 16 boole-and
				   (cw:make-region :left (+ 1 (left b)) :bottom (+ 1 (bottom b))
						   :width (- (width b) 1) :height (- (height b) 1)) t)))))
    ))

(defmethod disable-button ((b radio-button))
  (if (and (display b) (status (display b)))
      (when (equal (cw:active-region-status (region b)) :active)
	(setf (region b) (cw:deactivate (region b)))
	(if (colorp)
	    (if (status b)
		(draw-filled-rectangle (display b) (+ (left b) 2) (+ (bottom b) 2) (- (width b) 3) (- (height b) 3) :color 50%-gray)
	      (draw-rectangle (display b) (left b) (bottom b) (width b) (height b) :color 50%-gray))
	  (progn (cw:bitblt *gray-bitmap* 0 0 (window (display b)) (left b) (bottom b) 16 16 boole-and
			    (cw:make-region :left (left b) :bottom (bottom b)
					    :width (1+ (width b)) :height (1+ (height b))) t)
		 (cw:bitblt *gray-bitmap* 0 0 (pattern (display b)) (left b) (bottom b) 16 16 boole-and
			    (cw:make-region :left (left b) :bottom (bottom b)
					    :width (1+ (width b)) :height (1+ (height b))) t))
	  ))))


(defmethod enable-button ((b radio-button))
  (when (and (display b) (status (display b)))
    (setf (region b) (cw:activate (region b)))
    (draw-rectangle (display b) (left b) (bottom b) (width b) (height b))
    (if (status b) (draw-filled-rectangle (display b) (+ (left b) 2) (+ (bottom b) 2)
					  (- (width b) 3) (- (height b) 3)))))

(defmethod disable-button (l)
  (dolist (i l t) (disable-button i)))

(defmethod enable-button (l)
  (dolist (i l t) (enable-button i)))

(defmethod clear-button (l)
  (dolist (i l t) (clear-button i)))

(defmethod reset-button (l)
  (dolist (i l t) (reset-button i)))


;;; Dummy functions... these buttons shouldn't be reset anyway.
(defmethod reset-button ((b pop-up-button)))
(defmethod reset-button ((b radio-button)))


(defmethod enable-button ((b push-button))
  (when (and (display b) (status (display b)) (status b))
    (unless (equal (status b) 1)
      (setf (status b) (- (status b) (signum (status b)))))
    (when (equal (status b) 0)
      (setf (region b) (cw:activate (region b)))
      (enable-button (inhibit-buttons b))
      (clear-display (display b) :left (1+ (left b)) :bottom (1+ (bottom b))
		     :width (1- (width b)) :height (1- (height b)))
      (if (label b)
	  (let ((cf (font (display b)))
		(c-label (clip-label b)))
	    (setf (font (display b)) (font b))
	    (write-display (display b) c-label
			   (+ (left b) (if *push-button-label-left-align-p* 3 (/ (- (width b) (font-string-width (font b) c-label)) 2)))
			 (+ (bottom b) (font-baseline (font b)) (/ (- (height b) (font-character-height (font b))) 2)))
	    (setf (font (display b)) cf)))
      (if (slot-boundp b 'bitmap)
	  (copy-mask (bitmap b) 0 0 (display b)
		   (+ 3 (left b) (floor (- (width b) (width (bitmap b)) 5) 2))
		   (+ 3 (bottom b) (floor (- (height b) (height (bitmap b)) 5) 2))
		   (width (bitmap b)) (height (bitmap b)) boole-1 (cw:make-region :left (+ (left b) 3) :bottom (+ (bottom b) 3)
									    :width (- (width b) 5) :height (- (height b) 5)))
	  ))))

(defmethod reset-button ((b push-button))
  (when (and (display b) (status b) (not (equal (cw:active-region-status (region b)) :active))
	     (> (status b) 0) (status (display b)))
    (if (equal (status b) 1)
	(progn (setf (region b) (cw:activate (region b)))
	       (setf (status b) 0)
	       (enable-button (inhibit-buttons b))
	       #| (cw:complement-area (window (display b)) (cw:make-region :left (+ 3 (left b)) :bottom (+ 3 (bottom b))
									:width (- (width b) 5) :height (- (height b) 5)))
	       (cw:bitblt (window (display b)) (+ 1 (left b)) (+ 1 (bottom b)) (pattern (display b))
			  (+ 1 (left b)) (+ 1 (bottom b))) |#
	       (clear-display (display b) :left (1+ (left b)) :bottom (1+ (bottom b)) :width (- (width b) 2) :height (- (height b) 2))
	       (if (label b)
		   (let ((cf (font b))
			 (c-label (clip-label b)))
		     (setf (font (display b)) (font b))
		     (write-display (display b) c-label
				    (+ (left b) (if *push-button-label-left-align-p* 3 (/ (- (width b) (font-string-width (font b) c-label)) 2)))
				    (+ (bottom b) (font-baseline (font b)) (/ (- (height b) (font-character-height (font b))) 2)) :operation boole-1)
		     (setf (font (display b)) cf)))
	       (if (slot-boundp b 'bitmap)
		   (copy-mask (bitmap b) 0 0 (display b)
		   (+ 3 (left b) (floor (- (width b) (width (bitmap b)) 5) 2))
		   (+ 3 (bottom b) (floor (- (height b) (height (bitmap b)) 5) 2))
		   (width (bitmap b)) (height (bitmap b)) boole-1 (cw:make-region :left (+ (left b) 3) :bottom (+ (bottom b) 3)
									    :width (- (width b) 5) :height (- (height b) 5)))))
      (progn (setf (status b) (- (1- (status b))))
	     (if (colorp)
		 (progn
		 (clear-display (display b) :left (1+ (left b)) :bottom (1+ (bottom b)) :width (- (width b) 2) :height (- (height b) 2))
		 (setf (cw:window-stream-foreground-color (pattern (display b))) 50%-gray)
		 (if (label b)
		   (let ((cf (font b))
			 (c-label (clip-label b)))
		     (setf (font (display b)) (font b))
		     (write-display (display b) c-label
				    (+ (left b) (if *push-button-label-left-align-p* 3 (/ (- (width b) (font-string-width (font b) c-label)) 2)))
				    (+ (bottom b) (font-baseline (font b)) (/ (- (height b) (font-character-height (font b))) 2)) :operation boole-1)
		     (setf (font (display b)) cf)))
		 (if (slot-boundp b 'bitmap)
		   (copy-mask (bitmap b) 0 0 (display b)
		   (+ 3 (left b) (floor (- (width b) (width (bitmap b)) 5) 2))
		   (+ 3 (bottom b) (floor (- (height b) (height (bitmap b)) 5) 2))
		   (width (bitmap b)) (height (bitmap b)) boole-1 (cw:make-region :left (+ (left b) 3) :bottom (+ (bottom b) 3)
									    :width (- (width b) 5) :height (- (height b) 5))))
		 (setf (cw:window-stream-foreground-color (pattern (display b))) black))
	       (progn
		   (cw:complement-area (pattern (display b)) (cw:make-region :left (+ 3 (left b)) :bottom (+ 3 (bottom b))
									     :width (- (width b) 5) :height (- (height b) 5)))
		   (cw:complement-area (window (display b)) (cw:make-region :left (+ 3 (left b)) :bottom (+ 3 (bottom b))
									    :width (- (width b) 5) :height (- (height b) 5))))
	     )))))

(defmethod unset-button ((b push-button))
  (when (and (display b) (status (display b)) (status b))
    (if (cw:active-p (region b))
	(disable-button b))
    (setf (status b) nil)
    (clear-display (display b) :left (left b) :bottom (bottom b)
		   :width (1+ (width b)) :height (1+ (height b)))))


(defmethod highlight-button ((b push-button) color)
  (when (and (display b) (status (display b)) (status b))
    (if (colorp)
	    (progn
	      (setf (cw:window-stream-foreground-color (pattern (display b))) color)
	      (if (slot-boundp b 'bitmap)
		  (copy-mask (bitmap b) 0 0 (display b)
			     (+ 3 (left b) (floor (- (width b) (width (bitmap b)) 5) 2))
			     (+ 3 (bottom b) (floor (- (height b) (height (bitmap b)) 5) 2))
			     (width (bitmap b)) (height (bitmap b)) boole-1 (cw:make-region :left (+ (left b) 3) :bottom (+ (bottom b) 3)
											    :width (- (width b) 5) :height (- (height b) 5))))
	      (if (label b)
		  (let ((cf (font (display b)))
			(c-label (clip-label b)))
		    (setf (font (display b)) (font b))
		    (write-display (display b) c-label
				   (+ (left b) (if *push-button-label-left-align-p* 3 (/ (- (width b) (font-string-width (font b) c-label)) 2)))
				   (+ (bottom b) (font-baseline (font b)) (/ (- (height b) (font-character-height (font b))) 2)))
		    (setf (font (display b)) cf)))
	      (setf (cw:window-stream-foreground-color (pattern (display b))) black))
	  (if (equal color black)
	      (progn
		(clear-display (display b) :left (1+ (left b)) :bottom (1+ (bottom b))
			       :width (1- (width b)) :height (1- (height b)))
		(if (label b)
		    (let ((cf (font (display b)))
			  (c-label (clip-label b)))
		      (setf (font (display b)) (font b))
		      (write-display (display b) c-label
				     (+ (left b) (if *push-button-label-left-align-p* 3 (/ (- (width b) (font-string-width (font b) c-label)) 2)))
				     (+ (bottom b) (font-baseline (font b)) (/ (- (height b) (font-character-height (font b))) 2)))
		      (setf (font (display b)) cf)))
		(if (slot-boundp b 'bitmap)
		    (copy-mask (bitmap b) 0 0 (display b)
			       (+ 3 (left b) (floor (- (width b) (width (bitmap b)) 5) 2))
			       (+ 3 (bottom b) (floor (- (height b) (height (bitmap b)) 5) 2))
			       (width (bitmap b)) (height (bitmap b)) boole-1 (cw:make-region :left (+ (left b) 3) :bottom (+ (bottom b) 3)
											      :width (- (width b) 5) :height (- (height b) 5)))
		  ))
	    (progn (cw:bitblt cw:*light-grey-bitmap* 0 0 (pattern (display b)) (+ 1 (left b)) (+ 1 (bottom b)) 16 16 boole-ior
			      (cw:make-region :left (+ 3 (left b))       :bottom (+ 3 (bottom b))
					      :width (- (width b) 5) :height (- (height b) 5)) t)
		   (refresh-display (display b)))
		 ))))


(defmethod set-button ((b radio-button) display &key
		       (left 0)
		       (bottom 0)
		       (active t)
		       (action nil))
  (when (and display (status display))
    (if *debug* (format t "~%set-button (~A radio-button) ~A ..." b display))
    (if (not (slot-boundp b 'left)) (setf (left b) left))
    (if (not (slot-boundp b 'bottom)) (setf (bottom b) bottom))
    (if action
	(setf (action b) action)
      (setf action (action b)))
    (setf (display b) display)
    (setf bottom (bottom b)) (setf left (left b))
    (draw-rectangle display left bottom
		    (width b) (height b))
    (if (label b)
	(let ((cf (font display)))
	  (setf (font display) (font b))
	  (write-display display (label b) (+ left (width b) 10) bottom)
	  (setf (font display) cf)))
    (if (status b) (draw-filled-rectangle display (+ left 2) (+ bottom 2)
					  (- (width b) 3) (- (height b) 3)))
    (setf (region b) (make-active-region display :left left :bottom bottom
					 :width (width b) :height (height b)))
    (add-active-region-method (region b) ':left-button-down :after 
			      (function (lambda (&rest cw-internals)
					  (declare (ignore cw-internals))
					  (setf (status b) (not (status b)))
					  (if (status b)
					      (progn (draw-filled-rectangle (display b) (+ left 2) (+ bottom 2)
									    (- (width b) 3) (- (height b) 3))
						     (clear-button (inhibit-buttons b))
						     (disable-button (inhibit-buttons b)))
					    (progn (draw-filled-rectangle (display b) (+ left 2) (+ bottom 2)
									  (- (width b) 3) (- (height b) 3) :color white)
						   (enable-button (inhibit-buttons b)))
					    )
					  (mp:process-run-function (write-to-string (label b)) #'button-call (action b)))))
    #| (add-active-region-method (region b) ':left-button-down :after
				  (function (lambda (&rest cw-internals)
					      (declare (ignore cw-internals))
					      (mp:process-run-function (write-to-string (label b)) #'button-call (action b))))) |#
    (unless active (disable-button b))))

(defmethod unset-button ((b radio-button))
  (when (and (display b) (status (display b)))
    (setf (region b) (cw:deactivate (region b)))
    (clear-display (display b) :left (left b) :bottom (bottom b)
		   :width (1+ (width b)) :height (1+ (height b)))
    (if (label b)
	(let ((cf (font (display b))))
	  (setf (font (display b)) (font b))
	  (write-display (display b) (label b) (+ (left b) (width b) 10) (bottom b) :operation boole-clr)
	  (setf (font (display b)) cf)))))

(defmethod toggle-button ((b radio-button))
  (when (and (display b) (status (display b))
	     (equal (cw:active-region-status (region b)) :active))
    (setf (status b) (not (status b)))
    (if (status b)
	(progn (draw-filled-rectangle (display b) (+ (left b) 2) (+ (bottom b) 2)
				      (- (width b) 3) (- (height b) 3))
	       (clear-button (inhibit-buttons b))
	       (disable-button (inhibit-buttons b)))
      (progn (draw-filled-rectangle (display b) (+ (left b) 2) (+ (bottom b) 2)
				    (- (width b) 3) (- (height b) 3) :color white)
	     (enable-button (inhibit-buttons b))))
    (if (action b)
	(button-call (action b)))))

(defmethod clear-button ((b radio-button))
  (when (and (display b) (status (display b)) (status b))
    (toggle-button b)))

(defun set-exclusive (&rest l)		; l is a list of radio-buttons
  (dolist (i l t)
    (add-active-region-method (region i) ':left-button-down :before
			      (function (lambda (&rest cw-internals)
					  (declare (ignore cw-internals))
					  (clear-button l))))))

(defmethod software-push ((b radio-button))
  (toggle-button b))

(defmethod software-push ((b push-button))
  (when (and (equal (status b) 0) (status (region b)))
    (cw:deactivate (region b))
    (setf (status b) 1)
    (if (colorp)
	(progn (draw-filled-rectangle (display b) (+ 3 (left b)) (+ 3 (bottom b))
				      (- (width b) 5) (- (height b) 5)
				      :color black)
	       (setf (cw:window-stream-foreground-color (pattern (display b))) 50%-gray)
	       (if (slot-boundp b 'bitmap)
		   (copy-mask (bitmap b) 0 0 (display b)
			      (+ 3 (left b) (floor (- (width b) (width (bitmap b)) 5) 2))
			      (+ 3 (bottom b) (floor (- (height b) (height (bitmap b)) 5) 2))
			      (width (bitmap b)) (height (bitmap b)) boole-1 (cw:make-region :left (+ (left b) 3) :bottom (+ (bottom b) 3)
											     :width (- (width b) 5) :height (- (height b) 5))))
	       (if (label b)
		   (let ((cf (font (display b)))
			 (c-label (clip-label b)))
		     (setf (font (display b)) (font b))
		     (write-display (display b) c-label
				    (+ (left b) (if *push-button-label-left-align-p* 3 (/ (- (width b) (font-string-width (font b) c-label)) 2)))
				    (+ (bottom b) (font-baseline (font b)) (/ (- (height b) (font-character-height (font b))) 2)))
		     (setf (font (display b)) cf)))
	       (setf (cw:window-stream-foreground-color (pattern (display b))) black))
      (progn (cw:bitblt *gray-bitmap* 0 0 (pattern (display b)) (+ 1 (left b)) (+ 1 (bottom b)) 16 16 boole-ior
			(cw:make-region :left (+ 1 (left b))       :bottom (+ 1 (bottom b))
					:width (- (width b) 1) :height (- (height b) 1)) t)
	     ))
    (cw:bitblt (pattern (display b)) (+ 1 (left b)) (+ 1 (bottom b))
	       (window (display b)) (+ 1 (left b)) (+ 1 (bottom b)))
    (disable-button (inhibit-buttons b))
;    (mp:process-run-function (write-to-string (label b)) #'button-call (action b))
    (button-call (action b))
    ))


(defun button-call (action)
  (when action (apply action nil)))

(defmethod print-object ((b button) stream)
  (format stream "#<~a '~A' (~A)>" (class-name (class-of b)) (label b) (status b)))

;;; ==========================================================================
;;; END OF FILE
;;; ==========================================================================
