;;; -*- Mode:Lisp; Syntax:Common-Lisp; Base:10; -*-
;;;
;;; Filename:   pop-up-button.cl
;;; Short Desc: example file of the usage of pop-up-buttons
;;; Author:	NA
;;; INTERNAL only
;;; ==========================================================================

(use-package :gin)

(format t "; Now click any mouse-button...")
(setf disp (make-display :title "pop-up-buttons" :width 360 :height 240))

(setf exit-button (make-instance 'push-button :label "Exit"))
(set-button exit-button disp :left 200 :bottom 5
	    :action `(lambda nil (close-display ,disp)))


;;; Here we define some (dummy) functions that will be called by the
;;; menus.

(defun foo ()
  (let ((sub-window (make-display :width 200 :height 100
				  :title "Please enter the source")))
    (write-display sub-window "Filename: " 10 25 )
    (format t "open db: ~A" (read-display sub-window))
    (close-display sub-window)))

(defun exit-prog () (close-display disp))
(defun quit-prog () (close-display disp))
(defun beer ()) (defun gin ()) (defun grapp ())



;;; This is the definition of the (CLOS) menu-object.

(setf my-sub-menu (make-instance 'menu
		      :items '(("Beer"	 beer)
			       ("Gin"	 gin)
			       ("Grappa" grapp))))

(setf my-main-menu (make-instance 'menu
		     :items `(("Do Something"    foo      		"this is the Help text...")
			      ("SUB Options -->" ,(options my-sub-menu) "Here you will have some Drinks")
			      ("Exit"		 exit-prog		"Exit & Save...")
			      ("-----------")
			      ("Quit"		 quit-prog		"Leave the Program without saving"))
		     :query "What do you want to do?"))

;;; When you create a menu you can specify the following keyword-
;;; arguments: :items and :query. The items ist a list of lists with 3
;;; elements in each sublist: The first element is a string that will
;;; appear on the screen upon pop-up, the second is an atom that will
;;; be interpreted as a function name and called upon release of the
;;; mouse cursor over the corresponding area in the pop-up-menu, and
;;; the last element is a string that will automatically be written in
;;; the cw:*prompt-window* (or to the standard-output stream if this
;;; window is closed) if the user rests more than one second above one
;;; are inside the pop-up-menu.
;;; The :query keyword specifies the title of the pop-up-menu and must
;;; be a string (default: no title will appear).




(setf menu-button (make-instance 'pop-up-button
		    :label "Here is the Menu"
		    :menu my-main-menu))

;;; The width of a pop-up-button is set by the method
;;; initialize-instance to the following default size:
;;; (width == (max (+ (if (label b) (font-string-width (font disp) (label menu-button))) 40)
;;;		   (if (slot-boundp menu-button 'bitmap)
;;;			       (+ 5 (width (bitmap menu-button)))
;;;			     0)))
;;; (height == (max (+ 2 (font-character-height (font disp)))
;;;		    (if (label menu-button) 30 0)
;;;		    (if (slot-boundp menu-button 'bitmap)
;;;				(+ 5 (height (bitmap menu-button)))
;;;			      0)))
;;;
;;; but you can set the size of the button to any desired size with the
;;; :width and :height keyword arguments (Do not make the button too
;;; small!). When you make the button with make-instance you have to
;;; specify a menu with the :menu keyword.



(set-button menu-button disp :left 5 :bottom 5)

;;; Unlike push-buttons and value-buttons you can not move
;;; pop-up-buttons with the middle button of your mouse (a feature
;;; that will be removed in the final version of the interface).
;;; Pop-up-buttos MUST be created with a menu. These buttons can be
;;; disabled, enabled and unset with the functions disable-button,
;;; enable-button and unset-button respectively. You may also use a
;;; bitmap (with the :bitmap key) instead of a label - in this case
;;; the Button is automatically created with the rught size, unless
;;; you specify another size with the :width or :height keys. Unlike
;;; the label of the pop-up-button the bitmap is not centered within
;;; the button-frame but aligned to the lower left corner of the
;;; button. The method set-button for the pop-up-button accepts only 2
;;; keyword arguments: :left and :bottom and they both default to 0.



(setf qw (make-instance 'pop-up-button
		    :width 100 :bitmap (read-bitmap "~almassy/bitmaps/homer.xbm")
		    :menu my-main-menu))
(set-button qw disp :left 30 :bottom 50)



;;; More possibilities:

;(disable-button menu-button)
;(enable-button menu-button)
;(unset-button menu-button)
;(set-button menu-button disp)
