;;; -*- Mode:Lisp; Syntax:Common-Lisp; Base:10; -*-
;;;
;;; Filename:   select-button.cl
;;; Short Desc: example file of the usage of select-buttons
;;; Author:	NA
;;; INTERNAL
;;; ==========================================================================

(use-package :gin)

(setf disp (make-display :title "pAILab:Pool"))

(setf exit-button (make-instance 'push-button :label "Exit"))
(set-button exit-button disp :left (- (width disp) (width exit-button) 5) :bottom 5
	    :action `(lambda nil (close-display ,disp)))
(draw-line disp 0 31 (width disp) 31)

(setf run-button (make-instance 'push-button :label "Run"))
(set-button run-button disp :left 5 :bottom 170 :active nil)


(setf sb (make-instance 'select-button
	   :label "Rulesets"
	   :height 100 :width (- (floor (width disp) 2) 10)
	   :items '("Safe to stack" "-unknown-" "Nomic"
		    "Management Logic" "Weather Forecast" "Making Love"
		    "Traffic prediction")
	   :exclusive t
	   ;:font (open-font :times :roman 13)
	   ))
(dolist (i (items sb) t)
  (setf (action i) `(lambda nil
		      (if (and (active sb2) (active sb))
			  (enable-button run-button))
		      (documentation-print
		       (format nil "The \"~a\" ruleset was selected" ,(label i))))))
(set-button sb disp :bottom 36 :left 5)


(setf sb2 (make-instance 'select-button
	    :label "Working memories"
	    :height 100 :width (- (floor (width disp) 2) 10)
	    :items '("Table1" "Table2" "Rain/Tornado"
		     "Times")
	    :exclusive t
	    ;:font (open-font :times :roman 13)
	    ))
(set-button sb2 disp :bottom 36 :left (- (width disp) (width sb2) 5))

(dolist (i (items sb2) t)
  (setf (action i) `(lambda nil
		      (if (and (active sb2) (active sb))
			  (enable-button run-button))
		      (if (status ,i)
			  (documentation-print
			   (format nil "The Working memory \"~a\" was selected" ,(label i)))))))


;;; HEY  -  you may add items to a select-button:
;;;
;;;         (add-item sb "Seppl Mueller")
;;;
;;; But unfortunately you can't remove them...
;;; BUT: you can reuse the items of a button:

#|


(setf pl (make-instance 'select-button
	   :height 70
	   :width 200
	   :items (cdddr (items sb))
	   :label "A new one..."))
(set-button pl disp :left 5 :bottom 200)

 |#