;;; -*- Mode:Lisp; Syntax:Common-Lisp; Base:10; -*-
;;;
;;; Filename:   help-button.cl
;;; Short Desc: example file of the usage of help-buttons
;;; Author:	NA
;;; INTERNAL only
;;; ==========================================================================


(use-package :gin)

(format t "; Now click any mouse-button...")
(setf disp (make-display :title "Need Help ?" :width 197 :height 110))

(setf exit-button (make-instance 'push-button :label "Exit"))
(set-button exit-button disp :left 140 :bottom 5
	    :action `(lambda nil (close-display ,disp)))

(setf help-button (make-instance 'push-button :label "Pagable Help"))
(defvar this-help-stream nil)
(set-button help-button disp :left 5 :bottom 5
	    :action `(lambda nil (setf this-help-stream (make-instance 'help-stream
							  :left 200 :bottom 10
							  :width 720 :height 840
							  :filename (ask "Please give me the complete filename: "
									 :condition (function (lambda (this) (not (numberp (read-from-string this)))))
									 :error-message "Don't enter a number.")
							  :from-button ,help-button))))


;;; The method make-instance of help-stream accepts the following
;;; keyword arguments:
;;;		:filename - a string that must contain the
;;;			path-name of a readable text-file, that
;;;			contains the Help information. There is also
;;;			an accessor function named filename. If you do
;;;			a (setf (filename my-help-stream) "some-filename")
;;;			then the original file will be closed, and the
;;;			help-stream will be refreshed with the new
;;;			file starting at page 1.
;;;		:from-button - a button (i.e. the CLOS object) that
;;;			will be reset with the method reset-button
;;;			after the exit button of the help-display is
;;;			clicked. (This should usually be the
;;;			"help-button" - the default is NIL, no button
;;;			will be reset)
;;;		:left	- the distance between the left side of the
;;;			help-display and the left border of the actual
;;;			screen (the default is 10) - 
;;;		:bottom	- the distance between the bottom side of the
;;;			help-display and the bottom of the actual
;;;			screen (the default is 10). NOTE: the user is
;;;			prompted with the mouse for the position of
;;;			the upper left corner of the window if both
;;;			offset keywords are missing) 
;;;		:width	- the width of the help-display
;;;			(the default is 500 - i.e. the help-file
;;;			should not be wider than 54 columns:
;;;			(+ 10 (* 54 (font-character-width *normal-font*)))
;;;			is approx. 500)
;;;		:height	- the height of the help-display
;;;			(the default is 500, but if the help-file is
;;;			longer than 24 Lines, you can page with the
;;;			up/down buttons.)
;;;			(+ 5 (* (+ 5 (font-character-height *normal-font*)
;;;		:font	- the font in which the help text will
;;;			be written on the help-display (the default is
;;;			gi:*normal-font*)


(setf help-button2  (make-instance 'push-button :label "Scrollable Help"))
(set-button help-button2 disp :left 5 :bottom 40
	    :action `(lambda nil (make-display :display-type 'help-display
					       :filename (ask "Please give me the complete filename: "
							      :condition (function (lambda (this) (not (numberp (read-from-string this)))))
							      :error-message "Don't enter a number."
							      :default "garbage")
					       :from-button ,help-button2
					       :button-region t
					       :font *italic-font*)))

;;; the function file-does-not-exist takes the pathname as first
;;; argument and accepts the following keyword arguments:
;;;		:reason	- a string that tells the reason why this file
;;;			was opened (the default value of is "Unable to
;;;			open file")
;;;		:from-button - a button (i.e. the CLOS object) that
;;;			will be reset with the method reset-button
;;;			after the acknowledge button of the
;;;			warning-display is clicked. This should
;;;			usually be the button that caused this opening
;;;			operation. (the default is NIL, no button
;;;			will be reset)
;;;		:width	- the width of the warning-display (the
;;;			default is at least 175 depending of the
;;;			length of the strings to be displayed)
;;;		:height	- the height of the warning-display (the
;;;			default is 92)
;;;		:font	- the font of the reason and the pathname
;;;			inside the help-display. (the default is
;;;			*normal-font*). Note that the font of the
;;;			label of the acknowledge-button is
;;;			*default-font*.
;;; This function does not wait for any user answer.

(setf trouble-button (make-instance 'push-button :label "Don't click in here"))
(set-button trouble-button disp :left 5 :bottom 75
	    :action `(lambda nil (display-error (format nil "You Did it!~
							   ~&I told you not to push the button~
							   ~&\"~a\"!" ,trouble-button)
						:button-label "Ok, I'll never click again"
						:from-button ,trouble-button
						:title "Don't do that again!")))

;;; The function display-error displays a small window at the cursor
;;; location to indicate error-messages. The following arguments are
;;; processed:
;;;		text	- the error message that will be displayed in
;;;			the window. This string may contain formatting
;;;			characters (several lines).
;;;		:from-button - the button (i.e. the CLOS object) that
;;;			will be reset with the method reset-button
;;;			after the acknowledge button of the
;;;			warning-display is clicked. This should
;;;			usually be the button that caused this opening
;;;			operation. (the default is NIL, no button
;;;			will be reset)
;;;		:width	- the width of the warning-display (the
;;;			default is at least 155 depending of the
;;;			length of the strings to be displayed)
;;;		:height	- the height of the warning-display (the
;;;			default is set to the the value (number of
;;;			lines + 3) * font-height)
;;;		:font	- the font of the reason and the pathname
;;;			inside the help-display. (the default is
;;;			*normal-font*). Note that the font of the
;;;			label of the acknowledge-button is
;;;			*default-font*.
;;;		:wait	- a switch to make the function wait for the
;;;			user to acknowledge the error-message. The
;;;			default is t.
;;;		:title	- the title of the window in which the
;;;			error-message will appear. The default is
;;;			"Error".
;;;		:button-label - the label of the acknowledge-button
;;;			wich defaults to "Acknowledge".

;;; the function ask opens a small window and prompts the user for
;;; keyboard input. the first argument is the prompt-string which may
;;; contain formatting characters (several lines). This function
;;; accepts the following keyword arguments: 
;;;		:left	- the distance between the left side of the
;;;			display and the left of the screen (default is
;;;			500)
;;;		:bottom	- the distance between the bottom side of the
;;;			display and the bottom of the screen (default
;;;			is 400)
;;;		:width	- the width of the display will default to 200
;;;			pixels wider that the longest line of the
;;;			prompt-string. 
;;;		:height	- the height of the display (the default is
;;;			set to the the value (number of lines + 2) *
;;;			font-height) 
;;;		:font	- the font of the display (default is
;;;			*default-font*) 
;;;		:title	- the title of the window in which the
;;;			reading will take place. The default is
;;;			"Please answer".
;;;		:from-button - a button (i.e. the CLOS object) that
;;;			will be reset with the method reset-button
;;;			after the return button is pressed. The
;;;			default is NIL, no button will be reset.
;;;		:condition - a function that will test whether the
;;;			input is acceptable. The default is (function
;;;			(lambda (x) t)) - i.e. not check will occur.
;;;		:error-message - the function display-error wil be
;;;			called with this argument when the test on the
;;;			input fails. This keyword argument is ignored
;;;			if no condition is specified.
