;;; -*- Mode:Lisp; Syntax:Common-Lisp; Base:10; -*-
;;;
;;; Filename:   draw-display.cl
;;; Short Desc: example file of the drawing functions in GIN
;;; Author:	NA
;;; INTERNAL
;;; ==========================================================================

(use-package :gin)

(setf disp (make-display :title "Some Graphics" :width 600
			 :left 400 :bottom 500 :height 300))

(setf exit-button (make-instance 'push-button :label "Dismiss"))
(set-button exit-button disp :left (- (width disp) (width exit-button) 5) :bottom 5
	    :action `(lambda nil (close-display ,disp)))


(draw-line disp 100 2 100 198)
(draw-line disp 2 100 198 100)

(draw-arc disp 100 100
	  60 110
	  :start-angle (gin::rad 290)
	  :end-angle   (gin::rad 320)
	  :color blue)

(draw-filled-arc disp 400 200 60 120
	  :start-angle (gin::rad 290)
	  :end-angle   (gin::rad 20)
	  :color red)
(draw-filled-arc disp 400 200 60 120
	  :start-angle (gin::rad 310)
	  :end-angle   (gin::rad 90)
	  :color blue)
(draw-filled-arc disp 400 200 60 120
	  :start-angle (gin::rad 40)
	  :end-angle   (gin::rad 60)
	  :color (cw:make-color :name "tan"))
(draw-filled-arc disp 400 200 60 120
	  :start-angle (gin::rad 100)
	  :end-angle   (gin::rad 90)
	  :color (cw:make-color :name "PaleTurquoise"))
(draw-filled-arc disp 400 200 60 120
	  :start-angle (gin::rad 190)
	  :end-angle   (gin::rad 40)
	  :color (cw:make-color :name "firebrick"))
(draw-filled-arc disp 400 200 60 120
	  :start-angle (gin::rad 230)
	  :end-angle   (gin::rad 60)
	  :color (cw:make-color :name "cadetblue"))

(draw-rectangle disp 363 135 200 130) 

(draw-circle disp 500 200 20)
(setf (font disp) gin::*big-bold-font*)
(write-display disp "M"
	       (- 500 (floor (font-character-width (font disp) #\M) 2.3))
	       (- 200 (floor (font-character-height (font disp)) 2.7)))

(draw-filled-circle disp 180 250 15 :color red)
(draw-filled-circle disp 180 210 15 :color cw:yellow)
(draw-filled-circle disp 180 170 15 :color green)
(draw-rectangle disp 157 145 50 125)

(draw-line disp 200 20 500 20 :color black :arrow t)

(let ((gin::arrow-head-angle (* 40 (/ pi 180)))
      (gin::arrow-head-length 30))
  (draw-line disp 200 50 500 50 :color black :arrow t))



#|

 (do ((x 10) (y 10))
	 ((> x 300))
       (multiple-value-bind (mx my)
	   (cw:mouse-xy)
	 (draw-line disp x y mx my)
	 (setf x mx)
	 (setf y my)))
(clear-display disp)

 |#
