;***************************************************
;   ****** EXAMPLE: LEARNING ANIMAL CATEGORIES *****
;***************************************************


(defvar animal-net)

(hopfield-make-net 'animal-net 28)  


(fill-input-pattern-pool animal-net				 
		'(
           (1 0   1 0   0 1 1   0 1   1 0   0 0 1 0 0   0 0 1   0 0 1   0 0 1   0 1 0)
           (1 0   1 1   0 1 1   0 1   1 0   0 0 1 0 0   0 0 1   0 0 1   0 0 1   0 1 0)
           (0 1   0 1   1 1 0   1 0   1 0   1 1 0 0 0   0 0 1   0 0 1   0 0 1   0 1 0)
           (1 0   1 0   0 1 0   1 0   1 0   1 0 0 0 1   1 0 0   0 1 0   0 1 0   0 1 0)
           (1 0   1 0   0 1 0   0 1   0 1   1 1 0 0 0   1 0 0   1 0 0   1 0 0   1 0 0)

; Because of interference of the stored patterns, this network has difficulties with the recall of
; more than 5 patterns. This is why not more than the above 5 patterns should be learned. However, 
; the patterns below are included here as "comments" in case one wants to see the "spurious" patterns
; that result during recall, if too many paterns are stored. 
;           (0 1   0 1   0 1 0   0 1   1 0   1 1 0 0 0   1 0 0   1 0 0   1 0 0   0 1 0)
;           (0 1   0 1   0 1 1   1 0   1 0   1 1 0 0 0   1 0 0   0 0 1   0 0 1   0 1 0)
;           (1 0   1 0   0 1 0   1 0   1 0   1 0 0 0 1   0 1 0   0 1 0   0 1 0   0 1 0)
;           (1 0   1 0   0 1 0   0 1   0 1   1 1 0 0 0   0 1 0   0 1 0   0 1 0   0 1 0)
;           (0 1   0 1   1 1 0   0 1   1 0   0 0 0 1 1   1 0 0   1 0 0   0 0 1   0 0 1)
;           (1 0   1 0   0 1 0   1 0   1 0   0 0 0 1 0   0 0 1   0 1 0   0 1 0   0 1 0)
;           (1 0   1 0   0 1 0   0 1   0 1   0 0 1 0 0   0 0 1   0 0 1   0 1 0   1 0 0)
;           (0 1   0 1   0 1 0   0 1   1 0   0 1 0 0 0   1 0 0   0 1 0   0 1 0   0 0 1)
;           (0 1   0 1   1 1 0   1 0   1 0   1 0 0 0 0   1 0 0   0 0 1   0 1 0   0 1 0)
								 ))



(hopfield-initialize-weights animal-net 0)

(hopfield-make-activation-output animal-net 28)
  

;  ***** Input fetures (structured description) ****
;				  
;						1	hair  feathers                                    (Hautbedeckung)
;
;						2	gives-milk  lays-eggs                             (Fortpflanzung)
;							
;						3	flies  walks  swims                               (Fortbewegung)
;							
;						4       eats-meat  eats-plants                            (Isst was?)
;							
;						5	hopfieldaws  hoofs                                (Fuesse)
;							
;						6	black  white  grey red  yellow  		  (Farbe)
;							
;						7	spots/patches  stripes  no-pattern		  (Muster)
;							
;						8	long-neck  medium-sized-neck  short-neck           (Hals)
;							
;					        9 	long-legs  medium-sized-legs  short-legs           (Beine)
;							
;						10	big medium-sized small  			   (Groesse)
;
;
;  **** Input features ****
;
;							
; 1.hair 2.feathers 3.milk  4.eggs     5.flies 6.walks   7.swims  8.meat   9.plants 10.claws  11.hoofs  12.black 13.white 14.grey
;
; 1.red  2.yellow   3.spots 4.stripes  5.no-p  6.l-neck  7.m-neck 8.s-neck 9.l-legs 10.m-legs 11.s-legs 12.big   13.med   14.small
;

		
; **** The animals ****  : 1.Beaver  2.Duckbill  3.Albatross  4.Cheetah  5.Giraffe    6.Ostrich  7.Penguin
;                         
;                          8.Tiger   9.Zebra    10.Canary    11.Fox     12.Elephant  13.Hen     14.Eagle       

(run-hopfield-learn animal-net)

;
;

(run-hopfield-recall 
 animal-net 
          ' (1 0   1 0   0 1 0   1 0   0 0   0 0 0 0 1   1 0 0   0 1 0   0 0 0   0 0 0)
 10)
