;;; -*- Mode:Lisp; Syntax:Common-Lisp; Base:10; -*-
;;; ************************************************************************
;;;                                 WIN-SHELL
;;; ************************************************************************
;;;
;;; Filename:   jtms-make.cl
;;; Short Desc: JTMS and JTRE from Lausanne (EPFL)
;;; Version:    0.1
;;; Status:     Experimental
;;; Last Mod:   22.8.91  Fatma FEKIH-AHMED
;;; Author:     Dean ALLEMANG
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; ------------------------------------------------------------------------
;;; RCS $Log$
;;; ------------------------------------------------------------------------

;;; DESCRIPTION
;;; ------------------------------------------------------------------------
;;; Make file to load the entire module (code, documentation, examples...)
;;; ------------------------------------------------------------------------


(in-package :pail)

(eval-when (load eval compile)
  (export '( )))
 


;;; ------------------------------------------------------------------------
;;; PARAMETERS
;;; ------------------------------------------------------------------------

(defparameter *gtrepath* (add-subdir *pail-path* "gtre"))
(defparameter *jtmspath* (add-subdir *pail-path* "jtms"))
 
;;; load sks-shell...
(ensure-loaded (add-path "rules" (add-subdir *pail-path* "pail-lib")))
(ensure-loaded (add-path "pool" (add-subdir *pail-path* "pail-lib")))
(ensure-loaded (add-path "trees" (add-subdir *pail-path* "pail-lib")))
(ensure-loaded (add-path "browser" (add-subdir *pail-path* "pail-lib")))
(ensure-loaded (add-path "tms-browser-specif" *gtrepath*))
(ensure-loaded (add-path "contra-specif" *gtrepath*))
(ensure-loaded (add-path "ebg-classes" (add-subdir *pail-path* "ebg")))
(ensure-loaded (add-path "ebl-jtre" *gtrepath*) :source t)
(ensure-loaded (add-path "jtms" *jtmspath*))
(ensure-loaded (add-path "gtre" *gtrepath*))
(ensure-loaded (add-path "jinterface" *gtrepath*) :force t)
(ensure-loaded (add-path "tms-browser" *gtrepath*))
(ensure-loaded (add-path "contra-browser" *gtrepath*))
(ensure-loaded (add-path "gtredefs" *gtrepath*))
(ensure-loaded (add-path "jtms-new" *jtmspath*))

(excl:gc)

;;; run sks-shell...

(defvar *verbose* nil)

(ensure-loaded (add-path "jtms-filemgr.cl" (add-subdir *pail-path* "jtms")))
(if *gin-p* 
    (ensure-loaded (add-path "jtms-dialog.cl" *jtmspath*))
  (ensure-loaded (add-path "jtms-ascii-dialog" *jtmspath*)))

(gtre::tre-init)

;;; ------------------------------------------------------------------------
;;; END OF FILE
;;; ------------------------------------------------------------------------
