;;; -*- Mode: LISP; Package: ID3; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   id3-ex4.cl
;;; Short Desc: 1st demo for id3
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   6.5.91 - TW
;;; Author:     Thomas Wehrle
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History: 
;;; 
;;;	
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :id3)

(defun dialog-4 (text-disp table-disp rule-disp)
  (let ((exm (make-table
	      :attributes '(profit      age         competition type)
	      :rows      '((down        *           no          software)
			   (down        midlife     yes         software)
			   (up          midlife     no          hardware)
			   (down        old         *           *)
			   (up          new         no          hardware)
			   (up          new         no          software)
			   (up          midlife     no          software)
			   (up          new         yes         software)
			   (down        midlife     yes         hardware)
			   (down        old         yes         software))))
	(attribute 'profit)
	(*readable* t)
	(dtree nil)
	(*default-font* (findfont (width *root-window*) 1140 13)))
    (deactivate-display rule-disp)
    (table-edit exm :font *default-font* :left 10 :bottom (+ 5 (round (height *root-window*) 3))
		:title "ID3:examples")
    (format-display-fill text-disp "In the <Examples> window you can see
                  the table of examples with wildcards.")
    (when (wait)
      (format-display text-disp "~%Now expanding wildcards ...")
      (setf exm (expand-wildcards exm))
      (format-display-fill text-disp "In the <Examples> window you can see
                  the new table without wildcards.")
      (refresh exm)
      (when (wait)
	(format-display-fill text-disp "So many lines increases the
                            chance for a clash")
	(setf dtree (classify attribute exm))
	(setf browse (make-instance 'browser
		       :starting-tree dtree
		       :title "ID3:Decision tree"
		       :left (round (width *root-window*) 2)
		       :bottom 0
		       :font *default-font*))
	(setf (left browse) (- (width *root-window*) (width browse) 5))
	(when (wait) (format-display text-disp "~%End of demo."))
	(close-display (display browse))))
    (close-table-edit exm)))


;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
