;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:HOPFIELD; Base:10; -*-
;;;
;;; ******************************
;;; *  PORTABLE AI LAB - UNI ZH  *
;;; ******************************
;;;
;;; Filename:   demo1.cl
;;; Short Desc: demo
;;; Version:    0.1
;;; Status:     Experimental
;;; Last Mod:   June 1992
;;; Author:     Erik Vinkhuyzen

;;; ==========================================================================
;;; DESCRIPTION
;;; ==========================================================================

(in-package :hopfield)

(defvar *wait* nil)

(defclass demo-manager ()
	  ((evaluation-list :initarg :evaluation-list
			    :accessor evaluation-list
			    :initform nil
			    :type list)
	   (hopfield-network :initarg :hopfield-network
			     :accessor hopfield-network
			     :initform nil
			     :type hopfield-network)
	   (demo-window     :initarg :demo-window
			    :accessor demo-window
			    :type demo-window)))


(defmethod initialize-instance :after ((dm demo-manager) &key)
  (setf (demo-window dm) (make-instance 'demo-window
			   :demo-manager dm
			   :hopfield-network (hopfield-network dm)
			   :title "Hopfield:Demo"
			   :width 400
			   :height 500
			   :left (+ (left (input-window (hopfield-network dm)))
				    (width (input-window (hopfield-network dm)))
				    20)
			   :bottom 200)))


(defmethod next ((dm demo-manager))
  (loop for i in (first (evaluation-list dm))
	      do (eval i)
	      finally (setf (evaluation-list dm) (rest (evaluation-list dm)))))
	

(defmethod text ((dm demo-manager) text)
  (format-display (text-window (demo-window dm)) text))

(defclass demo-window (display)
	  ((demo-manager :initarg :demo-manager
			 :accessor demo-manager
			 :type demo-manager)
	   (hopfield-network :initarg :hopfield-network
			     :accessor hopfield-network
			     :type hopfield-network)
	   (text-window 
	         :initarg :text-window
		 :accessor text-window
		 :type scroll-display)
	   (continue-button
	         :initarg :continue-button
		 :initform (make-instance 'push-button
			     :label "Continue"
			     :width 180)
		 :accessor continue-button
		 :type push-button)
	   (exit-button 
	         :initarg :exit-button
		 :accessor exit-button
		 :initform (make-instance 'push-button
			     :label "Exit"
			     :width 180)
		 :type push-button)))

(defmethod initialize-instance :after ((dw demo-window) &key)
  (setf (text-window dw) (make-instance 'scroll-display
			   :parent dw
			   :width (- (width dw) 20)
			   :height (- (height dw) 200)
			   :left 5
			   :bottom 170))
  (setf (action (exit-button dw)) `(lambda ()
				     (close-display ,dw)
				     ;;;(reset-button (demo-button ,dw))
				     ))
  (set-button (exit-button dw) dw
	      :left (- (width dw) 200)
	      :bottom 5)
  (setf (action (continue-button dw)) `(lambda ()
					 (cond ((evaluation-list (demo-manager ,dw))
						(next (demo-manager ,dw))
						(format-display (text-window ,dw) "~%Press Continue Button~%")
						(reset-button (continue-button ,dw)))
					       (t
						(format-display (text-window ,dw) "~% END OF DEMO~%~%~%")))))
  (set-button (continue-button dw) dw
	      :left 20
	      :bottom 5))


 

(defmethod demo1 ((dm demo-manager))
  (format-display (text-window (demo-window dm)) 
"This is the first demo of the hopfield-network!~%
In this demo we will show what a hopfield network
can learn and explain the basic mechanisms.~%
When you are ready to to go on press the
continue button in the lower left corner~%~%")
  (setf (title (demo-window dm)) "Demo 1")
  (setf (evaluation-list dm) 
    `(((format-display (text-window (demo-window ,dm)) 
"First we have to reset the network.
The activations of the network are set to 0
and the weights are set to 0~%~%")
				(setf (size (hopfield-network ,dm)) 16)
				(defaults (hopfield-network ,dm)))
			       ((format-display (text-window (demo-window ,dm)) 
"Now we will create a pattern in the output-window.
Just to show how the weights change when the network
learns a pattern, we will only make one unit active.~%
~%")                
				(toggle-button (aref (radio-button-array (editor-window (input-window (hopfield-network ,dm)))) 0)))
			     
			     ((format-display (text-window (demo-window ,dm))
"Now the network will learn this pattern. 
Note that when the network learns the pattern,
the weights (in the window on
the lower left corner) change.~%
Now we will learn the pattern~%"))
			      
                             ((software-push (learn-button (input-window 
			       (hopfield-network
				(demo-window
				 ,dm)))))
			     (format-display (text-window (demo-window ,dm))
"The lowest line of the weights represent the weights
from the active unit, to each of the other units.

When you click on one of these you will find out what
the weight is. Since the square is white, 
the weight is smaller than zero.
~%"))
			     ((format-display (text-window (demo-window ,dm))
"The weight is -1/16, because the weight-change
is calculated according to the formula:

W = 1/N * A1 * A2

where 

W = change in weight
N = the number of units
A1 = The activation of the first unit
A2 = The activation of the second unit~%
~%"))

((format-display (text-window (demo-window ,dm))
"Now we will test the network with a pattern,
that is randomly different from the learned pattern.

You can create a randomly different pattern 
by pressing the NOISE button. ~%"))
((software-push (noise-button (input-window 
				 (hopfield-network
				  (demo-window
				   ,dm)))))

(format-display (text-window (demo-window ,dm))
"Now, press the STEP button in the output-window
several times, you can see how the network will 
update its activations and find a stable pattern.

First we must CLAMP the pattern onto the network.~%~%"))

((software-push (clamp-button (input-window 
			       (hopfield-network
				(demo-window
				 ,dm)))))
 (format-display (text-window (demo-window ,dm))
		 "When the network test a pattern, each unit
calculates the incoming activations.~%
If the sum of incoming activations is higher
than the threshold, it becomes active (+1), 
otherwise its activation becomes -1. 

The exact formula is for each unit:

sum of the (incoming activations * weights)
~%"))
((format-display (text-window (demo-window ,dm))
"You can test whether a unit will change its 
activations in the next cycle, by clicking on 
the square in the Activations-window.
When the activation changes in the next
cycle, the square will blink~%")))))


(defmethod demo2 ((dm demo-manager))
  (format-display (text-window (demo-window dm)) "This is the second demo of the hopfield-network!~%
In this demo we will show how a change in the parameters 
of the network affects its behavior.~%
When you are ready to to go on press the
continue button in the lower left corner~%~%")
  (setf (title (demo-window dm)) "Demo 2")
  (setf (evaluation-list dm) `(((format-display (text-window (demo-window ,dm)) "First we have to reset the network.
The activations of the network are randomly
initialized and the weights are set to 0~%~%")
				(reset (hopfield-network ,dm))
				(defaults (hopfield-network ,dm))
				(reset (editor-window (input-window (hopfield-network ,dm)))))
			       ((format-display (text-window (demo-window ,dm)) 
"We will create a pattern in the input-window.")
				(loop for i from 1 to (- (size (hopfield-network ,dm)) 1) by 3
				    do (toggle-button (aref (radio-button-array 
							     (editor-window 
							      (input-window 
							       (hopfield-network ,dm)))) i))))
			       ((format-display (text-window (demo-window ,dm))
"Now the network will LEARN this pattern. ~%")
				(software-push (learn-button (input-window 
							      (hopfield-network
							       (demo-window
								,dm))))))
			       ((format-display (text-window (demo-window ,dm))
"To test this pattern, we will make every unit
active and run the TEST.")
				(loop for i from 0 to (- (size (hopfield-network ,dm)) 1)
				    if (not (status (aref (radio-button-array 
							   (editor-window 
							    (input-window 
							     (hopfield-network ,dm)))) i)))
				    do (toggle-button (aref (radio-button-array 
							     (editor-window 
							      (input-window 
							       (hopfield-network ,dm)))) i)))
				(software-push (test-button (input-window 
							     (hopfield-network
							      (demo-window
							       ,dm))))))
			       ((format-display (text-window (demo-window ,dm))
"As you can see the network recognizes the INVERSE
of the learned pattern. When a hopfield network 
learns a pattern it will learn the inverse of this
pattern as well!

Now we will increase the threshold.

To change any parameter of the network,
you can click on the buttons in the
Parameter-window. (In this case the
THRESHOLD-button.)
But I will do it now automatically")
				(setf (button-value 
				       (threshold-button 
					(parameter-window (hopfield-network ,dm)))) 0.42)
				(setf (threshold (hopfield-network ,dm)) 0.42))
			       
			       ((format-display (text-window (demo-window ,dm))
"Lets test the same pattern again.

But we will do it in STEPs.

First we clamp the pattern onto the network 

~%")
				(loop for i from 0 to (- (size (hopfield-network ,dm)) 1)
				  if (not (status (aref (radio-button-array 
							   (editor-window 
							    (input-window 
							     (hopfield-network ,dm)))) i)))
				  do (toggle-button (aref (radio-button-array 
							   (editor-window 
							    (input-window 
							     (hopfield-network ,dm)))) i)))
				(software-push (clamp-button (input-window 
							      (hopfield-network
							       (demo-window
								,dm))))))
			       ((format-display (text-window (demo-window ,dm))
"Then we use the STEP button in the Output
window.
~%")
				(software-push (step-button (output-window (hopfield-network ,dm)))))
			       ((format-display (text-window (demo-window ,dm))
"As you can see the network does not recognize 
the learned pattern!
In fact the whole network becomes deactivated.

You can understand this when you calculate the input
to each unit with the formula:

A = sum of (incoming activation * weight)

and A has to be greater than the threshold to make
the activation of a unit change to +1.

For the unit in the upper left corner the incoming
activation is 10 * 1/16 - 5 * 1/16 = 5/16,
which is not enough to make it become active with 
a treshold of 0.42.

Let's do one more STEP.
~%"))
			       ((software-push (step-button (output-window (hopfield-network ,dm))))
				(format-display (text-window (demo-window ,dm))
"Now the network does recognize the pattern!



In the second step the input to the second unit is

- 4 * 1/16 + (-11 * -1/16) = 7/16 = 0.44, 
just enough to become active! 

This shows you the dynamics of hopfield networks.
Because all units are linked to each other, the 
network can reach a pattern in several steps, 
always lowering its energy.
~%")))))

			     
(defclass demo-button (push-button)
	  ((menu      :initform (make-instance 'menu
				  :items '(("demo1" demo1
						      "")
					   ("demo2" demo2
					    "")
					   ("demo3" demo3
					    "")
					   ("demo4" demo4
					    "")))
		      :accessor menu
		      :type menu)
	   (input-window
	              :initarg :input-window
		      :accessor input-window
		      :type input-window)))

#|(defmethod initialize-instance :after ((dm demo-button) &key)
  (setf (action dm) `(lambda ()
			 (case  (accept-items ,(menu dm))
			   ((demo1) (demo1 (make-instance 'demo-manager
					     :hopfield-network (hopfield-network (input-window ,dm)))))
			   ((demo2) (demo2 (make-instance 'demo-manager
					     :hopfield-network (hopfield-network (input-window ,dm)))))
			   ((demo3) (demo3 (make-instance 'demo-manager
					     :hopfield-network (hopfield-network (input-window ,dm)))))
			   ((demo4) (demo4 (make-instance 'demo-manager
					     :hopfield-network (hopfield-network (input-window ,dm))))))
			 (reset-button ,dm))))|#


(defmethod demo3 ((dm demo-manager))
  (text dm "This is the third demo")
  (setf (evaluation-list dm)
;;;;;; 1 
    `(((text ,dm "In this demo we will show, what 
a hopfield network can learn.~%
First we have to initialize the 
network to be of size 16")
     (if (= (size (hopfield-network ,dm)) 16)
	 (progn (reset (hopfield-network ,dm))
		(reset (editor-window (input-window (hopfield-network ,dm)))))
       (setf (size (hopfield-network ,dm)) 16))
     (defaults (hopfield-network ,dm)))
;;;;;; 2
     ((text ,dm "Now we will create and store
some patterns. This will show the functionality
of the store and next buttons in the input-window.")
       (loop for i from 0 to 3
	 do (software-push (aref (radio-button-array (editor-window (input-window (hopfield-network ,dm)))) i))
	 finally (software-push (store-button (input-window (hopfield-network ,dm)))))
       (text ,dm "That was the first pattern"))
;;;;;; 3
     ((software-push (clear-button (input-window (hopfield-network ,dm))))
       (loop for i from 0 to 15 by 5
	 do (software-push (aref (radio-button-array (editor-window (input-window (hopfield-network ,dm)))) i))
	 finally (software-push (store-button (input-window (hopfield-network ,dm)))))
       (text ,dm "That was the second pattern"))
;;;;;; 4
     ((software-push (clear-button (input-window (hopfield-network ,dm))))
      (loop for i from 0 to 15 by 4
	 do (software-push (aref (radio-button-array (editor-window (input-window (hopfield-network ,dm)))) i))
	 finally (software-push (store-button (input-window (hopfield-network ,dm)))))
      (text ,dm "That was the third pattern"))
;;;;;; 5
     ((text ,dm "Now you can scroll through the patterns
using the next button.")
      (software-push (next-button (input-window (hopfield-network ,dm))))
      (software-push (next-button (input-window (hopfield-network ,dm))))
      (software-push (next-button (input-window (hopfield-network ,dm)))))
;;;;;; 6
     ((text ,dm "Now let`s learn all the patterns,
First we will set the decay to zero.
When the decay is set to zero, the
network will not forget any patterns.")
      (setf (button-value 
	     (decay-button
	      (parameter-window
	       (hopfield-network ,dm)))) 0)
      (setf (decay (hopfield-network ,dm)) 0))
;;;;;; 7
     ((text ,dm "Now let`s learn all the patterns")
      (software-push (learn-all-button (input-window (hopfield-network ,dm)))))
;;;;;; 8
     ((text ,dm "As you can see the weights in the
weight-window have changed.

You can click on any of these buttons and
see what the weight has become.

When you click the sixth button of the bottom-row,
you can see that the weight is -3/16.

This is understandable, since this button represents
the weight between the first (upper-right corner) and
the seventh unit. Note that these units have always
an opposite activation with each pattern. Therefore
their weight will decrease in every learning cycle."))
;;;;;; 8
     ((text ,dm "Let us create a test pattern.")
      (software-push (clear-button (input-window (hopfield-network ,dm))))
      (software-push (aref (radio-button-array (editor-window (input-window (hopfield-network ,dm)))) 1))
      (software-push (aref (radio-button-array (editor-window (input-window (hopfield-network ,dm)))) 2))
      (software-push (aref (radio-button-array (editor-window (input-window (hopfield-network ,dm)))) 3)))
;;;;;; 9
     ((text ,dm "And test it")
      (software-push (test-button (input-window (hopfield-network ,dm)))))
;;;;;; 10
     ((text ,dm "Let us create a more 
ambiguous test pattern.")
      (software-push (clear-button (input-window (hopfield-network ,dm))))
      (software-push (aref (radio-button-array (editor-window (input-window (hopfield-network ,dm)))) 1))
      (software-push (aref (radio-button-array (editor-window (input-window (hopfield-network ,dm)))) 2))
      (software-push (aref (radio-button-array (editor-window (input-window (hopfield-network ,dm)))) 3))
      (software-push (aref (radio-button-array (editor-window (input-window (hopfield-network ,dm)))) 5)))

;;;;;; 11
     ((text ,dm "And test it")
      (software-push (test-button (input-window (hopfield-network ,dm)))))
;;;;;; 12
     ((text ,dm "As you can see the pattern that is
recognized is the one that most looks like
the test pattern.
This is the most common use for 
hopfield-networks, pattern recognizers.

Let us now see what happens when the network gets
a truly ambiguous pattern.")
      (software-push (clear-button (input-window (hopfield-network ,dm))))
      (software-push (aref (radio-button-array (editor-window (input-window (hopfield-network ,dm)))) 2))
      (software-push (aref (radio-button-array (editor-window (input-window (hopfield-network ,dm)))) 3))
      (software-push (aref (radio-button-array (editor-window (input-window (hopfield-network ,dm)))) 5))
      (software-push (aref (radio-button-array (editor-window (input-window (hopfield-network ,dm)))) 10))
     (text ,dm "This pattern looks as much like the
first pattern as the second pattern"))
;;;;;; 12
    ((text ,dm "Now we will test this pattern.")
     (software-push (test-button (input-window (hopfield-network ,dm))))
     (text ,dm "~%~%As you can see the network cannot
recognize either one of the two patterns.
The pattern with only the unit in the
upper left corner active, is called a 
Spurious state, a pattern with low energy,
which is a mixture of the learned patterns.

Try some other patterns for yourself, in order
to get an idea about which patterns the system
can recognize and which it cannot.

It may be useful to clamp a pattern
using the clamp button, and then test it using
the step-button in the output window")))))
     
      
      
       
	    
(defmethod demo4 ((dm demo-manager))
  (text dm "This is the fourth demo

Press The Continue Button~%~%")
  (if (= (size (hopfield-network dm)) 16)
	 (progn (reset (hopfield-network dm))
		(reset (editor-window (input-window (hopfield-network dm)))))
       (setf (size (hopfield-network dm)) 16))
  (defaults (hopfield-network dm))
  (setf (evaluation-list dm)
;;;;;; 1 
    `(((text ,dm 
"In this short demo we will show that hopfield 
networks learn not only a pattern, but 
automatically learn the inverse of that pattern.

Also, asynchronous and synchronous updating
will be explained."))
;;;;;; 2
      ((text ,dm "Let us create a pattern:")
       (software-push (clear-button (input-window (hopfield-network ,dm))))
       (loop for i from 0 to 3
	 do (software-push (aref (radio-button-array (editor-window (input-window (hopfield-network ,dm)))) i))))
;;;;;; 3
      ((text ,dm "Now we will learn this pattern.")
       (software-push (learn-button (input-window (hopfield-network ,dm)))))
;;;;;; 4
      ((text ,dm "Now we will create a test pattern.")
       (software-push (clear-button (input-window (hopfield-network ,dm))))
       (software-push (aref (radio-button-array (editor-window (input-window (hopfield-network ,dm)))) 5))
       (software-push (aref (radio-button-array (editor-window (input-window (hopfield-network ,dm)))) 6))
       (software-push (aref (radio-button-array (editor-window (input-window (hopfield-network ,dm)))) 9))
       (software-push (aref (radio-button-array (editor-window (input-window (hopfield-network ,dm)))) 10)))
;;;;;; 5
      ((text ,dm "We will clamp this pattern onto the network")
       (software-push (clamp-button (input-window (hopfield-network ,dm)))))
;;;;;; 6
      ((text ,dm "Now let us update the network, using the step-button")
       (software-push (step-button (output-window (hopfield-network ,dm)))))
;;;;;; 7
      ((text ,dm "All the units in the border of the 
display become active.

Let us take a closer look at the upper-left unit.
This unit gets negative input from the other units
of the upper-row, because the weight to these units
is positive, but their activation is negative.
From the active units it receives negative input
also, since these activations are positive, but
their the weights are negative.

From the rest of the units (8) it receives positive
input, because both the weights and the activations
are negative.

Therefore the upper-left unit will become active."))
;;;;;; 8
       ((text ,dm "You can now see for every unit 
whether it will become active or not,
by clicking on the square in the Activations-
window. If the incoming activation will change
the activation of the unit, it will blink."))
;;;;;; 9
       ((text ,dm 
"Let's press the STEP button again.")
	(software-push (step-button (output-window (hopfield-network ,dm)))))
       ((text ,dm 
"As you can see the network starts flipping between
two states of equal energy!
Press the STEP button several times to check.

This phenomenon is a result of the synchronous
updating style."))
       ((text ,dm 
"Now let us change the updating style by pushing 
the button in the parameter window called 
Synchrone.

This changes the updating style. When updating is 
synchronous, the input to every unit is determined, 
and then updated. When updating is asynchronous,
however, one randomly chosen unit is updated, and
its activation is set immediatedly, before any
other unit is chosen. Also, each unit has only a 
chance to be updated, namely 80%.

Asynchronous updating avoids that the network starts
flipping between two states of equal energy.")
	(software-push (asynchronous-button (parameter-window (hopfield-network ,dm)))))
       ((text ,dm "Let us try the same pattern again.")
	(software-push (clamp-button (input-window (hopfield-network ,dm)))))
;;;;;; 10
       ((text ,dm "Step through this pattern yourself and
see what happens"))
;;;;;; 11
       ((text ,dm "Now the pattern (or the inverse of the
pattern) is found after a while.

This is because now every units has a chance to be updated.
Whether the real pattern or its inverse is found, is 
determined by the order in which the units are chosen.
Since the order is random, the chances should be 50%.

Try testing the same pattern several times!")))))

