;;; -*- Mode: LISP; Package: RULES; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - UNI ZH
;;;
;;; ************************************************************************
;;;
;;; Filename:   rules-ex2.cl
;;; Short Desc: 2nd demo of rule chaining
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   6.5.91 - DTA
;;; Author:     DTA from TW
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History: 
;;; 
;;;	
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================



(in-package :rules)


;;; Load example data into the pool

(load-file-no-questions (add-path "airlines" (add-subdir *pail-path* "pool")))

(defun dialog-2 (text-disp rule-disp table-disp)
  (let ((ruleset (pool-find-object *pail-pool* "airlines"))
	(wm (pool-find-object *pail-pool* "customers2"))
	(*readable* t)
	
	)
    (loop for assertion in (assertions wm) do (format-display table-disp "~a~%" assertion))
    (format-display rule-disp "~a" (print-rule-set ruleset nil))
    (format-display-fill text-disp
	"Now we will see some of the possible
         problems with rule programming.  In the
         Rules window, is a rule set with one rule.
         The application is airline reservations;  if a customer requests a
	 seat on some line, and there
         is a free seat available, and the customer does not already have a
         seat, then make the reservation.  Rod already has a reservation from
         Paris to NY, while Dean, Ken and Mike have made such
         requests.  Notice that the rule has negative preconditions.")

    (when (wait)
      (format-display-fill text-disp "When we run the rule on this
data, at the beginning, there are plenty of free seats, so the rule
can be instantiated in any of 12 ways - three customers times four free
seats.  An ordinary rule system assumes that if a binding is valid,
then it is always valid.  This is not true if the preconditions rely
on negative conditions.")
      (setf *trace-stream* *verbose-disp*)
      (let ((*reactive* nil))
	(rules::forward-chain ruleset wm))

      
      
      
      (when (wait)
	
	(format-display-fill text-disp "We can set the `Reactive'
parameter on the rule set, to make it act as a reactive system - it no
longer makes this assumption.  Once one rule is fired, all other rules
must be reconsidered before they will fire.")

	
	(setf wm (pool-find-object *pail-pool* "customers2"))
	(let ((*reactive* t))
	  (rules::forward-chain ruleset wm))
	
	
	
	(when (wait) (format-display-fill text-disp "Now we have the
expected answer.")
	      )
	))))
;;; ========================================================================
;;; END OF FILE
;;; ========================================================================
