;;; -*- Mode:Lisp; Syntax:Common-Lisp; Base:10; -*-
;;; ************************************************************************
;;; PORTABLE AI LAB - UNI ZH
;;; ************************************************************************
;;;
;;; Filename:   ebg-make
;;; Short Desc: Explanation Based Generalization - Initialization
;;;             An implementation of Mitchells EBG-Method
;;; Version:    1.0
;;; Status:     Beta
;;; Author:     SK
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;




;;; ------------------------------------------------------------------------
;;; Change History: 
;;; SK  11.11.90  Some pAIL standards applied
;;; SK  30.08.91  some modifications
;;; SK  22.11.91  New Startup, Tools, Demos
;;; ==========================================================================


;;; ------------------------------------------------------------------------
;;; DEFINE PACKAGE
;;; ------------------------------------------------------------------------


(in-package :ebg)


;;; ------------------------------------------------------------------------
;;; LOAD
;;; ------------------------------------------------------------------------

(defparameter *ebg-path*  (add-subdir *pail-path* "ebg"))
(defparameter *lib-path*  (add-subdir *pail-path* "pail-lib"))
(defparameter *unify-path*  (add-subdir *pail-path* "planning"))

(defvar *number-of-demos*   0                "Temp. var. Set by ebg-make!")

(ensure-loaded (add-path "unify"       *unify-path*))
(ensure-loaded (add-path "trees"       *lib-path*))
(ensure-loaded (add-path "tables"      *lib-path*))
(ensure-loaded (add-path "rules"       *lib-path*))
(ensure-loaded (add-path "tre2rul"     *lib-path*))
(ensure-loaded (add-path "ebg-classes" *ebg-path*))
(ensure-loaded (add-path "browser"     *lib-path*))
(ensure-loaded (add-path "ebg-browser" *ebg-path*))
(ensure-loaded (add-path "ebg"         *ebg-path*))


(if *gin-p*
    (progn
      (ensure-loaded (add-path "ebg-dialog" *ebg-path*))

      (setq *number-of-demos*
	  (do* ((i 1 (1+ i))
		(name (make-pathname :name (format nil "ebg-ex~a" i)
				     :type *sourcefile-type*)
		      (make-pathname :name (format nil "ebg-ex~a" i)
				     :type *sourcefile-type*)))
	      ((not (probe-file (add-path name *ebg-path*))) (1- i))
	    (ensure-loaded (add-path name *ebg-path*)))))
  (ensure-loaded (add-path "ebg-ascii-dialog" *ebg-path*)))


(format *standard-output* "~%EBG module loaded.~%")


;;; ==========================================================================
;;; END OF FILE
;;; ==========================================================================
