(in-package :csp)
 

(defvar *nodesize*)
 (setq *nodesize* 30)
    
(defmethod draw-graph ((n constraint-network))
  (protect-display  *csp-main-window* t)
  (setf (window n) 
    (make-instance 'display :title (if (main-networkp n) "CSP: Main Network"   "")
		   :width (net-disp-width n)
		   :height  (net-disp-width n)
		   :left (incf *gph-left* -10)
		   :bottom (incf *gph-bottom* -5)))
 (placenodes n
	      (truncate (width  (window n) ) 2)
	      (truncate (height (window n)  ) 2)
	      (net-radius n))
  (dolist (nd (nodes n))
    (paint nd  (window n))
    )
  (draw-arrows n)
  (protect-display  *csp-main-window* nil))

(defun net-disp-width(n)(round (* 2.5 (net-radius n))))

(defun placenodes (net cx cy rad)
  (let ((step (/ (* 2 pi) (length (nodes net))))
	(r (- pi))
	(x 0)
	(y 0))
    (dolist (nd (nodes net))
    (setq x (+ (* (cos r) rad   ) cx))
    (setq y (+ (* (sin r) rad ) cy))
  ;;    ;;    (format t "x = ~a  ... y = ~a~%" (floor x) (floor y))
      (setf (xpos nd) (floor x))
      (setf (ypos nd) (floor y))
      (setq r (+ r step)))))

 

(defmethod paint ((nd node) disp)
  (setf (font disp) *small-font*)
  (draw-circle disp (xpos nd) (ypos nd) *nodesize*)
  (let* ((str (format nil"~A" (name nd)))
	 (numval (format nil "~D" (number-of-values nd)))
	 (chx (- (xpos nd)  (floor (/ (font-string-width (font disp) str) 2))))
	 (chy (- (ypos nd)  (floor (/ (font-character-height (font disp)) 2))))
	 (rect-width (round (* *nodesize* 1.4)))
	 (rect-height (round (*  *nodesize* 0.6)))
	 (rect-bot (- (ypos nd) (round (*  rect-height 0.8  ))))
	 (rect-left (- (xpos nd) (truncate rect-width 2))))
    (write-display disp str chx  (+ chy (truncate *nodesize* 2)))
    (setf (domain-button nd)
      (make-instance 'push-button :label numval
		     :width rect-width :height rect-height
		     :font  *small-font*))
    (set-button  (domain-button nd) disp 
		 :left rect-left :bottom rect-bot
		 :action #'(lambda nil
			   (display-values nd)
			   (reset-button (domain-button nd))))))



(defun draw-arrows(net)
  (dolist (source-nd (nodes net))
    (dolist (target-nd (neighbors source-nd))
      (offsetarrow (xpos source-nd) (ypos source-nd )
		   (xpos target-nd) (ypos target-nd )
		   (window net)))))
   
    


(defun offsetarrow (x1 y1 x2 y2 disp)
  (let* ((posangle (if (= x1 x2)
		       (if (> y1 y2) (- (/ pi 2)) (/ pi 2))
		     (atan (/ (- y2 y1) (- x2 x1)))))
	 (angle (if (> x1 x2)
		    (+ pi posangle) posangle))
	 (sx1 (+ x1 (* (cos angle) *nodesize*)))
	 (sx2 (- x2 (* (cos angle) *nodesize*)))
	 (sy1 (+ y1 (* (sin angle) *nodesize*)))
	 (sy2 (- y2 (* (sin angle) *nodesize*)))
	 )
    (draw-line disp sx1 sy1 sx2 sy2 :arrow t)))




(defun net-radius (net)
  (let*
      ((nnd (length (nodes net)))
       (2R (/ (* 1.5 *nodesize*)
	      (sin (/ pi nnd)))))
    (round 2R)))



(defun highlight-node (node)
  (let* ((chx (- (xpos node)  
		 (floor (/   (+  (font-string-width *small-font* "  " )
				 (font-string-width *small-font*  (format nil "~A" (name node))))
			     2))))
	 (chy (- (ypos node)  (floor (/ (font-character-height  *small-font*  ) 2))))
	 )
    (draw-filled-rectangle  (display (domain-button node))
			    chx  (+ chy (truncate *nodesize* 2))
			    (+  (font-string-width  *small-font*   "  " )
				(font-string-width  *small-font*   (format nil "~A" (name node))))
			    (font-character-height  *small-font*  ) 
			    :operation cw::boole-xor)))

(defmethod display-values ((nd node))
  (message (format nil "Domain of Node  ~A: " (name nd)))
  (message (format nil "~{~A ~}~%"(possible-values nd))))

    
