 
(in-package :csp)
(defvar *square-size*)

(setq  *square-size* 20)

(defun g-show-schema(schema)
  (let 
      ((schema-disp (make-instance 'display 
		      :bottom (scalew 485)
		      :left (scalew 1000)
		      :width  (* *square-size* (cadr (array-dimensions schema)))
		      :height (+ 20 (* *square-size*(car (array-dimensions schema))))))
       (exit-button (make-instance 'push-button :label "Cancel")))
    (do ((col 1 (+ col 1)))
	((= col (1- (cadr (array-dimensions schema)))))
      (do ((row 1 (+ row 1)))
	  ((= row (1- (car (array-dimensions schema)))))
	(cond ((eq '_ (aref schema row col))
	       (draw-rectangle  schema-disp (g-col col)
				(g-row row  schema-disp)
				*square-size* *square-size*))
	      ((eq '*  (aref schema row col))
	       (draw-filled-rectangle  schema-disp (g-col col)
				       (g-row row   schema-disp)
				       *square-size* *square-size*))
	      (t (draw-rectangle  schema-disp (g-col col)
				  (g-row row  schema-disp)
				  *square-size* *square-size*)
		 (write-display schema-disp (aref schema row col)
				(+ (round (* 0.05 *square-size* )) (g-col col))
				(+ (round (* 0.7 *square-size* )) (g-row row  schema-disp))
				:font *small-font-8*)) )))
    (set-button exit-button schema-disp :left 20 :bottom 10
		:action #'(lambda nil(close-display schema-disp)))
    
    (setq *current-schema-disp* schema-disp)))



(defun display-word (word  schema net schema-disp )
  (let* ((positions (reverse (all-positions word)))
	 (node  (find-node (variable-name word ) net))
	 (word-value (car(possible-values node)))
	 (chars (coerce (string word-value) ' list)))
		     
    (mapc #'(lambda (pos char)
	      (write-display schema-disp 
			     char
			    (+ (truncate *square-size* 3 ) (g-col (cdr pos) ))
			    (+ (truncate *square-size* 4 ) (g-row (car pos)  schema-disp))
			    :font *default-font*))
	  positions chars)))

(defun g-row (row schema-disp)
  (- (height schema-disp) (* *square-size*  (1+ row))))
(defun g-col (col)
   (* *square-size* col))

(defun fill-schema ( schema net schema-disp)
  (mapc #'(lambda (w)(display-word w schema net schema-disp ) )*words*))

(defun find-word (variable-name)
  (find-if #'(lambda (word)(eq (variable-name word) variable-name)) *words*))