;;; -*- Mode: LISP; Package: cky; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   csp-demo.cl
;;; Short Desc: general dialog handling for DEMOS on CSP Module 
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   28.9.91 - FB 
;;; Author:     Fabio Baj
;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :csp)




;;; ==========================================================================
;;; GLOBAL VARIABLE DECLARATIONS
;;; ==========================================================================


(defvar *pause* nil)
(defvar *quit* nil)
(defvar *open-windows*)

;;============================================================================

;; DEMO FUNCTION: Runs the demo numbered nr
;;; ==========================================================================

(defun demo (nr menu-button other-exit-button tool-button maindisp)
  (init-sizes)
  (setq *csp-main-window* nil)
  (setq *open-windows* nil)
    (deactivate-display maindisp)
  (disable-button menu-button)
  (disable-button other-exit-button)
  (disable-button tool-button)
  (let ((disp (make-instance 'display :title (concatenate 'string "CSP:" (make-title-w nr))
			    :width *csp-mw-width*
			    :height (scaleh  240)
			    :borders 1
			    :left    *csp-mw-left*
			    :bottom (-  *csp-mw-bottom* (scaleh 240)))))
    (setf demo-exit-button (make-instance 'push-button :label "Exit" :font (my-findfont 13) 
					  :width (scalew 100)))
    (setf demo-help-button 
      (make-instance 'help-button :label "Help" :width (scalew 100) :font (my-findfont 13)
		     :subject (concatenate 'string "Demo " (format nil "~A" nr))
		     :technical  
		     (add-path "csp-demo-desc.asc" *csp-path*)
		     :general 
		     (add-path 
		      (concatenate 'string
			"csp-demo" (format nil "~A" nr )"-desc.asc") *csp-path*)))
   
    (setf demo-start-button (make-instance 'push-button :label "Start"  :font (my-findfont 13) :width (scalew 100)) )
    (setf demo-cont-button (make-instance 'push-button :label "Continue" :font (my-findfont 13) :width (scalew 100)))
    (setf (font disp) (my-findfont 16.5))
    (write-display disp 
		   (make-title nr)
		   (scalew  15 )(- (height disp) (scaleh 15) (cw:font-ascent (font disp))))
    (setf (font disp) *default-font*)
    
    
    (copy-mask *pail-logo* 0 0 disp 
	       (- (width disp) (cw:bitmap-width *pail-logo*) (scalew 15))
	       (- (height disp) (cw:bitmap-height *pail-logo*)(scaleh 45)))
    
    (setf demo-text-disp (make-instance
			  'scroll-display
			  :title "CSP:Comments"
			 
			  :parent disp :font (my-findfont 10)
			  :width  (round (* (width disp) 0.75))
			  :height (round (* 0.55 (height disp)))
			  :borders 1
			  :left (- (width disp)(round (* (width disp) 0.75)))
			  :bottom 0))
    
    (set-button demo-exit-button disp 
		
		:left (scalew 20)
		:bottom (+ (scaleh 10) (* 0 (scaleh 40)))
		:action `(lambda ()
			   (setf *quit* t) 
			   (setq *demo-in-execution* nil)
			   (if  *csp-main-window* 
			       (my-software-push *exit-button*  *csp-main-window* ))
			   (close-display ,disp)
			   (activate-display ,maindisp)
			   (mapcar #'(lambda (x)(close-display x)) *open-windows*)
			   (enable-button ,menu-button)
			   (enable-button ,other-exit-button)  
			   (enable-button ,tool-button)
			   
			   ))
    
    (set-button demo-help-button disp 
		:left  (scalew 20)
		:bottom (+ (scaleh 10) (* 1 (scaleh 40)))
		
		)
    
    (set-button demo-start-button disp 
		:left  (scalew 20)
		:bottom (+ (scaleh 10) (* 2 (scaleh 40)))
		
		:action
		#'(lambda ()
		    (disable-button  demo-start-button)
		    (reset-button  demo-start-button)
		    (disable-button demo-exit-button)
		    (dialog-handler nr)))
    
    (set-button demo-cont-button disp 
		:left (scalew 20)
		:bottom (+ (scaleh 10) (* 3 (scaleh 40)))
		:action 
		#'(lambda ()
		    (disable-button demo-exit-button)
		    (setf *pause* t)))
      ( disable-button  demo-cont-button)
    
    ))





(defun dialog-handler(nr)
  (labels ((clean-up ()
	       (close-display demo-text-disp)
	       (unless *quit*
		 (enable-button demo-exit-button)
		 (reset-button demo-cont-button)
		 (disable-button demo-cont-button)
		 (reset-button demo-start-button))))
      (defun wait ()
	(unless *quit*
	  (enable-button demo-cont-button)
	  (reset-button demo-cont-button)
	  (enable-button demo-exit-button)
	  (format-display demo-text-disp "~%<Continue>")
	  (mp:process-wait "wait-on-click" (function (lambda () (or *quit* *pause*))))
	  (if *quit* (clean-up)
	    (setf *pause* nil)))
	(not *quit*))
      (setf *pause* nil)
      (setf *quit* nil)
      (let ((fun-sym (find-symbol (write-to-string (read-from-string (format nil "demo-~a" nr))) :csp)))
	(if fun-sym
	    (funcall fun-sym )(progn
				(format t "Demo not implemented")
				(wait)
				(clean-up))))
      (clean-up)))







(defun make-title (nr)
  (format nil "A ~:R Demo on~% Constraint Propagation~%" nr))

(defun make-title-w (nr)
  (format nil "A ~:R Demo on  Constraint Propagation" nr))


(defun auto-handler(nr)
  (labels ((clean-up ()
	       (close-display demo-text-disp)
	       (unless *quit*
		 (enable-button demo-exit-button)
		 (reset-button demo-cont-button)
		 (disable-button demo-cont-button)
		 (reset-button demo-start-button))))
      (defun wait ()
	(unless *quit*
	  (enable-button demo-cont-button)
	  (reset-button demo-cont-button)
	  (enable-button demo-exit-button)
	  (format-display demo-text-disp "~%<Continue>")
	  (sleep 1)
	  (mp:process-wait "wait-on-click" (function (lambda () (not pail::*pause-demo*))))
	  (if pail::*stop-demo* (software-push demo-exit-button))
	  (software-push demo-cont-button)
	  (if *quit* (clean-up)
	    (setf *pause* nil)))
	(not *quit*))
      (setf *pause* nil)
      (setf *quit* nil)
      (let ((fun-sym (find-symbol (format nil "demo-~a" nr) :csp)))
	(if fun-sym
	    (funcall fun-sym )(progn
				(format t "Demo not implemented")
				(wait)
				(clean-up))))
      (clean-up)))


(defun auto-demo (nr    )
  (let ((disp (make-instance 'display :title (concatenate 'string "CSP:" (make-title-w nr))
			    :width 300
			    :height 480
			    :borders 1
			    :left  (-  (- *csp-mwp-left* 120) 304)
			    :bottom (- (+  *csp-mw-bottom*
					   *csp-mw-height*)
					   480))))
    (setf demo-exit-button (make-instance 'push-button :label "Exit" :width 100))
    (setf demo-help-button 
      (make-instance 'help-button :label "Help" :width (scalew 100)
		     :subject (concatenate 'string "Demo " (format nil "~A" nr))
		     :technical  
		     (add-path "csp-demo-desc.asc" *csp-path*)
		     :general 
		     (add-path 
		      (concatenate 'string
			"csp-demo" (format nil "~A" nr )"-desc.asc") *csp-path*)))
   
    (setf demo-start-button (make-instance 'push-button :label "Start" :width 100))
    (setf demo-cont-button (make-instance 'push-button :label "Continue" :width 100))
   
    (setf (font disp) (cw:open-font :courier :italic 16.5 :weight :bold))
    (write-display disp 
		   (make-title nr)
		   15 (- (height disp) 15 (cw:font-ascent (font disp))))
    (setf (font disp) *default-font*)
    
    
    (copy-mask *pail-logo* 0 0 disp 
	       (- (width disp) (cw:bitmap-width *pail-logo*) 15)
	       (- (height disp) (cw:bitmap-height *pail-logo*) 45))
    
    (setf demo-text-disp (make-instance
			  'scroll-display
			  :title "CSP:Comments"
			  :font (open-font-named "fixed")
			  :parent disp
			  :width  280
			  :height 260
			  :borders 1
			  :left (- (width disp) 290)
			  :bottom 80))
    
    (set-button demo-exit-button disp 
		:left  (- (width disp) 120)
		:bottom 40
		:action `(lambda ()
			   (setf *quit* t) (sleep 0.2)
			   (setq *demo-in-execution* nil)
			   (if  *csp-main-window* 
			       (my-software-push *exit-button*   *csp-main-window*))
			   (close-display ,disp)
			   (sleep 0.2)
			   
			   ))
    
    (set-button demo-help-button disp 
		:left (- (width disp) (* 2 120))
		:bottom 40
		)
    
    (set-button demo-start-button disp 
		:left (+ 20 120)
		:bottom 40		:action
		#'(lambda ()
		    (disable-button  demo-start-button)
		    (reset-button  demo-start-button)
		    (disable-button demo-exit-button)
		    (auto-handler nr)))
    
    (set-button demo-cont-button disp 
		:left 20
		:bottom 40
		:action 
		#'(lambda ()
		    (disable-button demo-exit-button)
		    (setf *pause* t)))
      ( disable-button  demo-cont-button)
    
      (setf pail::*stop-demo* nil)
      (software-push demo-start-button)
      (software-push demo-exit-button)
      ))

;;=================================================
(defun load-csp-demo (filename)
  (protect-display *csp-main-window* t)
  (if *graphics* (toggle-button *graph-button*))
  (disable-button *graph-button*)
  (cond ((null filename) nil)
	(t (setq *domain-loaded* filename)
	   (message (format nil "Loading ~A: Please wait ..." filename))
	   (reset-custom-functions)
	   (if (safe-load filename)
	       (progn
		 (change-title-bar filename )
		 (set-radio-buttons-after-loading)
		 (if *main-network* 
		     (progn
		       (display *main-network*)
		       (possible-solutions-message)
		       (test-net-too-big)
		       (message (format nil "~A succesfully loaded." filename)))
		   (problems-during-loading filename)))
	     (problems-during-loading filename))))
  (protect-display *csp-main-window* nil))
