(defvar *chart-h* )

(defvar *chart-w*)
(defvar *n*)

(defun set-d-vector (x y value)
  (setf (aref *displ-array* x (1- y)) value))
(defun cell-display ( x y)
  (aref *displ-array*  x (1- y)))


(defun row-c (r) (- (* *chart-h* (- *n*  r)) *chart-h*))
(defun col-c (c) (+ (* *chart-w* (- c 1 )) (scalew 20)))

(defun dispose-sentence()
  (let ((pos-sent 0)(b nil))
    (setq *sentence-but-list*
      (mapcar 
       #'(lambda (word)
	   (incf pos-sent)
	   (setf b (make-instance 'push-button :left (col-c pos-sent) :bottom (-  (height  *graph-chart-disp*) (scaleh 62))
				  :font (my-findfont 13) :width  *chart-w*  :label (string word)))
	   
	   (set-button  b  *graph-chart-disp*  
			:action  `(lambda nil
				    (reset-button ,b)
				    (disable-button ,b)
				    (setf *next-step* t)))
	   (disable-button b)
	   b)
       *current-sentence*))
    (dotimes (x  (+ 1 *n*))
      (write-display *graph-chart-disp*
		     x (- (col-c (1+ x)) 4)  (-  (height  *graph-chart-disp*) (scaleh  28))))))



(defun graph-chart-init()
 (setq *next-step* nil)
  (setq *n*  (length *current-sentence*))
  (setq *displ-array* (make-array (list *n* *n*)))
  (let ((n (length *current-sentence*)))
    (setf *graph-chart-disp*
      (make-instance 'display
       :left *cky-disp-left* :bottom (-(height *root-window*) 30 ( + (scaleh 100)(*   n *chart-h*)))
				       :title "Chart Parser" :width (+ (scalew 40 )( * n  *chart-w*))
       :height ( + (scaleh 100)(*   n *chart-h*))))
    (do ((r 0 (+ r 1)))
	((> r  n))
      (do ((c  (1+ r) (+ c 1)))
	  ((>  c n  ))
	(set-d-vector  r c
		       (make-instance 'scroll-display
			 :left (col-c c) :bottom   (row-c r)
			 :width  *chart-w*   :height(-  *chart-h*  18)
			 :font (my-findfont 11) :title (format nil "Chart[~A,~a]" r c )
			 :parent *graph-chart-disp* 
			 ))))
    (dispose-sentence)))




(defun chart-inform (str)
   (if *show-chart*  (format-display (cell-display *current-row* *current-col* ) str)))
 
   


(defun goto-graph-chart (pos1 pos2)
  (setf *current-row* pos1)
  (setf *current-col* pos2))
