;;; -*- Mode:Lisp; Syntax:Common-Lisp; Base:10; -*-
;;; ************************************************************************
;;;                                 WIN-SHELL
;;; ************************************************************************
;;;
;;; Filename:   backward-rules-make.cl
;;; Short Desc: STRIPS used as a backward chainer
;;; Version:    0.1
;;; Status:     Experimental
;;; Last Mod:   29.5.91 15:00:01 DTA
;;; Author:     DTA
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; ------------------------------------------------------------------------
;;; Change History:
;;; HF  11.11.87  first code, debugged
;;; SK  16.10.89  improved
;;; SK   5.11.90  some pail standards applied
;;; DTA  29.5.91  standards modified
;;; ------------------------------------------------------------------------

;;; DESCRIPTION
;;; ------------------------------------------------------------------------
;;; Make file to load the entire module (code, documentation, examples...)
;;; ------------------------------------------------------------------------

;;; (c) Copyright 1991 University of Zurich.  All rights reserved.
;;; Only for non-commercial research or educational purposes; 
;;; neach copy or derivative work must include this copyright notice in full;
;;; This software is made available AS IS, and there is no warranty about
;;; the software or its performance.

;(defpackage :rules (:use :common-lisp :pail-lib))

(in-package :rules)

(eval-when (load eval compile)
  (export '(demo-backward-rules backward-chain)))
 

;;; ------------------------------------------------------------------------
;;; PARAMETERS
;;; ------------------------------------------------------------------------

(defparameter *backward-rulespath* (add-subdir *pail-path* "backward-rules"))
(defparameter *planning-path* (add-subdir *pail-path* "planning"))
(defparameter *libpath* (add-subdir *pail-path* "pail-lib"))
(defparameter *ebgpath*  (add-subdir *pail-path* "ebg"))
(defvar *number-of-demos* 0)



(ensure-loaded (add-path "sftw-push" *libpath*))

(ensure-loaded (add-path "operators" (add-subdir *pail-path* "pail-lib")))
(ensure-loaded (add-path "rules" (add-subdir *pail-path* "pail-lib")))
(ensure-loaded (add-path "unify" *planning-path*))
(ensure-loaded (add-path "search" *planning-path*))
(ensure-loaded (add-path "planner" *planning-path*))
(ensure-loaded (add-path "strips" *planning-path*))
(ensure-loaded (add-path "backward-rules-init" *backward-rulespath*))
(ensure-loaded (add-path "gin-back" *planning-path*))
(ensure-loaded (add-path "graphics" *planning-path*))

(if *gin-p* 
    (progn
      (ensure-loaded (add-path "backward-rules-dialog" *backward-rulespath*))
      (setq *number-of-demos*
	  (do* ((i 1 (1+ i))
		(name (make-pathname :name (format nil "backward-rules-ex~a" i)
				     :type *sourcefile-type*)
		      (make-pathname :name (format nil "backward-rules-ex~a" i)
				     :type *sourcefile-type*)))
	      ((not (probe-file (add-path name *backward-rulespath*))) (1- i))
	    (ensure-loaded (add-path name *backward-rulespath*)))))
  (ensure-loaded (add-path "backward-rules-ascii-dialog" *backward-rulespath*)))


;;; ------------------------------------------------------------------------
;;; end of file
;;; ------------------------------------------------------------------------

