;;; -*- Mode: LISP; Package: atp; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   prolopars.cl
;;; Short Desc:  A PARSER for a subset of Prolog programs 
;;; Version:    1.0 
;;; Status:     Review
;;; Last Mod:   8.9.91 - FB
;;; Author:     Fabio Baj
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :atp)




;;---------------------------------------------------
;; pars         : LIST-OF(TOKEN)  --->  ( SEXPR .  LIST-OF(TOKEN) )
;; Behaviour    : Parses sent and trasforms it into
;;                a formula in prefix notation, togheter with a
;;                list of residual tokens. Implements the following 
;;                production rules:
;;                     PLG-FMLA  --> GOAL
;;                     PLG-FMLA  --> ATOMICF <= CONJ
;;                     PLG-FMLA  --> ATOMICF
;;           
;; Side effects : None
;; Example      : (pars '(A <= B #\, C #\, D #\. D #\.)) = '((=> (& B C D ) A) #\. D #\.)

(defun plg-fmla (sent)
  (let (head conj)
    (or
     (goal sent) 
     (and (setq head (atomic-f sent))
	  (eq '<= (cadr head))
	  (setq conj (conj-fmla (cddr head)))
	  (cons (list '=> (car conj) (car head))
		(cdr conj)))
     head)))
    
;;-----------------------------------   
;;       CONJ -->  ATOMICF , CONJ 
;;       CONJ -->  ATOMICF

(defun conj-fmla (sent)
  (let (subg conj)
    (or
     (and (setq subg (atomic-f sent))
	  (eq '#\, (cadr subg))
	  (setq conj (conj-fmla (cddr subg)))
	  (cons (list '& (car subg) (car conj))
		(cdr conj)))
     subg)))
	
;;---------------------------------
;;    GOAL -->  <= CONJ
(defun  goal (sent)
  (let (conj)
    (or
     (and
      (eq '<= (car sent))
      (setq conj (conj-fmla (cdr sent)))
      (or (setq  $user-answer-vars$ (collect-vars (car conj))) t)
      (cons (list '~ (car conj))
	    (cdr conj))))))
    
    
;;--------------------------------
;;    PLG-LIST -->  [ ]
;;    PLG-LIST -->  [  TM-LIST | <variable> ]
;;    PLG-LIST -->  [  TM-LIST | PLG-LIST ]
;;    PLG-LIST -->  [  TM-LIST ]
;;  The next production is not PROLOG:
;;    PLG-LIST -->  [  TM-LIST | TM ]

(defun plg-list (sent)
  (let (t-l pl1)
    (or 
     (and (eq '#\[ (car sent))(not (null (cdr sent)))(eq '#\] (cadr sent))
	  (cons '$- (cddr sent)))
     (and (eq '#\[ (car sent))
	  (setq t-l (t-list (cdr sent)))
	  (eq '#\| (cadr t-l))
	  (setq pl1 (if $prolog-mode$ (plg-list1 ( cddr t-l))
		      (tm-x (cddr t-l))))
	  (eq '#\] (cadr pl1))
	  (cons (c-cons (c-form (car t-l))
			(car pl1))
		(cddr pl1)))
     (and (eq '#\] (cadr t-l))
	  (cons (c-form (car t-l))
		(cddr t-l))))))
		   



(defun plg-list1 (sent)
 (or  (and (is-variable (car sent)) 
	   sent)
      (and (plg-list sent))))
	   


(defun c-form (l)
  (cond
   ((null (cdr l)) (list '$c (car l) '$-))
   (t (list '$c (car l) (c-form (cdr l))))))

(defun c-cons (c1 c2)
  (cond
   ((eq '$- (caddr c1)) (list (car c1)(cadr c1) c2))
   (t (list (car c1)(cadr c1)(c-cons (caddr c1) c2)))))

(defun output-c-list (clist)
  (cond ((eq '$c clist) (princ '[))
	((eq '$- clist) (princ ']))
	((atom clist) (princ clist))
	(t (mapcar 'output-c-list clist)))) 

(defun is-clist (l)
  (and (listp l)(eq '$c (car l))))
 
