;;; -*- Mode: LISP; Package: atp; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   exist.cl
;;; Short Desc: Functions to test whether two clauses are equal
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   8.9.91 - FB
;;; Author:     Fabio Baj
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================


(in-package :atp)



(defun exists (id1 id2)
  (eq (clause-compare id1 id2) 'uguali)))
	   
(defun clause-compare (id1 id2)
  (let ((cl1 (get-clause id1))
	(cl2 (get-clause id2))
	(info1 (get id1 'info))
	(info2 (get id2 'info))
	(cps nil))
    (cond ( (< (size info1)
	       (size info2)) '<)
	  ( (> (size info1)
	       (size info2)) '>)
	  ( (not (eq 'uguali
		     (setq cps ( compare-size-list  (sizelist info1)
						    (sizelist info2)))))
	    cps)
	  ((clause-p-equal (rename-variant cl1 cl2) cl1) 'uguali))))



(defun compare-size-list  (sl1 sl2)
  (let ((cmp1 (cmp-sl (car sl1) (car sl2)))
	(cmp2 (cmp-sl (cdr sl1) (cdr sl2))))
    (if
	(and (eq 'uguali cmp1)(eq 'uguali cmp2)) 'uguali
      cmp1)))

(defun cmp-sl (sl1 sl2)
  (cond ((not(eq(length sl1)(length sl2))) nil)
	((null sl1) 'uguali)
	((= (car sl1) (car sl2)) (cmp-sl (cdr sl1) (cdr sl2)))
	((< (car sl1) (car sl2)) '<)
	(t '>)))



(defmethod rename-variant ((oldclause clause-class)(newclause clause-class))
  (let ((vl1 (append  (collect-integer-vars (positive-atoms  oldclause))
		      (collect-integer-vars (negative-atoms oldclause))))
	(vl2 (append  (collect-integer-vars (positive-atoms  newclause))
		      (collect-integer-vars (negative-atoms newclause))))
	(diff nil ))
    (cond ((or (null vl1) (null vl2)) newclause)
	  (t (setq  diff (- (car vl2) (car vl1)))
	     (mk-variant newclause vl2 diff)))))
		     
(defmethod mk-variant ((clause clause-class) vlist diff)
  (let ((pos-neg (mk-variant1
		  (cons (positive-atoms clause)
			(negative-atoms clause))
		  vlist diff)))
    (make-clause (car pos-neg) (cdr pos-neg))))
  
  
  
(defmethod mk-variant1 (clause  vlist diff)
  (cond ((null vlist) clause)
	(t (mk-variant1 (subst (- (car vlist) diff)
			      (car vlist)
			      clause)
		       (cdr vlist)
		       diff))))
	   

(defmethod clause-p-equal ((cl1 clause-class)(cl2 clause-class))
  (or (clause-equal cl1 cl2)
      (and  (p-equal (positive-atoms cl1) (positive-atoms cl2))
	    (p-equal (negative-atoms cl1) (negative-atoms cl2)))))
(defun p-equal (atom-list1 atom-list2)
  (cond((not(eq (length atom-list1)( length atom-list2))) nil)
       ((null atom-list1)
	
	t)
       (t (p-equal (cdr atom-list1)(remove (car atom-list1)atom-list2 :test #'equalatom)))))
 
