;;; -*- Mode: LISP; Package: atp; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   norm.cl
;;; Short Desc: Normalization of clauses and semantic simplification
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   8.9.91 - FB
;;; Author:     Fabio Baj
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================



(in-package :atp)

;;---------------------------------------------------
;; norm       : CLAUSE ---> CLAUSE U {nil}
;; Behavior   : normalizes  clause merging identical literals
;;            : if a literal is both negated and positive the
;;            : clause is a tautology. = nil
;;            ; Semantic simplification is done here
;;            ; Equations with equal sides are treated as true
;;            ; atoms since all x (x=x) is true

(defmethod  norm (null-clause) nil)
(defmethod  norm ((cl clause-class))
  (remove-identities (sem-red  (norm1 cl))))


(defmethod remove-identities (null-clause) nil)
(defmethod remove-identities ((cl clause-class))
  (if (or   (p-subsumes '((-> -1 -1)) cl)
	    (p-subsumes '((=  -1 -1)) cl)) nil
    (remake-clause  
     (positive-atoms cl)
     (remove-if-match  '(-> -1 -1) (remove-if-match '(= -1  -1) (negative-atoms cl)))
     cl)))
    

(defmethod  norm1 (null-clause)  nil)
(defmethod norm1 ((cl clause-class))
  (if (is-tautology-p cl) nil
    (remake-clause  
     (merge-literals (positive-atoms cl))
     (merge-literals (negative-atoms cl))
     cl)))

(defun merge-literals (atom-list)
  (remove-duplicates atom-list :test #'equalatom))


(defmethod is-tautology-p ((cl clause-class))
  (is-taut1 (negative-atoms cl)(positive-atoms cl)))
(defun is-taut1 (neg pos)
  (cond ((null neg) nil)
	((member (car neg) pos :test #'equalatom) t)
	(t (is-taut1 (cdr neg) pos))))

(defmethod is-answer ((cl clause-class))
  (or 
   (and
    (null (positive-atoms cl))
    (all-answers   (negative-atoms cl)))
   (and
     (null (negative-atoms cl))
    (all-answers (positive-atoms cl)))))

(defun all-answers (atom-list)
  (cond ((null atom-list) t)
	((is-answer-literal (car atom-list))
	 (all-answers (cdr atom-list)))))
	

(defmethod sem-red (null-clause) nil)
(defmethod sem-red ((cl clause-class))
   (cond ($semantic-simplification$
	   (let ((demclause 
		  (remake-clause
		   (remove '$F (mapcar 'sem-re-duce (positive-atoms cl)))
		   (remove '$T (mapcar 'sem-re-duce  (negative-atoms cl)))
		   cl)))
	     (cond ((member '$F (negative-atoms demclause)) nil)
		   ((member '$T (positive-atoms demclause)) nil)
		   (t demclause))))
	  (t cl)))



(defmethod prolog-sem-red ((cl clause-class))
  (let ((new-clause 
	 (make-clause
	  (positive-atoms cl)
	  (if (negative-atoms cl)
	      (remove '$T (cons (sem-re-duce (car (negative-atoms cl)))
				(cdr (negative-atoms cl))))))))
    (if (clause-equal cl new-clause) new-clause
   (prolog-sem-red new-clause))))
 

