;;; -*- Mode: LISP; Package: atp; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   ebg.cl
;; Description  :  this file contains the implementation of 
;;              :  an Explaination-Based Generalisation algorithm
;;              :  for the PROLOG module of LENprover    
;;; Version:    1.0
;;; Status:     Review
;;; Created     : 20-Sep-1990
;;; Last Mod    : 20-Sep-1990
;;; Last Mod:   8.9.91 - FB
;;; Author:     Fabio Baj
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------

;;--------------------------------------------------------------
;; Running this program after a proof of a prolog program
;; on a training example, a new clause, that is a new concept
;; definition, obtained generalising the training example
;; is printed.
;; Adding this new clause to the original program we obtain
;; a program that solves problems of the class of the training
;; example in a more efficient way. For this reason we can
;; say that the program has learned a new concept.
;;--------------------------------------------------------------
(defun expl-based-gen ()
  (let ((result 
	 (remove-true 
	  (goal-regression (generalized-goal)
			   (inference-path-used) 
			   nil))))
    (print-result (generalized-goal) result)))

;;-------------------------------------------------------------
;; Goal regression is performed redoing the inference steps
;; used proving the training example, on a renamed goal.
;; Suspending evaluation before reaching non-operational leaves
;; we obtain a set of sufficient conditions for the definition
;; of the general concept.
;; This function returns the same list output by the
;; Kodratoff program.
;;-------------------------------------------------------------
(defun goal-regression (goal id-list tmp-result)  
  (cond ((null id-list) (reverse (cons (car (negative-atoms  goal)) tmp-result)))
	((or (eq 'fail (prolog-res1 goal (get-clause1 (car id-list)))))
	 (goal-regression (pop-subgoal goal) (cdr id-list) 
			  (cons (car (negative-atoms goal)) tmp-result)))
	(t (goal-regression (prolog-res1 goal (get-clause1 (car id-list)))
			    (cdr id-list) 
			    tmp-result))))


;-----------------------------------------------------------
; When a operational leaf is found it's popped from the subgoal
; asn added to the tmp-result = the result list
(defmethod pop-subgoal ((goal clause-class))
  (cond ((null (negative-atoms  goal)) nil)
	(t (make-instance 'all-negative-clause
			   :positive-atoms nil
			 :negative-atoms (cdr (negative-atoms goal))))))
	    

(defmethod generalized-goal ()
  (let 
      ((cl (renvar-for-out(get-clause1 
			   (car (inference-path-used))))))
    (make-instance 'all-negative-clause
      :positive-atoms  nil  :negative-atoms (positive-atoms cl))))
		
    
	      
			

;;-----------------------------------------------------
;; Builds a list made of the clauses used to proof the
;; trainig example
;;-----------------------------------------------------
(defun inference-path-used ()
  (inf-path1  (get-ancestors $contr$ ) nil))
(defun inf-path1 (idpair tmp)
  (cond ((null idpair) tmp)
	(t (inf-path1  (get-ancestors (car idpair) )
		       (cons (cadr idpair) tmp)))))

(defun remove-true (nterm)
  (remove nil (remove '$t (mapcar #'sem-re-duce nterm))))



(defun print-result (head body)
  (let ((body1 (rvfo  body (collect-integer-vars  body ))))
    (princ " ")
    (format t 
	    (clause-to-string-prolog
	     (make-instance 'clause-class :positive-atoms (negative-atoms head)
			    :negative-atoms body1)
	     0))))



;;;***********************************************************************




(defmethod prolog-res1 ((goal clause-class) 
		       (null t))
  'fail)
(defmethod prolog-res1 ((goal clause-class) 
		       (horn-clause clause-class))
  (let ((sigma (mgu (car (positive-atoms horn-clause))
		    (sem-re-duce (car (negative-atoms goal))))))
    (cond ((eq 'fail sigma) 'fail) 
	  (t  (apply-sub  (remake-clause nil
			  (append
			   (negative-atoms  horn-clause)
			   (cdr (negative-atoms goal)))
			  horn-clause)
			 sigma)))))

(defmethod get-clause1 (id)
 (if (member id '(sos axiom cut)) nil
     (internal-renvar (get-clause id))))