;;; -*- Mode: LISP; Package: atp; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   atp-demo5.cl
;;; Short Desc: Fifth demo on automated theorem proving
;;;             The source file for the demo theorem is in atp-demo5.th
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   8.9.91 - FB
;;; Author:     Fabio Baj
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================
(in-package :atp)


;;=====================================================================
;; The definition of demo5
;;=====================================================================

(defun demo-5 ( )
  (setq *theorems-dir*  *len-directory*)
  (setq *first-run* t)
  (setq *demo-in-execution* 5)
  (format-display-fill demo-text-disp (format nil  
		   "~%Here is a fifth demo on automated theorem proving:

ATP systems can be used to find plans, that are 
sequences  of actions to achieve a goal.
The well known  Monkey and Banana 
problems deals with a monkey who wants to eat a banana 
that is suspended from the ceiling of a room. 
He can walk in the room, carring a chair that is in 
the room and clim the chair to reach the banana.
Let us give a look to the input file.

"))
  (when (wait)
  (setq *view* (make-instance 'help-display
			    :left (scalew 10)
			    :bottom (scaleh 50)
			    :height (scaleh  400)
			    :width (scalew 800)
			    :filename  (add-path (choose-file-demo-5) *len-directory*)))
    (protect-display *view* t)
    (push *view*  *open-displays-list* )
  (format-display-fill demo-text-disp (format nil   "~%Now we call the theorem proving tool"))

  (when (wait)
  (en)
  (push *view*  *open-displays-list* )
  (protect-display *main-disp* t)
  (protect-display *out-disp* t)
  (protect-display *dialog-disp* t)
  (format-display-fill demo-text-disp (format nil   "~%The <LOAD THEOREM> button loads the theorem file
"))
  (when (wait)
  (my-software-push *load-file-button* *main-disp*)
  (enable-the-right-buttons)
  (format-display-fill demo-text-disp (format nil   "~%Pushing the <Prove Theorem> button ..."))
  (when (wait)
  (my-software-push *proof-th-button* *main-disp*)
  (format-display-fill demo-text-disp (format nil   "~%Here is the complete proof"))
  (my-software-push *show-proof-button* *main-disp*) 
  (when (wait)
 (format-display-fill demo-text-disp (format nil   "~%Here is the proof tree"))
  (my-software-push *show-proof-tree-button* *main-disp*)
    (setq *open-displays-list* (push (display *browser-disp*)  *open-displays-list* ))
  (format-display-fill demo-text-disp (format nil   "~%Push <Continue> to close the browser") )
  (when (wait)
  (close-display *browser-disp*) 
   (format-display-fill demo-text-disp (format nil  "~%Now we close the theorem proving tool~%"))
  (when (wait)
  (format-display-fill demo-text-disp (format nil  "~%******* End of the fifth DEMO ********"))

  (close-display *main-disp*)
  (close-display *out-disp* )
  (close-display *dialog-disp*)
  (sleep 1)))))))))



;;=====================================================================

(defun more-solutions-demo-5()
  (write-display 
   *dialog-disp* "reverse_into_plan(xs) = [Walk(a,c), Carry-the-chair(c,b), Climb] " 10 10)
  (format-display-fill demo-text-disp (format nil  
		   "~%The answer contains a plan which can be used
by the monkey to reach the banana: walk from a to c, 
carry the chair from c to b and climb"))
  (when (wait)
 nil))
 
(defun choose-file-demo-5 ()
  "atp-demo5.th")
  
