;;; -*- Mode: LISP; Package: atp; Syntax: Common-lisp;                   -*-
;;;
;;; ************************************************************************
;;;
;;; PORTABLE AI LAB - IDSIA LUGANO
;;;
;;; ************************************************************************
;;;
;;; Filename:   atp-demo4.cl
;;; Short Desc: Fourth demo on automated theorem proving
;;;             The source file for the demo theorem is in atp-demo4.th
;;; Version:    1.0
;;; Status:     Review
;;; Last Mod:   8.9.91 - FB
;;; Author:     Fabio Baj
;;;
;;; Copyright (c) 1992 Istituto Dalle Molle (IDSIA), University of
;;; Zurich, Swiss Federal Institute of Technology Lausanne.
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all
;;; copies and supporting documentation.
;;;
;;; IDSIA provides this software "as is" without express or implied
;;; warranty.  
;;;

;;;
;;; --------------------------------------------------------------------------
;;; Change History:
;;;
;;;
;;; --------------------------------------------------------------------------


;;; ==========================================================================
;;; PACKAGE DECLARATIONS
;;; ==========================================================================
(in-package :atp)


;;=====================================================================
;; The definition of demo4
;;=====================================================================

(defun demo-4 ( )
  (setq *theorems-dir*  *len-directory*)
  (setq *first-run* t)
  (setq *demo-in-execution* 4)
  (format-display-fill demo-text-disp ( format nil  
		   "~%Here is a fourth demo on automated theorem proving:

It shows the advantages of a complete theorem proving
system with respect to Prolog.
The next example is a prolog program which correctly
defines the ancestor relation, but can not be executed
by a common prolog interpreter, because it is left 
recursive. Since the Prolog search strategy is depth-first,
left-to-right, it goes into an infinite loop on left
recursive definitions.
Here is the bad Prolog program"))
  (when (wait)
  (setq *view* (make-instance 'help-display
			    :left (scalew 10 )
			    :bottom  (scaleh 50)
			    :height  (scaleh 400)
			    :width  (scalew 800)
			    :filename  (add-path (choose-file-demo-4) *len-directory*)))
    (protect-display *view* t)
   (push *view*  *open-displays-list* ) 
  (format-display-fill demo-text-disp ( format nil   "~%Now we call the theorem proving tool"))
  (when (wait)
  
  (en)
(push *view*  *open-displays-list* ) 
  (protect-display *main-disp* t)
  (protect-display *out-disp* t)
  (protect-display *dialog-disp* t)
  (format-display-fill demo-text-disp ( format nil   "~%The <LOAD THEOREM> button loads the theorem file
"))
  (when (wait)
  (my-software-push *load-file-button* *main-disp*)
  (enable-the-right-buttons)
  (format-display-fill demo-text-disp ( format nil   "~%Now we try to proof the theorem with the prolog
strategy. You will notice that there is an infinite loop.
In these cases the user can push the <Abort> button to kill the execution."))
  (when (wait)
  (my-software-push *proof-th-button* *main-disp*)
   (format-display-fill demo-text-disp ( format nil  "~%It is time to face this theorem with a more
complete theorem proving strategy. First, we reload the previous
theorem."))  
   (when (wait)
   (my-software-push *clear-button* *main-disp*)  
   (my-software-push *reload-last-button* *main-disp*)  
   (format-display-fill demo-text-disp ( format nil  "~%Then, we change the strategy options for this theorem"))
   (when (wait)
   (my-software-push *display-setting-button* *main-disp*) 
   ;; TRAP TO DISPLAY-SETTINGS-DEMO4
  (format-display-fill demo-text-disp ( format nil  "~%With a breadth first strategy the system is able
to find the right solution. Alternate solutions may be generated."))
  (my-software-push *proof-th-button* *main-disp*)
 (format-display-fill demo-text-disp ( format nil  "~%Now we close the theorem proving tool~%"))
  (when (wait)
  (format-display-fill demo-text-disp ( format nil  "~%******* End of the fourth DEMO ********"))

  (close-display *main-disp*)
  (close-display *out-disp* )
  (close-display *dialog-disp*)
  (sleep 2)))))))))
  
;;=====================================================================

(defun more-solutions-demo-4()
  (write-display *dialog-disp* " Who = george " 10 10)
 nil)
	 
 
(defun choose-file-demo-4 ()
  "atp-demo4.th")
  
(defun display-settings-demo-4 ()
   (protect-display set-disp  t)
  (format-display-fill demo-text-disp ( format nil  
		   "~%To proof this left recursive theorem we need a
strategy different from the one used by Prolog:
we choose th standard strategy
We must also set some inference rule to be used instead
of the prolog inference rule"))
  (when (wait) 
  (my-software-push *prolog-strategy-but* set-disp)  (sleep 0.8)
  (my-software-push *standard-strategy-but* set-disp)  (sleep 0.8)
  (my-software-push *neg-resolution-but* set-disp)  (sleep 0.8)
  (my-software-push *p-resolution-but* set-disp)
  (format-display-fill demo-text-disp ( format nil  
		   "~%Now we push <ok>"))
  (when (wait)
  (my-software-push *exit-disp-set-but* set-disp))))
