% Test selector program in Prolog.
% From AI Expert's Expert's Toolbox, March 1991
% Written by Rodger Knaus

% Listing 1 : Top level of test assembly

         % improve a given number of random initial solutions
solve( $main$, RESULT ) :-
       setglobal( zzz_restarts , 0 ),
       call( configuration( $number of restarts$ , MAX )) ,
       repeat,
          getglobal( zzz_restarts, N ),
          ( N >= MAX , !
          ; solve( $hlpr$, RESULT ),
            M is N + 1,
            setglobal( zzz_restarts, M ),
            fail  ).

         % find best solution from a a random start
solve(  $hlpr$, RESULT ) :-
     setglobal( zzz_climb_count  , 0  ),
     generate( START ), % generate random start
%     setglobal( zzz_solution_count  , 0    ),
     setglobal( zzz_current_solution, START ),
     setglobal( best_so_far , START  ),
     solve( $improve$,  RESULT  ).

solve( $improve$,  RESULT  ) :-
     repeat,
         getglobal( zzz_current_solution, CURRENT ),
         solve( $improve hlpr$, CURRENT, RESULT0 , STATUS ) ,
         set_slot_value( RESULT0, result, STATUS, RESULT ),  !.

solve( $improve hlpr$, CURRENT, RESULT , STATUS ) :-
           % save CURRENT solution if it's among the best so far
         solve( $update best so far$, CURRENT ),
           % get results of CURRENT solution on constraints
         frame_slot_val(  CURRENT,
                          constraint_pattern,
                          CONSTRAINT_PATTERN ),
         (      solve( $constraints satisfied $,
                        CONSTRAINT_PATTERN ) ,                !,
                RESULT = CURRENT,
                STATUS = $OK$
         ;      solve( $number of trials exceeded$ ),          !,
                RESULT = CURRENT,
                STATUS = $END OF RUN$
         ;      solve( $no improvement$, CONSTRAINT_PATTERN  ),!,
                RESULT = CURRENT,
                STATUS = $END OF CLIMB$
         ;      solve( $single improve step$, CURRENT,  NEW   ) ,
                solve( $improvement$, CURRENT,  NEW   ) ,
                solve( $update database$,  NEW   ) ,
                !,  fail
         ;      RESULT = CURRENT,
                STATUS = $CANT IMPROVE$ ).


solve( $single improve step$,
       DIET ,
       NEW_DIET   )  :-
           solve( $build satisfaction pattern$,
                  DIET     ,
                  CONSTRAINT_PATTERN ),    !,
           % find food to eliminate
     select( $in$, CONSTRAINT_PATTERN, DIET, $dummy$, FOOD_IN ) ,   !,
           % find food to put in
     select( $out$, CONSTRAINT_PATTERN, DIET, FOOD_IN, FOOD_OUT ),     !,
     change_diet( $main$, DIET, FOOD_IN, FOOD_OUT, NEW_DIET) .

-----------------------------------------------------------------------------------------------------------------------------

% Listing 2 :  Getting a Slot Value

frame_slot_val( FRAME, SLOT, VAL ) :-
        (    FRAME = [], !, fail
        ;    FRAME = PSLOT : PVAL,  !,
             (    SLOT = PSLOT,   !,
                  VAL = PVAL
             ;    SLOT = ASLOT + RSLOT,  !,
                  ifthenelse(   frame_slot_val( FRAME, ASLOT, VAL1) ,
                                true,
                                VAL1 = 0 ) ,
                  ifthenelse(   frame_slot_val( FRAME, RSLOT, VAL2) ,
                                true,
                                VAL2 = 0 ) ,
                  (   number( VAL1 ),
                      number( VAL2 ),   !,
                      VAL is VAL1 + VAL2
                  ;   VAL =  VAL1 + VAL2   )
             ;    SLOT = ASLOT : RSLOT,
                  ASLOT = PSLOT,   !,
                  frame_slot_val(  PVAL, RSLOT, VAL )
             )
       ;     atomic( FRAME ),
             (      recorded( FRAME, SLOT : VAL , _ ),   !
             ;      SLOT = X : Y ,
                    recorded( FRAME, X  : VAL1 , _ ),
                    frame_slot_val( VAL1, Y, VAL )     )
       ;     FRAME = [ PAIR   | REST ] ,    !,
             (     frame_slot_val( PAIR, SLOT, VAL ),   !
             ;     frame_slot_val( REST, SLOT, VAL )    )
       ;     functor( FRAME, _ , 1 ),
             arg( 1, FRAME,  LIST ),
             frame_slot_val( LIST, SLOT, VAL )       ).

