{$R+}    {Range checking off}
{$B+}    {Boolean complete evaluation on}
{$S+}    {Stack checking on}
{$I+}    {I/O checking on}
{$N-}    {No numeric coprocessor}

{ EasyIO.PAS -- a simple intelligent DOS shell. }
{ From AI Expert's AI Apprentice, April 1991. }
{ Written by Mark Minasi }

PROGRAM EasyIO;

Uses
  Crt,
  Dos;

CONST

  ArraySize = 400;         (* Currently can accomodate 400 commands *)

TYPE
  String15 = STRING[15];
  SArray = ARRAY[1..ArraySize] of String15;
  NArray = ARRAY[1..ArraySize] of Integer;
  String255 = STRING[255];
  Str66 = STRING[66];
  I255=ARRAY[1..255] of Integer;
VAR
  foundsomething:   boolean;
  CmdList,CmdSnd:                         SArray;
  Cand:                                   SArray;
  WhereCand:NArray; (* keeps track of where each Candidate came from *)
  CmdLen:                                 NArray;
  NCmd:                                   Integer;
  NCand:                                  Integer;
  infile,OutFile:                         Text;
  i:                                      Integer;
  out:                                    Text;
  WhereStart,NFound:                      Integer;
  IC:String15; GC: string[12]; (* Input command, eventual "good" command *)
  ISnd:String15;   (*Soundex code of input command *)
  IL: Integer;    (* length of input command *)
  FoundExact, Finished, Unique,Debug,Debug2: Boolean;
  zero,tolerance                         :I255;
  Parms:                                  String255;
  ctable:         array[' '..'Z'] of char;
  loose:        boolean;  (*How loose should the Soundex match be? *)


Procedure LoadTable;
{Required because Pascal has such a lousy compile-time data load facility}
var c:char;
begin
  for c:=' ' to 'Z' do ctable[c]:='0';
  ctable['B'] := '1';
  ctable['F'] := '1';
  ctable['P'] := '1';
  ctable['V'] := '1';
  ctable['C'] := '2';
  ctable['G'] := '2';
  ctable['J'] := '2';
  ctable['K'] := '2';
  ctable['Q'] := '2';
  ctable['S'] := '2';
  ctable['X'] := '2';
  ctable['Z'] := '2';
  ctable['D'] := '3';
  ctable['T'] := '3';
  ctable['L'] := '4';
  ctable['M'] := '5';
  ctable['N'] := '5';
  ctable['R'] := '6';
end;

Function Soundout(X:string255):string255;
var
  b,c:char;
  s,t:string255;
  i,l:integer;

function nodouble(x:string255):string255;
var t:string255;
    i,tl:integer;
begin
  i:=2;
  t:=upcase(x[1]);
  tl:=1;
  while i<=length(x) do
  begin
    if t[tl]=upcase(x[i]) then i:=i+1 else
    begin
      tl:=tl+1;
      t:=t+upcase(x[i]);
      i:=i+1;
    end;
  end;
  nodouble:=t;
end;

begin
  if x='' then s:='' else
  begin
    x:=nodouble(x); {remove double letters}
    l:=length(x);
    s:=x[1];
    for i:=2 to l do
    begin
      t:='';
      c:=x[i];
      if ctable[c]<>'0' then s:=s+ctable[c];
    end;
  end;
  {length check}
  if length(s)<4 then for i:=1 to 4-length(s) do s:=s+'0'
  else if length(s)>4 then s:=copy(s,1,4);
  soundout:=s;
end;

Procedure Sort(VAR CmdList:SArray;NCmd:Integer);

(* Shellsorts the commands *)

VAR i,dist:Integer;

Procedure Swap(VAR a,b:String15);
VAR t:String15;
BEGIN
  t:=a;
  a:=b;
  b:=t;
END;

Procedure RollUp(ptr:Integer);
VAR i:Integer;
    done:boolean;
(* Floats up ptr th value in CmdList until it hits equal or less value *)
BEGIN
  i:=ptr;
  done:=false;
  WHILE (i>=2) and not done DO
  BEGIN
    IF CmdList[i]<CmdList[i-1] then BEGIN
                                     swap(CmdList[i],CmdList[i-1]);
                                     END
                               ELSE done:=true;
    i:=i-1;
  END;
END;


BEGIN
  (* Determine sort distance *)

  dist:=1;
  WHILE dist < NCmd DO dist:=dist+dist;

  (* Sort *)

  WHILE dist>1 DO
  BEGIN          (* Check latest distance *)
    dist := dist div 2;
    for i:=1 to NCmd-dist DO
    BEGIN        (* Pairwise comparisons *)
      IF CmdList[i]>CmdList[i+dist] then
      BEGIN      (* Swap and float up *)
        swap(CmdList[i],CmdList[i+dist]);
        RollUp(i);
      END;       (* Swap and float up *)
    END;         (* Pairwise comparisons *)
  END;           (* Check latest distance *)
END;             (* Procedure *)


PROCEDURE Telescope(VAR CmdList:SArray; VAR CmdLen:NArray; NCmd:Integer);

(* Finds telescopic lengths of commands.  Fills CmdLen Array. *)

VAR
  i,d1,d2:                                Integer;
  bef,aft:                                String15;

FUNCTION MinDiff(s1,s2:String15):Integer;

VAR
  l1,l2,l3,sl:                            Integer;

BEGIN
  l1:=Length(s1);
  l2:=Length(s2);
  IF l1>l2 THEN sl:=l1 ELSE sl:=l2;
  l3:=1;
  WHILE (l3<=sl) and (s1[l3]=s2[l3]) DO l3:=l3 + 1;
  MinDiff:=l3;
  (* Notice that we could end up with an l3 larger than the length of one
     input string.  This is addressed in the procedure.  It could happen when
     one command was contained completely in another, like "for" and "format".
   *)
END;

BEGIN (* Procedure Telescope *)

  FOR i:=1 TO NCmd DO
  BEGIN
    IF i<>1 THEN bef:=CmdList[i-1] ELSE bef:='';
    IF i<>NCmd THEN aft:=CmdList[i+1] ELSE aft:='';
    d1:=MinDiff(CmdList[i],bef);
    d2:=MinDiff(CmdList[i],aft);
    IF d1>d2 THEN CmdLen[i]:=d1 ELSE CmdLen[i]:=d2;
    IF CmdLen[i] > Length(CmdList[i]) THEN CmdLen[i]:=Length(CmdList[i]);
  END;
END;

PROCEDURE Init;
(* Used whenever new disk or subdirectory found *)
VAR i,j:Integer;
BEGIN
  NCmd:=5;
  CmdList[1]:='BYE';
  CmdList[2]:='HELP';
  CmdList[3]:='BUG';
  CmdList[4]:='DUMP';
  CmdList[5]:='NEWDISK';
  CmdList[NCmd+1]:='DIR';
  CmdList[NCmd+2]:='COPY';
  CmdList[NCmd+3]:='ERASE';
  CmdList[NCmd+4]:='VOL';
  CmdList[NCmd+5]:='VERIFY';
  CmdList[NCmd+6]:='VER';
  CmdList[NCmd+7]:='BREAK';
  CmdList[NCmd+8]:='CD';
  CmdList[NCmd+9]:='RD';
  CmdList[NCmd+10]:='MD';
  CmdList[NCmd+11]:='PATH';
  CmdList[NCmd+12]:='ECHO';
  CmdList[NCmd+13]:='TYPE';
  CmdList[NCmd+14]:='LOOSE';
  ncmd:=ncmd+14;
  (* Remove trailing blanks *)
  FOR i:=1 TO NCmd DO
  BEGIN
    j:=Pos(' ',CmdList[i]);
    IF j<>0 THEN CmdList[i]:=Copy(CmdList[i],1,j-1);
  END;
  Writeln(NCmd,' commands found.');
  Sort(CmdList,NCmd);
  Telescope(CmdList,CmdLen,NCmd);
  FOR i:=1 TO 255 DO zero[i]:=0;
  FOR i:=1 TO 2 DO tolerance[i]:=0;
  FOR i:=3 TO 4 DO tolerance[i]:=1;
  FOR i:=5 TO 13 DO tolerance[i]:=2;
  FOR i:=7 TO 255 DO tolerance[i]:=3;
  for i:=1 to Ncmd do CmdSnd[i]:=SoundOut(CmdList[i]);
END;

PROCEDURE ShowChoices;
(* When a number of Candidate commands exist, they are presented to the
   user and he/she can decide which they meant *)

VAR i,j,k:Integer;
    s1:String255;
BEGIN
  (* First remove the duplicates *)
  k:=0;
  FOR i:=1 TO NCand DO
  BEGIN
    s1:=Cand[i];
    FOR j:=i+1 TO NCand DO IF Cand[j]=s1 THEN Cand[j]:='';
  END;
  Writeln;
  Write('It is unclear which command you meant.  I have narrowed down');
  Writeln(' the possibilities');
  Writeln('to the following:');
  FOR I:=1 TO NCand DO IF Cand[i]<>'' THEN
  BEGIN
    k:=k+1;
    Write(k,') ',Cand[i]);
    IF debug THEN Write(' ',WhereCand[i]);
    Writeln;
  END;
  Writeln;
  Write('Please enter the number of the one you meant, or 0 for none.');
  i:=0;
  REPEAT
    Write('? ');
    Readln(i)
  UNTIL (i>=0) and (i<=NCand);
  IF i<>0 THEN GC:=Cand[i] ELSE
  begin FoundExact:=False;Foundsomething:=false; end;
END;

PROCEDURE TCheck;

(* Simple check to see if any command is immediately recognizable
   bearing the telescope in mind.  Uses binary search *)
VAR
   Top, Bottom, I, FirstLoc, LastLoc:Integer;
   temp:String15;
   FoundFirst,FoundLast,CantFind:Boolean;
BEGIN
  FoundExact := False;
  Unique := True;
  Top:=0;
  Bottom:=NCmd+1;
  CantFind:=False;
  WHILE (not FoundExact) AND (Not CantFind) DO
  BEGIN
    (* Reset Top or Bottom depending on IC relative to list *)
    IF (Top>=Bottom) or ((Bottom-Top)=1) Then
    begin
      CantFind:=True;
    end else
    begin

      I:=(Top + Bottom) DIV 2;
      temp := Copy(CmdList[i],1,il);
      If Debug THEN Writeln('Testing against ',temp,' top,bottom= ',
                          top,' ',bottom);
      IF temp = ic THEN FoundExact:=True
      ELSE IF temp > ic THEN bottom:=i ELSE top:=i;
    end;
  END;
  (* If FoundExact = True, we matched, but we COULD have matched at a length
     smaller than the minimum telescope length.  We would then want to look at
     all Candidates *)
  IF FoundExact and (il < CmdLen[i]) THEN
  BEGIN (* Duplicate possibilities. Search back & forth to find all *)
    IF debug THEN Writeln('   May match ',cmdlist[i]);
    Unique := False;
    FirstLoc:=i;
    FoundFirst:=False;
    WHILE (not FoundFirst) and (FirstLoc-1 > 0) DO
    IF Copy(CmdList[FirstLoc-1],1,il) = ic THEN FirstLoc:=FirstLoc - 1
                                           ELSE FoundFirst:=True;
    FoundLast:=False;
    LastLoc:=i;
    WHILE (not FoundLast) and (LastLoc + 1<= NCmd) DO
    IF Copy(CmdList[LastLoc+1],1,il) = ic THEN LastLoc:=LastLoc + 1
                                          ELSE FoundLast:=True;
    (* Transfer to Candidates list *)
    NCand:= LastLoc - FirstLoc + 1;
    FOR i:=1 TO NCand DO
    BEGIN
      Cand[i]:=CmdList[i+FirstLoc - 1];
      WhereCand[i]:=0;  (* 0 is ID of TCheck *)
    END;
    (* Ask user to pick desired command from Candidates.  Goes in GC. *)
    ShowChoices;
  END ELSE GC:=CmdList[i];
END;  (* FoundExact and Unique carry enough information out of the routine *)

FUNCTION Ndiff(a,b:String15):Integer;
(* Returns the number of differing characters between a and b.  Only checks
   to the length of the shorter one. *)

(* Examples:  Ndiff('ab','ac') = 1
              Ndiff('abc','ab') = 0
              Ndiff('abcde','abde') = 2 *)

VAR la,lb,l,i,sum:Integer;
BEGIN
  sum:=0;
  la:=Length(a);
  lb:=Length(b);
  IF la<lb THEN l:=la ELSE l:=lb;
  IF l>0 THEN FOR i:=1 TO l DO IF a[i]<>b[i] THEN sum:=sum+1;
  Ndiff:=sum;
END;


PROCEDURE CheckTranspose;
(* Examines whether a single transpose could cause the no match. *)
(* Method is to sum the ASCII values of the commands.  If the sum is the
   same as the input command, it is worth investigating further. *)

(* It should be obvious that you should never call this if the string to be
   examined is one character long *)

VAR sum1,sum2,i,j,ictot:Integer;

BEGIN
  ictot:=0;
  FOR i:=1 TO il DO ictot:=ictot + ord(ic[i]);
  IF DEBUG THEN Writeln('ICTOT=',ICTOT);
  FOR i:=1 TO NCmd DO
  BEGIN
    (* Ignore if input command shorter than telescope length, or
       if input command is longer than total length *)
    IF (CmdLen[i] <= il) and (Length(CmdList[i])>=il) THEN
    BEGIN
      (* compute ASCII sum *)
      sum1:=0;
      FOR j:=1 TO il DO sum1:=sum1+ord(CmdList[i][j]);
      IF sum1 = ictot THEN
      BEGIN
        (* Further scrutiny: only one switched letter? *)
        sum2:=ndiff(ic,CmdList[i]);
        IF DEBUG THEN Writeln(CmdList[I],' TOT= ',SUM1,' NDIFF=',SUM2);
        IF sum2=2 THEN
        BEGIN
          NCand:=NCand+1;
          Cand[NCand]:=CmdList[i];
          WhereCand[NCand]:=1; (* 1 is ID for transpose *)
          FoundExact:=True;
        END;  (* Add Candidate *)
      END;    (* Further scrutiny *)
    END;      (* Test for equal ASCII total *)
  END;        (* Check all recognized commands *)
END;          (* Procedure *)


FUNCTION Remove(s:String15;p:Integer):String15;
VAR i,l:Integer;
    s1,s2:String15;
BEGIN
  l:=Length(s);
  IF p=1 THEN remove:=Copy(s,2,l-1)
  ELSE IF p=Length(s) THEN remove:=Copy(s,1,l-1)
  ELSE remove:=concat(Copy(s,1,p-1),Copy(s,p+1,l-p+1));
END;

PROCEDURE CheckForExtra;
(* This sequentially removes one character, then checks it against
   the command list.  As it would be silly to do so, this does not
   check unless the length of the command is:

   telescope length <= input command length <= total length
*)
VAR
  shortlen, i, j:        Integer;
  test:                  String15;

BEGIN
  IF IL>1 THEN
  BEGIN
    shortlen:= il - 1;   (* determine length of shortened command. *)
    FOR i:=1 TO il DO    (* check with each character removed. *)
    BEGIN
      test:=remove(ic,i); (* test against input command with a letter rmvd. *)
      IF debug THEN Writeln('Extra test: testing ',test);
      FOR j:=1 TO NCmd DO (* look at all commands *)
      BEGIN
        IF (CmdLen[j] <= shortlen) and (Length(CmdList[j]) >= shortlen) THEN
        (* falls in the correct length interval *)
        IF test = Copy(CmdList[j],1,shortlen) THEN
        BEGIN  (* found one *)
          NCand:=NCand+1;
          Cand[NCand]:=CmdList[j];
          WhereCand[NCand]:=2; (* 2 is the ID for CheckForExtra *)
          FoundExact:=True; (* I'm not sure about this *)
        END;   (* handling a "match" *)
      END; (* scanning all commands *)
    END; (* checking with each character removed *)
  END;   (* main clause of program *)
END; (* procedure *)


PROCEDURE Invert(s1:String255;VAR s2:String255);
(* Reverses an s254 string *)
VAR i,l:Integer;
BEGIN
  l:=Length(s1);
  s2:='';
  FOR i:=l downto 1 DO s2:=concat(s2,s1[i]);
END;

PROCEDURE InvertARRAY(i1:I255;VAR i2:I255;l,l2:Integer);

(* This reverses the Integer ARRAYs used to keep track of the string
   maps.  This is used to test the robustness of the match, as the
   match procedure is by no means infallible.  The suggested way to use
   MATCH is to run the two strings through it, save the maps, then reverse
   the strings and do it again.  Then reverse the maps so that they SHOULD
   end up equal to the first set of maps.  This routine reverses maps.  The
   inputs are the string to reverse, where you want it, the length of the
   string that this ARRAY is a map for, and the length of the OTHER string.

   For example, suppose you have s1 and s2.  Create maps m1 and m2 with the
   MATCH routine.  Then reverse s1 and s2 with the INVERT routine.  Run the
   reversed s1 and s2 through the MATCH routine, creating maps m1a and m2a.
   Now, if the match is incontrovertible, m1=m1a and m2=m2a.  But remember
   that the maps m1a and m2a refer to a different string -- s1 and s2 look
   a lot different when reversed.  So, you must invert maps m1a and m2a.  Do
   this like so:

        INVERTARRAY(M1A,M1A,Length(S1),Length(S2));
        INVERTARRAY(M2A,M2A,Length(S2),Length(S1));

*)
VAR i,j:Integer;
BEGIN
  FOR i:=1 TO l DO
  BEGIN
    j:=i1[i];
    (* if 0, -1, or -2, this is a special code.  Reverse its position
       but not its value. *)
    IF j>0 THEN j:=l2-j+1;
    i2[l-i+1]:=j;
  END;
END;


PROCEDURE Match(S1,S2:String255;VAR Map1,Map2:I255);

(* This program tries, insofar as possible, to develop a map matching
   two strings.  Thus, if we compare "BREAKERS" and "BRAEKERES", the routine
   should be bright enough to see that "BR", "KER", and "S" match.

   S1 and S2 are the inputs, two strings.  Map1 and Map2 are two byte ARRAYs
   indexed 1..255, and are the outputs.  Each map draws the connections
   between its string and the other string.  The map contains a positive
   number if it points to the other string, 0 if empty, -1 if the character
   is in S1 but not in S2, and -2 if it is part of a mutual difference between
   S1 and S2.

   For example:

   Take our BREAKERS / BRAEKERES example.  Look at Map1:

   Map1[1], referring to "B", contains 1, as S2[1] matches S1[1].
   Map1[2], likewise, contains 2.
   Map1[3] requires some intelligence.  The routine could either try to
   match the E in BR[E]AKERS with the E in BRA[E]KARS, or match the A
   in BRE[A]KERS to the A in BR[A]EKERS.  Assume that the E's are matched.
   Then Map1[3] would equal 4, as that points to its match in S2.  Map2[3]
   (the map for S2) would contain -1, as it is considered inserted.
   Map1[4]: here, we seek a match for the A.  None would exist, so it is
   considered inserted and gets -1.
   Map1[5]: K matches the fifth position in S2, so Map1[5]=5.
   and so on...
*)
VAR
   Len1, Len2,L1,L2,Ptr1,Ptr2,T1,T2         :Integer;
   Switch:                                  Integer;

PROCEDURE Connect2to1;
var i9:integer;

BEGIN
             Ptr2:=t2;
             Ptr1:=t1 + l2;
             FOR i9:=t1 TO ptr1-1 DO map1[i9]:=-1; (* Inserted characters *)
             map2[ptr2]:=ptr1;
             map1[ptr1]:=ptr2;
             t1 := ptr1;
END;
PROCEDURE Connect1to2;     (* Used when you have found that the current
                              character in S1 matches one later on in S2.
                              Marks intervening S2 characters as inserted.
                            *)

var i9: integer;
BEGIN
             Ptr1:=t1;
             Ptr2:=t2 + l1;
             FOR I9:=t2 TO ptr2-1 DO map2[i9]:=-1; (* Inserted characters *)
             map1[ptr1]:=ptr2;
             map2[ptr2]:=ptr1;
             t2 := ptr2;
END;

BEGIN
  Len1:=Length(S1);
  Len2:=Length(S2);
  Ptr1:=0;           (* Ptr1 points to the last matched character in S1 *)
  Ptr2:=0;           (* Ptr2 does likewise for S2 *)
  T1:=0;             (* T1 (Test1) points to the currently scrutinized part
                        of S1. *)
  T2:=0;             (* T2 does likewise for S2 *)

  IF debug2 THEN FOR i:=1 TO 255 DO BEGIN map1[i]:=0;map2[i]:=0;END;
  IF debug2 THEN Writeln('Starting Match...');
  WHILE (T1 < Len1) and (T2 < Len2) DO
  BEGIN
    IF debug2 THEN BEGIN
      Writeln('t1=',t1,' t2=',t2,' ptr1=',ptr1,' ptr2=',ptr2);
      FOR i:=1 TO len1 DO Write(map1[i],' ');
      Writeln;
      FOR i:=1 TO len2 DO Write(map2[i],' ');
      Writeln;
      Writeln;
    END;

    T1 := T1 + 1;
    T2 := T2 + 1;
    IF S1[T1] = S2[T2] THEN
    BEGIN
      Ptr1 := t1;
      Ptr2 := t2;
      map1[ptr1]:=t2;
      map2[ptr2]:=t1;
      IF debug2 THEN Writeln('Found match. ',s1[t1],'=',s2[t2]);
    END
    ELSE
    BEGIN    (* No direct match.  Look for the current character from S1 in
                the remainder of S2, and look for the current character from
                S2 in the remainder of S1. *)

      L1 := Pos(s1[t1], Copy(S2,t2+1,len2-t2));
      L2 := Pos(s2[t2], Copy(s1,t1+1,len1-t1));
      IF debug2 THEN Writeln('Search initiated.  L1,L2=',l1,' ',l2);

      (* Four possibilities: *)
         (* Neither matched: mutual difference *)
      IF (l1=0) and (l2=0) THEN switch:=1;
         (* S1 was found later in S2 *)
      IF (l1<>0) and (l2=0) THEN switch:=2;
         (* S2 was found later in S1 *)
      IF (l1=0) and (l2<>0) THEN switch:=3;
         (* Both were found later *)
      IF (l1<>0) and (l2<>0) THEN switch:=4;
      IF debug2 THEN Writeln('  Switch=',switch);

      Case Switch of
        1: BEGIN (* Mutual differences *)
             map1[t1] := -2;
             map2[t2] := -2;
           END;
        2: BEGIN (* Found S1 later in S2 *)
             Connect1to2;
           END;
        3: BEGIN (* Found S2 later in S1 *)
             Connect2to1;
           END;
        4: BEGIN (* Found links both ways.  Take the shortest one *)
             IF l2 < l1 THEN connect2to1 ELSE connect1to2;
           END;
      END;
    END; (* Troublesome match clause *)
  END; (* Main While loop *)

  IF debug2 THEN Writeln('Done.  Cleaning up now.');
  IF debug2 THEN Writeln;
  (* Clean up.  IF there's any letters left on the end, call them inserted *)
  if (t1>=len1) and (t2<len2) THEN FOR i:=t2+1 TO len2 DO map2[i]:=0;
  if (t1<len2) and (t2>=len2) THEN FOR i:=t1+1 TO len2 DO map1[i]:=0;
END;

FUNCTION Isum(m:I255):Integer;
VAR i,sum:Integer;
BEGIN
  sum:=0;
  FOR i:=1 TO 255 DO
  BEGIN
    IF m[i]<0 THEN sum:=sum+1;
  END;
  isum:=sum;
END;


PROCEDURE TryMatch;
(* Look for a match between each recognized command and the input command.
   For robustness, do the match both backwards and forwards; only keep the
   closer evaluation.  Remove the inserts from the end, then count the
   number of misses between the input command and the command from the
   command list being considered.  If it is within the criterion, accept
   it as a Candidate.
*)

VAR
  m1,m2,m1a,m2a                         : I255;
  s1,s2                                 : String255;
  i,j,k,l1,l2                           : Integer;
  sum1,sum2,score                       : Integer;

BEGIN
  FOR I:=1 TO NCmd DO
  BEGIN
    S1:=CmdList[i];  (* Get a command off the command list *)
    s2:=ic;         (* Compare to input command *)
    l1:=Length(s1);
    l2:=il;
    (* As before, don't bother looking if length makes it impossible.
       However, here, allow some extra length leeway. *)
     IF (CmdLen[i]-1 <= l2) and (l1+1 >= l2) THEN
     BEGIN
       m1:=zero;
       m2:=zero;
       m1a:=zero;
       m2a:=zero;
       match(s1,s2,m1,m2);
       (* Now check match backwards *)
       invert(s1,s1);
       invert(s2,s2);
       match(s1,s2,m1a,m2a);
       sum1:=isum(m1) + isum(m2);
       sum2:=isum(m1a) + isum(m2a);
       IF sum1 < sum2 THEN score:=sum1 ELSE score:=sum2;
       invert(s1,s1);
       IF debug THEN Writeln('  Try match with ',s1,' score=',score);
       IF score <= tolerance[l2] THEN
       BEGIN
         NCand:=NCand+1;
         FoundExact:=True;
         Cand[NCand]:=s1;
         WhereCand[NCand]:=3; (* 3 is ID for this routine *)
         IF debug THEN Writeln('  Matched to ',s1,' error sum=',score);
       END; (* save new Candidate *)
     END; (* match process *)
   END;   (* for loop to search all commands *)
 END; (* procedure *)

PROCEDURE CheckForDropped;
(* This is kind of a patch.  If you mistype one character on a short command,
   like "dor" for dir or "cory" for copy, there isn't enough info for the more
   sophisticated MATCH routine to confidently match.  (For longer commands,
   one mistyped character is a smaller percentage, and no problem.)  This
   checks a VERY stringent set of circumstances:
   1) your input command is 3 or 4 characters long
   2) the things that you check it against are the exact same length as
      the input command
*)
VAR i,f1:Integer;
BEGIN
  FOR i:=1 TO NCmd DO
  BEGIN
    IF ((il>=3) and (il<=4)) and (il = Length(CmdList[i])) THEN
    BEGIN
      f1:=ndiff(ic,CmdList[i]);
      IF f1=1 THEN
      BEGIN
        NCand:=NCand+1;
        FoundExact:=True;
        Cand[NCand]:=CmdList[i];
        WhereCand[NCand]:=4 (* 4 is ID for this routine *)
      END; (* register new Candidate *)
    END; (* test acceptable Candidate *)
  END; (* loop through commands *)
END; (* procedure *)

Procedure TrySoundexMatch;
var
  foundsound:boolean;
  i,j:integer;
  t1,t2:String255;
Begin
(*  Return candidates that are exact Soundex matches *)
  foundsound:=false;
  for i:=1 to NCmd do
  begin
    if ISnd=CmdSnd[i] then
    begin
      NCand:=NCand+1;
      Cand[NCand]:=CmdList[i];
      foundsound:=true;
    end;
  end;

(* If no exact matches, look for a one-character difference *)

  if (not foundsound) and (loose) then
  begin
    for i:=1 to NCmd do
    begin
      (* for i=1 to 4, trim out the ith character from each and see if
         you end up with a match *)            
      t1:=copy(ISnd,2,3);
      t2:=copy(CmdSnd[i],2,3);
      if t1=t2 then begin
        NCand:=NCand+1;
        Cand[NCand]:=CmdList[i];
      end;
      t1:=copy(ISnd,1,3);
      t2:=copy(CmdSnd[i],1,3);
      if t1=t2 then begin
        NCand:=NCand+1;
        Cand[NCand]:=CmdList[i];
      end;
      for j:=2 to 3 do
      begin
        t1:=concat(copy(ISnd,1,j-1),copy(ISnd,J+1,4-j));
        t1:=concat(copy(CmdSnd[i],1,j-1),copy(CmdSnd[i],J+1,4-j));
        if t1=t2 then begin
          if debug then writeln('Soundexes:',' ',t1,' ',t2,' ',CmdList[i]);
          NCand:=NCand+1;
          Cand[NCand]:=CmdList[i];
        end;
      end
    end;
  end;




End; (*Procedure *)


PROCEDURE LookFurther;
BEGIN
  (* These routines (Check...) must set/reset FoundExact, as can
     ShowChoices *)
  (* Compute Soundex for input command *)
  ISnd:=SoundOut(IC);
  NCand:=0;            (* Initialize # of Candidates to zero *)
  IF il>1 THEN CheckTranspose;      (* Look for transposed values *)
  CheckForExtra;       (* Look for a match with an extra key *)
  CheckForDropped;     (* Look for a match with an switched letter if
                          it's a short command and the exact length *)
  IF (il>1) and (not FoundExact) THEN TryMatch;
  (* don't look unless no prospects otherwise *)
  TrySoundexMatch;

{
  CheckDistance;       (* Look for commands close by on keyboard *)
}

  IF NCand > 0 THEN  ShowChoices ELSE
  BEGIN
     Writeln;Writeln('I couldn''t find anything like that.');
     foundsomething:=false;
  END;
END;

FUNCTION Trim(s:String255):String255;
BEGIN
  IF (s[1]<>' ') or (Length(s)=0)
       THEN trim:=s ELSE trim:=trim(Copy(s,2,Length(s)-1));
END;

PROCEDURE GetInput(VAR IC:String15;VAR IL:Integer;VAR Parms:String255);
VAR i,j:Integer;
    tempin:string[255];
BEGIN
  Parms:='';
  REPEAT
    Write('_');
    Readln(tempin)
  UNTIL tempin <> '';
  IF debug THEN Writeln('Got from keyboard:',tempin);
  tempin:=trim(tempin);
  il:=Length(tempin);
  FOR i:=1 TO il DO tempin[i]:=upcase(tempin[i]);
  j:=Pos(' ',tempin);
  IF j>0 THEN
  BEGIN
    Parms:=trim(Copy(tempin,j,il-j+1));
    ic:=Copy(tempin,1,j-1);
    il:=j-1;
  END ELSE ic:=tempin;
  IF debug THEN Writeln('Leaving GetInput with IC=',ic,' Parms=',Parms);
END;


PROCEDURE Execute(GC:String15);
const spaces = '                                                     ';
VAR i,j:Integer;
    outline:String255;
    foundit:Boolean;
    VAR cmdin:string[255];
    ReturnCode:Integer;
BEGIN
  IF GC='BYE' THEN finished:=True ELSE
  IF GC='HELP'THEN
       BEGIN
         Writeln('Following are the commands recognized:');
         FOR i:=1 TO NCmd DO
         BEGIN
           outline:=Copy(CmdList[i],1,CmdLen[i]);
           j:=Length(CmdList[i]) - CmdLen[i] ;
           IF j>0 THEN outline:=concat(outline,'(',Copy(CmdList[i],
                                       CmdLen[i]+1,j));
           j:=Length(outline);
           outline:=concat(outline,Copy(spaces,1,13-j));
           Write(outline);
           IF (i mod 5) = 0 THEN Writeln;
         END;
         IF (NCmd mod 5) <> 0 THEN Writeln;
       END (* HELP function *) ELSE
   IF GC='BUG' THEN
       BEGIN
        debug:=not debug;
        Writeln('Debug now = ',debug);
       END  (* debug print toggle *)
   ELSE IF GC='DUMP' THEN
       BEGIN
         FOR i:=1 TO NCmd DO Writeln(CmdList[i],' ',CmdSnd[i]);
       END
   ELSE IF GC = 'NEWDISK' THEN init
   ELSE if gc = 'LOOSE' then
     begin
       if loose then writeln('Loose soundex match disabled.')
                else writeln('Loose soundex match enabled.');
        loose:=not loose;
      end

   ELSE BEGIN
         writeln('Submitting command:',GC);
        END;
END;

BEGIN (* Main Procedure *)
  loose:=false;
  LoadTable;
  Init;
  Debug:=False;Debug2:=False;
  Finished:=False;
  WHILE NOT Finished DO
  BEGIN
    foundsomething:=true;
    GetInput(IC,IL,Parms);
    TCheck;
    IF NOT FoundExact THEN LookFurther;
    Writeln;
    if foundsomething then execute(GC);
  END;

END.

