/* Copyright 1987 - Knowledge Garden Inc.
                    473A Malden Bridge Rd.
                    R.D. 2
                                                        

  VT_SAM implements a small story analyzer based upon scripts. 
  The program is described in the October 1987 AI Apprentice column
  in AI Expert magazine.

  This program has been tested using Turbo Prolog 1.1 on an IBM PC/AT. It has
  been run under DOS 3.2.

  We would be pleased to hear your comments, good or bad, or any applications
  and modifications of the program. Contact us at:

     AI Expert
     500 Howard Street
     San Francisco, CA 94105

  or on the AI Expert BBS. Our id is BillandBev Thompson ,[76703,4324].
  You can also contact us on BIX, our id is bbt.

   Bill and Bev Thompson    */
                                                        
nowarnings       /* needed to prevent Turbo from complaining about */
code = 4096      /* unbound varaiables in predicate definitions */

domains
  file = help_file
  key = backspace; cr; chr(char); f_key(integer); other
  list = reference symbol*         /* reference is needed because we wish to */
  symbol_list = reference list*    /* pass unbound variables from one */
                                   /* predicate to another */
  
  	
predicates
  go
  read_parse(symbol_list,symbol_list)
  parse_and_append(list,symbol_list,symbol_list)
  sentence(list,list)
  noun_phrase(list,symbol,list)
  determiner(list,list)
  noun(list,symbol,list)
  verb_phrase(list,symbol,list)
  verb(list,symbol,list)
  prep_phrase1(list,symbol,list)
  prep_phrase2(list,symbol,list)
  vt_sam(symbol_list,symbol_list)
  find(symbol_list,symbol_list,symbol_list)
  match(symbol_list,symbol_list)
  filler(symbol,symbol_list)
  name_defaults(symbol_list)
  script(symbol,symbol_list,symbol_list)
  trigger(symbol,symbol)
  read_a_line(string,string,key)
  help
  read_contents(string,string)
  string_list(string,list)  
  append_list(symbol_list,list,symbol_list)  
  member(symbol,list)
  list_member(list,symbol_list)
  write_list(symbol_list)
  translate(list)
  read_key(key)
  key_code(key,char,integer)
  key_code2(key,integer)


goal
  go.


clauses

/* go is the goal clause, it displays the header and then reads
   the story, parses it and calls vt_sam to analyze it */
   
  go :-
        makewindow(1,14,0,"",0,0,25,80),
        clearwindow,
        write("VT_SAM              Copyright [c] 1987"),nl,
        write("                    Knowledge Garden Inc."),nl,
        write("                    473A Malden Bridge Rd."),nl,
        write("                    Nassau,NY 12123"),nl,nl,
        write("Enter your story, one line at a time in lower case."),nl,
        write("Enter a blank line to quit.  - "),
        write("Press F1 for help."),nl,nl,
        read_parse([],Story),!,
        vt_sam(Story,Understanding),nl,
        write("The translated story:"),nl,nl,
        write_list(Understanding).

        
/* read the story a line at a time until a blank line is encountered 
   On successful return, Story will be bound to the parsed story */
   
  read_parse(Story,New_story) :- 
        read_key(Key),
  	read_a_line("",S,Key),
  	S <> "",
        string_list(S,L),
        parse_and_append(L,Story,Story2),
        read_parse(Story2,New_story).
        
  read_parse(Story,Story).
        

/* Parse a senetence and append it to the story list */

  parse_and_append(Line,Story,Story2) :-
  	sentence(Line,Trans),
  	append_list(Story,Trans,Story2).
  	
  parse_and_append(_,Story,Story).  	
  

/* The parser - this is all described in the article */
  
  sentence(S0,Trans) :-
  	noun_phrase(S0,Noun,S1),
  	verb_phrase(S1,Noun,Trans).
  	
  sentence(S,[]) :-
  	write("Sorry, ",S," can't be parsed."),nl,
  	fail.
  	
  	  	  
  noun_phrase(S0,Noun,S) :-
  	determiner(S0,S1),
  	noun(S1,Noun,S).  	
  	
  noun_phrase(S0,Noun,S) :-
   	noun(S0,Noun,S).
   	
   	
  determiner([Det | S],S) :-
  	member(Det,[the,a]).
  	
  
  noun([Noun | S],Noun,S) :-
  	member(Noun,[john,restaurant,customer,door,seat,
  	             waiter,menu,food,meal,hamburger,salad,soup,
  	             money,check,lennys,counter,waitress]).

  noun([Noun | S],_,S) :-
  	member(Noun,[he,she,him,her]).


  verb_phrase(S0,Noun,[ptrans,Noun,Noun,Obj1,Obj2]) :-  
  	verb(S0,ptrans,S1),
  	prep_phrase1(S1,Obj1,S2),
  	prep_phrase2(S2,Obj2,S3),
  	S3 = [].

  verb_phrase(S0,Noun,[atrans,Obj2,Noun,Obj2,Obj1]) :-  
  	verb(S0,atrans,S1),
  	noun_phrase(S1,Obj1,S2),
  	prep_phrase2(S2,Obj2,S3),
  	S3 = [].

  verb_phrase(S0,Noun,[ptrans,Noun,Noun,_,Obj1]) :-  
  	verb(S0,ptrans,S1),
  	prep_phrase2(S1,Obj1,S2),
  	S2 = [].

  verb_phrase(S0,Noun,[atrans,Noun,Obj1,_]) :-  
  	verb(S0,atrans,S1),
  	noun_phrase(S1,Obj1,S2),
  	S2 = [].

  verb_phrase(S0,Noun,[ingest,Noun,Obj1]) :-  
  	verb(S0,ingest,S1),
  	noun_phrase(S1,Obj1,S2),
  	S2 = [].
  
  verb_phrase(S0,Noun,[mtrans,Noun,Obj1,_]) :-  
  	verb(S0,mtrans,S1),
  	noun_phrase(S1,Obj1,S2),
  	S2 = [].
  
  verb_phrase(S0,Noun,[ptrans,Noun,Noun,_,_]) :-
  	verb(S0,ptrans,S1),
  	S1 = [].


  verb([Verb | S],ptrans,S) :-
   	member(Verb,[left,went]).

  verb([Verb | S],atrans,S) :-
   	member(Verb,[gave,brought]).

  verb([Verb | S],mtrans,S) :-
   	member(Verb,[ordered]).

  verb([Verb | S],ingest,S) :-
   	member(Verb,[ate]).
  	
  	
  prep_phrase1([from | S],Noun,S1) :-
  	noun_phrase(S,Noun,S1).


  prep_phrase2([to | S],Noun,S1) :-
  	noun_phrase(S,Noun,S1).


/* The script processor, this is also described in the article */
  	
  vt_sam(Story,Script) :-
  	find(Story,Script,Defaults),
  	match(Script,Story),
  	name_defaults(Defaults).
  
  vt_sam(Story,[]) :-
	write("Sorry, that story could not be translated."),nl.   
  

  find(Story,Script,Defaults) :-
  	filler(Slot,Story),
  	bound(Slot),
  	trigger(Slot,Name),
  	script(Name,Script,Defaults).
  	
  	
  match(_,[]).
  
  match([Line | Script],[Line | Story]) :-
	match(Script,Story).
	
  match([_ | Script],Story) :-
  	match(Script,Story).
  	
  	
  filler(Slot,Story) :-
   	list_member([_ | Args],Story),
   	member(Slot,Args).
   	
   	
  name_defaults([]).
  
  name_defaults([[N,N] | L]) :-
  	name_defaults(L).

  name_defaults([[N1,N2] | L]) :-
  	name_defaults(L).
  	

/* Scripts go here - This is slightly different from the article,
   because Turbo complained about an overflow when we put the
   script and defaults in the head of the predicate where they
   belong */
   
  script(restaurant,Script,Defaults) :-
  	Script = [[ptrans,Actor,Actor,Earlier_place,Restaurant],
  	 [ptrans,Actor,Actor,Door,Seat],
  	 [atrans,Actor,Waiter,Actor,Menu],
  	 [mtrans,Actor,Food,Waiter],
  	 [atrans,Actor,Waiter,Actor,Food],
  	 [ingest,Actor,Food],
  	 [atrans,Waiter,Actor,Waiter,Money],
  	 [ptrans,Actor,Actor,Restaurant,Gone]],
  	Defaults = [[Actor,customer],
  	 [Earlier_place,somewhere],
  	 [Restaurant,restaurant],
  	 [Waiter,waiter],
  	 [Menu,menu],
  	 [Door,door],
  	 [Seat,seat],
  	 [Food,meal],
  	 [Money,money],
  	 [Gone,somewhere_else]]. 


/* Triggers for this script */

  trigger(lennys,restaurant).
  
  trigger(waiter,restaurant).
  
  trigger(waitress,restaurant).
  

/* The translation routines. These are pretty simpleminded, but
   they could be extended to perform more interesting functions */
   
  write_list([]).
  
  write_list([H | T]) :-
  	translate(H),
  	write("."),nl,
  	write_list(T).	
  	

  translate([ptrans,Actor,Actor,Place1,Place2]) :-
  	write(Actor," went from ",Place1," to ",Place2).

  translate([mtrans,Actor1,Object,Actor2]) :-
  	write(Actor1," ordered ",Object," from ",Actor2).

  translate([ingest,Actor,Object]) :-
  	write(Actor," ate ",Object).

  translate([atrans,Actor1,Actor2,Actor1,Object]) :-
  	write(Actor2," gave ",Object," to ",Actor1).


/* Read a line from the keyboard - F1 provides help */

  read_a_line(S,S,cr) :-
  	nl,!.
  
  read_a_line(S0,S,chr(Ch)) :-
  	char_int(Ch,Val),
  	Val >= 32,
  	Val <= 126,!,
  	write(Ch),
  	str_char(Ch_str,Ch),
  	concat(S0,Ch_str,S1),
  	read_key(Key),
  	read_a_line(S1,S,Key).

  read_a_line(S0,S,backspace) :-
  	str_len(S0,S_len),
  	S_len > 0,!,
  	New_len = S_len - 1,
  	frontstr(New_len,S0,S1,_),
  	cursor(Row,_),
  	cursor(Row,0),
  	write(S1," "),
  	cursor(Row,New_len),
  	read_key(Key),
  	read_a_line(S1,S,Key).
  	
  read_a_line(S0,S,f_key(1)) :-
  	help,!,
  	read_key(Key),
  	read_a_line(S0,S,Key).

 read_a_line(S0,S,_) :-
 	beep,
 	read_key(Key),
 	read_a_line(S0,S,Key).  	  	


/* help function */  

  help :- 
        makewindow(2,79,15,"Help",5,12,14,66),
        openread(help_file,"VTSAM.HLP"),
        readdevice(help_file),
        read_contents("",S),
        closefile(help_file),
        readdevice(keyboard),
        display(S),
  	removewindow.


  read_contents(S0,S) :-
  	not(eof(help_file)),!,
  	readln(S1),
  	concat(S1,"\n",S2),
  	concat(S0,S2,S3),
  	read_contents(S3,S).
  	
  read_contents(S,S).  	


/* Utility functions - We need two different membership functions
   because Turbo requires the arguments of a predicate to be
   explicitly typed, other PROLOGs aren't so fussy */
  
  list_member(X,[X | _]).
  
  list_member(X,[_ | T]) :-
  	list_member(X,T).
  	
  
  string_list("",[]).
  
  string_list(S,[H | T]) :-
  	fronttoken(S,H,S1),
  	string_list(S1,T).  
  

  member(X,[X | _]).
  
  member(X,[_ | T]) :-
  	member(X,T).
  	
  	
  append_list([],List,[List]).
  
  append_list([H | L1],List,[H | L2]) :-
  	append_list(L1,List,L2).  	  
  
  	
/* Read keys from keyboard - This is from the Turbo Prolog
   manual */
     
  read_key(Key) :-
  	readchar(T),
  	char_int(T,Val),
  	key_code(Key,T,Val).
  	
  
  key_code(Key,_,0) :-
  	readchar(T),
  	char_int(T,Val),
  	key_code2(Key,Val),!.
  
  key_code(backspace,_,8) :- !.
  	
  key_code(cr,_,13) :- !.  	
  
  key_code(chr(T),T,_) :- !.
  
  key_code(other,_,_).
    
  
  key_code2(f_key(1),59) :- !.

  key_code2(other,_).
                                                                                            