

Source Code to VT-Prolog



(*$V-,R+,B- *)
PROGRAM very_tiny_prolog ;

(* Copyright 1986 - MicroExpert Systems
                    Box 430 R.D. 2
                    Nassau, NY 12123       *)


 CONST
  debug = false ;
  back_space = ^H ;
  tab = ^I ;
  eof_mark = ^Z ;
  esc = #27 ;
  quote_char = #39 ;
  left_arrow = #75 ;
  end_key = #79 ;
  del_line = ^X ;
  return = ^M ;
  bell = ^G ;

 TYPE
  counter = 0 .. maxint ;
  string80 = string[80] ;
  string132 = string[132] ;
  string255 = string[255] ;
  text_file = text ;
  char_set = SET OF char ;
  node_type = (cons_node,func,variable,constant,free_node) ;
  node_ptr = ^node ;
  node = RECORD
          in_use : boolean ;
          CASE tag : node_type OF
           cons_node : (tail_ptr : node_ptr ;
                        head_ptr : node_ptr) ;
           func,
           constant,
           variable  : (string_data : string80) ;
           free_node : (next_free : node_ptr ;
                        block_cnt : counter) ;
          END ;

 VAR
  line,saved_line : string132 ;
  token : string80 ;
  source_file : text_file ;
  error_flag,in_comment : boolean ;
  delim_set,text_chars,editing_chars : char_set ;
  data_base,initial_heap,free,saved_list : node_ptr ;
  total_free : real ;


 PROCEDURE noise ;
  BEGIN
   write(bell) ;
  END ; (* noise *)


 FUNCTION open(VAR f : text_file ; f_name : string80) : boolean ;
  BEGIN
   assign(f,f_name) ;
   (*$I- *)
   reset(f) ;
   (*$I+ *)
   open := (ioresult = 0) ;
  END ; (* open *)


 FUNCTION is_console(VAR f : text_file) : boolean ;
  TYPE
   fib = ARRAY [0 .. 75] OF byte ;
  VAR
   fib_ptr : ^fib ;
   dev_type : byte ;
  BEGIN
   fib_ptr := addr(f) ;
   dev_type := fib_ptr^[2] AND $07 ;
   is_console := (dev_type = 1) OR (dev_type = 2) ;
  END ; (* is_console *)


 PROCEDURE strip_leading_blanks(VAR s : string80) ;
  BEGIN
   IF length(s) > 0
    THEN
     IF (s[1] = ' ') OR (s[1] = tab)
      THEN
       BEGIN
        delete(s,1,1) ;
        strip_leading_blanks(s) ;
       END ;
  END ; (* strip_leading_blanks *)


 PROCEDURE strip_trailing_blanks(VAR s : string80) ;
  BEGIN
   IF length(s) > 0
    THEN
     IF (s[length(s)] = ' ') OR (s[length(s)] = tab)
      THEN
       BEGIN
        delete(s,length(s),1) ;
        strip_trailing_blanks(s) ;
       END ;
  END ; (* strip_trailing_blanks *)


 FUNCTION toupper(s : string80) : string80 ;
  VAR
   i : byte ;
  BEGIN
   IF length(s) > 0
    THEN
     FOR i := 1 TO length(s) DO
      s[i] := upcase(s[i]) ;
   toupper := s ;
  END ; (* toupper *)


 FUNCTION is_number(s : string80) : boolean ;
  VAR
   num : real ;
   code : integer ;
  BEGIN
   strip_trailing_blanks(s) ;
   strip_leading_blanks(s) ;
   IF s <> ''
    THEN val(s,num,code)
    ELSE code := -1 ;
   is_number := (code = 0) ;
  END ; (* is_number *)


 FUNCTION head(list : node_ptr) : node_ptr ;
  BEGIN
   IF list = NIL
    THEN head := NIL
    ELSE head := list^.head_ptr ;
  END ; (* head *)


 FUNCTION tail(list : node_ptr) : node_ptr ;
  BEGIN
   IF list = NIL
    THEN tail := NIL
   ELSE
    CASE list^.tag OF
     cons_node : tail := list^.tail_ptr ;
     free_node : tail := list^.next_free ;
     ELSE        tail := NIL ;
    END ;
  END ; (* tail *)


 FUNCTION allocation_size(x : counter) : counter ;
  BEGIN
   allocation_size := (((x - 1) DIV 8) + 1) * 8 ;
  END ; (* allocation_size *)


 FUNCTION node_size : counter ;
  BEGIN
   node_size := 2 * sizeof(node_ptr) + sizeof(boolean) + sizeof(node_type) ;
  END ; (* node_size *)


 FUNCTION normalize(pt : node_ptr) : node_ptr ;
  VAR
   pt_seg,pt_ofs : integer ;
  BEGIN
   pt_seg := seg(pt^) + (ofs(pt^) DIV 16) ;
   pt_ofs := ofs(pt^) MOD 16 ;
   normalize := ptr(pt_seg,pt_ofs) ;
  END ; (* normalize *)


 PROCEDURE print_list(list : node_ptr) ;
  VAR
   p : node_ptr ;
  BEGIN
   IF list <> NIL
    THEN
     BEGIN
      IF list^.tag IN [constant,variable,func]
       THEN write(ord(list^.tag),' ',list^.string_data,' ')
       ELSE
        BEGIN
         write('(') ;
         p := list ;
         WHILE p <> NIL DO
          BEGIN
           print_list(head(p)) ;
           p := tail(p) ;
          END ;
         write(') ') ;
        END ;
     END ;
  END ; (* print_list *)


 PROCEDURE collect_garbage ;
  (* This routine is specific to Turbo Pascal Ver 3.01  *)
  (* It depends upon the fact that Turbo allocates memory in 8 byte blocks *)
  (* on the PC. If you recompile this program on another system be very  *)
  (* careful with this routine. It is the only one that is machine specific *)

  FUNCTION lower(p1,p2 : node_ptr) : boolean ;
   BEGIN
    p1 := normalize(p1) ;
    p2 := normalize(p2) ;
    lower := (seg(p1^) < seg(p2^)) OR
              ((seg(p1^) = seg(p2^)) AND (ofs(p1^) < ofs(p2^))) ;
   END ; (* lower *)

  PROCEDURE mark(list : node_ptr) ;
   BEGIN
    IF list <> NIL
     THEN
      BEGIN
       IF NOT list^.in_use
        THEN
         BEGIN
          list^.in_use := true ;
          IF list^.tag = cons_node
           THEN
            BEGIN
             mark(head(list)) ;
             mark(tail(list)) ;
            END ;
         END ;
      END ;
   END ; (* mark *)

  PROCEDURE unmark_mem ;
   VAR
    p : node_ptr ;
    string_base,node_allocation : counter ;
   BEGIN
    string_base := sizeof(node_type) + sizeof(boolean) ;
    p := normalize(initial_heap) ;
    node_allocation := allocation_size(node_size) ;
    WHILE lower(p,HeapPtr) DO
     BEGIN
      p^.in_use := false ;
      IF p^.tag = cons_node
       THEN p := normalize(ptr(seg(p^),ofs(p^) + node_allocation))
      ELSE IF p^.tag = free_node
       THEN p := normalize(ptr(seg(p^),ofs(p^) + (p^.block_cnt + 1) * 8))
      ELSE p := normalize(ptr(seg(p^),
                              ofs(p^) +
                              allocation_size(string_base +
                                              length(p^.string_data) + 1))) ;
     END ;
   END ; (* unmark_mem *)

  PROCEDURE release_mem ;
   VAR
    heap_top : node_ptr ;
    string_base,node_allocation,string_allocation,block_allocation : counter ;

   PROCEDURE free_memory(pt : node_ptr ; size : counter) ;
    VAR
     blks : counter ;
    BEGIN
     blks := ((size - 1) DIV 8) + 1 ;
     pt^.tag := free_node ;
     IF normalize(ptr(seg(pt^),ofs(pt^) + 8 * blks)) = free
      THEN
       BEGIN
        pt^.next_free := free^.next_free ;
        pt^.block_cnt := free^.block_cnt + blks ;
        free := pt ;
       END
     ELSE IF normalize(ptr(seg(free^),ofs(free^) + 8 * free^.block_cnt)) = pt
      THEN free^.block_cnt := free^.block_cnt + blks
     ELSE
      BEGIN
       pt^.next_free := free ;
       pt^.block_cnt := blks - 1 ;
       free := pt ;
      END ;
     total_free := total_free + (blks * 8.0) ;
    END ; (* free_memory *)

   PROCEDURE do_release ;
    VAR
     p : node_ptr ;
    BEGIN
     p := normalize(initial_heap) ;
     WHILE lower(p,heap_top) DO
      BEGIN
       IF p^.tag = cons_node
        THEN
         BEGIN
          IF NOT p^.in_use
           THEN free_memory(p,node_size) ;
          p := normalize(ptr(seg(p^),ofs(p^) + node_allocation)) ;
         END
        ELSE IF p^.tag = free_node
         THEN
          BEGIN
           block_allocation := (p^.block_cnt + 1) * 8 ;
           free_memory(p,block_allocation) ;
           p := normalize(ptr(seg(p^),ofs(p^) + block_allocation)) ;
          END
        ELSE
         BEGIN
          string_allocation := allocation_size(string_base +
                                               length(p^.string_data) + 1) ;
          IF NOT p^.in_use
           THEN free_memory(p,string_base + length(p^.string_data) + 1) ;
          p := normalize(ptr(seg(p^),ofs(p^) + string_allocation)) ;
         END ;
      END ;
    END ; (* do_release *)

   BEGIN
    free := NIL ;
    total_free := 0.0 ;
    heap_top := HeapPtr ;
    string_base := sizeof(node_type) + sizeof(boolean) ;
    node_allocation := allocation_size(node_size) ;
    do_release ;
   END ; (* release_mem *)

  BEGIN
   unmark_mem ;
   mark(saved_list) ;
   release_mem ;
  END ; (* collect_garbage *)


 PROCEDURE get_memory(VAR p : node_ptr ; size : counter) ;
  VAR
   blks : counter ;
   allocated : boolean ;

  PROCEDURE get_from_free(VAR list : node_ptr) ;
   BEGIN
    IF list <> NIL
     THEN
      BEGIN
      IF list^.block_cnt >= (blks - 1)
       THEN
        BEGIN
         p := normalize(ptr(seg(list^),ofs(list^) +
                                       (list^.block_cnt - blks + 1) * 8)) ;
         IF list^.block_cnt = blks - 1
          THEN list := list^.next_free
          ELSE list^.block_cnt := list^.block_cnt - blks ;
         allocated := true ;
         total_free := total_free - (blks * 8.0) ;
        END
       ELSE get_from_free(list^.next_free) ;
      END ;
   END ; (* get_from_free *)

  BEGIN
   blks := ((size - 1) DIV 8) + 1 ;
   allocated := false ;
   get_from_free(free) ;
   IF NOT allocated
    THEN getmem(p,blks * 8) ;
  END ; (* get_memory *)


 FUNCTION alloc_str(typ : node_type ; s : string80) : node_ptr ;
  VAR
   pt : node_ptr ;
  BEGIN
   get_memory(pt,allocation_size(sizeof(node_type) + sizeof(boolean) +
                                 length(s) + 1)) ;
   pt^.tag := typ ;
   pt^.string_data := s ;
   alloc_str := pt ;
  END ; (* alloc_str *)


 PROCEDURE alloc_cons(VAR p : node_ptr ; ex : node_ptr) ;
  BEGIN
   get_memory(p,allocation_size(node_size)) ;
   p^.tag := cons_node ;
   p^.head_ptr := ex ;
   p^.tail_ptr := NIL ;
  END ; (* alloc_cons *)


 FUNCTION cons(new_node,list : node_ptr) : node_ptr ;
  VAR
   p : node_ptr ;
  BEGIN
   alloc_cons(p,new_node) ;
   p^.tail_ptr := list ;
   cons := p ;
  END ; (* cons *)


 FUNCTION append_list(list1,list2 : node_ptr) : node_ptr ;
  BEGIN
   IF list1 = NIL
    THEN append_list := list2
    ELSE append_list := cons(head(list1),append_list(tail(list1),list2)) ;
  END ; (* append_list *)


 FUNCTION list_length(list : node_ptr) : counter ;
  BEGIN
   IF list = NIL
    THEN list_length := 0
    ELSE list_length := 1 + list_length(list^.tail_ptr) ;
  END ; (* list_length *)


 FUNCTION string_val(list : node_ptr) : string80 ;
  BEGIN
   IF list = NIL
    THEN string_val := ''
   ELSE IF list^.tag IN [func,constant,variable]
    THEN string_val := list^.string_data
   ELSE string_val := '' ;
  END ; (* string_val *)


 FUNCTION tag_value(list : node_ptr) : node_type ;
  BEGIN
   IF list = NIL
    THEN tag_value := free_node
    ELSE tag_value := list^.tag ;
  END ; (* string_val *)


 PROCEDURE wait ;
  VAR
   ch : char ;
  BEGIN
   gotoxy(25,25) ;
   write('Press any key to continue. ') ;
   read(kbd,ch) ;
   write(return) ;
   clreol ;
  END ; (* wait *)


 PROCEDURE read_kbd(VAR s : string80) ;
  BEGIN
   write('-> ') ;
   readln(s) ;
  END ; (* read_kbd *)


 PROCEDURE read_from_file(VAR f : text_file) ;

  PROCEDURE read_a_line ;
   BEGIN
    (*$I- *)
    readln(f,line) ;
    (*$I+ *)
    IF ioresult <> 0
     THEN line := eof_mark
    ELSE IF eof(f)
     THEN line := concat(line,eof_mark) ;
   END ; (* read_a_line *)

  BEGIN
   line := '' ;
   IF is_console(f)
    THEN read_kbd(line)
    ELSE read_a_line ;
   IF in_comment
    THEN
     IF pos('*)',line) > 0
      THEN
       BEGIN
        delete(line,1,pos('*)',line) + 1) ;
        in_comment := false ;
       END
      ELSE read_from_file(f) ;
   saved_line := line ;
  END ; (* read_from_file *)


 PROCEDURE get_token(VAR t_line : string132 ; VAR token : string80) ;

  PROCEDURE get_word ;
   VAR
    done : boolean ;
    cn : integer ;
    len : byte ;
   BEGIN
    cn := 1 ;
    len := length(t_line) ;
    done := false ;
    WHILE NOT done DO
     IF cn > len
      THEN done := true
     ELSE IF t_line[cn] IN delim_set
      THEN done := true
     ELSE cn := cn + 1 ;
    token := copy(t_line,1,cn-1) ;
    delete(t_line,1,cn-1) ;
   END ; (* get_word *)

  PROCEDURE comment ;
   BEGIN
    IF pos('*)',t_line) > 0
     THEN
      BEGIN
       delete(t_line,1,pos('*)',t_line)+1) ;
       get_token(line,token) ;
      END
     ELSE
      BEGIN
       t_line := '' ;
       token := '' ;
       in_comment := true ;
      END ;
   END ; (* comment *)

  PROCEDURE get_quote ;
   BEGIN
    delete(t_line,1,1) ;
    IF pos(quote_char,t_line) > 0
     THEN
      BEGIN
       token := concat(quote_char,copy(t_line,1,pos(quote_char,t_line) - 1)) ;
       delete(t_line,1,pos(quote_char,t_line)) ;
      END
     ELSE
      BEGIN
       token := t_line ;
       t_line := '' ;
      END ;
   END ; (* get_quote *)

  BEGIN
   strip_leading_blanks(t_line) ;
   IF length(t_line) > 0
    THEN
     BEGIN
      IF copy(t_line,1,2) = '(*'
       THEN comment
      ELSE IF (copy(t_line,1,2) = ':-') OR (copy(t_line,1,2) = '?-')
       THEN
        BEGIN
         token := copy(t_line,1,2) ;
         delete(t_line,1,2) ;
        END
      ELSE IF t_line[1] = quote_char
       THEN get_quote
      ELSE IF t_line[1] IN delim_set
       THEN
        BEGIN
         token := t_line[1] ;
         delete(t_line,1,1) ;
        END
      ELSE get_word ;
     END
    ELSE token := '' ;
  END ; (* get_token *)


 PROCEDURE scan(VAR f : text_file ; VAR token : string80) ;
  BEGIN
   IF length(line) > 0
    THEN
     BEGIN
      get_token(line,token) ;
      IF token = ''
       THEN scan(f,token) ;
     END
    ELSE
     BEGIN
      read_from_file(f) ;
      scan(f,token) ;
     END ;
  END ; (* scan *)


 PROCEDURE compile(VAR source : text_file) ;

  PROCEDURE error(error_msg : string80) ;

   PROCEDURE runout ;
    BEGIN
     WHILE (token <> '.') AND (token <> eof_mark)
      scan(source,token) ;
    END ; (* runout *)

   BEGIN
    error_flag := true ;
    writeln ;
    writeln(error_msg) ;
    writeln ;
    writeln(saved_line) ;
    writeln('' : length(saved_line) - length(line) - 1,'^') ; ;
    runout ;
    wait ;
   END ; (* error *)

  PROCEDURE goal(VAR l_ptr : node_ptr) ;
   VAR
    goal_token : string80 ;

   PROCEDURE quoted_str(VAR q_ptr : node_ptr) ;
    BEGIN
     q_ptr := append_list(q_ptr,cons(alloc_str(constant,
                                     copy(token,2,length(token) - 1)),
                                     NIL)) ;
     scan(source,token) ;
    END ; (* quoted_str *)

   PROCEDURE functor(VAR f_ptr : node_ptr ; func_token : string80) ;
    VAR
     c_ptr : node_ptr ;

    PROCEDURE components(VAR cm_ptr : node_ptr) ;

     PROCEDURE term(VAR t_ptr : node_ptr) ;
      VAR
       t_token : string80 ;

      PROCEDURE varbl(VAR v_ptr : node_ptr) ;
       BEGIN
        v_ptr := append_list(v_ptr,cons(alloc_str(variable,token),NIL)) ;
        scan(source,token) ;
       END ; (* varbl *)

      PROCEDURE number(VAR n_ptr : node_ptr) ;
       BEGIN
        n_ptr := append_list(n_ptr,cons(alloc_str(constant,token),NIL)) ;
        scan(source,token) ;
       END ; (* handle_number *)

      BEGIN
       IF token[1] IN ['A' .. 'Z','_']
        THEN varbl(t_ptr)
       ELSE IF token[1] = quote_char
        THEN quoted_str(t_ptr)
       ELSE IF is_number(token)
        THEN number(t_ptr)
       ELSE IF token[1] IN ['a' .. 'z']
        THEN
         BEGIN
          t_token := token ;
          scan(source,token) ;
          IF token = '('
           THEN functor(t_ptr,t_token)
           ELSE t_ptr := append_list(t_ptr,
                                     cons(alloc_str(constant,t_token),NIL)) ;
         END
       ELSE error('Illegal Symbol.') ;
      END ; (* term *)

     BEGIN
      term(cm_ptr) ;
      IF token = ','
       THEN
        BEGIN
         scan(source,token) ;
         components(cm_ptr) ;
        END ;
     END ; (* components *)

    BEGIN
     c_ptr := cons(alloc_str(func,func_token),NIL) ;
     scan(source,token) ;
     components(c_ptr) ;
     IF token = ')'
      THEN
       BEGIN
        f_ptr := append_list(f_ptr,cons(c_ptr,NIL)) ;
        scan(source,token) ;
       END
      ELSE error('Missing '')''.') ;
    END ; (* functor *)

   BEGIN
    IF token[1] IN ['a' .. 'z',quote_char]
     THEN
      BEGIN
       IF token[1] = quote_char
        THEN
         BEGIN
          l_ptr := append_list(l_ptr,
                               cons(cons(alloc_str(constant,
                               copy(token,2,length(token) - 1)),NIL),NIL)) ;
          scan(source,token) ;
         END
        ELSE
         BEGIN
          goal_token := token ;
          scan(source,token) ;
          IF token = '('
           THEN functor(l_ptr,goal_token)
           ELSE l_ptr := append_list(l_ptr,
                                     cons(cons(alloc_str(constant,goal_token),
                                               NIL),NIL)) ;
         END
      END
     ELSE error('A goal must begin with ''a .. z'' or be a quoted string.') ;
   END ; (* goal *)

  PROCEDURE tail_list(VAR t_ptr : node_ptr) ;
   BEGIN
    goal(t_ptr) ;
    IF token = ','
     THEN
      BEGIN
       scan(source,token) ;
       tail_list(t_ptr) ;
      END ;
   END ; (* tail *)

  PROCEDURE rule ;
   VAR
    r_ptr : node_ptr ;

   PROCEDURE head_list(VAR h_ptr : node_ptr) ;
    BEGIN
     goal(h_ptr) ;
    END ; (* head *)

   PROCEDURE append_rule(VAR list : node_ptr) ;
    BEGIN
     IF list = NIL
      THEN alloc_cons(list,r_ptr)
      ELSE append_rule(list^.tail_ptr) ;
    END ; (* append_rule *)

   BEGIN
    r_ptr := NIL ;
    head_list(r_ptr) ;
    IF token = ':-'
     THEN
      BEGIN
       scan(source,token) ;
       tail_list(r_ptr) ;
      END ;
    IF token <> '.'
     THEN error('''.'' expected.') ;
    IF NOT error_flag
     THEN append_rule(data_base) ;
   END ; (* rule *)

  PROCEDURE query ;
   VAR
    q_ptr : node_ptr ;
    solved : boolean ;

   PROCEDURE solve(list,env : node_ptr ; level : counter) ;
    VAR
     new_env,p : node_ptr ;

    FUNCTION look_up(var_str : string80 ; environ : node_ptr) : node_ptr ;
     VAR
      found : boolean ;
      p : node_ptr ;
     BEGIN
      p := environ ;
      found := false ;
      WHILE (p <> NIL) AND (NOT found) DO
       BEGIN
        IF var_str = string_val(head(head(p)))
         THEN
          BEGIN
           found := true ;
           look_up := tail(head(p)) ;
          END
         ELSE p := tail(p) ;
       END ;
      IF NOT found
       THEN look_up := NIL ;
     END ; (* look_up *)

    PROCEDURE check_continue ;
     VAR
      printed : boolean ;
      ch : char ;

     PROCEDURE print_bindings(list : node_ptr) ;

      PROCEDURE print_functor(l : node_ptr) ; FORWARD ;

      PROCEDURE print_variable(var_str : string80) ;
       VAR
        var_ptr : node_ptr ;
       BEGIN
        var_ptr := look_up(var_str,env) ;
        IF var_ptr <> NIL
         THEN
          CASE tag_value(head(var_ptr)) OF
           constant  : write(string_val(head(var_ptr)),' ') ;
           variable  : print_variable(string_val(head(var_ptr))) ;
           cons_node : print_functor(head(var_ptr)) ;
          END
         ELSE write('_ ') ;
       END ; (* print_variable *)

      PROCEDURE print_functor (* l : node_ptr *) ;

       PROCEDURE print_components(p : node_ptr) ;
        BEGIN
         IF p <> NIL
          THEN
           BEGIN
            CASE tag_value(head(p)) OF
             constant  : write(string_val(head(p)),' ') ;
             variable  : print_variable(string_val(head(p))) ;
             cons_node : print_functor(head(p)) ;
            END ;
            IF tail(p) <> NIL
             THEN
              BEGIN
               write(',') ;
               print_components(tail(p)) ;
              END ;
           END ;
        END ; (* print_components *)

       BEGIN
        IF l <> NIL
         THEN
          BEGIN
           write(string_val(head(l))) ;
           IF tail(l) <> NIL
            THEN
             BEGIN
              write('(') ;
              print_components(tail(l)) ;
              write(')') ;
             END ;
          END ;
       END ; (* print_functor *)

      BEGIN
       IF list <> NIL
        THEN
         BEGIN
          print_bindings(tail(list)) ;
          IF pos('#',string_val(head(head(list)))) = 0
           THEN
            BEGIN
             printed := true ;
             writeln ;
             write(string_val(head(head(list))),' = ') ;
             CASE tag_value(head(tail(head(list)))) OF
              constant  : write(string_val(head(tail(head(list)))),' ') ;
              variable  : print_variable(string_val(head(tail(head(list))))) ;
              cons_node : print_functor(head(tail(head(list)))) ;
             END ;
            END ;
         END ;
      END ; (* print_bindings *)

     BEGIN
      printed := false ;
      print_bindings(env) ;
      IF NOT printed
       THEN
        BEGIN
         writeln ;
         write('Yes ') ;
        END ;
      REPEAT
       read(kbd,ch) ;
      UNTIL ch IN [return,';'] ;
      solved := (ch = return) ;
      writeln ;
     END ; (* check_continue *)

    FUNCTION copy_list(list : node_ptr ; copy_level : counter) : node_ptr ;
     VAR
      temp_list,p : node_ptr ;
      level_str : string[6] ;

     PROCEDURE list_copy(from_list : node_ptr ; VAR to_list : node_ptr) ;
      BEGIN
       IF from_list <> NIL
        THEN
         CASE from_list^.tag OF
          variable : to_list := alloc_str(variable,
                                          concat(from_list^.string_data,
                                                 level_str)) ;
          func,
          constant  : to_list := from_list ;
          cons_node : BEGIN
                       list_copy(tail(from_list),to_list) ;
                       to_list := cons(copy_list(head(from_list),copy_level),
                                       to_list) ;
                      END ;
         END ;
      END ; (* list_copy *)

     BEGIN
      str(copy_level,level_str) ;
      level_str := concat('#',level_str) ;
      temp_list := NIL ;
      list_copy(list,temp_list) ;
      copy_list := temp_list ;
     END ; (* copy_list *)

    FUNCTION unify(list1,list2,environ : node_ptr ; VAR new_environ : node_ptr) :
                   boolean ;
     VAR
      var_ptr : node_ptr ;

     PROCEDURE make_binding(l1,l2 : node_ptr) ;
      BEGIN
       IF copy(string_val(head(l1)),1,1) <> '_'
        THEN new_environ := cons(cons(head(l1),l2),environ)
        ELSE new_environ := environ ;
       unify := true ;
      END ; (* make_binding *)

     PROCEDURE fail ;
      BEGIN
       unify := false ;
       new_environ := environ ;
      END ; (* fail *)

     PROCEDURE unify_constant ;
      BEGIN
       CASE tag_value(head(list2)) OF
        constant  : IF string_val(head(list1)) = string_val(head(list2))
                     THEN
                      BEGIN
                       unify := true ;
                       new_environ := environ ;
                      END
                     ELSE fail ;
        variable  : BEGIN
                     var_ptr := look_up(string_val(head(list2)),environ) ;
                     IF var_ptr = NIL
                      THEN make_binding(list2,list1)
                      ELSE unify := unify(list1,var_ptr,environ,new_environ) ;
                    END ;
        cons_node,
        func      : fail ;
       END ;
      END ; (* unify_constant *)

     PROCEDURE unify_func ;

      PROCEDURE unify_tail ;
       VAR
        p,q : node_ptr ;
        unified : boolean ;
       BEGIN
        p := tail(list1) ;
        q := tail(list2) ;
        unified := true ;
        new_environ := environ ;
        WHILE (p <> NIL) AND unified DO
         BEGIN
          unified := unified AND unify(cons(head(p),NIL),cons(head(q),NIL),
                                       new_environ,new_environ) ;
          p := tail(p) ;
          q := tail(q) ;
         END ;
        IF NOT unified
         THEN fail ;
       END ; (* unify_tail *)

      BEGIN
       CASE tag_value(head(list2)) OF
        constant  : fail ;
        variable  : BEGIN
                     var_ptr := look_up(string_val(head(list2)),environ) ;
                     IF var_ptr = NIL
                      THEN make_binding(list2,list1)
                      ELSE unify := unify(list1,var_ptr,environ,new_environ) ;
                    END ;
        func      : IF string_val(head(list1)) = string_val(head(list2))
                     THEN
                      IF list_length(tail(list1)) = list_length(tail(list2))
                       THEN unify_tail
                       ELSE fail
                     ELSE fail ;
        cons_node : fail ;
       END ;
      END ; (* unify_func *)

     PROCEDURE unify_expr ;
      BEGIN
       CASE tag_value(head(list2)) OF
         constant  : fail ;
         variable  : BEGIN
                      var_ptr := look_up(string_val(head(list2)),environ) ;
                      IF var_ptr = NIL
                       THEN make_binding(list2,list1)
                       ELSE unify := unify(list1,var_ptr,environ,new_environ) ;
                     END ;
         func      : fail ;
         cons_node : IF unify(head(list1),head(list2),environ,new_environ)
                      THEN unify := unify(tail(list1),tail(list2),new_environ,
                                          new_environ)
                      ELSE fail ;
        END ;
      END ; (* unify_expr *)

     BEGIN
      IF (list1 = NIL) AND (list2 = NIL)
       THEN
        BEGIN
         unify := true ;
         new_environ := environ ;
        END
      ELSE IF list1 = NIL
       THEN fail
      ELSE IF list2 = NIL
       THEN fail
      ELSE
       CASE tag_value(head(list1)) OF
        constant  : unify_constant ;
        variable  : BEGIN
                     var_ptr := look_up(string_val(head(list1)),environ) ;
                     IF var_ptr = NIL
                      THEN make_binding(list1,list2)
                      ELSE unify := unify(var_ptr,list2,environ,new_environ) ;
                    END ;
        func      : unify_func ;
        cons_node : unify_expr ;
       END ;
     END ; (* unify *)

   PROCEDURE test_memory ;
    BEGIN
     IF (memavail * 16.0) + total_free < 10000
       THEN collect_garbage ;
    END ; (* collect_garbage *)

    BEGIN
     saved_list := cons(list,cons(env,saved_list)) ;
     IF list = NIL
      THEN check_continue
      ELSE
       BEGIN
        p := data_base ;
        WHILE (p <> NIL) AND (NOT solved) DO
         BEGIN
          test_memory ;
          IF unify(copy_list(head(head(p)),level),head(list),env,new_env)
           THEN solve(append_list(copy_list(tail(head(p)),level),tail(list)),
                      new_env,level + 1) ;
          p := tail(p) ;
         END ;
       END ;
     saved_list := tail(tail(saved_list)) ;
    END ; (* solve *)

   BEGIN
    q_ptr := NIL ;
    tail_list(q_ptr) ;
    IF token <> '.'
     THEN error('''.'' expected.')
    ELSE IF NOT error_flag
     THEN
      BEGIN
       solved := false ;
       saved_list := cons(data_base,NIL) ;
       solve(q_ptr,NIL,0) ;
       IF NOT solved
        THEN writeln('No') ;
      END ;
   END ; (* query *)

  PROCEDURE read_new_file ;
   VAR
    new_file : text_file ;
    old_line,old_save : string132 ;
    f_name : string80 ;
   BEGIN
    IF token[1] = quote_char
     THEN delete(token,1,1) ;
    IF pos('.',token) = 0
     THEN f_name := concat(token,'.PRO')
     ELSE f_name := token ;
    IF open(new_file,f_name)
     THEN
      BEGIN
       old_line := line ;
       old_save := saved_line ;
       line := '' ;
       compile(new_file) ;
       close(new_file) ;
       line := old_line ;
       saved_line := old_save ;
       scan(source,token) ;
       IF token <> '.'
        THEN error('''.'' expected.') ;
      END
     ELSE error(concat('Unable to open ',token)) ;
   END ; (* read_new_file *)

  PROCEDURE do_exit ;
   BEGIN
    scan(source,token) ;
    IF token <> '.'
     THEN error('''.'' expected.')
     ELSE halt
   END ; (* do_exit *)

  BEGIN
   scan(source,token) ;
   WHILE token <> eof_mark DO
    BEGIN
     error_flag := false ;
     IF token = '?-'
      THEN
       BEGIN
        scan(source,token) ;
        query ;
       END
      ELSE IF token = '@'
       THEN
        BEGIN
         scan(source,token) ;
         read_new_file ;
        END
      ELSE IF toupper(token) = 'EXIT'
       THEN do_exit
      ELSE rule ;
    scan(source,token) ;
   END ;
  END ; (* compile *)


 PROCEDURE initialize ;
  BEGIN
   clrscr ;
   writeln ;
   writeln('Very Tiny Prolog - Version 1.0     [c] 1986 MicroExpert Systems') ;
   writeln ;
   in_comment := false ;
   delim_set := [' ',')','(',',','[',']',eof_mark,tab,quote_char,':',
                 '@','.','?'] ;
   text_chars := [' ' .. '~'] ;
   editing_chars := [return,back_space,esc,del_line,eof_mark] ;
   line := '' ;
   data_base := NIL ;
   free := NIL ;
   saved_list := NIL ;
   total_free := 0.0 ;
   initial_heap := HeapPtr ;
  END ; (* initialize *)


 BEGIN
  initialize ;
  compile(kbd) ;
 END.
al_free := 0.0 ;
   initial_heap := HeapPtr ;
  END ; (* initialize *)


 BEGIN
  initi