/*
Copyright (C) 1992 University of Maryland.

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies, and
that both that copyright notice and this permission notice appear
in supporting documentation.  The author makes no representations
about the suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty. Your use of
this software signifies that you are willing to take the risks of
using this software by yourself.

THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE
USE OR PERFORMANCE OF THIS SOFTWARE.
*/

/* ck.c */

/* author: Hui-Hsien Chou
           Dept. of Computer Science
	   University of Maryland, College Park
*/

/* ck.c implements the rule compression algorithm. Basically, it is an */
 /* exhausted searching algorithm which tries all possible */
 /* combinations of the rules. Details has been explained in the */
 /* technical report which accompanied this package. The program below */
 /* is uncommented, though. */

/* To compile this program, type

           cc ck.c -o ck
*/

#include <stdio.h>
#define UNLIMITED 65535

typedef struct trace {
  struct trace *child, *sibling;
  int choice;
} trace;

char board[1000][6], temp[6];
int stack[6];
int states = 8, count;
int sym_symbols = 0;
int svalue();
trace *par();
trace *newnode();
void recycle();
void doit();
void rotate();

char *symbols[] = {
".", "*", "L", "+", "-", "X", "O", "#", ";", ":"
};

main(argc, argv)
int argc;
char *argv[];
{
  int save, i, j, k, used;
  trace *start;
  char buf[100];
  
  for (i=1; i<argc; i++) {
    if (*argv[i] == '-')
      switch (argv[i][1]) {
      case 'n':
	i++;
	for (j=0; j<10 && argv[i][j]!='\0'; j++)
	  *(symbols[j]) = argv[i][j];
	if (argv[i][j]!='\0')
	  fprintf(stderr, 
		  "%s: extra symbols %s ignored (max. 10 states allowed)!\n",
		 argv[0], &(argv[i][j]));
	states = j;
	continue;
      case 'r':
	sym_symbols = 1;
	continue;
      }
    fprintf(stderr, "%s: unknown option %s ignored.\n", argv[0], argv[i]);
  }

  count = 0;
  while (fgets(buf, 100, stdin)) {
    if (strncmp(buf+6, "->", 2)==0) {
      sscanf(buf, "%c%c%c%c%c -> %c", &temp[0], &temp[1], &temp[2], 
	     &temp[3], &temp[4], &temp[5]);
      for (i=0; i<6; i++)
	board[count][i] = svalue(temp[i]);
      for (i=0; i<3; i++)
	rotate(board[count+i], board[count+i+1]);
      count += 4;
    }
  }
  for (i=0; i<6; i++)
    board[count][i] = -1;

  for (i=1, j=4; i<count/4; i++, j+=4)
    for (k=0; k<6; k++) {
      temp[k] = board[i][k]; board[i][k] = board[j][k];
      board[j][k] = temp[k];
    }

  for (i=count/4-1, save = count/4; i>=0; i--)
    if (board[i][0] == board[i][5]) {
      save--;
      for (j=0; j<6; j++) {
	temp[j] = board[i][j]; board[i][j] = board[save][j];
	board[save][j] = temp[j];
      }
    }

  stack[0] = 5;
  start = par(0, save, 0, 5, &used);
  doit(0, save, 0, 5, start);

/*
  for (i=0; i<count; i++)
    printf("%c%c%c%c%c -> %c\n", *symbols[board[i][0]], *symbols[board[i][1]],
	   *symbols[board[i][2]], *symbols[board[i][3]], 
	   *symbols[board[i][4]], *symbols[board[i][5]]);
*/
  fprintf(stderr, "count = %d, used = %d\n", count, used);
}

void rotate(a, b)
char *a, *b;
{
  int i;

  *b = *a;
  for (i=1; i<4; i++)
    b[i] = a[i+1];
  b[4] = a[1]; b[5] = a[5];

  if (sym_symbols) {
    for (i=0; i<6; i++)
      if (b[i]>1 && b[i] < 5)
	b[i]--;
      else if (b[i]==1)
	b[i] = 4;
  }
}

int svalue(i)
char i;
{
  int j;

  for (j=0; j<states; j++)
    if (*symbols[j]==i) 
      return j;
  printf("unrecognized symbol %c in svalue!\n", i);
  exit(0);
}

trace *pool=0;

trace *newnode(c, s, ch)
trace *c, *s;
int ch;
{
  trace *ptr;
  if (pool) {
    ptr = pool;
    pool = pool->sibling;
  } else
    ptr = (trace*)malloc(sizeof(trace));
  ptr->child = c; ptr->sibling = s; ptr->choice = ch;
  return ptr;
}

void recycle(p)
trace *p;
{
  if (p) {
    recycle(p->child);
    recycle(p->sibling);
    p->sibling = pool;
    pool = p;
  }
}

trace *par(l, r, d, key, used)
int l, r, d, key;
int *used;
{
  int i, j, a, ll, rr;
  char sym;
  trace *ptr, *dummy;
  struct com {
    trace *p;
    int l;
  } compare[5];

  for (i=l; i<r-1; i++)
    for (j=i+1; j<r; j++)
      if (board[i][key]>board[j][key]) {
	for (a=0; a<6; a++) {
	  temp[a] = board[i][a]; board[i][a] = board[j][a];
	  board[j][a] = temp[a];
	}
      }
  if (d>=5) {
    *used = r-l;
    return newnode(0, 0, -1);          /* ??????????????? */
  }
  ll=rr=l; *used = 0; ptr = dummy = newnode(0, 0, 0);
  while (rr<r) {
    sym = board[ll][key];
    while (board[rr][key]==sym && rr<r) rr++;
    if (key<5) {
      sym = board[ll][5]; a = 0;
      for (i=0; i<count; i++)
	if (board[i][5]!=sym) {
	  for (j=1; j<=d; j++)
	    if (board[i][stack[j]]!=board[ll][stack[j]])
	      break;
	  if (j>d) {
	    a = 1; break;
	  }
	}
      if (a==0) {
	ptr->sibling = newnode(0, 0, -1);
	(*used)++;
	ll = rr;
	ptr = ptr->sibling;
	continue;
      }
    }
    for (i=0; i<5; i++) {
      compare[i].l = UNLIMITED;
      compare[i].p = 0;
    }
    for (i=0; i<5; i++) {
      for (j=0, a=0; j<=d; j++)
	if (stack[j] == i) {
	  a = 1;
	  break;
	}
      if (a) 
	continue;
      stack[d+1] = i;
      compare[i].p = par(ll, rr, d+1, i, &(compare[i].l));
    }
    for (i=0, j=0, a=UNLIMITED; i<5; i++)
      if (compare[i].l < a) {
	a = compare[i].l;
	j = i;
      }
    ptr->sibling = newnode(compare[j].p, 0, j);
    ptr = ptr->sibling;
    (*used) += compare[j].l;
    for (i=0; i<5; i++)
      if (i!=j && compare[i].p)
	recycle(compare[i].p);
    ll = rr;
  }
  ptr = dummy->sibling;
  dummy->sibling = 0;
  recycle(dummy);
  return ptr;
}

void doit(l, r, d, key, guide)
int l, r, d, key;
trace *guide;
{
  int i, j, a, ll, rr;
  char sym;
  int checked[6];

  if (guide==0) {
    fprintf(stderr, "impossible error 0 in doit\n");
    exit(0);
  }
  for (i=l; i<r-1; i++)
    for (j=i+1; j<r; j++)
      if (board[i][key]>board[j][key]) {
	for (a=0; a<6; a++) {
	  temp[a] = board[i][a]; board[i][a] = board[j][a];
	  board[j][a] = temp[a];
	}
      }
  if (d>=5) {
    if (guide->sibling || guide->child || guide->choice != -1) {
      fprintf(stderr, "impossible error 1 in doit\n");
      exit(0);
    }
    for (i=l; i<r; i++)
      printf("%c%c%c%c%c -> %c\n", *symbols[board[i][0]], 
	     *symbols[board[i][1]],
	     *symbols[board[i][2]], *symbols[board[i][3]], 
	     *symbols[board[i][4]], *symbols[board[i][5]]);
    return;
  }
  ll=rr=l; 
  while (rr<r) {
    sym = board[ll][key];
    while (board[rr][key]==sym && rr<r) rr++;
    if (key<5) {
      sym = board[ll][5]; a = 0;
      for (i=0; i<count; i++)
	if (board[i][5]!=sym) {
	  for (j=1; j<=d; j++)
	    if (board[i][stack[j]]!=board[ll][stack[j]])
	      break;
	  if (j>d) {
	    a = 1; break;
	  }
	}
      if (a==0) {
	if (guide->child || guide->choice != -1) {
	  fprintf(stderr, "impossible error 2 in doit\n");
	  exit(0);
	}
	guide = guide->sibling;
	for (i=0; i<6; i++)
	  checked[i]=0;
	for (i=0; i<=d; i++)
	  checked[stack[i]] = 1;
	for (i=0; i<5; i++)
	  if (checked[i])
	    printf("%c", *symbols[board[ll][i]]);
	  else
	    printf("_");
	printf(" -> %c\n", *symbols[board[ll][5]]);
	ll = rr;
	continue;
      }
    }
    if (guide->child==0 || guide->choice<0) {
      fprintf(stderr, "impossible error 3 in doit\n");
      exit(0);
    }
    stack[d+1] = guide->choice;
    doit(ll, rr, d+1, guide->choice, guide->child);
    guide = guide->sibling;
    ll = rr;
  }
  if (guide) {
    fprintf(stderr, "impossible error 4 in doit\n");
    exit(0);
  }
}
