/*
 * File: bz.m256.c
 *   By: Dave Hiebeler
 *       hiebeler@turing.cs.rpi.edu
 *       February 1990
 *
 * The version of the Belousov-Zhabotinski ("BZ") reaction described in
 * the CAM book by Toffoli and Margolus (also discussed as the "hodgepodge"
 * model in A.K. Dewdney's "Computer Recreations" colum in Scientific
 * American, sometime in 1989).
 *
 * The low bitplane represents the presence of a "tubeworm" (to use the
 * language of Toffoli and Margolus).  If a worm is present and sees
 * too many neighbors also active, it retreats into its tube and hides
 * there for a few time-steps  (a timer is on the upper 2 bitplanes).
 */


#include "nborhood.h"

#define WORM 0x04	/* mask to get low bitplane */
#define CLOCK 0x03


byte bz();

void
init_function()
{
    update_function = bz;
    parm1 = 3;
}


byte
bz(nbors)
moore_nbors *nbors;
{
    int nbor_sum;
    byte ret_val;
    
    Get_moore_nbors;
    ret_val = 0;
    nbor_sum = (tl&WORM) + (l&WORM) + (bl&WORM) + (t&WORM) + (b&WORM) +
	(tr&WORM) + (r&WORM) + (br&WORM);
    nbor_sum = nbor_sum >> 2;
    if (!(c&CLOCK))
	ret_val = 0x04;
    if ((nbor_sum >= parm1) || (nbor_sum == parm2))
	ret_val |= 0x08;
    if ((c&0x0c) == 0x0c)
	ret_val |= 3;
    else if (c&0x03)
	ret_val |= (c&0x03)-1;
    return ret_val;
}
