;;;; -*- mode:Lisp; syntax:Common-Lisp; package:user -*- ;;;;
;;;; Copyright 1992 Patrick H. Winston.  All rights reserved.
;;;; Version 1.1.1, copied from master file on 23 Apr 93       
;;;; 
;;;; This software is licensed by Patrick H. Winston (licensor) for
;;;; instructional use with the textbooks ``Artificial Intelligence,'' by
;;;; Patrick H. Winston, and ``Lisp,'' by Patrick H. Winston and Berthold
;;;; K. P. Horn.  Your are free to make copies of this software and
;;;; modify it for such instructional use as long as:
;;;; 1. You keep this notice intact.
;;;; 2. You cause any modified files to carry a prominent notice stating
;;;;    that you modified the files and the date of your modifications.
;;;; This software is licensed ``AS IS'' without warranty and the licensor
;;;; shall have no liability for any alleged defect or damages.

;;;; REMARKS

#|

This version does not use delayed evaluation.

|#

;;;; BASIC ACCESS FUNCTIONS

(defun make-empty-stream () 'nil)

(defun stream-endp (stream) (endp stream))

(defun stream-first (stream) (first stream))

(defun stream-rest (stream) (rest stream))

(defun stream-cons (object stream) (cons object stream))

(defun stream-append (&rest streams)
  (apply #'append streams))

(defun stream-concatenate (streams) (apply #'append streams))

(defun stream-transform (procedure stream)
  (mapcar procedure stream))

(defun stream-member (object stream)
  (member object stream :test #'equal))

(defmacro stream-remember (object variable)
  `(unless (member ,object ,variable :test #'equal)
     (setf ,variable
	   (append ,variable
		   (cons ,object (make-empty-stream))))
     ,object))



