;;;; -*- Mode:LISP; Syntax:COMMON-LISP; Package:GBB; Base:10 -*-
;;;; *-* File: VAX11:DIS$DISK:[GBB.V-120.LOCAL]VARIABLES.LISP *-*
;;;; *-* Edited-By: Cork *-*
;;;; *-* Last-Edit: Thursday, September 15, 1988  12:55:53 *-*
;;;; *-* Machine: Caliban (Explorer II,  Microcode EXP2-UCODE 308 for the Explorer Lisp Microprocessor) *-*
;;;; *-* Software: TI Common Lisp System 4.61 *-*
;;;; *-* Lisp: TI Common Lisp System 4.61 (1.0) *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *
;;;; *                   GBB GLOBAL VARIABLES AND CONSTANTS
;;;; *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; Written by: Kevin Gallagher
;;;             Department of Computer and Information Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; This code was written as part of the GBB (Generic Blackboard) system at
;;; the Department of Computer and Information Science (COINS), University of 
;;; Massachusetts, Amherst, Massachusetts 01003.
;;;
;;; Copyright (c) 1986, 1987, 1988 COINS.  
;;; All rights are reserved.
;;;
;;; Development of this code was partially supported by:
;;;    Donations from Texas Instruments, Inc.;
;;;    NSF CER grant DCR-8500332;
;;;    ONR URI contract N00014-86-K-0764.
;;;
;;; Permission to copy this software, to redistribute it, and to use it for
;;; any purpose is granted, subject to the following restrictions and
;;; understandings.
;;;
;;; 1.  Title and copyright to this software and any material associated
;;; therewith shall at all times remain with COINS.  Any copy made of this
;;; software must include this copyright notice in full.
;;;
;;; 2.  The user acknowledges that the software and associated materials
;;; are provided as a research tool that remains under active development
;;; and is being supplied ``as is'' for the purposes of scientific
;;; collaboration aimed at further development and application of the
;;; software and the exchange of technical data.
;;;
;;; 3.  All software and materials developed as a consequence of the use of
;;; this software shall duly acknowledge such use, in accordance with the
;;; usual standards of acknowledging credit in academic research.
;;;
;;; 4.  Users of this software agree to make their best efforts to inform
;;; the COINS GBB Development Group of noteworthy uses of this software.
;;; The COINS GBB Development Group can be reached at:
;;;
;;;     GBB Development Group
;;;     C/O Dr. Daniel D. Corkill
;;;     Department of Computer and Information Science
;;;     Lederle Graduate Research Center
;;;     University of Massachusetts
;;;     Amherst, Massachusetts 01003
;;;
;;;     (413) 545-0156
;;;
;;; or via electronic mail:
;;;
;;;     GBB@CS.UMass.Edu
;;;
;;; Users are further encouraged to make themselves known to this group so
;;; that new releases, bug fixes, and tutorial information can be
;;; distributed as they become available.
;;;
;;; 5.  COINS makes no representations or warranties of the merchantability
;;; or fitness of this software for any particular purpose; that uses of
;;; the software and associated materials will not infringe any patents,
;;; copyrights, trademarks, or other rights; nor that the operation of this
;;; software will be error-free.  COINS is under no obligation to provide
;;; any services, by way of maintenance, update, or otherwise.  
;;;
;;; 6.  In conjunction with products or services arising from the use of
;;; this material, there shall be no use of the name of the Department of
;;; Computer and Information Science or the University of Massachusetts in
;;; any advertising, promotional, or sales literature without prior written
;;; consent from COINS in each case.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  This file contains the definitions of many GBB global variables and
;;;  constants.   For most variables it is more natural to define them near the
;;;  place where they are used.
;;;
;;;  Variables are defined here for two reasons.  Some variables are here
;;;  because there is no better place to put their definition.  Others are here
;;;  because they are referred to in a file that is loaded before the file that
;;;  would be natural to define them in is loaded.
;;;
;;;  02-22-87 File Created.  (Gallagher)
;;;  06-27-88 Added *SLOT-OPTION-KEYWORDS* and *LINK-OPTION-KEYWORDS*.
;;;           (Gallagher)
;;;  07-05-88 Added *UNIT-INFORMATION-HASH-TABLE*.  (Gallagher)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

(in-package 'GBB)

(use-package '(lisp umass-extended-lisp))

(proclaim `(optimize (speed ,*gbb-optimize-speed*)
                     (safety ,*gbb-optimize-safety*)))

;;; ===========================================================================

;;; Hash tables used to store information about GBB objects.

(defvar *blackboard-hash-table*         (make-hash-table :test 'eq))

(defvar *space-hash-table*              (make-hash-table :test 'eq))

(defvar *unit-description-hash-table*   (make-hash-table :test 'eq))

(defvar *unit-information-hash-table*   (make-hash-table :test 'eq))

(defvar *link-description-hash-table*   (make-hash-table :test 'eq))

(defvar *index-structure-hash-table*    (make-hash-table :test 'eq))
  
  

;;; *ALL-UNITS* is a list of all the unit types that have been defined.
;;; It is a list of symbols).  Unit types are added by DEFINE-UNIT.  The
;;; function RESET-GBB sets *ALL-UNITS* to nil.  It is used in several
;;; functions, such as CHECK-UNIT-LINKS, that default to processing all
;;; unit types.

(defvar *all-units* nil
  "List of all unit types.")


;;; %%RUN-EVENTS%% controls whether events are run during unit creation,
;;; unit deletion, LINKF, etc.  Use the macros WITH-EVENTS-ENABLED and
;;; WITH-EVENTS-DISABLED to change the value of this variable.  The value
;;; of %%RUN-EVENTS%% should normally be true.  This capability is
;;; included primarily for save-blackboard which needs to be able to
;;; suppress events when restoring unit instances.

(defvar %%run-events%% t
  "Controls running of events during MAKE-<unit-type>,
   DELETE-<unit-type>, LINKF, etc.")


;;; Each unit has a set of events that apply to the whole unit.
;;; They are stored as an association list in the EVENTS slot
;;; of the unit-description.  *EVENT-TYPES* is a list of these
;;; event names.  Use the function GET-UNIT-EVENTS to access
;;; these events in a unit type.

(defconstant *event-types*
	     '(:creation-events
	       :deletion-events
               :add-to-space-events
               :delete-from-space-events
	       :slot-initialization-events
	       :slot-access-events
	       :slot-update-events
	       :link-initialization-events
               :link-access-events
	       :link-update-events
	       :unlink-events)
  "List of event names associated with a unit.")


(defconstant *slot-option-keywords*
             '(:type
               :read-only
               :static
               :dynamic
               :private
               :initialization-events
               :access-events
               :update-events
               :save-print-function)
  "List of slot option keywords.")

(defconstant *link-option-keywords*
             '(:private
               :initialization-events
               :access-events
               :update-events
               :unlink-events)
  "List of link option keywords.")


;;; *BLACKBOARD-DATABASE* is a list of trees that make up the ``blackboard
;;; database''.  The leaves of the trees are space instances.  The function
;;; INSTANTIATE-BLACKBOARD-DATABASE adds to the database.

(defvar *BLACKBOARD-DATABASE* nil
  "The blackboard database.  A list of nodes which are the roots
   of bb/space trees.")

(defvar *SPACE-INSTANCE-LIST* nil
  "List of space instances in the current blackboard database.")

(defvar *SPACE-INSTANCE-TABLE* nil
  "Hash table of space instances in the current blackboard database.")



(defvar *UNIT-MAPPINGS-FOR-SPACE-PATHS* nil
  "Association list of filled out bb/space paths and unit mappings.")



;;; These variables provide hooks into the some of the GBB internals.
;;; They are primarily used for graphics stuff.

(defvar *INSTANTIATE-BB-DB-HOOK-FUNCTIONS* nil
  "A list of functions which will be called after each call to
   INSTANTIATE-BLACKBOARD-DATABASE.  Each element of the list
   should be a function of no (zero) arguments.")

(defvar *CLEAR-SPACE-HOOK-FUNCTIONS* nil
  "A list of functions which will be called at each call to CLEAR-SPACE
   or CLEAR-BLACKBOARD-DATABASE.  Each element of the list should be a
   function of one argument: the space instance being cleared.")

(defvar *INSERT-UNIT-HOOK-FUNCTIONS* nil
  "A list of functions which will be called after each call to
   INSERT-UNIT-ON-SPACE-INSTANCE.  Each element of the list should be a
   function of two arguments: the unit instance that was added,
   and the space instance that it was placed on.")

(defvar *MOVE-UNIT-HOOK-FUNCTIONS* nil
  "A list of functions which will be called after each call to
   MOVE-UNIT-ON-SPACE-INSTANCE.  Each element of the list should
   be a function of two arguments: the unit instance that was
   added, and the space instance that it was moved on.")

(defvar *DELETE-UNIT-HOOK-FUNCTIONS* nil
  "A list of functions which will be called after each call to
   DELETE-UNIT-FROM-SPACE-INSTANCE.  Each element of the list should be a
   function of two arguments: the unit instance that was deleted,
   and the space instance that it was deleted from.")


;;; ---------------------------------------------------------------------------
;;;                                End of File
;;; ---------------------------------------------------------------------------
