;;;; -*- Mode:LISP; Syntax:COMMON-LISP; Package:GBB; Base:10 -*-
;;;; *-* File: VAX11:DIS$DISK:[GBB.V-120.LOCAL]STRUCTURES.LISP *-*
;;;; *-* Edited-By: Cork *-*
;;;; *-* Last-Edit: Thursday, September 15, 1988  12:51:07 *-*
;;;; *-* Machine: Caliban (Explorer II,  Microcode EXP2-UCODE 308 for the Explorer Lisp Microprocessor) *-*
;;;; *-* Software: TI Common Lisp System 4.61 *-*
;;;; *-* Lisp: TI Common Lisp System 4.61 (1.0) *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *
;;;; *                        STRUCTURE DEFINITIONS
;;;; *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; Written by: Kevin Gallagher
;;;             Department of Computer and Information Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; This code was written as part of the GBB (Generic Blackboard) system at
;;; the Department of Computer and Information Science (COINS), University of 
;;; Massachusetts, Amherst, Massachusetts 01003.
;;;
;;; Copyright (c) 1986, 1987, 1988 COINS.  
;;; All rights are reserved.
;;;
;;; Development of this code was partially supported by:
;;;    Donations from Texas Instruments, Inc.;
;;;    NSF CER grant DCR-8500332;
;;;    ONR URI contract N00014-86-K-0764.
;;;
;;; Permission to copy this software, to redistribute it, and to use it for
;;; any purpose is granted, subject to the following restrictions and
;;; understandings.
;;;
;;; 1.  Title and copyright to this software and any material associated
;;; therewith shall at all times remain with COINS.  Any copy made of this
;;; software must include this copyright notice in full.
;;;
;;; 2.  The user acknowledges that the software and associated materials
;;; are provided as a research tool that remains under active development
;;; and is being supplied ``as is'' for the purposes of scientific
;;; collaboration aimed at further development and application of the
;;; software and the exchange of technical data.
;;;
;;; 3.  All software and materials developed as a consequence of the use of
;;; this software shall duly acknowledge such use, in accordance with the
;;; usual standards of acknowledging credit in academic research.
;;;
;;; 4.  Users of this software agree to make their best efforts to inform
;;; the COINS GBB Development Group of noteworthy uses of this software.
;;; The COINS GBB Development Group can be reached at:
;;;
;;;     GBB Development Group
;;;     C/O Dr. Daniel D. Corkill
;;;     Department of Computer and Information Science
;;;     Lederle Graduate Research Center
;;;     University of Massachusetts
;;;     Amherst, Massachusetts 01003
;;;
;;;     (413) 545-0156
;;;
;;; or via electronic mail:
;;;
;;;     GBB@CS.UMass.Edu
;;;
;;; Users are further encouraged to make themselves known to this group so
;;; that new releases, bug fixes, and tutorial information can be
;;; distributed as they become available.
;;;
;;; 5.  COINS makes no representations or warranties of the merchantability
;;; or fitness of this software for any particular purpose; that uses of
;;; the software and associated materials will not infringe any patents,
;;; copyrights, trademarks, or other rights; nor that the operation of this
;;; software will be error-free.  COINS is under no obligation to provide
;;; any services, by way of maintenance, update, or otherwise.  
;;;
;;; 6.  In conjunction with products or services arising from the use of
;;; this material, there shall be no use of the name of the Department of
;;; Computer and Information Science or the University of Massachusetts in
;;; any advertising, promotional, or sales literature without prior written
;;; consent from COINS in each case.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  01-08-86 File Created.  (Gallagher)
;;;  ...      Many changes.  (Gallagher and Johnson)
;;;  11-19-86 Added a package slot to unit-description.  (Gallagher)
;;;  01-08-87 Added and ELEMENT-TYPE slot to index-structure.  Changed the
;;;           meaning of the TYPE slot.  (Gallagher)
;;;  01-13-87 Added INTERNAL-CONSTRUCTOR and EXTERNAL-CONSTRUCTOR slots to
;;;           unit-description.  Removed HASH-P from unit-description.  Changed
;;;           space-instance to %%SPACE-INSTANCES%% in basic-unit.  (Gallagher)
;;;  01-20-87 Added DUMMY-HASH-TABLE to UNIT-DESCRIPTION.  (Johnson)
;;;  02-06-87 Added NAME slot to basic-unit.  (Gallagher)
;;;  03-06-87 Added LENGTH to pattern-object; and N-MATCH and N-MISMATCH to
;;;           search-pattern.  (Gallagher)
;;;  08-11-87 Changed SLOT by adding MODIFIABLE and INDEX-SOURCE-P slots and
;;;           deleting the READ-ONLY slot.  This was done to implement "moving
;;;           units."  (Gallagher)
;;;  10-22-87 Changes necessary for storing subtypes of unit types on spaces:
;;;           - Removed UNITS-WITHOUT-MAPPINGS from SPACE-TYPE.
;;;           - Added IN-USE to UNIT-MAPPING.
;;;           - Added BUCKET-SPECS to UNIT-MAPPING-INDEX.  (Gallagher)
;;;  04-28-88 Added PRIVATE and SPECIALISED slots to basic-slot.  (Gallagher)
;;;  07-05-88 Split the UNIT-DESCRIPTION into two parts: UNIT-DESCRIPTION which
;;;           will contain only static (read-only) information about a unit;
;;;           and UNIT-INFORMATION which will contain dynamic (modifiable)
;;;           information about a unit.  (Gallagher)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

(in-package 'GBB :use '(lisp umass-extended-lisp))

(use-package '(lisp umass-extended-lisp))

(proclaim `(optimize (speed ,*gbb-optimize-speed*)
                     (safety ,*gbb-optimize-safety*)))

;;; ===========================================================================



(defstruct (space-type
	     (:conc-name "SPACE.")
	     (:print-function print-type-and-name))
  "Description of a space."

  name			;; Symbol naming this space
  (documentation nil)
  (dimensions nil)	;; Dimensions of this space
  (units nil)		;; Units that can be stored on this space
  (unit-mappings nil)	;; Unit-mappings that apply to this space
  )


(defstruct (space-dimension
	     (:conc-name "DIMENSION.")
	     (:print-function print-type-and-name)
	     (:constructor nil))
  "Base part a space dimension.  All space dimensions have names and types.
   This structure is included in other dimension description defstructs."

  name			;; Symbol naming this dimension
  type			;; Type of this dimension (e.g., :ordered, :enumerated)
  )


(defstruct (ordered-dimension
	     (:include space-dimension)
	     (:conc-name "ODIM.")
	     (:print-function print-type-and-name))
  "Description of a :ordered dimension type."

  (range nil)		;; The range -- a cons of (min . max)
  )


(defstruct (enumerated-dimension
	     (:include space-dimension)
	     (:conc-name "EDIM.")
	     (:print-function print-type-and-name))
  "Description of an :enumerated dimension type."

  (labelset nil)	;; The labelset of the dimension
  (test 'eq)		;; The test function
  )


(defstruct (space-instance
	     (:conc-name "SPACE-INSTANCE.")
	     (:print-function space-instance-print-function))
  "Information that is specific to each instance of the space."

  space			;; The space that this is an instance of
  name                  ;; Symbol naming the space
  (parent nil)		;; Parent blackboard or nil
  (data nil)		;; The storage for this space instance.  If the space
			;; is unstructured then this is just a list of unit
			;; instances.  Otherwise, its an alist of
                        ;;   ((unit-mapping1 . (((index1 index2 ...) . array)
                        ;;                      ((index3) . array)
			;;                      ...))
                        ;;    (unit-mapping2 . (...))
			;;    ...)
  (path nil)		;; BB/Space path to this instance
  (path-structure nil)  ;; Path structure for this instance
  )


(defstruct (blackboard
	     (:conc-name "BB.")
	     (:print-function print-type-and-name))
  "Description of a blackboard."

  name                  ;; Symbol naming this blackboard
  (documentation nil)
  (spaces nil)          ;; Spaces below this blackboard
  (blackboards nil)     ;; Blackboards below this blackboard
  )


;; There are no explicit blackboard instances.  Each database-node is a
;; sort of blackboard instance.

(defstruct (database-node
	     (:conc-name "DB-NODE.")
	     (:print-function db-node-print-function))
  "A node in the blackboard database tree."

  name			;; Symbol naming this space or bb
  type			;; A space or a blackboard (the object not it's name)
  (parent nil)          ;; Parent node (or nil if this is the root)
  start			;; Inclusive index of the first copy of this bb or space
  end			;; Exclusive index of the last copy
  vector		;; Vector of space or bb instances
  )

(defstruct (path-structure
	     (:conc-name "PATH-STRUCTURE.")
	     (:print-function path-structure-print-function))
  "A blackboard/space path"
  path-value            ;; a path spec list.
  space-instance        ;; the corresponding space instance.
  )


(defstruct (index-structure
	     (:conc-name "INDEX-STRUCTURE.")
	     (:print-function print-type-and-name))
  "Information about an index structure."

  name                  ;; Name of the index structure
  (documentation nil)
  (type nil)            ;; Type of the index structure: (:scalar, :list, :composite)
  (element-type nil)    ;; If a composite index structure, the type of the composite
			;;   elements.  If a single object, the type of the element.
  (composite-type nil)  ;; Type of the composite or nil
  (composite-index nil) ;; Which index is used in length matches
  (symbols nil)         ;; List of index symbols
  (functions nil)       ;; Alist of ((index type path ...) ...)
  (index-list nil)	;; Original index specification
  )


;;; This defines how to get the value of an index from a unit.  A
;;; list of unit-indexes is stored in the x-INDEXES slot of the unit
;;; description.
;;;
;;; If the index-structure slot is nil then the value of the slot
;;; is the value of the index.

(defstruct (unit-index
	     (:conc-name "UNIT-INDEX.")
	     (:print-function print-type-and-name))
  "How to get index values from a unit."

  name			;; Name of the index (e.g., time, x, ...)
  package		;; Home package of the index name (used by path indexes)
  datatype		;; The expected datatype of the slot
  element-type		;; :point, :range, etc.
  index-structure	;; Index type -- an index-structure or nil
  slot-name		;; Slot in the unit that contains this index
  slot-accessor		;; The slot accessor function name
  functions		;; Functions to extract the index from the slot
			;;   (this will always be a list)
  offset		;; Index into the %%indexes%% slot of the unit instance
  )


(defstruct (index-info
	     (:conc-name "INDEX-INFO.")
	     (:print-function print-type-and-name))
  "Information about the indexes associated with a unit."

  name			;; Name of the index (e.g., time, x, y, ...)
  type			;; Type of the index (e.g., :point, :label)
  (composite-index nil) ;; Name of the composite index if this index is part of
			;;   a composite or nil if not
  offset		;; Index into the sequence of index values
  )


(defstruct (unit-mapping
	     (:conc-name "UNIT-MAPPING.")
	     (:print-function unit-mapping-print-function))
  "Defines the way units are stored on a space."

  documentation
  units			;; Unit types that participate in this mapping
  spaces		;; Spaces that participate in this mapping
  (indexes nil)
  (umi-list nil)	;; List of unit-mapping-indexes
  (in-use nil)		;; True if this mapping has been used in a space instance.
			;;   If it is in use then it must not be modified.
  )


(defstruct (unit-mapping-index
	     (:conc-name "UMI.")
	     (:print-function print-type-and-name))
  "Defines how to store and access units based on an index."

  name			;; Name of this index (e.g., time, x, ...)
  type			;; Type of this index (e.g., :subranges)
  bucket-specs		;; Describes the desired buckets as given by the user
  buckets		;; Buckets which map index values to array indexes
  array-dim		;; The dimension of the array for this index
  array-size		;; Size of this dimension
  )


(defstruct (bucket
	     (:conc-name "BUCKET.")
	     (:print-function bucket-print-function))
  "The mapping from data values to array indexes for dimensions
   of type range."

  start			;; Index of the first bucket
  end			;; Index of the last bucket
  offset		;; Offset into the array of the first bucket
  count			;; Number of buckets
  width			;; Width of each bucket
  )


(defstruct (basic-slot
             (:conc-name "BASIC-SLOT.")
	     (:constructor nil))
  "Slots that need to be included in both slots and links.
   This structure is never instantiated by itself."

  name                  ;; Name of the slot or link
  unit                  ;; Unit that the slot or link is contained in
  (initialization-events nil)
			;; List of initialization events
  (access-events nil)   ;; List of access events
  (update-events nil)   ;; List of update events
  (inherited-p nil)     ;; T if this slot was included from another unit, nil otherwise
  (private nil)         ;; T if this slot is private --- No accessor and update functions
                        ;;   will be defined when PRIVATE = T and INHERITED = T.
  )

(defstruct (link
	     (:conc-name "LINK.")
	     (:print-function link-print-function)
             (:include basic-slot))
  "Describes a unit link."

  singular              ;; T if this link is singular, nil otherwise
  dimensions            ;; Nil if not a vector of links; a list of dimensions otherwise.
  accessor		;; Name of the unit's internal accessor function
			;;   this link
  i-link-name           ;; Inverse link slot name
  i-link-unit           ;; Inverse link unit name
  i-link-singular       ;; T if the i-link is singular, nil otherwise
  i-link-accessor	;; Name of the internal accessor function for
			;;   the inverse link
  (unlink-events nil)	;; List of unlink events
  )


(defstruct (slot
	     (:conc-name "SLOT.")
	     (:print-function print-type-and-name)
             (:include basic-slot))
  "Information about a slot in a unit."

  (type t)		;; Type of this slot as given by the :type slot option
  (initial-value nil)   ;; Initial value of the slot
  (initial-value-present-p nil)
  			;; Flag indicating that an initial value was actually supplied
  (save-print-function nil)
			;; Function to print a slot readably.  The function
			;;   should accept two arguments: a stream and the slot value.
  (modifiable :dynamic)	;; If an index uses this slot this indicates whether the
			;;   slot can be changed.  The value will be one of
			;;   :dynamic, :static, :read-only.
  (index-source-p nil)	;; T if the slot is used as a source for a dimensional index
  (specialised nil)     ;; T if this slot augments an included slot
  )


;;; Unit-Description and Unit-Information
;;;
;;; Each unit has two structures which hold information about the unit.
;;; The unit-description structure contains information that is computed at
;;; compile time and is never changed.  The unit-information structure (not
;;; a great name, i know) is initialised at load time and contains data
;;; structures that must be changed at runtime.  This split is so that lisp
;;; implementations that are agressive about making quoted data read-only
;;; won't complain and so that the static data can be made read-only
;;; safely.

;;; The slot-list, link-list, d-index-list, and p-index-list slots hold the
;;; actual arguments given to define-unit and are used to handle the
;;; :include option.  The slots, links, d-indexes and p-indexes slots are
;;; lists of slots, links, and unit-indexes (i.e., structures).

(defstruct (unit-description
	     (:conc-name "UNIT.")
	     (:print-function print-type-and-name))
  "Static information about a unit."

  name	      		;; Name of the unit for this description
  (documentation nil)
  package		;; Package that the unit was defined in
  (name-and-options nil);; NAME-AND-OPTIONS argument to define-unit
  (slot-list nil)	;; SLOTS argument to define-unit
  (d-index-list nil)	;; DIMENSIONAL-INDEXES argument to define-unit
  (p-index-list nil)	;; PATH-INDEXES argument to define-unit
  (link-list nil)	;; LINKS argument to define-unit
  (paths nil)		;; PATHS argument to define-unit
  (included nil)	;; Name of the included unit if any
  (subtypes nil)        ;; List of all subtypes of this unit (this unit not included)
  (supertypes nil)      ;; List of all supertypes of this unit (this unit not included)
  (d-indexes nil)	;; List of unit indexes for dimensions
  (p-indexes nil)	;; List of unit indexes for the path
  (links nil)		;; List of link structures
  (slots nil)		;; List of slot structures
  (name-function nil)	;; Default name function
  (print-function nil)	;; Unit print function if supplied
  external-constructor	;; Name of the unit constructor function
  internal-constructor	;; Name of the defstruct construction function
  external-conc-name	;; Conc name for publicly available slot accessors
  internal-conc-name	;; Conc name to really modify the slots
  (events nil)		;; List of event types.
  path-generation-fn	;; Function to generate bb/space paths
  )


(defstruct (unit-information
	     (:conc-name "UNIT-INFO.")
	     (:print-function print-type-and-name))
  "Modifiable information about a unit."

  name                  ;; Name of the unit
  (hash-table nil)	;; Hash table of unit instances
  (dummy-hash-table nil);; Hash table of dummy unit instances
  )


;;; This structure is included in every unit.  Percent signs are used
;;; for hidden slots to avoid possible conflicts with user slots.

(defstruct (basic-unit
	     (:conc-name "BASIC-UNIT.")
	     (:constructor nil))
  "Slots that need to be included in every unit.  This structure is
   never instantiated by itself."

  ;; This slot is used by find-units to record that a unit has been
  ;; processed and whether it is selected.  I use several bits in one slot
  ;; (rather than several slots each of which is a bit) to save storage in
  ;; implementations that don't optimize storage. 
  (%%mark-1%% 0 :type fixnum)

  ;; Indexes stored in a canonical form
  (%%indexes%% nil)

  ;; The space instance that this unit is stored on.
  (%%space-instances%% nil)

  ;; The name of the unit.  If the unit is anonymous this slot will contain
  ;; the symbol :anonymous.
  (name :anonymous)
  )


(defconstant *internal-unit-slots* '(%%mark-1%% %%indexes%% %%space-instances%%)
  "List of slot names in BASIC-UNIT that the user should not touch.")

(defconstant *external-unit-slots* '(name)
  "List of slot names in BASIC-UNIT that the user should know about.")


(defstruct (event-type
	     (:conc-name "EVENT-TYPE.")
	     (:print-function event-type-print-function))
  "Collection of events of a particular type."

  type			;; Type of these events (e.g., :creation-events)
  (functions nil)	;; List of the actual functions to use
  (records nil)		;; List of event records.
  )


(defstruct (event-record
	     (:conc-name "EVENT.")
	     (:print-function event-record-print-function))
  "Information about a single event."

  (name nil)		;; Name of the event
  (flag nil)		;; Modifier, if any (e.g., :never-inherit)
  )


(defstruct (search-pattern
	     (:conc-name "PATTERN.")
	     (:print-function defstruct-print-function))
  "Pattern information used in FIND-UNITS."

  match-function	;; How to compare the unit instance with the pattern
  before-extras		;; Number of composite index elements that fall
  after-extras		;;   outside the pattern
		;; The following three slots indicate the number number of composite
		;; index elements that can (match | mismatch | be skipped) as it
		;; appears in the pattern (e.g., (:percentage 80)).
  match			;; Lower limit on number of composite index elements
			;;   that must match
  mismatch		;; Upper limit on number of composite index elements
			;;   that can mismatch
  skipped		;; Upper limit on number of composite index elements
			;;   that can be skipped
  n-match		;; Actual number that must match
  n-mismatch		;; Actual number that may mismatch
  n-skipped		;; Actual number that may be skipped
  contiguous		;; Whether matching elements must be contiguous.
  pattern-object	;; The pattern object
  )


(defstruct (pattern-object
	     (:conc-name "PATTERN-OBJECT.")
	     (:print-function pattern-object-print-function))
  "Information about a pattern object."

  (all-indexes nil)	;; All the indexes in this pattern
  (length 0)		;; Length of the longest composite or 0 if there are
			;;   no composites
  (c-type nil)		;; Type of the composite (:set, :series, etc...)
  (c-index nil)		;; The composite index
  (c-indexes nil)	;; Indexes that are parts of a composite -- in order
  (c-types nil)		;; Types of the composite indexes
  (c-data nil)		;; Values of the composite indexes
  (n-indexes nil)	;; Indexes that are not part of a composite -- in order
  (n-types nil)		;; Types of the non-composite indexes
  (n-data nil)		;; Values of the non-composite indexes
  )



;;;;
;;;; Print functions for the structures
;;;;

(defun defstruct-print-function (object stream depth)
  "Simplest defstruct printer.  Prints the object's type and address."
  (declare (ignore depth))
  (format stream "#<~:@(~a~) ~x>"
          (type-of object)
	  (%pointer object)))

(defun print-type-and-name (object stream depth)
  "Print a structure that has a slot called ``name''."
  (declare (ignore depth))
  (format stream "#<~:@(~a~) ~s ~x>"
          (type-of object)
	  (get-structure-slot object 'name)
	  (%pointer object)))

(defun space-instance-print-function (si stream depth)
  (declare (ignore depth))
  (format stream "#<SPACE-INSTANCE ~s ~x>"
          (space-instance.name si)
	  (%pointer si)))

(defun path-structure-print-function (ps stream depth)
  (declare (ignore depth))
  (format stream
          (if *print-escape* "#<PATH-STRUCTURE ~s>" "~s")
          (get-path-from-path-structure ps)))

(defun db-node-print-function (node stream depth)
  (declare (ignore depth))
  (format stream "#<DATABASE-NODE ~s (~d ~d)>"
	  (db-node.name node) (db-node.start node) (db-node.end node)))

(defun unit-mapping-print-function (mapping stream depth)
  (declare (ignore depth))
  (format stream "#<UNIT-MAPPING ~s (" (unit-mapping.units mapping))
  (do* ((space-list (unit-mapping.spaces mapping) (cdr space-list))
        (space (first space-list) (first space-list)))
       ((endp space-list))
    (princ (if (symbolp space) space (space.name space))
           stream)
    (when (cdr space-list)
      (princ " " stream)))
  (format stream ")~{ ~s~}>" (unit-mapping.indexes mapping)))

(defun bucket-print-function (bucket stream depth)
  (declare (ignore depth))
  (format stream "#<BUCKET ~d ~d ~d ~d ~d>"
          (bucket.start bucket) (bucket.end bucket)
          (bucket.offset bucket) (bucket.count bucket)
          (bucket.width bucket)))

;; This print function is conditionalized because it is
;; used by check-unit-links to print the existing links.

(defun link-print-function (link stream depth)
  (declare (ignore depth))
  (cond (*print-escape*
	 (format stream "#<LINK ~s ~:[~;:SINGULAR ~](~s ~s~:[~; :SINGULAR~])>"
		 (link.name link) (link.singular link)
		 (link.i-link-unit link) (link.i-link-name link)
		 (link.i-link-singular link)))
	(t (format stream "(~a ~:[~;:SINGULAR ~](~a ~a~:[~; :SINGULAR~]))"
		   (link.name link) (link.singular link)
		   (link.i-link-unit link) (link.i-link-name link)
		   (link.i-link-singular link)))))

(defun pattern-object-print-function (object stream depth)
  (declare (ignore depth))
  (format stream "#<PATTERN-OBJECT ~s ~s>"
	  (pattern-object.c-indexes object) (pattern-object.n-indexes object)))

(defun event-type-print-function (object stream depth)
  (declare (ignore depth))
  (cond (*print-escape*
	 (format stream "#<EVENT-TYPE ~s ~a>"
		 (event-type.type object) (event-type.functions object)))
	(t (format stream "(~s~{ ~a~})"
		   (event-type.type object) (event-type.records object)))))

(defun event-record-print-function (object stream depth)
  (declare (ignore depth))
  (cond (*print-escape*
	 (format stream "#<EVENT-RECORD ~s~@[ ~s~]>"
		 (event.name object) (event.flag object)))
	;; If not printing ``readably'' (*print-escape* is false) then
	;; print as it appears in define-unit.
	((or (null (event.name object))
	     (null (event.flag object)))
	 ;; One of name or flag must be non-nil.
	 (format stream "~s" (or (event.name object) (event.flag object))))
	(t (format stream "(~s ~s)" (event.name object) (event.flag object)))))


;;; --------------------------------------------------------------------------
;;;                                End of File
;;; --------------------------------------------------------------------------
