;;;; -*- Mode:LISP; Syntax:COMMON-LISP; Package:USER; Base:10 -*-
;;;; *-* File: VAX11:DIS$DISK:[GBB.V-120.LOCAL.SIMPLE-SHELL]SIMPLE-SHELL-EXAMPLE.LISP *-*
;;;; *-* Last-Edit: Thursday, September 15, 1988  14:18:16; Edited-By: Cork *-*
;;;; *-* Machine: Caliban (Explorer II,  Microcode EXP2-UCODE 308 for the Explorer Lisp Microprocessor) *-*
;;;; *-* Software: TI Common Lisp System 4.61 *-*
;;;; *-* Lisp: TI Common Lisp System 4.61 (1.0) *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *
;;;; *           SIMPLE AGENDA-BASED CONTROL SHELL APPLICATION CODE
;;;; *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; Written by: Daniel Corkill
;;;             Department of Computer and Information Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; This code was written as part of the GBB (Generic Blackboard) system at
;;; the Department of Computer and Information Science (COINS), University of 
;;; Massachusetts, Amherst, Massachusetts 01003.
;;;
;;; Copyright (c) 1986, 1987, 1988 COINS.  
;;; All rights are reserved.
;;;
;;; Development of this code was partially supported by:
;;;    Donations from Texas Instruments, Inc.;
;;;    NSF CER grant DCR-8500332;
;;;    ONR URI contract N00014-86-K-0764.
;;;
;;; Permission to copy this software, to redistribute it, and to use it for
;;; any purpose is granted, subject to the following restrictions and
;;; understandings.
;;;
;;; 1.  Title and copyright to this software and any material associated
;;; therewith shall at all times remain with COINS.  Any copy made of this
;;; software must include this copyright notice in full.
;;;
;;; 2.  The user acknowledges that the software and associated materials
;;; are provided as a research tool that remains under active development
;;; and is being supplied ``as is'' for the purposes of scientific
;;; collaboration aimed at further development and application of the
;;; software and the exchange of technical data.
;;;
;;; 3.  All software and materials developed as a consequence of the use of
;;; this software shall duly acknowledge such use, in accordance with the
;;; usual standards of acknowledging credit in academic research.
;;;
;;; 4.  Users of this software agree to make their best efforts to inform
;;; the COINS GBB Development Group of noteworthy uses of this software.
;;; The COINS GBB Development Group can be reached at:
;;;
;;;     GBB Development Group
;;;     C/O Dr. Daniel D. Corkill
;;;     Department of Computer and Information Science
;;;     Lederle Graduate Research Center
;;;     University of Massachusetts
;;;     Amherst, Massachusetts 01003
;;;
;;;     (413) 545-0156
;;;
;;; or via electronic mail:
;;;
;;;     GBB@CS.UMass.Edu
;;;
;;; Users are further encouraged to make themselves known to this group so
;;; that new releases, bug fixes, and tutorial information can be
;;; distributed as they become available.
;;;
;;; 5.  COINS makes no representations or warranties of the merchantability
;;; or fitness of this software for any particular purpose; that uses of
;;; the software and associated materials will not infringe any patents,
;;; copyrights, trademarks, or other rights; nor that the operation of this
;;; software will be error-free.  COINS is under no obligation to provide
;;; any services, by way of maintenance, update, or otherwise.  
;;;
;;; 6.  In conjunction with products or services arising from the use of
;;; this material, there shall be no use of the name of the Department of
;;; Computer and Information Science or the University of Massachusetts in
;;; any advertising, promotional, or sales literature without prior written
;;; consent from COINS in each case.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  08-25-86 File Created.  (Cork)
;;;  11-18-86 Testing Completed.  (Cork)
;;;  05-18-88 Added KS as additional (first) argument to both precondition and
;;;           KS functions to match V1.2 changes to simple-shell.  (Cork)
;;;  09-3-88  Added SOLUTION-FAILURE KS. (Cork)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

#+SYMBOLICS
(in-package "CL-USER" :USE '("LISP" "UMASS-EXTENDED-LISP" "GBB" "SIMPLE-SHELL"))
#-SYMBOLICS
(in-package "USER" :USE '("LISP" "UMASS-EXTENDED-LISP" "GBB" "SIMPLE-SHELL"))

#-TI
(require "GBB SIMPLE-SHELL")
#+TI
;; Improve TI's REQUIRE error message ::
(unless (member "GBB SIMPLE-SHELL" user::*modules* :TEST 'string=)
  (error "Module GBB SIMPLE-SHELL is not loaded."))

(use-package '("LISP" "UMASS-EXTENDED-LISP" "GBB" "SIMPLE-SHELL"))

;;; ---------------------------------------------------------------------------
;;;
;;; Global Variable Definitions :::
;;;
;;; ---------------------------------------------------------------------------

(defvar *LAST-HYP-NUMBER* :UNINITIALIZED

  "*LAST-HYP-NUMBER*

This variable contains the instance counter for the last generated HYP unit.")

;;; ---------------------------------------------------------------------------
;;;
;;; Blackboard Unit Definitions :::
;;;
;;; ---------------------------------------------------------------------------

;;; The following UNIT definitions include the basic definitions created by the
;;; control shell for hypotheses, knowledge sources, and knowledge source
;;; instances.  Application-specific slots should be added to these 
;;; definitions.

;;; ---------------------------------------------------------------------------

(defevent-printer CREATED-HYP-EVENT-PRINTER (hyp)

   "CREATED-HYP-EVENT-PRINTER hyp

This print event is signalled whenever a stimulus hyp is created."

  :PRINT-SPEC ("~A ~A {~S}"
               (basic-unit$name hyp)
               (hyp$level hyp)
               (hyp$belief hyp)))

;;; ---------------------------------------------------------------------------

(defun GENERATE-HYP-NAME (hyp)
  
  "GENERATE-HYP-NAME hyp

This function returns the name string for a HYP unit."
  
  (declare (ignore hyp))
  (format nil "h.~5,'0D" (incf *last-hyp-number*)))

;;; ---------------------------------------------------------------------------

(define-unit (HYP (:INCLUDE basic-unit)
                  (:NAME-FUNCTION generate-hyp-name)
                  (:CREATION-EVENTS created-hyp-event-printer)
                  ;; The following must be included to trigger KSs when this
                  ;; unit is added to any space ::
                  (:ADD-TO-SPACE-EVENTS add-unit-to-space-event-handler))
             
  "HYP (Hypothesis)"

  :SLOTS
  ((belief)
   (value)
   (level))

  :LINKS
  ((supported-hyps  (hyp supporting-hyps))
   (supporting-hyps (hyp supported-hyps)))

  :DIMENSIONAL-INDEXES
  ((value value :TYPE :point))

  :PATH-INDEXES
  ((level level :TYPE :label))

  :PATHS
  ((:PATHS `(blackboard ,level))))

;;; ---------------------------------------------------------------------------

(define-unit (KS (:INCLUDE basic-ks))
             
  "KS (Knowledge Source)

This unit type contains knowledge source information.")

;;; ---------------------------------------------------------------------------

(define-unit (KSI (:INCLUDE basic-ksi))
             
  "KSI (Knowledge Source Instance)

This unit type represents a knowledge source instantiation (or activation)
record on the scheduling queue.")

;;; --------------------------------------------------------------------------
;;;
;;; The Knowledge Source Code :::
;;;
;;; --------------------------------------------------------------------------

(defun INITIAL-KS-FUNCTION (ks initial-hyps)

  "INITIAL-KS-FUNCTION initial-hyps

This KS function simply inserts some random data on SPACE1."

  (declare (ignore ks initial-hyps))
  (dotimes (i 16)
    (make-hyp :LEVEL 'space1
              :VALUE (random 100)
	      :BELIEF (random 10))))

;;; ---------------------------------------------------------------------------

(defun SYN-KS-PRECONDITION (ks stimulus-hyp)

  "SYN-KS-PRECONDITION ks stimulus-hyp

This KS precondition estimates the result of synthesizing data from SPACEn to
SPACEn+1.  `Stimulus-hyp' provides a context for searching for other hyps with a
value within +/-2 of the value of `stimulus-hyp'."

  (declare (ignore ks))
  (let ((precondition-rating 0)
        (supporting-hyps
          (find-units
            'hyp
            (make-paths :unit-instances stimulus-hyp)
            `(:ELEMENT-MATCH :within
              :PATTERN-OBJECT
              (:INDEX-TYPE (:DIMENSION value :TYPE :point)
               :INDEX-OBJECT ,(hyp$value stimulus-hyp)
               :DELTA ((value 3)))))))
      (cond ((> (length supporting-hyps) 2)
             (setf precondition-rating
                   (max precondition-rating
                        (mapc-+ 'hyp$belief supporting-hyps)))
             (values precondition-rating
                     (list stimulus-hyp supporting-hyps)))
            (t 0))))

;;; ---------------------------------------------------------------------------

(defun SYN-KS-FUNCTION (ks ksi space)

  "SYN-KS-FUNCTION ks ksi space

This KS function estimates the result of synthesizing data from `space'-1 to
`space'."

  (declare (ignore ks))
  (let* ((response-frame (ksi$response-frame ksi))
         (stimulus-hyp (first response-frame))
         (supporting-hyps (second response-frame)))
    (make-hyp :LEVEL space
              :SUPPORTING-HYPS supporting-hyps
              :VALUE (hyp$value stimulus-hyp)
              :BELIEF (mapc-+ 'hyp$belief supporting-hyps))))

;;; ---------------------------------------------------------------------------

(defun SOLUTION-FINDER-KS-PRECONDITION (ks stimulus-hyp)

  "SOLUTION-FINDER-KS-PRECONDITION ks stimulus-hyp

This KS precondition is triggered when a hypothesis has been added to SPACE4."

  (declare (ignore ks))
  (values (hyp$belief stimulus-hyp) (list stimulus-hyp)))

;;; ---------------------------------------------------------------------------

(defun SOLUTION-FINDER-KS-FUNCTION (ks ksi)

  "SOLUTION-FINDER-KS-FUNCTION ks ksi

This KS function terminates the application on creation of a hyp on SPACE4."

  (declare (ignore ks))
  (let ((solution-hyp (first (ksi$response-frame ksi))))
    (format t "~2& ***** SOLUTION FOUND *****~& HYP: ~A ~A {~A}"
            (hyp$name solution-hyp)
            (hyp$level solution-hyp)
            (hyp$belief solution-hyp))
    (pp-solution-supports solution-hyp))
  :STOP)                                   ; Signal the termination.

;;; ---------------------------------------------------------------------------

(defun SOLUTION-FAILURE-KS-PRECONDITION (ks always-nil)

  "SOLUTION-FAILURE-KS-PRECONDITION ks always-nil

This KS precondition returns a rating of MOST-POSITIVE-FIXNUM if fewer than
36 hyps have been created on space1.  This indicates that more hyps should
be created to attempt a solution."

  (declare (ignore ks always-nil))
  (flet ((count-units (paths &AUX (result 0))
           ;; Returns the number of units on the given paths ::
           (map-space #'(lambda (ignored)
                          (declare (ignore ignored))
                          (incf result))
                      'hyp
                      paths)
           result))
    
    ;; Instantiate a KS to make more input data unless we have
    ;; already inserted at least 36 initial hypotheses on SPACE1 ::
    (if (< (count-units (make-paths :PATHS '(blackboard space1)))
           36)
        most-positive-fixnum
        0)))

;;; ---------------------------------------------------------------------------

(defun SOLUTION-FAILURE-KS-FUNCTION (ks ksi)

  "SOLUTION-FAILURE-KS-FUNCTION ks ksi

This KS function runs if no more KSIs exist to run."

  (declare (ignore ks ksi))
  (format t "~2& ***** NO SOLUTION FOUND *****~
              ~& The initial data did not support a complete solution.~
              ~& Adding more random data....~2&")
  (dotimes (i 9)
    (make-hyp :LEVEL 'space1
              :VALUE (random 100)
	      :BELIEF (random 10))))

;;; ---------------------------------------------------------------------------

(defun PP-SOLUTION-SUPPORTS (hyp)

  "PP-SOLUTION-SUPPORTS hyp

This function pprints the solution support structure rooted in `hyp'."

  (labels
    ((pp-solution-supports#1 (hyps indent)
       (when hyps
         (dolist (hyp hyps)
           (format t "~&~VT~A ~A {~S}"
                   indent
                   (hyp$name hyp)
                   (hyp$level hyp)
                   (hyp$belief hyp))
           (pp-solution-supports#1
             (hyp$supporting-hyps hyp)
             (+ 2 indent))))))

    (format t "~& ***** Solution Supports *****")
    (pp-solution-supports#1 (list hyp) 2)))

;;; ---------------------------------------------------------------------------
;;;
;;; Define The Blackboard Structure :::
;;;
;;; ---------------------------------------------------------------------------

(define-space SPACE1
  "A level."
  :UNITS      (hyp)
  :DIMENSIONS ((value :ORDERED (0 100))))

(define-spaces (SPACE2 SPACE3)
  "More levels."
  :UNITS      (hyp)
  :DIMENSIONS ((value :ORDERED (0 100))))

(define-spaces (SPACE4)
  "One more level."
  :UNITS      (hyp)
  :DIMENSIONS ((value :ORDERED (0 100))))

(define-blackboard BLACKBOARD (space1 space2 space3 space4)
  "Basic blackboard structure.")

;;; -------------------------------------------------------------------------
;;;
;;; Define Unit/Space Mappings :::
;;;
;;; -------------------------------------------------------------------------

(define-unit-mapping (hyp) (space1)
  :INDEXES (value)
  :INDEX-STRUCTURE ((value :SUBRANGES (:start :end (:WIDTH 10)))))

;;; -------------------------------------------------------------------------
;;;
;;; Inform GBB About The Knowledge Sources :::
;;;
;;; -------------------------------------------------------------------------

(define-ks INITIAL
  :KS-FUNCTION 'initial-ks-function)

(define-ks SYN-SPACE1-SPACE2
  :TRIGGER-CONDITIONS ((:unit-addition-to-space
                         ((hyp) ((blackboard space1)))))
  :PRECONDITION-FUNCTION 'syn-ks-precondition
  :KS-FUNCTION '(lambda (ks ksi)
                  (syn-ks-function ks ksi 'space2)))
  
(define-ks SYN-SPACE2-SPACE3
  :TRIGGER-CONDITIONS ((:unit-addition-to-space
                         (hyp ((blackboard space2)))))
  :PRECONDITION-FUNCTION 'syn-ks-precondition
  :KS-FUNCTION '(lambda (ks ksi)
                  (syn-ks-function ks ksi 'space3)))
  
(define-ks SYN-SPACE3-SPACE4
  :TRIGGER-CONDITIONS ((:unit-addition-to-space
                         (hyp ((blackboard space3)))))
  :PRECONDITION-FUNCTION 'syn-ks-precondition
  :KS-FUNCTION '(lambda (ks ksi)
                  (syn-ks-function ks ksi 'space4)))
  
(define-ks SOLUTION-FINDER
  :TRIGGER-CONDITIONS ((:unit-addition-to-space
                         (hyp ((blackboard space4)))))
  :PRECONDITION-FUNCTION 'solution-finder-ks-precondition
  :KS-FUNCTION 'solution-finder-ks-function)

(define-ks SOLUTION-FAILURE
  :TRIGGER-CONDITIONS ((:queue-quiescence))
  :PRECONDITION-FUNCTION 'solution-failure-ks-precondition
  :KS-FUNCTION 'solution-failure-ks-function)

;;; --------------------------------------------------------------------------
;;;
;;; Function To Run The Simple Shell Example :::
;;;
;;; --------------------------------------------------------------------------

(defun SIMPLE-SHELL-EXAMPLE (&KEY (event-print-stream *standard-output*))

  "SIMPLE-SHELL-EXAMPLE &KEY event-print-stream

Runs the simple shell example.  An alternate stream for printing simple
shell events can be optionally specified (the default is *standard-output*)."
 
  (let ((*event-print-stream* event-print-stream))
    (format *event-print-stream*
            "~2&;;; Running the Simple Shell Example....~%")
    (clear-blackboard-database t)
    (setf *last-hyp-number* 0)
    (instantiate-simple-control-shell 'blackboard :MODE :overwrite)
    (pp-blackboard-database)
    (format *event-print-stream*
            "~2&;;; Note that since the data is random, a solution might not ~
             be found.~@
             ;;; Rerun by evaluating (simple-shell-example).")
    (simple-control-shell 'initial)))


;;; **************************************************************************
;;;                                End of File
;;; **************************************************************************

